{extends file='catalog/product.tpl'}

{block name='content'}

  <section id="main" itemscope itemtype="https://schema.org/Product">
    <meta itemprop="url" content="{$product.url}">

    {* Pack title *}
    {block name='ap5_pack_title'}
      <div class="row">
        <div class="col-xs-12 col-12">
        {block name='page_header_container'}
          {block name='page_header'}

            {* {if $product.description_short}
              <div class="text-xs-justify text-justify" itemprop="description">{$product.description_short nofilter}</div>
            {/if} *}
          {/block}
        {/block}
        </div>
      </div>
    {/block}

<div id="cg-left-column">
  {block name='page_header_container'}
  {block name='page_header'}
  <h1 class="h1 product-title" itemprop="name">{block name='page_title'}{$product.name}{/block}</h1>
  {/block}
  {/block}
  <div class="col-image">
    {if $product.cover}
  {assign var='coverImage' value=Product::getCover($product->id)}
  {assign var='coverImageId' value="{$product->id}-{$coverImage.id_image}"}

    <img src="{$link->getImageLink($product.link_rewrite, $coverImageId, 'large_default')}" alt="{if !empty($product.cover.legend)}{$product.cover.legend}{else}{$product.name|truncate:30:'...'}{/if}" data-full-size-image-url="{$product.cover.large.url}" width="500" height="500" />

{else}

    <img src="{$urls.no_picture_image.bySize.large_default.url}" width="500" height="500" />

{/if}
  </div>
  <div class="col-middle">
    <div>  {block name='product_additional_info'}
      {include file='catalog/_partials/product-additional-info.tpl'}
      {/block}</div>
      {block name='product_description_short'}
      <div id="product-description-short-{$product.id}" сlass="product-short-desc" itemprop="description">

        {$product.description_short nofilter}</div>
      {/block}
      {include file='_partials/cg-product-flags-ficheprod.tpl'}
      {include file='catalog/_partials/cg-product-rassurance.tpl'}
  </div>
</div>

<div class="col-content">
  <div class="col-content-inside">
    {block name='ap5_buy_block'}
    {* Buy block *}
    {include file='module:pm_advancedpack/views/templates/front/1.7/pack-price-container.tpl'}
  {/block}
  {include file='catalog/_partials/cg-scrollnav-kit.tpl'}
  </div>
  </div>
  <!--          Presentation-->
  {if $product.description}
  <a class="anchor" id="presentationanchor"></a>
  <div class="card prodtext expandablock"  id="presentation">
    <h2><span class="material-icons">
  visibility
  </span> Présentation : {$product.name}</h2>
    {$product.description nofilter}
    {include file='catalog/_partials/cg-textes-auto.tpl'}
  </div>
  {/if}
  {block name='ap5_product_list'}
{* Product list of the pack *}
<a class="anchor" id="contenuanchor"></a>
{include file='module:pm_advancedpack/views/templates/front/1.7/pack-product-list.tpl'}
{/block}
{block name='ap5_tabs_header'}
{* Product tabs *}
{if $packShowProductsFeatures || $packShowProductsShortDescription || $packShowProductsLongDescription}

<div id="ap5-pack-content-block" class="card prodtext">
<h2><span class="material-icons">
inventory_2
</span> {l s='Pack content' mod='pm_advancedpack'}</h2>
<div class="card-block">
{include file='module:pm_advancedpack/views/templates/front/1.7/pack-product-list-tabs.tpl'}
</div>
</div>

{/if}
{/block}
{block name='ap5_accessories'}
  {block name='product_accessories'}
    {if $accessories}
      <div id="accessoires"class="product-accessories clearfix card prodtext">
        <h2>{l s='You might also like' d='Shop.Theme.Catalog'}</h2>
        <div class=" gapcardlist l4 m3 s1">
          {foreach from=$accessories item="product_accessory"}
            {block name='product_miniature'}
              {include file='catalog/_partials/miniatures/product.tpl' product=$product_accessory}
            {/block}
          {/foreach}
        </div>
      </div> {/if}
  {/block}
{/block}

      <div style="position:relative;" id="prodscroll">

          <div id="prodscrollcontent">




    {block name='ap5_product_attachments'}
      {if $product.attachments}
        <div class="row">
          <div id="ap5-pack-download-block" class="card">
            <div class="card-header">
              <h3 class="page-product-heading">{l s='Download' d='Shop.Theme.Actions'}</h3>
            </div>
            <div class="card-block">
              {foreach from=$product.attachments item=attachment}
                <div class="attachment">
                  <h4>
                    <a href="{url entity='attachment' params=['id_attachment' => $attachment.id_attachment]}">
                      {$attachment.name}
                    </a>
                  </h4>
                  <p>{$attachment.description}</p>
                  <a href="{url entity='attachment' params=['id_attachment' => $attachment.id_attachment]}">
                    {l s='Download' d='Shop.Theme.Actions'} ({$attachment.file_size_formatted})
                  </a>
                </div>
              {/foreach}
            </div>
          </div>
        </div>
      {/if}
    {/block}


{block name='ap5_footer'}
      {block name='product_footer'}
        {hook h='displayFooterProduct' product=$product category=$category}
      {/block}
    {/block}
              </div>

          </div>










    {block name='ap5_images'}
      {block name='product_images_modal'}
        {include file='catalog/_partials/product-images-modal.tpl'}
      {/block}
    {/block}

    {block name='ap5_footer_container'}
      {block name='page_footer_container'}
        <footer class="page-footer">
          {block name='page_footer'}
            <!-- Footer content -->
          {/block}
        </footer>
      {/block}
    {/block}
  </section>

{/block}
