{*
* 2016 ROJA45.COM
* All rights reserved.
*
* DISCLAIMER
*
* Changing this file will render any support provided by us null and void.
*
*  @author 			Roja45 <support@roja45.com>
*  @copyright  		2016 roja45.com
*}

<table class="quotation-content table" id="quotationProducts">
    {foreach from=$quotation_products item=product name=product key=k}
        {if $smarty.foreach.product.iteration == 1}
        <thead>
            <tr>
                <th class="column-select">
                    <label class="checkbox-container">
                        <input id="product_quotation_select_all" type="checkbox" class="select-quotation-product-all" name="product_quotation_select_all">
                        <span class="checkbox-checkmark"></span>
                    </label>
                </th>
                <th class="column-image"></th>
                <th class="column-title"><span class="title_box">{l s='Product' mod='roja45quotationspro'}</span></th>
                <!-- <th class="column-wholesale">
                    <span class="title_box ">{l s='Wholesale' mod='roja45quotationspro'}</span>
                </th> -->
                <th class="column-unitprice">
                    <span class="title_box">{l s='Unit Price' mod='roja45quotationspro'}</span>
                    <small class="text-muted">{if ($use_taxes)}{l s='tax incl.' mod='roja45quotationspro'}{else}{l s='tax excl.' mod='roja45quotationspro'}{/if}</small>
                </th>
                <th class="column-discount"><span class="title_box ">{l s='Discount' mod='roja45quotationspro'}</span></th>
                <th class="column-quoteprice">
                    <span class="title_box ">{l s='Quote' mod='roja45quotationspro'}</span>
                    <small class="text-muted">{if ($use_taxes)}{l s='tax incl.' mod='roja45quotationspro'}{else}{l s='tax excl.' mod='roja45quotationspro'}{/if}</small>
                </th>
                <th class="column-quantity"><span class="title_box ">{l s='Qty' mod='roja45quotationspro'}</span></th>
                <th class="column-total">
                    <span class="title_box ">{l s='Total' mod='roja45quotationspro'}</span>
                    <small class="text-muted">{if ($use_taxes)}{l s='tax incl.' mod='roja45quotationspro'}{else}{l s='tax excl.' mod='roja45quotationspro'}{/if}</small>
                </th>
                <th class="column-taxpaid">
                    <span class="title_box ">{l s='Tax' mod='roja45quotationspro'}</span>
                </th>
                <!--<th class="column-taxrate">
                    <span class="title_box ">{l s='Rate' mod='roja45quotationspro'}</span>
                </th>-->
                {if $quotation_has_ecotax > 0}
                    <th class="column-taxrate">
                        <span class="title_box ">{l s='Ecotax' mod='roja45quotationspro'}</span>
                        <small class="text-muted">{if ($use_taxes)}{l s='tax incl.' mod='roja45quotationspro'}{else}{l s='tax excl.' mod='roja45quotationspro'}{/if}</small>
                    </th>
                {/if}
                <!-- <th class="column-profit">
                    <span class="title_box ">{l s='Total Profit' mod='roja45quotationspro'}</span>
                </th> -->
                {if $deposit_enabled}
                    <th class="column-deposit">
                        <span class="title_box ">{l s='Deposit %' mod='roja45quotationspro'}</span>
                    </th>
                {/if}
                <!--<th class="column-buttons add_product_quotation_fields"></th>-->
            </tr>
        </thead>
        <tbody>
        {/if}
        <tr class="product-line-row" data-id-roja45-quotation-product="{$product['id_roja45_quotation_product']|escape:'html':'UTF-8'}">
            <input type="hidden" name="product_quotation[product_quotation_id]" class="product_quotation_id" value="{$product['id_roja45_quotation_product']|escape:'html':'UTF-8'}"/>
            <input type="hidden" name="product_quotation[id_product]" class="product_id" value="{$product['id_product']|escape:'html':'UTF-8'}"/>
            {if $product.deleted}
                <td class="column-select"></td>
                <td class="column-image"></td>
                <td class="column-title">{l s='Product no longer available' mod='roja45quotationspro'}</td>
                <td class="column-wholesale"></td>
                <td class="column-unitprice"></td>
                <td class="column-discount"></td>
                <td class="column-quoteprice"></td>
                <td class="column-quantity"></td>
                <td class="column-total"></td>
                    <td class="column-taxpaid">
                    </td>
                    <td class="column-taxrate">
                    </td>
                <!-- <td class="column-profit"></td> -->
                {if $deposit_enabled}
                <td class="column-deposit"></td>
                {/if}
                <td class="column-buttons">
                    <button type="button" title="{l s='Delete' mod='roja45quotationspro'}" class="btn btn-secondary delete_product_quotation_line" {if $deleted}disabled="disabled"{/if}>
                        <i class="icon-trash"></i>
                    </button>
                </td>
            {else}
                <td class="column-select">
                    <i title="{l s='Drag to change order' mod='roja45quotationspro'}" class="icon-arrows"></i>
                    <label class="checkbox-container">
                        <input type="checkbox" class="select-quotation-product" name="product_quotation[selected]">
                        <span class="checkbox-checkmark"></span>
                    </label>
                </td>
                <td class="column-image">{if isset($product.image_tag)}<img src="{$product.image_tag|escape:'htmlall':'UTF-8'}" alt="{$product['product_title']|escape:'html':'UTF-8'}" class="img img-thumbnail" width="{$product['image_width']}" height="{$product['image_height']}"/>{/if}</td>
                <td class="column-title">
                   <a href="{$product.admin_link}" target="_blank">
                        <span class="productName">{$product['product_title']|escape:'html':'UTF-8'}</span><br/>
                        {if $product.attributes}<span class="productAttributes">{$product['attributes']|escape:'html':'UTF-8'}</span><br/>{/if}
                        {if $product.reference}{l s='Reference #:' mod='roja45quotationspro'} {$product.reference|escape:'html':'UTF-8'}<br/>{/if}
                        {if $product.supplier_reference}{l s='Supplier #' mod='roja45quotationspro'} {$product.supplier_reference|escape:'html':'UTF-8'}{/if}
                    </a>
                    <input type="text"
                           name="product_quotation[comment]"
                           {if ($quotation->isLocked())}disabled="disabled"{/if}
                           class="product_quotation_editable product_quotation_comment product_comment"
                           placeholder="{l s='Add comment' mod='roja45quotationspro'}"
                           value="{if isset($product.comment)}{$product.comment|escape:'htmlall':'UTF-8'}{/if}"/>
                </td>
                <td class="column-wholesale wholesale_price" data-wholesale-price="{$product.wholesale_price}">
                    {$product.wholesale_price_formatted}
                </td>
                <td class="column-unitprice" data-list-price="{if ($use_taxes)}{$product.list_price_incl_without_reduction}{else}{$product.list_price_excl_without_reduction}{/if}">
                    {if ($use_taxes)}
                        <span>{$product.list_price_incl_without_reduction_formatted}</span>
                    {else}
                        <span>{$product.list_price_excl_without_reduction_formatted}</span>
                    {/if}
                </td>
                <td class="column-discount productDiscount fixed-width-md">

                    <div class="input-group">
                        <input type="text"
                               class="product_quotation_editable form-control product_quotation_discount"
                               name="product_quotation[product_discount]"
                               value="{$product['discount']|escape:'html':'UTF-8'}"/>
                        <div class="input-group-addon custom">
                            <select
                                    name="product_quotation[product_discount_type]"
                                    class="product_quotation_discount_type"
                            >
                                <option value="percentage" {if isset($product.discount_type)}{if $product.discount_type=='percentage'}selected="selected"{/if}{else}selected="selected"{/if}>%</option>
                                <option value="fixed" {if isset($product.discount_type) && $product.discount_type!='percentage'}selected="selected"{/if}>{$currency->sign|escape:'html':'UTF-8'}</option>
                            </select>
                        </div>
                    </div>
                </td>
                <td class="column-quoteprice">
                    <div class="fixed-width-md">
                    {if ($use_taxes)}
                            <div class="input-group">
                                <div class="input-group-addon">{$currency->sign|escape:'html':'UTF-8'}</div>
                                <input type="text"
                                       name="product_quotation[product_price_tax_incl]"
                                       {if ($quotation->isLocked())}disabled="disabled"{/if}
                                       class="product_quotation_editable product_quotation_price_tax_incl product_price"
                                       value="{$product['unit_price_tax_incl_currency']|escape:'html':'UTF-8'}"/>
                            </div>
                    {else}
                            <div class="input-group">
                                <div class="input-group-addon">{$currency->sign|escape:'html':'UTF-8'}</div>
                                <input type="text"
                                       name="product_quotation[product_price_tax_excl]"
                                       {if ($quotation->isLocked())}disabled="disabled"{/if}
                                       class="product_quotation_editable product_quotation_price_tax_excl product_price"
                                       value="{$product['unit_price_tax_excl_currency']|escape:'html':'UTF-8'}"/>
                            </div>
                    {/if}
                    </div>
                </td>
                <td class="column-quantity productQuantity">
                    <div class="fixed-width-sm">
                    <input type="number"
                           name="product_quotation[product_quantity]"
                            {if ($quotation->isLocked())}disabled="disabled"{/if}
                           class="product_quotation_editable form-control product_quotation_quantity"
                           value="{$product['qty']|escape:'html':'UTF-8'}"/>
                    </div>
                </td>
                <td class="column-total total_product hide-when-dirty">
                        {if ($use_taxes)}
                            {$product['product_price_subtotal_incl_formatted']}
                        {else}
                            {$product['product_price_subtotal_excl_formatted']}
                        {/if}

                </td>
                    <td class="column-taxpaid total_product_tax hide-when-dirty fixed-width-sm">
                        <div>{$product.tax_paid_formatted}</div>
                        <div><small>({$product.tax_rate_formatted})</small></div>
                    </td>
                    <!--<td class="column-taxrate">
                        {$product.tax_rate_formatted}
                    </td>-->
            {if $quotation_has_ecotax > 0}
                <td class="column-ecotaxrate fixed-width-sm">
                {if ($use_taxes)}{$product.product_ecotax_inc}{else}{$product.product_ecotax}{/if}
                </td>
            {/if}
                <!-- <td class="column-profit total_product_profit fixed-width-sm hide-when-dirty">
                    {$product['product_profit_subtotal_excl_formatted']}
                </td> -->
                {if $deposit_enabled}
                <td class="deposit_required">
                    <span class="deposit_required_show">{$product['deposit_amount']|escape:'html':'UTF-8'}</span>
                    <div class="deposit_required_edit" style="display:none;">
                        <div class="fixed-width-md">
                            <input type="text"
                                   name="product_quotation[deposit_amount]"
                                   class="product_quotation_editable product_quotation_deposit_amount product_deposit_amount"
                                   value="{$product.deposit_amount|escape:'htmlall':'UTF-8'}"/>
                        </div>
                    </div>
                </td>
                <td class="total_to_pay hide-when-dirty">
                    {if ($use_taxes)}
                        {$product['product_price_deposit_incl_formatted']}
                    {else}
                        {$product['product_price_deposit_excl_formatted']}
                    {/if}
                </td>
                {/if}
                <!--<td class="column-buttons quotation_action text-right">
                    {if !$quotation->is_template}
                        <div class="btn-group">
                            <button type="button" title="{l s='Save' mod='roja45quotationspro'}" class="btn btn-primary btn-save-quotation-product" {if $deleted}disabled="disabled"{/if} style="display:none;padding-left: 5px;padding-right: 5px;">
                                <i class="icon-save"></i>
                            </button>
                            <button type="button" title="{l s='Delete' mod='roja45quotationspro'}" class="btn btn-primary btn-delete-quotation-product disabled-while-saving" {if $deleted}disabled="disabled"{/if} style="padding-left: 5px;padding-right: 5px;">
                                <i class="icon-trash"></i>
                            </button>
                        </div>
                    {/if}
                </td>-->
            {/if}
        </tr>

        {if count($product['customizations'])}

        <tr class="product-line-customization-row">
            <td colspan="4">
                <table class="table">
                    <tr><td><strong>{l s='Customizations' mod='roja45quotationspro'}</strong></td></tr>
            {foreach $product['customizations'] as $customization}
                <tr>
                    <td> <div class="form-horizontal">
                            {if ($customization.type == Product::CUSTOMIZE_FILE)}
                                <div class="form-group">
                                    <span class="col-lg-4 control-label"><strong>{$customization.name}</strong></span>
                                    <div class="col-lg-8">
                                        <a href="{$smarty.const._THEME_PROD_PIC_DIR_}{$customization.value}" target="_blank" class="_blank">
                                            <img class="img-thumbnail" src="{$smarty.const._THEME_PROD_PIC_DIR_}{$customization.value}_small" alt=""/>
                                        </a>
                                    </div>
                                </div>
                            {elseif ($customization.type == Product::CUSTOMIZE_TEXTFIELD)}
                                <div class="form-group">
                                    <span class="col-lg-4 control-label"><strong>{$customization.name}</strong></span>
                                    <div class="col-lg-8">
                                        <p class="form-control-static">{$customization.value}</p>
                                    </div>
                                </div>
                            {/if}
                        </div>
                    </td>
                </tr>
            {/foreach}
                </table>

            </td>
        </tr>

        {/if}
    {/foreach}
    </tbody>
</table>
