{**
* 2018 TerraNet
*
* NOTICE OF LICENSE
*
* @author    TerraNet
* @copyright 2018 TerraNet
* @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
*}

{if isset($product->id) && isset($available_features)}
    <div id="product-features" class="panel product-tab">
        <input type="hidden" name="submitted_ffg_tabs" value="Features"/>
        <h3>{l s='Assign features to this product' mod='fullfeaturesgroups' }</h3>
        <div class="alert alert-info">
            {l s='You can specify a value for each relevant feature regarding this product. Empty fields will not be displayed.' mod='fullfeaturesgroups' }
            <br/>
            {l s='You can either create a specific value, or select among the existing pre-defined values you\'ve previously added.' mod='fullfeaturesgroups' }
        </div>

        <table class="table">
            <thead>
            <tr>
                <th><span class="title_box">{l s='Feature' mod='fullfeaturesgroups' }</span></th>
                <th><span class="title_box">{l s='Pre-defined value' mod='fullfeaturesgroups' }</span></th>
                <th>
                    <span class="title_box"><u>{l s='or' mod='fullfeaturesgroups' }</u> {l s='Customized value' mod='fullfeaturesgroups' }</span>
                </th>
            </tr>
            </thead>
            <tbody>
            {foreach from=$available_features item=available_feature}
                <tr>
                    <td>{$available_feature.name|escape:'htmlall':'UTF-8'}</td>
                    <td>
                        {if sizeof($available_feature.featureValues)}
                            <select size="5" multiple="5" id="feature_gr_{$available_feature.id_feature|escape:'htmlall':'UTF-8'}_value"
                                    name="feature_gr_{$available_feature.id_feature|escape:'htmlall':'UTF-8'}_value[]"
                                    class="form-control"
                                    onchange="$('.custom_gr_{$available_feature.id_feature|escape:'htmlall':'UTF-8'}').val('');">
                                <option selected="selected" value="0">---</option>
                                {foreach from=$available_feature.featureValues item=value}
                                    <option value="{$value.id_feature_value|escape:'htmlall':'UTF-8'}" {if in_array($value.id_feature_value, $available_feature.current_item)}selected="selected"{/if}>{$value.value|truncate:40}</option>
                                {/foreach}
                            </select>
                        {else}
                            <input type="hidden" name="feature_gr_{$available_feature.id_feature|escape:'htmlall':'UTF-8'}_value"
                                   value="0"/>
                            <span>{l s='N/A' mod='fullfeaturesgroups'} -
                                <a href="{$link->getAdminLink('AdminFeatures')|escape:'html':'UTF-8'}&amp;addfeature_value&amp;id_feature={$available_feature.id_feature|escape:'htmlall':'UTF-8'}"
                                   class="confirm_leave btn btn-link"><i
                                            class="icon-plus-sign"></i> {l s='Add pre-defined values first' mod='fullfeaturesgroups' }
                                    <i class="icon-external-link-sign"></i></a>
                            </span>
                        {/if}
                    </td>
                    <td>
                    <fieldset class="form-group mb-0">
                        <label class="form-control-label">{l s='OR Customized value' mod='fullfeaturesgroups'}</label>
                        <div class="translations tabbable" id="form_step1_features_gr_custom_value">
                            <div class="translationsFields">
                        {if $languages|count > 0}
                            {foreach from=$languages item=language}
                                <div class="input-group language-inp-container">
                                    <span class="input-group-addon">{$language['iso_code']|escape:'htmlall':'UTF-8'}{if $language.id_lang == $default_form_language}*{/if}</span>
                                    <textarea
                                            class="custom_gr_{$available_feature.id_feature|escape:'htmlall':'UTF-8'} form-control textarea-autosize"
                                            name="custom_gr_{$available_feature.id_feature|escape:'htmlall':'UTF-8'}_{$language.id_lang|escape:'htmlall':'UTF-8'}"
                                            cols="40" rows="1"
                                            onkeyup="if (isArrowKey(event)) return;$('#feature_{$available_feature.id_feature|escape:'htmlall':'UTF-8'}_value').val(0);">{$available_feature.val[$language.id_lang].value|escape:'html':'UTF-8'|default:""}</textarea>
                                </div>
                            {/foreach}
                        {/if}
                            </div>
                        </div>
                    </fieldset>
                    </td>
                </tr>
                {foreachelse}
                <tr>
                    <td colspan="3" style="text-align:center;"><i
                                class="icon-warning-sign"></i> {l s='No features have been defined' mod='fullfeaturesgroups' }
                    </td>
                </tr>
            {/foreach}
            </tbody>
        </table>

        <a href="{$link->getAdminLink('AdminFeatures')|escape:'html':'UTF-8'}&amp;addfeature"
           class="btn btn-link confirm_leave button">
            <i class="icon-plus-sign"></i> {l s='Add a new feature' mod='fullfeaturesgroups' } <i
                    class="icon-external-link-sign"></i>
        </a>
    </div>
{else}
    <div id="product-features" class="panel product-tab">
        <h3>{l s='Assign features to this product' mod='fullfeaturesgroups' }</h3>

        <div class="alert alert-warning">
            {l s='Please add this product category to one of the futures group in Feature Category section on Full Features Groupe module Settings' mod='fullfeaturesgroups' }
        </div>
    </div>
{/if}

{if isset($disabled_def_feature) && $disabled_def_feature == 1}
<style type="text/css">
    #features {
        display: none;
    }
</style>
{/if}
