{*
* 2022 PayPlug
*
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0).
* It is available through the world-wide-web at this URL:
* https://opensource.org/licenses/osl-3.0.php
* If you are unable to obtain it through the world-wide-web, please send an email
* to contact@payplug.com so we can send you a copy immediately.
*
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PayPlug module to newer
 * versions in the future.
*
*  @author PayPlug SAS
*  @copyright 2023 PayPlug SAS
*  @license   https://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
*  International Registered Trademark & Property of PayPlug SAS
*}

<form class="{$module_name|escape:'htmlall':'UTF-8'}IntegratedPayment">
    <div class="{$module_name|escape:'htmlall':'UTF-8'}IntegratedPayment_container -cardHolder"></div>
    <div class="{$module_name|escape:'htmlall':'UTF-8'}IntegratedPayment_error -cardHolder">
        <span class="-hide invalidField">{l s='hook.checkout.payment.integrated.cardholder.error' mod='pspaylater'}</span>
        <span class="-hide emptyField">{l s='hook.checkout.payment.integrated.cardholder.empty' mod='pspaylater'}</span>
    </div>

    <div class="{$module_name|escape:'htmlall':'UTF-8'}IntegratedPayment_container -scheme">
        <div>{l s='hook.integratedPayment.scheme' mod='pspaylater'}</div>
        <div class="{$module_name|escape:'htmlall':'UTF-8'}IntegratedPayment_schemes">
            <label class="{$module_name|escape:'htmlall':'UTF-8'}IntegratedPayment_scheme -visa">
                <input type="radio" name="schemeOptions" value="visa" />
                <span></span>
            </label>
            <label class="{$module_name|escape:'htmlall':'UTF-8'}IntegratedPayment_scheme -mastercard">
                <input type="radio" name="schemeOptions" value="mastercard" />
                <span></span>
            </label>
            <label class="{$module_name|escape:'htmlall':'UTF-8'}IntegratedPayment_scheme -cb">
                <input type="radio" name="schemeOptions" value="cb" />
                <span></span>
            </label>
        </div>
    </div>

    <div class="{$module_name|escape:'htmlall':'UTF-8'}IntegratedPayment_container -pan"></div>
    <div class="{$module_name|escape:'htmlall':'UTF-8'}IntegratedPayment_error -pan">
        <span class="-hide invalidField">{l s='hook.checkout.payment.integrated.cardpan.error' mod='pspaylater'}</span>
        <span class="-hide emptyField">{l s='hook.checkout.payment.integrated.cardholder.empty' mod='pspaylater'}</span>
    </div>

    <div class="{$module_name|escape:'htmlall':'UTF-8'}IntegratedPayment_container -exp"></div>
    <div class="{$module_name|escape:'htmlall':'UTF-8'}IntegratedPayment_container -cvv"></div>

    <div class="{$module_name|escape:'htmlall':'UTF-8'}IntegratedPayment_error -exp">
        <span class="-hide invalidField">{l s='hook.checkout.payment.integrated.cardexp.error' mod='pspaylater'}</span>
        <span class="-hide emptyField">{l s='hook.checkout.payment.integrated.cardholder.empty' mod='pspaylater'}</span>
    </div>
    <div class="{$module_name|escape:'htmlall':'UTF-8'}IntegratedPayment_error -cvv">
        <span class="-hide invalidField">{l s='hook.checkout.payment.integrated.cardcvv.error' mod='pspaylater'}</span>
        <span class="-hide emptyField">{l s='hook.checkout.payment.integrated.cardholder.empty' mod='pspaylater'}</span>
    </div>


    {if isset($is_one_click_activated) && $is_one_click_activated }
        <div class="{$module_name|escape:'htmlall':'UTF-8'}IntegratedPayment_container -saveCard">
            <label>
                <input type="checkbox" name="savecard">
                <span></span>
                {l s='hook.integratedPayment.savecard' mod='pspaylater'}
            </label>
        </div>
    {/if}

    {if isset($is_deferred_activated) && $is_deferred_activated }
        <div class="{$module_name|escape:'htmlall':'UTF-8'}IntegratedPayment_container -deferred">
            {l s='hook.integratedPayment.deferred' mod='pspaylater'}
        </div>
    {/if}

    <div class="{$module_name|escape:'htmlall':'UTF-8'}IntegratedPayment_error -fields">
        {l s='hook.checkout.payment.integrated.fields.error' mod='pspaylater'}
    </div>
    <div class="{$module_name|escape:'htmlall':'UTF-8'}IntegratedPayment_error -payment">
    </div>
    <div class="{$module_name|escape:'htmlall':'UTF-8'}IntegratedPayment_error -api">
        {l s='hook.header.integratedPayment.api.genericError' tags=['<br>'] mod='pspaylater'}
    </div>
</form>
<script type="text/javascript">
    {literal}
        var placeholderCardholder = '{/literal}{$placeholderCardholder|escape:'javascript':'UTF-8'}{literal}';
        var placeholderPan = '{/literal}{$placeholderPan|escape:'javascript':'UTF-8'}{literal}';
        var placeholderCvv = '{/literal}{$placeholderCvv|escape:'javascript':'UTF-8'}{literal}';
        var placeholderExp = '{/literal}{$placeholderExp|escape:'javascript':'UTF-8'}{literal}';
        var loadIntegrated = function() {
            if (typeof window['payplug_utilities'] != 'undefined') {
                window['payplug_utilities'].loadScript('{/literal}{$integrated_payment_js_url|escape:'javascript':'UTF-8'}{literal}', function() {
                    if(typeof window['payplug_module'] != 'undefined') {
                        window['payplug_module'].integrated.init();
                    } else {
                        console.log('Type of payplugModule : ' + typeof window['payplug_module']);
                    }
                });
            } else {
                console.log('Type of payplug_utilities : ' + typeof window['payplug_utilities']);
            }
        }
        if (typeof window['payplug_utilities'] != 'undefined' && typeof window['payplug_module'] != 'undefined') {
            loadIntegrated();
        } else {
            window.addEventListener("load", loadIntegrated);
        }
    {/literal}
</script>