{**
 * pm_advancedcookiebanner
 *
 * @author    Presta-Module.com <support@presta-module.com> - http://www.presta-module.com
 * @copyright Presta-Module - http://www.presta-module.com
 * @license   see file: LICENSE.txt
 *
 *           ____     __  __
 *          |  _ \   |  \/  |
 *          | |_) |  | |\/| |
 *          |  __/   | |  | |
 *          |_|      |_|  |_|
 *}

{extends file="helpers/form/form.tpl"}

{block name="field"}
    {if $input.type == 'title'}
        <div class="bo-remove-padding-left col-lg-8 col-lg-offset-4">
    {elseif $input.type == 'offsetLessTitle' || $input.type == 'csvExport'}
        <div class="bo-remove-padding-left">
    {/if}
    {$smarty.block.parent}
    {if $input.type == 'title' || $input.type == 'offsetLessTitle' || $input.type == 'csvExport'}
        </div>
    {/if}
{/block}

{block name="input"}
    {if $input.type == 'custom_columns'}
        <div id="acbLeftColumn" class="col-lg-3 col-md-3 col-sm-3 col-xs-3">
            <h2 class="acbSubtitle">{l s='Modules enabled without consent' mod='pm_advancedcookiebanner'}</h2>
            <ul id="availableModulesList" class="connectedSortable moduleList no-margin" data-id-input="PM_ACB_MODULES_ALLOWED">
                {if !empty($input.values.list.allowed)}
                    {foreach from=$input.values.list.allowed item=moduleInfos}
                        <li data-module-name="{$moduleInfos.name|escape:'html':'UTF-8'}" class="acbModuleBlacklist col-lg-12 col-md-12 col-sm-12 col-xs-12">
                            <span class="acbModuleLogo">
                                <img src="../modules/{$moduleInfos.name|escape:'html':'UTF-8'}/logo.png" />
                            </span>
                            <span class="acbModuleDisplayName">{$moduleInfos.displayName|escape:'html':'UTF-8'}</span>
                        </li>
                    {/foreach}
                {/if}
            </ul>
        </div>
        <div id="acbColumnsContainer" class="col-lg-9 col-md-9 col-sm-9 col-xs-9">
            <div class="col-lg-12 row">
                <h2 class="acbSubtitle">{l s='Statistics modules' mod='pm_advancedcookiebanner'}</h2>
                <ul id="acbReceiverAnalytics" data-id-input="PM_ACB_MODULES_ANALYTICS" class="connectedSortable">
                    <div class="acbPlaceholder {if !empty($input.values.list.analytics)}hide{/if}">
                        {l s='Drag here the module(s) that use cookies for statistics purposes' mod='pm_advancedcookiebanner'}
                    </div>
                    {if !empty($input.values.list.analytics)}
                        {foreach from=$input.values.list.analytics item=moduleInfos}
                            <li data-module-name="{$moduleInfos.name|escape:'html':'UTF-8'}" class="acbModuleBlacklist">
                                <span class="acbModuleLogo">
                                    <img src="../modules/{$moduleInfos.name|escape:'html':'UTF-8'}/logo.png" />
                                </span>
                                <span class="acbModuleDisplayName">{$moduleInfos.displayName|escape:'html':'UTF-8'}</span>
                                <div class="acbRemoveModuleIconContainer">
                                    <span class="ui-icon ui-icon-trash"></span>
                                </div>
                            </li>
                        {/foreach}
                    {/if}
                </ul>
            </div>
            <div class="col-lg-12 row">
                <h2 class="acbSubtitle">{l s='Marketing and Social network modules' mod='pm_advancedcookiebanner'}</h2>
                <ul id="acbReceiverMarketing" data-id-input="PM_ACB_MODULES_MARKETING" class="connectedSortable">
                    <div class="acbPlaceholder {if !empty($input.values.list.marketing)}hide{/if}">
                        {l s='Drag here the module(s) that use cookies for marketing or social purposes' mod='pm_advancedcookiebanner'}
                    </div>
                    {if !empty($input.values.list.marketing)}
                        {foreach from=$input.values.list.marketing item=moduleInfos}
                            <li data-module-name="{$moduleInfos.name|escape:'html':'UTF-8'}" class="acbModuleBlacklist">
                                <span class="acbModuleLogo">
                                    <img src="../modules/{$moduleInfos.name|escape:'html':'UTF-8'}/logo.png" />
                                </span>
                                <span class="acbModuleDisplayName">{$moduleInfos.displayName|escape:'html':'UTF-8'}</span>
                                <div class="acbRemoveModuleIconContainer">
                                    <span class="ui-icon ui-icon-trash"></span>
                                </div>
                            </li>
                        {/foreach}
                    {/if}
                </ul>
            </div>
        </div>

        <input type="text" class="hide" name="PM_ACB_MODULES_ALLOWED" value="{$input.values.input.allowed|escape:'html':'UTF-8'}" />
        <input type="text" class="hide" name="PM_ACB_MODULES_ANALYTICS" value="{$input.values.input.analytics|escape:'html':'UTF-8'}" />
        <input type="text" class="hide" name="PM_ACB_MODULES_MARKETING" value="{$input.values.input.marketing|escape:'html':'UTF-8'}" />

    {elseif $input.type == 'blocked_modules_list_explaination'}
        <div class="acbBlockedModulesListExplanation alert alert-info">
            <p>{l s='Select here the modules that use cookies and/or collect data, and have to be blocked until your customer has accepted your terms of use.' mod='pm_advancedcookiebanner'}</p>
            <ul>
                <li>{l s='The modules listed on the left column are the modules installed on your shop. All the modules in this column are enabled by default, and cannot be refused.' mod='pm_advancedcookiebanner'}</li>
                <li>{l s='The modules listed on the right column are the modules that you want to block until your customer has accepted your terms. These 2 categories can be declined, individually.' mod='pm_advancedcookiebanner'}</li>
            </ul>
        </div>

    {elseif $input.type == 'title' || $input.type == 'offsetLessTitle'}
        <h2>{$input.content}</h2>

    {elseif $input.type == 'maintenance_ip'}
        <input type="text" name="{$input.name|escape:'html':'UTF-8'}" class="{$input.class|escape:'html':'UTF-8'}" value="{$fields_value[$input.name]|escape:'html':'UTF-8'}" style="display:inline-block;">
        <button type="button" class="btn btn-default" onclick="addRemoteAddr();"><i class="icon-plus"></i> {l s='Add my IP' mod='pm_advancedcookiebanner'}</button>

        <script type="text/javascript">
            function addRemoteAddr()
            {
                var length = $("input[name={$input.name|escape:'html':'UTF-8'}]").attr("value").length;
                if (length > 0) {
                    $("input[name={$input.name|escape:'html':'UTF-8'}]").attr("value", $("input[name={$input.name|escape:'html':'UTF-8'}]").attr("value") + ",{Tools::getRemoteAddr()|escape:'html':'UTF-8'}");
                } else {
                    $("input[name={$input.name|escape:'html':'UTF-8'}]").attr("value", "{Tools::getRemoteAddr()|escape:'html':'UTF-8'}");
                }
            }
        </script>

    {elseif $input.type == 'custom_file'}
        <div class="form-group">
            <div class="col-sm-6">
                <input id="{$input.name|escape:'html':'UTF-8'}" type="file" name="{$input.name|escape:'html':'UTF-8'}" class="hide" accept="image/png,image/jpg,image/gif" />
                <div class="dummyfile input-group">
                    <span class="input-group-addon"><i class="icon-file"></i></span>
                    <input id="{$input.name|escape:'html':'UTF-8'}-name" class="disabled" style="cursor:default;" type="text" name="filename" readonly />
                    <span class="input-group-btn">
                        <button id="{$input.name|escape:'html':'UTF-8'}-selectbutton" type="button" name="submitAddAttachments" class="btn btn-default">
                            <i class="icon-folder-open"></i> {l s='Choose an image' mod='pm_advancedcookiebanner'}
                        </button>
                    </span>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div id="{$input.name|escape:'html':'UTF-8'}-images-thumbnails" class="col-lg-12">
                <img src="{$acb_path|escape:'html':'UTF-8'}views/img/{$acb_mobile_image_name|escape:'html':'UTF-8'}" class="img-thumbnail pm_acb_img_bo" />
                {if $acb_mobile_image_name != "default.png"}
                    <input type="checkbox" name="{$input.name|escape:'html':'UTF-8'}-remove"> {l s='Remove this image' mod='pm_advancedcookiebanner'}
                {/if}
            </div>
        </div>

        <script>
            $(document).ready(function(){
                $('#{$input.name|escape:'html':'UTF-8'}-selectbutton').click(function(e){
                    $('#{$input.name|escape:'html':'UTF-8'}').trigger('click');
                });
                $('#{$input.name|escape:'html':'UTF-8'}-name').click(function(e){
                    $('#{$input.name|escape:'html':'UTF-8'}').trigger('click');
                });
                $('#{$input.name|escape:'html':'UTF-8'}').change(function(e){
                    var val = $(this).val();
                    var file = val.split(/[\\/]/);
                    $('#{$input.name|escape:'html':'UTF-8'}-name').val(file[file.length-1]);
                });
            });
        </script>

    {else if $input.type == 'csvExport'}
        <div class="d-flex flex-column">
            <p>{l s='You can generate an export of your stored consents. Here is the detail of each field in the export:' mod='pm_advancedcookiebanner'}
            <ul>
                <li>{l s='id_customer/id_guest: The ID of the entity used by PrestaShop to identify the visitor' mod='pm_advancedcookiebanner'}</li>
                <li>{l s='consent: The level of consent given by the visitor:' mod='pm_advancedcookiebanner'}
                    <ul>
                        <li>{l s='0: Only required modules are allowed' mod='pm_advancedcookiebanner'}</li>
                        <li>{l s='1: Required and analytics modules are allowed' mod='pm_advancedcookiebanner'}</li>
                        <li>{l s='2: Required and marketing modules are allowed' mod='pm_advancedcookiebanner'}</li>
                        <li>{l s='3: All modules are allowed' mod='pm_advancedcookiebanner'}</li>
                    </ul>
                </li>
                <li>{l s='date_add: The date and time at which the consent was given (UTC)' mod='pm_advancedcookiebanner'}</li>
            </ul>
            <a target="_blank" rel="noopenner noreferrer" class="btn btn-primary mt-2" href="{$exportUrl|escape:'html':'UTF-8'}json">{l s='Export as JSON' mod='pm_advancedcookiebanner'}</a>
            <a target="_blank" rel="noopenner noreferrer" class="btn btn-primary mt-2" href="{$exportUrl|escape:'html':'UTF-8'}csv">{l s='Export as CSV' mod='pm_advancedcookiebanner'}</a>
        </div>

    {else if $input.type == 'advancedStyles'}
        <div class="pm_acb_advanced_styles_container">
            <textarea style="height:150px;" rows="5" name="{$input.name|escape:'html':'UTF-8'}" id="{$input.name|escape:'html':'UTF-8'}">{$advanced_styles}{* HTML *}</textarea>
        </div>

    {else}
        {$smarty.block.parent}
    {/if}
{/block}
