{*
/*
* 2011-2015 Lineagrafica.es
*
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://www.lineagrafica.es/eula.html
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to soporte@lineagrafica.es so we can send you a copy immediately.
*
* DISCLAIMER
*
*  @author Línea Gráfica Especialistas en Comercio Electrónico, S.L. <soporte@lineagrafica.es>
*  @copyright  2011-2015 Línea Gráfica Especialistas en Comercio Electrónico, S.L.
*  @version  See config.xml file to check version
*  @license    http://www.lineagrafica.es/eula.html  EULA License
*  International Registered Trademark & Property of Línea Gráfica Especialistas en Comercio Electrónico, S.L.
*/
*}
<div class="panel">
	{if isset($header)}{$header|escape:'htmlall':'UTF-8'}{/if}
	{if isset($nodes)}
	<ul id="{$id|escape:'htmlall':'UTF-8'}" class="tree">
		{$nodes|escape:'htmlall':'UTF-8'}
	</ul>
	{/if}
</div>
<script type="text/javascript">
	function checkAllAssociatedShops($tree)
	{
		$tree.find(":input[type=checkbox]").each(
			function()
			{
				$(this).prop("checked", true);
				$(this).parent().addClass("tree-selected");
			}
		);
	}

	function uncheckAllAssociatedShops($tree)
	{
		$tree.find(":input[type=checkbox]").each(
			function()
			{
				$(this).prop("checked", false);
				$(this).parent().removeClass("tree-selected");
			}
		);
	}

	$(document).ready(function () {
		$("#{$id|escape:'htmlall':'UTF-8'}").tree("expandAll");
		$("#{$id|escape:'htmlall':'UTF-8'}").find(":input[type=checkbox]").click(
			function()
			{
				if($(this).is(':checked'))
				{
					$(this).parent().addClass("tree-selected");
					$(this).parent().parent().find("ul").find(":input[type=checkbox]").each(
						function()
						{
							$(this).prop("checked", true);
							$(this).parent().addClass("tree-selected");
						}
					);
				}
				else
				{
					$(this).parent().removeClass("tree-selected");
					$(this).parent().parent().find("ul").find(":input[type=checkbox]").each(
						function()
						{
							$(this).prop("checked", false);
							$(this).parent().removeClass("tree-selected");
						}
					);
				}
			}
		);

		{if isset($selected_shops)}
			{assign var=imploded_selected_shops value='","'|implode:$selected_shops}
			var selected_shops = new Array("{$imploded_selected_shops|escape:'htmlall':'UTF-8'}");

			$("#{$id|escape:'htmlall':'UTF-8'}").find(".tree-item :input").each(
				function()
				{
					if ($.inArray($(this).val(), selected_shops) != -1)
					{
						$(this).prop("checked", true);
						$(this).parent().addClass("tree-selected");
						$(this).parents("ul.tree").each(
							function()
							{
								$(this).children().children().children(".icon-folder-close")
									.removeClass("icon-folder-close")
									.addClass("icon-folder-open");
								$(this).show();
							}
						);
					}
				}
			);
		{/if}
	});
</script>