{*
/*
* 2011-2015 Lineagrafica.es
*
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://www.lineagrafica.es/eula.html
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to soporte@lineagrafica.es so we can send you a copy immediately.
*
* DISCLAIMER
*
*  @author Línea Gráfica Especialistas en Comercio Electrónico, S.L. <soporte@lineagrafica.es>
*  @copyright  2011-2015 Línea Gráfica Especialistas en Comercio Electrónico, S.L.
*  @version  See config.xml file to check version
*  @license    http://www.lineagrafica.es/eula.html  EULA License
*  International Registered Trademark & Property of Línea Gráfica Especialistas en Comercio Electrónico, S.L.
*/
*}

<div class="leadin">{block name="leadin"}{/block}</div>

<script type="text/javascript">
	id_language = Number({$current_id_lang|escape:'htmlall':'UTF-8'});
	{if isset($tabs) && $tabs|count}
		var helper_tabs= {$tabs|escape:'htmlall':'UTF-8'|json_encode};
		var unique_field_id = '{$table|escape:'htmlall':'UTF-8'}_';
	{/if}
</script>
{block name="defaultOptions"}
<form action="{$current|escape:'htmlall':'UTF-8'}&amp;token={$token|escape:'htmlall':'UTF-8'}"
	id="{if $table == null}configuration_form{else}{$table|escape:'htmlall':'UTF-8'}_form{/if}"
	method="post"
	enctype="multipart/form-data" class="form-horizontal">
	{foreach $option_list AS $category => $categoryData}
		{if isset($categoryData['top'])}{$categoryData['top']|escape:'htmlall':'UTF-8'}{/if}
		<div class="panel {if isset($categoryData['class'])}{$categoryData['class']|escape:'htmlall':'UTF-8'}{/if}" id="{$table|escape:'htmlall':'UTF-8'}_fieldset_{$category|escape:'htmlall':'UTF-8'}">
			{* Options category title *}
			<div class="panel-heading">
				<i class="{if isset($categoryData['icon'])}{$categoryData['icon']|escape:'htmlall':'UTF-8'}{else}icon-cogs{/if}"></i>
				{if isset($categoryData['title'])}{$categoryData['title']|escape:'htmlall':'UTF-8'}{else}{l s='Options' mod='lgsitemaps'}{/if}
			</div>

			{* Category description *}

			{if (isset($categoryData['description']) && $categoryData['description'])}
				<div class="alert alert-info">{$categoryData['description']|escape:'htmlall':'UTF-8'}</div>
			{/if}
			{* Category info *}
			{if (isset($categoryData['info']) && $categoryData['info'])}
				<p>{$categoryData['info']|escape:'htmlall':'UTF-8'}</p>
			{/if}

			{if !$categoryData['hide_multishop_checkbox'] && $use_multishop}
			<div class="well clearfix">
				<label class="control-label col-lg-3">
					<i class="icon-sitemap"></i> {l s='Multistore' mod='lgsitemaps'}
				</label>
				<div class="col-lg-9">
					<span class="switch prestashop-switch fixed-width-lg">
						<input type="radio" name="{$table|escape:'htmlall':'UTF-8'}_multishop_{$category|escape:'htmlall':'UTF-8'}" id="{$table|escape:'htmlall':'UTF-8'}_multishop_{$category|escape:'htmlall':'UTF-8'}_on" value="1" onclick="toggleAllMultishopDefaultValue($('#{$table|escape:'htmlall':'UTF-8'}_fieldset_{$category|escape:'htmlall':'UTF-8'}'), true)">
						<label for="{$table|escape:'htmlall':'UTF-8'}_multishop_{$category|escape:'htmlall':'UTF-8'}_on">
							{l s='Yes' mod='lgsitemaps'}
						</label>
						<input type="radio" name="{$table|escape:'htmlall':'UTF-8'}_multishop_{$category|escape:'htmlall':'UTF-8'}" id="{$table|escape:'htmlall':'UTF-8'}_multishop_{$category|escape:'htmlall':'UTF-8'}_off" value="0" checked="checked" onclick="toggleAllMultishopDefaultValue($('#{$table|escape:'htmlall':'UTF-8'}_fieldset_{$category|escape:'htmlall':'UTF-8'}'), false)">
						<label for="{$table|escape:'htmlall':'UTF-8'}_multishop_{$category|escape:'htmlall':'UTF-8'}_off">
							{l s='No' mod='lgsitemaps'}
						</label>
						<a class="slide-button btn"></a>
					</span>
					<div class="row">
						<div class="col-lg-12">
							<p class="help-block">
								<strong>{l s='Check / Uncheck all' mod='lgsitemaps'}</strong>
								{l s='(If you are editing this page for several shops, some fields may be disabled. If you need to edit them, you will need to check the box for each field)' mod='lgsitemaps'}
							</p>
						</div>
					</div>
				</div>
			</div>
			{/if}

			<div class="form-wrapper">
			{foreach $categoryData['fields'] AS $key => $field}
					{if $field['type'] == 'hidden'}
						<input type="hidden" name="{$key|escape:'htmlall':'UTF-8'}" value="{$field['value']|escape:'htmlall':'UTF-8'}" />
					{else}
						<div class="form-group {if isset($field.form_group_class)} {$field.form_group_class|escape:'htmlall':'UTF-8'} {/if}" {if isset($tabs) && isset($field.tab)}data-tab-id="{$field.tab|escape:'htmlall':'UTF-8'}"{/if}>
							<div id="conf_id_{$key|escape:'htmlall':'UTF-8'}" {if $field['is_invisible']} class="isInvisible"{/if}>
								{block name="label"}
									{if isset($field['title']) && isset($field['hint'])}
										<label class="control-label col-lg-3 {if isset($field['required']) && $field['required'] && $field['type'] != 'radio'}required{/if}" for="{$key|escape:'htmlall':'UTF-8'}">
											{if !$categoryData['hide_multishop_checkbox'] && $field['multishop_default'] && empty($field['no_multishop_checkbox'])}
											<input type="checkbox" name="multishopOverrideOption[{$key|escape:'htmlall':'UTF-8'}]" value="1" {if !$field['is_disabled']}checked="checked"{/if} onclick="toggleMultishopDefaultValue(this, '{$key|escape:'htmlall':'UTF-8'}')"/>
											{/if}
											<span title="" data-toggle="tooltip" class="label-tooltip" data-original-title="
												{if is_array($field['hint'])}
													{foreach $field['hint'] as $hint}
														{if is_array($hint)}
															{$hint.text|escape:'htmlall':'UTF-8'}
														{else}
															{$hint|escape:'htmlall':'UTF-8'}
														{/if}
													{/foreach}
												{else}
													{$field['hint']|escape:'htmlall':'UTF-8'}
												{/if}
											" data-html="true">
												{$field['title']|escape:'htmlall':'UTF-8'}
											</span>
										</label>
									{elseif isset($field['title'])}
										<label class="control-label col-lg-3" for="{$key|escape:'htmlall':'UTF-8'}">
											{if !$categoryData['hide_multishop_checkbox'] && $field['multishop_default'] && empty($field['no_multishop_checkbox'])}
											<input type="checkbox" name="multishopOverrideOption[{$key|escape:'htmlall':'UTF-8'}]" value="1" {if !$field['is_disabled']}checked="checked"{/if} onclick="checkMultishopDefaultValue(this, '{$key|escape:'htmlall':'UTF-8'}')" />
											{/if}
											{$field['title']|escape:'htmlall':'UTF-8'}
										</label>
									{/if}
								{/block}
								{block name="field"}

								{block name="input"}
									{if $field['type'] == 'select'}
										<div class="col-lg-9">
											{if $field['list']}
												<select class="form-control fixed-width-xxl {if isset($field['class'])}{$field['class']|escape:'htmlall':'UTF-8'}{/if}" name="{$key|escape:'htmlall':'UTF-8'}"{if isset($field['js'])} onchange="{$field['js']|escape:'htmlall':'UTF-8'}"{/if} id="{$key|escape:'htmlall':'UTF-8'}" {if isset($field['size'])} size="{$field['size']|escape:'htmlall':'UTF-8'}"{/if}>
													{foreach $field['list'] AS $k => $option}
														<option value="{$option[$field['identifier']]|escape:'htmlall':'UTF-8'}"{if $field['value'] == $option[$field['identifier']]} selected="selected"{/if}>{$option['name']|escape:'htmlall':'UTF-8'}</option>
													{/foreach}
												</select>
											{else if isset($input.empty_message)}
												{$input.empty_message|escape:'htmlall':'UTF-8'}
											{/if}
										</div>
									{elseif $field['type'] == 'bool'}
										<div class="col-lg-9">
											<span class="switch prestashop-switch fixed-width-lg">
												<input type="radio" name="{$key|escape:'htmlall':'UTF-8'}" id="{$key|escape:'htmlall':'UTF-8'}_on" value="1" {if $field['value']} checked="checked"{/if}{if isset($field['js']['on'])} {$field['js']['on']|escape:'htmlall':'UTF-8'}{/if}/>
												<label for="{$key|escape:'htmlall':'UTF-8'}_on" class="radioCheck">
													{l s='Yes' mod='lgsitemaps'}
												</label>
												<input type="radio" name="{$key|escape:'htmlall':'UTF-8'}" id="{$key|escape:'htmlall':'UTF-8'}_off" value="0" {if !$field['value']} checked="checked"{/if}{if isset($field['js']['off'])} {$field['js']['off']|escape:'htmlall':'UTF-8'}{/if}/>
												<label for="{$key|escape:'htmlall':'UTF-8'}_off" class="radioCheck">
													{l s='No' mod='lgsitemaps'}
												</label>
												<a class="slide-button btn"></a>
											</span>
										</div>
									{elseif $field['type'] == 'radio'}
										<div class="col-lg-9">
											{foreach $field['choices'] AS $k => $v}
												<p class="radio">
													<label for="{$key|escape:'htmlall':'UTF-8'}_{$k|escape:'htmlall':'UTF-8'}">
														<input type="radio" name="{$key|escape:'htmlall':'UTF-8'}" id="{$key|escape:'htmlall':'UTF-8'}_{$k|escape:'htmlall':'UTF-8'}" value="{$k|escape:'htmlall':'UTF-8'}"{if $k == $field['value']} checked="checked"{/if}{if isset($field['js'][$k])} {$field['js'][$k]|escape:'htmlall':'UTF-8'}{/if}/>
													 	{$v|escape:'htmlall':'UTF-8'}
													</label>
												</p>
											{/foreach}
										</div>
									{elseif $field['type'] == 'checkbox'}
										<div class="col-lg-9">
											{foreach $field['choices'] AS $k => $v}
												<p class="checkbox">
													<input type="checkbox" name="{$key|escape:'htmlall':'UTF-8'}" id="{$key|escape:'htmlall':'UTF-8'}{$k|escape:'htmlall':'UTF-8'}_on" value="{$k|intval}"{if $k == $field['value']} checked="checked"{/if}{if isset($field['js'][$k])} {$field['js'][$k]|escape:'htmlall':'UTF-8'}{/if}/>
													<label class="col-lg-3" for="{$key|escape:'htmlall':'UTF-8'}{$k|escape:'htmlall':'UTF-8'}_on"> {$v|escape:'htmlall':'UTF-8'}</label>
												</p>
											{/foreach}
										</div>
									{elseif $field['type'] == 'text'}
										<div class="col-lg-9">{if isset($field['suffix'])}<div class="input-group">{/if}
											<input class="form-control {if isset($field['class'])}{$field['class']|escape:'htmlall':'UTF-8'}{/if}" type="{$field['type']|escape:'htmlall':'UTF-8'}"{if isset($field['id'])} id="{$field['id']|escape:'htmlall':'UTF-8'}"{/if} size="{if isset($field['size'])}{$field['size']|intval}{else}5{/if}" name="{$key}" value="{$field['value']|escape:'html':'UTF-8'}" {if isset($field['autocomplete']) && !$field['autocomplete']}autocomplete="off"{/if}/>
											{if isset($field['suffix'])}
											<span class="input-group-addon">
												{(string)$field['suffix']|escape:'htmlall':'UTF-8'}
											</span>
											{/if}
											{if isset($field['suffix'])}</div>{/if}
										</div>
									{elseif $field['type'] == 'password'}
										<div class="col-lg-9">{if isset($field['suffix'])}<div class="input-group">{/if}
											<input type="{$field['type']|escape:'htmlall':'UTF-8'}"{if isset($field['id'])} id="{$field['id']}"{/if} size="{if isset($field['size'])}{$field['size']|intval}{else}5{/if}" name="{$key|escape:'htmlall':'UTF-8'}" value="" {if isset($field['autocomplete']) && !$field['autocomplete']}autocomplete="off"{/if} />
											{if isset($field['suffix'])}
											<span class="input-group-addon">
												{(string)$field['suffix']|escape:'htmlall':'UTF-8'}
											</span>
											{/if}
											{if isset($field['suffix'])}</div>{/if}
										</div>
									{elseif $field['type'] == 'textarea'}
										<div class="col-lg-9">
											<textarea class="textarea-autosize" name={$key|escape:'htmlall':'UTF-8'} cols="{$field['cols']|escape:'htmlall':'UTF-8'}" rows="{$field['rows']|escape:'htmlall':'UTF-8'}">{$field['value']|escape:'html':'UTF-8'}</textarea>
										</div>
									{elseif $field['type'] == 'file'}
										<div class="col-lg-9">{$field['file']|escape:'htmlall':'UTF-8'}</div>
									{elseif $field['type'] == 'color'}
										<div class="col-lg-2">
											<div class="input-group">
												<input type="color" size="{$field['size']|escape:'htmlall':'UTF-8'}" data-hex="true" {if isset($input.class)}class="{$field['class']|escape:'htmlall':'UTF-8'}" {else}class="color mColorPickerInput"{/if} name="{$field['name']|escape:'htmlall':'UTF-8'}" class="{if isset($field['class'])}{$field['class']|escape:'htmlall':'UTF-8'}{/if}" value="{$field['value']|escape:'html':'UTF-8'}" />
											</div>
							            </div>
									{elseif $field['type'] == 'price'}
										<div class="col-lg-9">
											<div class="input-group fixed-width-lg">
												<span class="input-group-addon">{$currency_left_sign|escape:'htmlall':'UTF-8'}{$currency_right_sign|escape:'htmlall':'UTF-8'} {l s='(tax excl.)' mod='lgsitemaps'}</span>
												<input type="text" size="{if isset($field['size'])}{$field['size']|intval}{else}5{/if}" name="{$key|escape:'htmlall':'UTF-8'}" value="{$field['value']|escape:'html':'UTF-8'}" />
											</div>
										</div>
									{elseif $field['type'] == 'textLang' || $field['type'] == 'textareaLang' || $field['type'] == 'selectLang'}
										{if $field['type'] == 'textLang'}
											<div class="col-lg-9">
												<div class="row">
												{foreach $field['languages'] AS $id_lang => $value}
													{if $field['languages']|count > 1}
													<div class="translatable-field lang-{$id_lang|escape:'htmlall':'UTF-8'}" {if $id_lang != $current_id_lang}style="display:none;"{/if}>
														<div class="col-lg-9">
													{else}
													<div class="col-lg-12">
													{/if}
															<input type="text"
																name="{$key|escape:'htmlall':'UTF-8'}_{$id_lang|escape:'htmlall':'UTF-8'}"
																value="{$value|escape:'html':'UTF-8'}"
																{if isset($input.class)}class="{$input.class|escape:'htmlall':'UTF-8'}"{/if}
															/>
													{if $field['languages']|count > 1}
														</div>
														<div class="col-lg-2">
															<button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown">
																{foreach $languages as $language}
																	{if $language.id_lang == $id_lang}{$language.iso_code|escape:'htmlall':'UTF-8'}{/if}
																{/foreach}
																<span class="caret"></span>
															</button>
															<ul class="dropdown-menu">
																{foreach $languages as $language}
																<li>
																	<a href="javascript:hideOtherLanguage({$language.id_lang|escape:'htmlall':'UTF-8'});">{$language.name|escape:'htmlall':'UTF-8'}</a>
																</li>
																{/foreach}
															</ul>
														</div>
													</div>
													{else}
													</div>
													{/if}
												{/foreach}
												</div>
											</div>
										{elseif $field['type'] == 'textareaLang'}
											<div class="col-lg-9">
												{foreach $field['languages'] AS $id_lang => $value}
													<div class="row translatable-field lang-{$id_lang|escape:'htmlall':'UTF-8'}" {if $id_lang != $current_id_lang}style="display:none;"{/if}>
														<div id="{$key|escape:'htmlall':'UTF-8'}_{$id_lang|escape:'htmlall':'UTF-8'}" class="col-lg-9" >
															<textarea class="textarea-autosize" name="{$key|escape:'htmlall':'UTF-8'}_{$id_lang|escape:'htmlall':'UTF-8'}">{$value|replace:'\r\n':"\n"}</textarea>
														</div>
														<div class="col-lg-2">
															<button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown">
																{foreach $languages as $language}
																	{if $language.id_lang == $id_lang}{$language.iso_code|escape:'htmlall':'UTF-8'}{/if}
																{/foreach}
																<span class="caret"></span>
															</button>
															<ul class="dropdown-menu">
																{foreach $languages as $language}
																<li>
																	<a href="javascript:hideOtherLanguage({$language.id_lang|escape:'htmlall':'UTF-8'});">{$language.name|escape:'htmlall':'UTF-8'}</a>
																</li>
																{/foreach}
															</ul>
														</div>

													</div>
												{/foreach}
												<script type="text/javascript">
													$(document).ready(function() {
														$(".textarea-autosize").autosize();
													});
												</script>
											</div>
										{elseif $field['type'] == 'selectLang'}
											{foreach $languages as $language}
												<div id="{$key|escape:'htmlall':'UTF-8'}_{$language.id_lang|escape:'htmlall':'UTF-8'}" style="display: {if $language.id_lang == $current_id_lang}block{else}none{/if};" class="col-lg-9">
													<select name="{$key|escape:'htmlall':'UTF-8'}_{$language.iso_code|upper|escape:'htmlall':'UTF-8'}">
														{foreach $field['list'] AS $k => $v}
															<option value="{if isset($v.cast)}{$v.cast[$v[$field.identifier]]|escape:'htmlall':'UTF-8'}{else}{$v[$field.identifier]|escape:'htmlall':'UTF-8'}{/if}"
																{if $field['value'][$language.id_lang] == $v['name']} selected="selected"{/if}>
																{$v['name']|escape:'htmlall':'UTF-8'}
															</option>
														{/foreach}
													</select>
												</div>
											{/foreach}
										{/if}
									{/if}
									{if isset($field['desc']) && !empty($field['desc'])}
									<div class="col-lg-9 col-lg-offset-3">
										<p class="help-block">
											{if is_array($field['desc'])}
												{foreach $field['desc'] as $p}
													{if is_array($p)}
														<span id="{$p.id|escape:'htmlall':'UTF-8'}">{$p.text|escape:'htmlall':'UTF-8'}</span><br />
													{else}
														{$p|escape:'htmlall':'UTF-8'}<br />
													{/if}
												{/foreach}
											{else}
												{$field['desc']|escape:'htmlall':'UTF-8'}
											{/if}
										</p>
									</div>
									{/if}
								{/block}{* end block input *}
								{if $field['is_invisible']}
								<div class="col-lg-9 col-lg-offset-3">
									<p class="alert alert-warning row-margin-top">
										{l s='You can\'t change the value of this configuration field in the context of this shop.' mod='lgsitemaps'}
									</p>
								</div>
								{/if}
								{/block}{* end block field *}
							</div>
						</div>
				{/if}
			{/foreach}
			</div><!-- /.form-wrapper -->

			{if isset($categoryData['bottom'])}{$categoryData['bottom']|escape:'htmlall':'UTF-8'}{/if}
			{block name="footer"}
				{if isset($categoryData['submit']) || isset($categoryData['buttons'])}
					<div class="panel-footer">
						{if isset($categoryData['submit']) && !empty($categoryData['submit'])}
						<button type="{if isset($categoryData['submit']['type'])}{$categoryData['submit']['type']|escape:'htmlall':'UTF-8'}{else}submit{/if}" {if isset($categoryData['submit']['id'])}id="{$categoryData['submit']['id']|escape:'htmlall':'UTF-8'}"{/if} class="btn btn-default pull-right" name="{if isset($categoryData['submit']['name'])}{$categoryData['submit']['name']|escape:'htmlall':'UTF-8'}{else}submitOptions{$table|escape:'htmlall':'UTF-8'}{/if}"><i class="process-icon-{if isset($categoryData['submit']['imgclass'])}{$categoryData['submit']['imgclass']|escape:'htmlall':'UTF-8'}{else}save{/if}" ></i> {$categoryData['submit']['title']|escape:'htmlall':'UTF-8'}</button>
						{/if}
						{if isset($categoryData['buttons'])}
						{foreach from=$categoryData['buttons'] item=btn key=k}
						{if isset($btn.href) && trim($btn.href) != ''}
							<a href="{$btn.href|escape:'htmlall':'UTF-8'}" {if isset($btn['id'])}id="{$btn['id']|escape:'htmlall':'UTF-8'}"{/if} class="btn btn-default{if isset($btn['class'])} {$btn['class']|escape:'htmlall':'UTF-8'}{/if}" {if isset($btn.js) && $btn.js} onclick="{$btn.js|escape:'htmlall':'UTF-8'}"{/if}>{if isset($btn['icon'])}<i class="{$btn['icon']|escape:'htmlall':'UTF-8'}" ></i> {/if}{$btn.title|escape:'htmlall':'UTF-8'}</a>
						{else}
							<button type="{if isset($btn['type'])}{$btn['type']|escape:'htmlall':'UTF-8'}{else}button{/if}" {if isset($btn['id'])}id="{$btn['id']|escape:'htmlall':'UTF-8'}"{/if} class="{if isset($btn['class'])}{$btn['class']|escape:'htmlall':'UTF-8'}{else}btn btn-default{/if}" name="{if isset($btn['name'])}{$btn['name']|escape:'htmlall':'UTF-8'}{else}submitOptions{$table|escape:'htmlall':'UTF-8'}{/if}"{if isset($btn.js) && $btn.js} onclick="{$btn.js|escape:'htmlall':'UTF-8'}"{/if}>{if isset($btn['icon'])}<i class="{$btn['icon']|escape:'htmlall':'UTF-8'}" ></i> {/if}{$btn.title|escape:'htmlall':'UTF-8'}</button>
						{/if}
						{/foreach}
						{/if}
					</div>
				{/if}
			{/block}
		</div>
	{/foreach}
	{hook h='displayAdminOptions'}
	{if isset($name_controller)}
		{capture name=hookName assign=hookName}display{$name_controller|escape:'htmlall':'UTF-8'|ucfirst}Options{/capture}
		{hook h=$hookName}
	{elseif isset($smarty.get.controller)}
		{capture name=hookName assign=hookName}display{$smarty.get.controller|escape:'htmlall':'UTF-8'|ucfirst|htmlentities}Options{/capture}
		{hook h=$hookName}
	{/if}
</form>
{/block}
{block name="after"}{/block}
