{*
/*
* 2011-2015 Lineagrafica.es
*
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://www.lineagrafica.es/eula.html
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to soporte@lineagrafica.es so we can send you a copy immediately.
*
* DISCLAIMER
*
*  @author Línea Gráfica Especialistas en Comercio Electrónico, S.L. <soporte@lineagrafica.es>
*  @copyright  2011-2015 Línea Gráfica Especialistas en Comercio Electrónico, S.L.
*  @version  See config.xml file to check version
*  @license    http://www.lineagrafica.es/eula.html  EULA License
*  International Registered Trademark & Property of Línea Gráfica Especialistas en Comercio Electrónico, S.L.
*/
*}
<{if isset($href) && $href}a style="display:block" href="{$href|escape:'htmlall':'UTF-8'}"{else}div{/if} id="{$id|escape:'htmlall':'UTF-8'}" class="box-stats {$color|escape:'htmlall':'UTF-8'}" >
	<div class="kpi-content">
	{if isset($icon) && $icon}
		<i class="{$icon|escape'htmlall':'UTF-8'}"></i>
	{/if}
	{if isset($chart) && $chart}
		<div class="boxchart-overlay">
			<div class="boxchart">
			</div>
		</div>
	{/if}
	
		<span class="title">{$title|escape:'htmlall':'UTF-8'}</span>
		<span cLass="subtitle">{$subtitle|escape:'htmlall':'UTF-8'}</span>
		<span class="value">{$value|escape:'htmlall':'UTF-8'|replace:'&amp;':'&'}</span>
	</div>
	
</{if isset($href) && $href}a{else}div{/if}>

{if isset($source) && $source != ''}
<script>
	$.ajax({
		url: '{$source|escape:'htmlall':'UTF-8'|addslashes}' + '&rand=' + new Date().getTime(),
		dataType: 'json',
		type: 'GET',
		cache: false,
		headers: { 'cache-control': 'no-cache' },
		success: function(jsonData){
			if (!jsonData.has_errors)
			{
				if (jsonData.value != undefined)
					$('#{$id|escape:'htmlall':'UTF-8'|addslashes} .value').html(jsonData.value);
				if (jsonData.data != undefined)
				{
					$("#{$id|escape:'htmlall':'UTF-8'|addslashes} .boxchart svg").remove();
					set_d3_{$id|escape:'htmlall':'UTF-8'|str_replace:'-':'_'|addslashes}(jsonData.data);
				}
			}
		}
	});
</script>
{/if}

{if $chart}
<script>
	function set_d3_{$id|escape:'htmlall':'UTF-8'|str_replace:'-':'_'|addslashes}(jsonObject)
	{
		var data = new Array;
		$.each(jsonObject, function (index, value) {
			data.push(value);
		});
		var data_max = d3.max(data);

		var chart = d3.select("#{$id|escape:'htmlall':'UTF-8'|addslashes} .boxchart").append("svg")
			.attr("class", "data_chart")
			.attr("width", data.length * 6)
			.attr("height", 45);

		var y = d3.scale.linear()
			.domain([0, data_max])
			.range([0, data_max * 45]);

		chart.selectAll("rect")
			.data(data)
			.enter().append("rect")
			.attr("y", function(d) { return 45 - d * 45 / data_max; })
			.attr("x", function(d, i) { return i * 6; })
			.attr("width", 4)
			.attr("height", y);
	}
	
	{if $data}
		set_d3_{$id|escape:'htmlall':'UTF-8'|str_replace:'-':'_'|escape:'htmlall':'UTF-8'|addslashes}($.parseJSON("{$data|escape:'htmlall':'UTF-8'|addslashes}"));
	{/if}
</script>
{/if}