{*
/*
* 2011-2015 Lineagrafica.es
*
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://www.lineagrafica.es/eula.html
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to soporte@lineagrafica.es so we can send you a copy immediately.
*
* DISCLAIMER
*
*  @author Línea Gráfica Especialistas en Comercio Electrónico, S.L. <soporte@lineagrafica.es>
*  @copyright  2011-2015 Línea Gráfica Especialistas en Comercio Electrónico, S.L.
*  @version  See config.xml file to check version
*  @license    http://www.lineagrafica.es/eula.html  EULA License
*  International Registered Trademark & Property of Línea Gráfica Especialistas en Comercio Electrónico, S.L.
*/
*}
{if count($categories) && isset($categories)}
	<script type="text/javascript">
		var inputName = '{$categories.input_name|escape:'htmlall':'UTF-8'|@addcslashes:'\''}';
		var use_radio = {if $categories.use_radio}1{else}0{/if};
		var selectedCat = {$categories.selected_cat|@implode|intval};
		var selectedLabel = '{$categories.trads.selected|escape:'htmlall':'UTF-8'|@addcslashes:'\''}';
		var home = '{$categories.trads.Root.name|escape:'htmlall':'UTF-8'|@addcslashes:'\''}';
		var use_radio = {if $categories.use_radio}1{else}0{/if};
		var use_context = {if isset($categories.use_context)}1{else}0{/if};
	</script>
<div class="panel">
	<div class="category-filter panel-heading">
		<a href="#" id="collapse_all" class="btn btn-link"><i class="icon-collapse-alt icon-large"></i> {$categories.trads['Collapse All']|escape:'htmlall':'UTF-8'}</a>
	 	<a href="#" id="expand_all" class="btn btn-link"><i class="icon-expand-alt icon-large"></i> {$categories.trads['Expand All']|escape:'htmlall':'UTF-8'}</a> 
		{if !$categories.use_radio}
		<a href="#" id="check_all" class="btn btn-link"><i class="icon-check-sign"></i> {$categories.trads['Check All']|escape:'htmlall':'UTF-8'}</a>
		<a href="#" id="uncheck_all" class="btn btn-link"><i class="icon-check-empty"></i> {$categories.trads['Uncheck All']|escape:'htmlall':'UTF-8'}</a>
		{/if}
		{if $categories.use_search}
			<span>
				{$categories.trads.search|escape:'htmlall':'UTF-8'}:&nbsp;
				<form method="post" id="filternameForm">
					<input type="text" name="search_cat" id="search_cat"/>
				</form>
			</span>
		{/if}
	</div>
	{assign var=home_is_selected value=false}
	{foreach $categories.selected_cat AS $cat}
		{if is_array($cat)}
			{if $cat.id_category != $categories.trads.Root.id_category}
				<input {if in_array($cat.id_category, $categories.disabled_categories)}disabled="disabled"{/if} type="hidden" name="{$categories.input_name|escape:'htmlall':'UTF-8'}" value="{$cat.id_category|escape:'htmlall':'UTF-8'}"/>
			{else}
				{assign var=home_is_selected value=true}
			{/if}
		{else}
			{if $cat != $categories.trads.Root.id_category}
				<input {if in_array($cat, $categories.disabled_categories)}disabled="disabled"{/if} type="hidden" name="{$categories.input_name|escape:'htmlall':'UTF-8'}" value="{$cat|escape:'htmlall':'UTF-8'}"/>
			{else}
				{assign var=home_is_selected value=true}
			{/if}
		{/if}
	{/foreach}
	<ul id="categories-treeview" class="filetree">
		<li id="{$categories.trads.Root.id_category|escape:'htmlall':'UTF-8'}" class="hasChildren">
			<span class="folder">
				{if $categories.top_category->id != $categories.trads.Root.id_category}
					<input type="{if !$categories.use_radio}checkbox{else}radio{/if}"
							name="{$categories.input_name|escape:'htmlall':'UTF-8'}"
							value="{$categories.trads.Root.id_category|escape:'htmlall':'UTF-8'}"
							{if $home_is_selected}checked="checked"{/if}
							onclick="clickOnCategoryBox($(this));"/>
						<span class="category_label">{$categories.trads.Root.name|escape:'htmlall':'UTF-8'}</span>
				{else}
					&nbsp;
				{/if}
			</span>
			<ul>
				<li><span class="placeholder">&nbsp;</span></li>
		  	</ul>
		</li>
	</ul>
	{if $categories.use_radio}
	<script type="text/javascript">
		searchCategory();
	</script>
	{/if}
</div>
{/if}
