{*
/*
* 2011-2015 Lineagrafica.es
*
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://www.lineagrafica.es/eula.html
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to soporte@lineagrafica.es so we can send you a copy immediately.
*
* DISCLAIMER
*
*  @author Línea Gráfica Especialistas en Comercio Electrónico, S.L. <soporte@lineagrafica.es>
*  @copyright  2011-2015 Línea Gráfica Especialistas en Comercio Electrónico, S.L.
*  @version  See config.xml file to check version
*  @license    http://www.lineagrafica.es/eula.html  EULA License
*  International Registered Trademark & Property of Línea Gráfica Especialistas en Comercio Electrónico, S.L.
*/
*}

<div id="datepicker" class="row row-padding-top hide">
	<div class="col-lg-12">
		<div class="daterangepicker-days">
			<div class="row">	
				{if $is_rtl}
				<div class="col-sm-6 col-lg-4">
					<div class="datepicker2" data-date="{$date_to|escape:'htmlall':'UTF-8'}" data-date-format="{$date_format|escape:'htmlall':'UTF-8'}"></div>
				</div>
				<div class="col-sm-6 col-lg-4">
					<div class="datepicker1" data-date="{$date_from|escape:'htmlall':'UTF-8'}" data-date-format="{$date_format|escape:'htmlall':'UTF-8'}"></div>
				</div>
				{else}
				<div class="col-sm-6 col-lg-4">
					<div class="datepicker1" data-date="{$date_from|escape:'htmlall':'UTF-8'}" data-date-format="{$date_format|escape:'htmlall':'UTF-8'}"></div>
				</div>
				<div class="col-sm-6 col-lg-4">
					<div class="datepicker2" data-date="{$date_to|escape:'htmlall':'UTF-8'}" data-date-format="{$date_format|escape:'htmlall':'UTF-8'}"></div>
				</div>
				{/if}
				<div class="col-xs-12 col-sm-6 col-lg-4 pull-right">
					<div id='datepicker-form' class='form-inline'>
						<div id='date-range' class='form-date-group'>
							<div  class='form-date-heading'>
								<span class="title">{l s='Date range' mod='lgsitemaps'}</span>
								{if isset($actions) && $actions|count > 0}
									{if $actions|count > 1}
									<button class='btn btn-default btn-xs pull-right dropdown-toggle' data-toggle='dropdown' type="button">
										{l s='Custom' mod='lgsitemaps'}
										<i class='icon-angle-down'></i>
									</button>
									<ul class='dropdown-menu'>
										{foreach from=$actions item=action}
										<li><a{if isset($action.href)} href="{$action.href|escape:'htmlall':'UTF-8'}"{/if}{if isset($action.class)} class="{$action.class|escape:'htmlall':'UTF-8'}"{/if}>{if isset($action.icon)}<i class="{$action.icon|escape:'htmlall':'UTF-8'}"></i> {/if}{$action.label|escape:'htmlall':'UTF-8'}</a></li>
										{/foreach}
									</ul>
									{else}
									<a{if isset($actions[0].href)} href="{$actions[0].href|escape:'htmlall':'UTF-8'}"{/if} class="btn btn-default btn-xs pull-right{if isset($actions[0].class)} {$actions[0].class|escape:'htmlall':'UTF-8'}{/if}">{if isset($actions[0].icon)}<i class="{$actions[0].icon|escape:'htmlall':'UTF-8'}"></i> {/if}{$actions[0].label|escape:'htmlall':'UTF-8'}</a>
									{/if}
								{/if}
							</div>
							<div class='form-date-body'>
								<label>{l s='From' mod='lgsitemaps'}</label>
								<input class='date-input form-control' id='date-start' placeholder='Start' type='text' name="date_from" value="{$date_from|escape:'htmlall':'UTF-8'}" data-date-format="{$date_format|escape:'htmlall':'UTF-8'}" tabindex="1" />
								<label>{l s='to' mod='lgsitemaps'}</label>
								<input class='date-input form-control' id='date-end' placeholder='End' type='text' name="date_to" value="{$date_to|escape:'htmlall':'UTF-8'}" data-date-format="{$date_format|escape:'htmlall':'UTF-8'}" tabindex="2" />
							</div>
						</div>
						<div id="date-compare" class='form-date-group'>
							<div class='form-date-heading'>
								<span class="checkbox-title">
									<label >
										<input type='checkbox' id="datepicker-compare" name="datepicker_compare"{if isset($compare_date_from) && isset($compare_date_to)} checked="checked"{/if} tabindex="3">
										{l s='Compare to' mod='lgsitemaps'}
									</label>
								</span>
								<select id="compare-options" class="form-control fixed-width-lg pull-right" name="compare_date_option"{if is_null($compare_date_from) || is_null($compare_date_to)} disabled="disabled"{/if}>
									<option value="1" {if $compare_option == 1}selected="selected"{/if} label="{l s='Previous period' mod='lgsitemaps'}">{l s='Previous period' mod='lgsitemaps'}</option>
									<option value="2" {if $compare_option == 2}selected="selected"{/if} label="{l s='Previous Year' mod='lgsitemaps'}">{l s='Previous year' mod='lgsitemaps'}</option>
									<option value="3" {if $compare_option == 3}selected="selected"{/if} label="{l s='Custom' mod='lgsitemaps'}">{l s='Custom' mod='lgsitemaps'}</option>
								</select>
							</div>
							<div class="form-date-body" id="form-date-body-compare"{if is_null($compare_date_from) || is_null($compare_date_to)} style="display: none;"{/if}>
								<label>{l s='From' mod='lgsitemaps'}</label>
								<input id="date-start-compare" class="date-input form-control" type="text" placeholder="Start" name="compare_date_from" value="{$compare_date_from|escape:'htmlall':'UTF-8'}" data-date-format="{$date_format|escape:'htmlall':'UTF-8'}" tabindex="4" />
								<label>{l s='to' mod='lgsitemaps'}</label>
								<input id="date-end-compare" class="date-input form-control" type="text" placeholder="End" name="compare_date_to" value="{$compare_date_to|escape:'htmlall':'UTF-8'}" data-date-format="{$date_format|escape:'htmlall':'UTF-8'}" 
								tabindex="5" />
							</div>
						</div>
						<div class='form-date-actions'>
							<button class='btn btn-link' type='button' id="datepicker-cancel" tabindex="7">
								<i class='icon-remove'></i>
								{l s='Cancel' mod='lgsitemaps'}
							</button>
							<button class='btn btn-default pull-right' type='submit' name="submitDateRange" tabindex="6">
								<i class='icon-ok text-success'></i>
								{l s='Apply' mod='lgsitemaps'}
							</button>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<script type="text/javascript">
	translated_dates = {
		days: ['{l s='Sunday' js=1 mod='lgsitemaps'}', '{l s='Monday' js=1 mod='lgsitemaps'}', '{l s='Tuesday' js=1 mod='lgsitemaps'}', '{l s='Wednesday' js=1 mod='lgsitemaps'}', '{l s='Thursday' js=1 mod='lgsitemaps'}', '{l s='Friday' js=1 mod='lgsitemaps'}', '{l s='Saturday' js=1 mod='lgsitemaps'}', '{l s='Sunday' js=1 mod='lgsitemaps'}'],
		daysShort: ['{l s='Sun' js=1 mod='lgsitemaps'}', '{l s='Mon' js=1 mod='lgsitemaps'}', '{l s='Tue' js=1 mod='lgsitemaps'}', '{l s='Wed' js=1 mod='lgsitemaps'}', '{l s='Thu' js=1 mod='lgsitemaps'}', '{l s='Fri' js=1 mod='lgsitemaps'}', '{l s='Sat' js=1 mod='lgsitemaps'}', '{l s='Sun' js=1 mod='lgsitemaps'}'],
		daysMin: ['{l s='Su' js=1 mod='lgsitemaps'}', '{l s='Mo' js=1 mod='lgsitemaps'}', '{l s='Tu' js=1 mod='lgsitemaps'}', '{l s='We' js=1 mod='lgsitemaps'}', '{l s='Th' js=1 mod='lgsitemaps'}', '{l s='Fr' js=1 mod='lgsitemaps'}', '{l s='Sa' js=1 mod='lgsitemaps'}', '{l s='Su' js=1 mod='lgsitemaps'}'],
		months: ['{l s='January' js=1 mod='lgsitemaps'}', '{l s='February' js=1 mod='lgsitemaps'}', '{l s='March' js=1 mod='lgsitemaps'}', '{l s='April' js=1 mod='lgsitemaps'}', '{l s='May' js=1 mod='lgsitemaps'}', '{l s='June' js=1 mod='lgsitemaps'}', '{l s='July' js=1 mod='lgsitemaps'}', '{l s='August' js=1 mod='lgsitemaps'}', '{l s='September' js=1 mod='lgsitemaps'}', '{l s='October' js=1 mod='lgsitemaps'}', '{l s='November' js=1 mod='lgsitemaps'}', '{l s='December' js=1 mod='lgsitemaps'}'],
		monthsShort: ['{l s='Jan' js=1 mod='lgsitemaps'}', '{l s='Feb' js=1 mod='lgsitemaps'}', '{l s='Mar' js=1 mod='lgsitemaps'}', '{l s='Apr' js=1 mod='lgsitemaps'}', '{l s='May' js=1 mod='lgsitemaps'}', '{l s='Jun' js=1 mod='lgsitemaps'}', '{l s='Jul' js=1 mod='lgsitemaps'}', '{l s='Aug' js=1 mod='lgsitemaps'}', '{l s='Sep' js=1 mod='lgsitemaps'}', '{l s='Oct' js=1 mod='lgsitemaps'}', '{l s='Nov' js=1 mod='lgsitemaps'}', '{l s='Dec' js=1 mod='lgsitemaps'}']
	};
</script>
