{**
 * 2007-2017 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2017 PrestaShop SA
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 * International Registered Trademark & Property of PrestaShop SA
 *}
<!doctype html>
<html lang="{$language.iso_code}">

<head>


  {block name='head'}
    {include file='_partials/head.tpl'}
  {/block}
</head>
{assign var="device" value="desktop"}

{if Context::getContext()->isMobile()}

  {assign var="device" value="mobile"}

{else if  Context::getContext()->isTablet()}

  {assign var="device" value="tablet"}

{else}

  {assign var="device" value="desktop"}

{/if}

<body id="{$page.page_name}" class="cgv1 {$page.body_classes|classnames}  {$device} {if isset($roythemes.o_add) && $roythemes.o_add == "1"} add1{/if} customerGroup{Group::getCurrent()->id} {if $page.page_name == 'product'}

{if in_array(120,Product::getProductCategories($product->id|intval))}
porteur
{/if}
{if in_array(119,Product::getProductCategories($product->id|intval))}
nohayon
{/if}
{if in_array(132,Product::getProductCategories($product->id|intval))}
hayon
{/if}
 {/if}" data-layout="{if isset($roythemes.g_lay)}{$roythemes.g_lay}{/if}" {if $page.page_name == 'product'}
  data-spy="scroll" data-target="#side">
  {/if}{if $page.page_name != 'product'}>{/if}



  {block name='hook_after_body_opening_tag'}
    {hook h='displayAfterBodyOpeningTag'}
  {/block}


  <main class="">


    {if isset($roythemes.g_lay) && $roythemes.g_lay == "4"}<div class="lay_boxed">{/if}

      {block name='product_activation'}
        {include file='catalog/_partials/product-activation.tpl'}
      {/block}

      <header id="header">
        {block name='header'}
          {include file='_partials/header.tpl'}
        {/block}
      </header>



      {* {if $device === 'desktop' &&  $customer.id_default_group != 7}
{include file="_partials/cg-menu-desktop.tpl"}
{else if $device === 'mobile' &&  $customer.id_default_group != 7}
{include file="_partials/cg-menu-mobile.tpl"}
{/if} *}
      {* {if $device === 'desktop' &&  $customer.id_default_group != 7}

        {block name='cgtopnav'}

          {include file="_partials/cg-topnav.tpl"}

        {/block}

      {/if} *}
      {block name='notifications'}
        {include file='_partials/notifications.tpl'}
      {/block}

      {block name='breadcrumb'}
        {include file='_partials/breadcrumb.tpl'}
      {/block}
      <section id="wrapper" class="stick_parent_lb">

        {hook h="displayWrapperTop"}
        {*   <div {if $page.page_name == 'cms' || $page.page_name == 'index' || $page.page_name == 'product' || $page.page_name == 'pagenotfound' || $page.page_name == 'order-confirmation'|| $page.page_name == 'module-b2bregistration-business'} class="container-fluid" style="padding:0;"{else} class="container" {/if}> *}
        {if $page.page_name == 'category' && $category.id == 226}
          {include file='catalog/category-configurator.tpl'}
        {else}
          <div class="container-fluid">

            {hook h="displayLeviBox"}
            {if $page.page_name == 'category'}
              {if $category.id!= 144}

                <div id="cg-catheader" class="block-category">




                  <div id="category-description" class="readmore closed">
                    <h1 class="h1">{$category.name}</h1>
                    {if $category.description}
                      {$category.description nofilter}
                    {/if}

                  </div>
                  <div class="hidden-lg-down" style="background-image:url({$category.image.large.url});">
                  </div>


                </div>
              {else}
                <div id="backtoschool" class="bg-red-img flexmaster gap parallax">
                  <h1 style="color:#fff">Promotions équipement d'atelier</h1>


          </div>
          {/if}

          {if $device != 'mobile' && $category.id!= 144}
          {include file='catalog/_partials/cg-gondole.tpl'}
          {/if}

          {* {block name='cg-subcategories'}
           {include file='catalog/_partials/cg-subcategories.tpl'}
           {/block} *}
          {/if}

          {if $page.page_name == 'manufacturer'}

          <div id="cg-catheader" class="block-category">




            <div id="category-description" class="text-muted readmore closed">
              <h1>Équipement d'atelier {$manufacturer.name}</h1>
                    <div id="manufacturer-short_description">{$manufacturer.short_description nofilter}</div>
                    <div id="manufacturer-description">{$manufacturer.description nofilter}</div>

                  </div>


                </div>
              {/if}
              {if $page.page_name == 'prices-drop'}

                <div id="cg-catheader" class="block-category">




                  <div id="category-description" class="text-muted readmore closed">
                    <h1>Équipement d'atelier en promotion</h1>
              <div>
                <p>Sélection d'équipement professionnel à prix réduit. Le meilleur de l'équipement d'atelier, outillage
                        pour garagistes, pneumaticiens et carrossiers ainsi que consommables pour la réparation et le
                        changement des pneumatiques.</p>
                    </div>

                  </div>


                </div>
              {/if}


              {if $page.page_name != 'index'}
                {block name="top_column"}
                  <div id="top_column">
                    {hook h='displayTopColumn'}
                  </div>
                {/block}
              {/if}
              <div class="stickinside">
                {if $page.page_name == 'product'}
                  {block name="left_column"}
                    <div class="side-column">
                      <div class="stickme">{hook h='displayLeftColumnProduct'}
                      </div>
                    </div>
                  {/block}
                {else if $page.page_name == 'category'}
                  {block name="left_column"}
                    <div class="cgleftcol shidden m4 l2">
                      {* <div id="39e7a80b-799d-4882-afc3-b7b76988182b" class="cgavis"></div><script async charset="utf-8" src="https://widgets.rr.skeepers.io/generated/4dd229ad-e15a-2e94-dd2c-d13b1c5d285e/39e7a80b-799d-4882-afc3-b7b76988182b.js"></script> *}
                      {block name='cg-subcategories'}
                        {include file='catalog/_partials/cg-subcategories.tpl'}
                      {/block}
                      <div class="stickme">
                        {hook h='displayLeftColumn'}
                        {if $page.page_name == "category" && $category.id != 144}

                          {$globaltags = []}
                          {foreach from=$listing.products item="product"}
                            {if Tag::getProductTags($product.id_product)}

                              {foreach Tag::getProductTags($product.id_product) as $k=>$tags}
                                {foreach $tags as $tag}
                                  {if $tag|in_array:$globaltags}
                                  {else}
                                    {$globaltags[]=$tag}
                                  {/if}
                                {/foreach}
                              {/foreach}
                            {/if}
                          {/foreach}
                          {if !empty($globaltags) }
                            <div id="category_tags" class="l8 m8 s12 well">
                              <h3>Trouvez votre {$category.name} avec ces tags : </h3>
                              <ul class="product-tags l12 m12 s12">
                                {foreach from=$globaltags item=globaltag}
                                  {* <div>{$globaltag}</div> *}
                                  <li><a
                                      href="{$link->getPageLink('search', true, NULL, [tag =>$globaltag|urlencode])}">{$globaltag|escape:html:'UTF-8'}</a>
                                  </li>
                                {/foreach}
                              </ul>
                            </div>
                          {/if}
                        {/if}
                      </div>
                    </div>
                  {/block}
                {/if}
                {block name="content_wrapper"}
                  <div id="content-wrapper" class="right-column">
                    {hook h="displayContentWrapperTop"}
                    {block name="content"}
                      <p>Hello world! This is HTML5 Boilerplate.</p>
                    {/block}
                    {hook h="displayContentWrapperBottom"}
                  </div>
                {/block}
              </div>
              {block name="right_column"}
                <div id="right-column" class="col-md-12 col-lg-3 side-column">
                  {if $page.page_name == 'product'}
                    {hook h='displayRightColumnProduct'}
                  {else}
                    {hook h="displayRightColumn"}
                  {/if}
                </div>
              {/block}
            </div>
          {/if}
          {hook h="displayWrapperBottom"}
        </section>
        {if $page.page_name == 'product'}
          <section id="postlist">

            <div id="bottomlinks" class="cardlist">



              <div class="pts">
                <h2><a href="https://www.protruckshop.com/" target="_blank" rel="follow"><strong>Pièces camions &amp;
                      VUL</strong></a></h2><a href="https://www.protruckshop.com/" title="pièces détachées camion"
                  rel="follow"><img src="/themes/modez/assets/img/logos/logo-protruckshop.jpg" width="200" height="49"
                    style="margin-bottom: 15px;" alt="Logo Protruck Shop">
                </a>
                <p>Plus de 20 000 références de pièces détachées pour poids lourds, utilitaires et remorques aux meilleurs
                  prix</p>
                <a class="btn btn-default" href="https://www.protruckshop.com/" rel="follow">Découvrez les pièces poids
                  lourds et VUL</a>
              </div>
            </div>
          </section>
        {/if}
        {if $page.page_name == 'category'}
          <section id="postlist">



            {hook h='displayTexteBas'}




            <div id="bottomlinks" class="cardlist">
              <div class="pts">
                <h2><a href="https://www.protruckshop.com/" target="_blank" rel="follow"><strong>Pièces camions &amp;
                      VUL</strong></a></h2><a href="https://www.protruckshop.com/" title="pièces détachées camion"
                  rel="follow"><img src="/themes/modez/assets/img/logos/logo-protruckshop.jpg" width="200" height="49"
                    style="margin-bottom: 15px;" alt="Logo Protruck Shop">
                </a>
                <p>Plus de 20 000 références de pièces détachées pour poids lourds, utilitaires et remorques aux meilleurs
                  prix</p>
                <a class="btn btn-default" href="https://www.protruckshop.com/" rel="follow">Découvrez les pièces poids
                  lourds et VUL</a>
              </div>
            </div>
          </section>
        {/if}
        <footer id="footer">
          {block name="footer"}
            {include file="_partials/footer.tpl"}
          {/block}
        </footer>


        {if isset($roythemes.g_lay) && $roythemes.g_lay == "4"}
      </div>{/if}

    </main>

    {block name='javascript_bottom'}
      {include file="_partials/javascript.tpl" javascript=$javascript.bottom}
    {/block}



    {block name='hook_before_body_closing_tag'}
      {hook h='displayBeforeBodyClosingTag'}
    {/block}
    {if $page.page_name == 'category' || $page.page_name =='module-ambjolisearch-jolisearch' || $page.page_name =='manufacturer' || $page.page_name =='product'}
      {include file="catalog/modal-utilisation.tpl"}
    {/if}

    <script async charset="utf-8"
      src="https://brand-widgets.rr.skeepers.io/generated/4dd229ad-e15a-2e94-dd2c-d13b1c5d285e/664cb987-6c33-4d34-ac8e-f1ecf554bda5.js">
    </script>


    {* TIDIO CHAT *}
    {*         {if $page.page_name == "product" && $product.width > 99}
          <script src="//code.tidio.co/4zfyz6rki6cduryoszzlev3evpmmauoo.js" async></script>
          {elseif $page.page_name == "product" && $product.id_product == 470}
            <script src="//code.tidio.co/4zfyz6rki6cduryoszzlev3evpmmauoo.js" async></script>
          {/if} *}


    <div id="modal_franco" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title">Livraison offerte dès 200€ HT* <button type="button" class="close float-right"
                data-dismiss="modal" aria-label="Close"> <span aria-hidden="true">&times;</span> </button></h5>
          </div>
          <div class="modal-body text-center">
            <p>*La livraison est offerte pour le consommable et l'outillage <span class="small">(Articles avec l'icône
                <img src="{$urls.base_url}modules/jprestaspeedpack/views/img/lazyloader.svg" class="flag lazyload"
                  width="25" height="25" alt="frais de port offerts pour toute commande de plus de 200€ HT"
                  data-src="/themes/modez/assets/img/icones/franco200.svg" />)</span> dès 200€ d'achat HT.</p>
          <p>La livraison <b>ne sera pas offerte</b> si le panier contient un article ne répondant pas à ce critère.</p>
        </div>
      </div>
    </div>
  </div>




{*  {if $page.page_name == 'category' && $category.id == 226}
        <script type="text/javascript" src="/themes/modez/assets/js/category-configurator.js"></script>
    {/if}
   *}

  </html>