{**
 * 2007-2017 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2017 PrestaShop SA
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 * International Registered Trademark & Property of PrestaShop SA
 *}
<!doctype html>
<html lang="{$language.iso_code}">

  <head>


    {block name='head'}
      {include file='_partials/head.tpl'}
    {/block}
  </head>

  <body id="{$page.page_name}" class="cgv1 {$page.body_classes|classnames}{if isset($roythemes.o_add) && $roythemes.o_add == "1"} add1{/if} customerGroup{Group::getCurrent()->id} {if $page.page_name == 'product'}

{if in_array(120,Product::getProductCategories($product->id|intval))}
porteur
{/if}
{if in_array(119,Product::getProductCategories($product->id|intval))}
nohayon
{/if}
{if in_array(132,Product::getProductCategories($product->id|intval))}
hayon
{/if}
 {/if}" data-layout="{if isset($roythemes.g_lay)}{$roythemes.g_lay}{/if}" {if $page.page_name == 'product'} data-spy="scroll" data-target="#side">
{/if}{if $page.page_name != 'product'}>{/if}
    {block name='hook_after_body_opening_tag'}
      {hook h='displayAfterBodyOpeningTag'}
    {/block}
    {block name='cgmenu'}

      {include file="_partials/cgmenuwidget.tpl"}

    {/block}
    <main class="">

      {if isset($roythemes.g_lay) && $roythemes.g_lay == "4"}<div class="lay_boxed">{/if}

      {block name='product_activation'}
        {include file='catalog/_partials/product-activation.tpl'}
      {/block}

      <header id="header">
        {block name='header'}
          {include file='_partials/header.tpl'}
        {/block}
      </header>

      {block name='notifications'}
        {include file='_partials/notifications.tpl'}
      {/block}

      {block name='breadcrumb'}
          {include file='_partials/breadcrumb.tpl'}
      {/block}

      <section id="wrapper" class="stick_parent_lb">
        {hook h="displayWrapperTop"}
        <div {if $page.page_name == 'cms' || $page.page_name == 'index' || $page.page_name == 'product'} class="container-fluid" style="padding:0;"{else} class="container" {/if}>

          {hook h="displayLeviBox"}
            {if $page.page_name == 'category'}
<div id="cg-catheader" class="block-category hidden-sm-down">

      <h1 class="h1">{$category.name}</h1>

       {if $category.description}
        <div id="category-description" class="text-muted">{$category.description nofilter}

    </div>
      {/if}
{if $customer.id_default_group === '7'}
    <div id="category-description-addon" class="text-muted">
      <div>  <h2 style="text-align:right;padding-right:50px;font-size:1em;line-height:1;">Livré<br /><span style="font-weight:700;color:#41535b;"> Le Lendemain</span><br /><span
            style="color:white;background-color:#be1e2b;font-weight:700;padding:0;font-style:italic;line-height:1.5;margin-top:10px;">Avant 9h <i class="far fa-clock"></i></span></h2>
            <a class="pull-right" href="#collapseExpress" data-toggle="collapse"  aria-expanded="false" aria-controls="collapseExpress" style="margin-right:50px;">
               En savoir +

             <div class="collapse" id="collapseExpress">
                 <p style="text-align:center;margin:auto;margin-top:20px;margin-bottom:20px;">
                   Les services de livraison <i style="color:#be1e2b;">Express en entreprise</i> et <i style="color:#be1e2b;">Express 9h en entreprise</i> sont disponibles pour les articles marqués <img src="/themes/modez/assets/img/consogarage-rapide.svg" width="30" alt="Icône expédition express"/> si vous disposez d'un <strong>compte pro</strong> et que vous passez commande
                   <strong>avant 11h le matin</strong>.
                 </p>
                 {if !$customer.is_logged}
                 <div class="alert alert-info text-center" style="margin:auto;"><i class="fas fa-sign-in-alt fa-2x"></i>
                   <p>Connectez-vous ou créez un compte<br /> pour plus d'information.</p>
                   <div class="btn-group" role="group" aria-label="connexion">
                     <a class="btn btn-secondary" style="font-size:0.7em;" href="https://www.consogarage.com/connexion">Se connecter</a>
                     <button type="button" class="btn btn-secondary" style="font-size:0.7em;">Créer un compte</button>
                   </div>
                 </div>
                 {else}
                 {if ($customer.id_default_group === '7') || ($customer.id_default_group === '4')}
                 <div class="alert alert-success text-center" style="margin:auto;"><i class="far fa-thumbs-up fa-large"></i><br />Vous êtes connecté sur un compte pro. <strong>vous avez accès aux livraisons express</strong>.</div>
                 {else}
                 <div class="alert alert-info text-center" style="margin:auto;"><i class="fas fa-info-circle fa-2x"></i><br />Vous souhaitez un compte pro ?<br /> Envoyez-nous votre demande.<a class="btn btn-secondary btn-block"
                     href="mailto:contact@consogarage.com?subject=Demande_de_compte_pro">Passer pro</a></div>
                 {/if}
                 {/if}
             </div>
           </div>
    </div>
{/if}
    {if $category.texte_seo}<a href="#textebas" class="btn btn-sm btn-default pull-right">Voir +</a>{/if}
    {block name='cg-subcategories'}
        {include file='catalog/_partials/cg-subcategories.tpl'}
    {/block}

    </div>
            {/if}
            {if $page.page_name != 'index'}
        {block name="top_column"}
          <div id="top_column">
            {hook h='displayTopColumn'}
          </div>
        {/block}
        {/if}
<div class="stickinside">
        {block name="left_column"}
            <div id="left-column" class="col-md-12 col-lg-3 side-column">
           <div class="stickme">   {if $page.page_name == 'product'}
                {hook h='displayLeftColumnProduct'}
              {else}
                {hook h="displayLeftColumn"}
               <div class="pts"><a href="https://www.protruckshop.com/" target="_blank" rel="follow"><img src="/themes/modez/assets/img/marketing/protruckshop-banniere2.jpg" width="414" height="167" alt="protruck shop.com, pièces détachées poids-lourds"/></a></div>
               {/if}</div>
            </div>
          {/block}

          {block name="content_wrapper"}
            <div id="content-wrapper" class="left-column right-column col-sm-4 col-md-12">
              {hook h="displayContentWrapperTop"}
              {block name="content"}
                <p>Hello world! This is HTML5 Boilerplate.</p>
              {/block}
              {hook h="displayContentWrapperBottom"}
            </div>
          {/block}
          </div>
          {block name="right_column"}
            <div id="right-column" class="col-md-12 col-lg-3 side-column">
              {if $page.page_name == 'product'}
                {hook h='displayRightColumnProduct'}
              {else}
                {hook h="displayRightColumn"}
              {/if}
            </div>
          {/block}
        </div>
        {hook h="displayWrapperBottom"}
      </section>
        {if $page.page_name == 'product'}
        <section id="postlist">

             <div id="bottomlinks" class="cardlist l3 m2 s1">
                <div>
                <h2 >Kits de démarrage <strong>garagistes</strong> et <strong>pneumaticiens</strong></h2><img src="/themes/modez/assets/img/3dgarage-mini.jpg" alt="équipement de garage" width="200" height="136"><p>Tout l'équipement, l'outillage et les consommables nécessaires pour <strong>démarrer une activité à moindre coût</strong>.</p><a class="btn btn-default btn-block" href="/22--kits-de-demarrage">S'équiper</a>
                </div>


                <div class="pts"><h2 ><a href="https://www.protruckshop.com/" target="_blank" rel="follow"><strong>Pièces camions &amp; VUL</strong></a></h2><a href="https://www.protruckshop.com/" title="pièces détachées camion" rel="follow"><img src="/themes/modez/assets/img/logos/logo-protruckshop.jpg" width="200" height="49" style="margin-bottom: 15px;" alt="Logo Protruck Shop">
                </a>
                  <p>Plus de 20 000 références de pièces détachées pour poids lourds, utilitaires et remorques aux meilleurs prix</p>
                  <a class="btn btn-default" href="https://www.protruckshop.com/" rel="follow">Découvrez les pièces poids lourds et VUL</a></div>
            </div>
        </section>
        {/if}
{if $page.page_name == 'category'}
        <section id="postlist">







                    {if $category.texte_seo}<div id="textebas">
            <h2 class="h1 products-section-title">{$category.name}</h2>
{$category.texte_seo nofilter}

            </div>{/if}
            <div id="bottomlinks" class="cardlist l3 m2 s1">
                <div style="background-color:white;">
                <h2>Kits de démarrage <strong>garagistes</strong> et <strong>pneumaticiens</strong></h2><img src="/themes/modez/assets/img/3dgarage-mini.jpg" alt="équipement de garage" width="200" height="136"><p>Tout l'équipement, l'outillage et les consommables nécessaires pour <strong>démarrer une activité à moindre coût</strong>.</p> <a class="btn btn-default" href="/22--kits-de-demarrage">S'équiper</a>
                </div>
                <div>{include file='_partials/cgrandomban.tpl'}</div>

                <div class="pts"><h2 ><a href="https://www.protruckshop.com/" target="_blank" rel="follow"><strong>Pièces camions &amp; VUL</strong></a></h2><a href="https://www.protruckshop.com/" title="pièces détachées camion" rel="follow"><img src="/themes/modez/assets/img/logos/logo-protruckshop.jpg" width="200" height="49" style="margin-bottom: 15px;" alt="Logo Protruck Shop">
                </a>
                  <p>Plus de 20 000 références de pièces détachées pour poids lourds, utilitaires et remorques aux meilleurs prix</p>
                  <a class="btn btn-default" href="https://www.protruckshop.com/" rel="follow">Découvrez les pièces poids lourds et VUL</a></div>
            </div>
        </section>
        {/if}
        <!-- <div id="cgnlsubscribe">

        <div style="z-index:9;background-color:rgba(255,255,255,.9);padding:20px;padding-right:100px;position:relative;"><img src="/themes/modez/assets/img/homeban/phone-mockup-newsletter.png" alt="Smartphone ayant reçu la newsletter" id="nlmockup" width="180" height="270"/><h2>La newsletter CONSOGARAGE</h2><h3>Promotions, nouveautés, informations ...</h3><p style="text-align:right;">Inscrivez-vous pour ne rien manquer !</p></div>

        <div>

        <iframe src="/themes/modez/templates/_partials/cgnlsubscribe.html" width="400px;"height="300px" class="nlframe"></iframe>
        </div>
        <p id="nldisclaimer">Votre adresse de messagerie est uniquement utilisée pour vous envoyer notre lettre d'information ainsi que des informations concernant les activités de L'Entreprise. Vous pouvez à tout moment utiliser le lien de désabonnement intégré dans la newsletter.</p>
        </div> -->
      <footer id="footer">
        {block name="footer"}
          {include file="_partials/footer.tpl"}
        {/block}
      </footer>
<div class="side_menu">
                    <div class="side_menu_rel">
                        <div id="side_cart_wrap">
                            {widget name='ps_shoppingcart'}
                        </div>
                        <div id="side_search_wrap">
                            <h4 class="side_title">{l s='Search' d='Shop.Theme.Catalog'}</h4>
                            <!-- {widget name='ps_searchbar'} -->
                            <div id="search_results">
                            </div>
                            {hook h="displaySideSearch"}
                        </div>
                        <div id="side_menu_wrap">
                            {hook h="displaySideMenu"}
                        </div>
                        <div id="side_mail_wrap">
                            {hook h="displaySideMail"}
                        </div>
                        <div id="side_acc_wrap">
                            {hook h="displaySideAcc"}
                        </div>
                    </div>
                </div>

      <div class="side_close ddd">
        <i>
          <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><title>4</title><g id="Layer_4" data-name="Layer 4"><path d="M19.78,17,14.83,12l4.95-4.95a1,1,0,0,0,0-1.41L18.36,4.24a1,1,0,0,0-1.41,0L12,9.19,7.05,4.24a1,1,0,0,0-1.41,0L4.22,5.65a1,1,0,0,0,0,1.41L9.17,12,4.22,17a1,1,0,0,0,0,1.41L5.64,19.8a1,1,0,0,0,1.41,0L12,14.85l4.95,4.95a1,1,0,0,0,1.41,0l1.41-1.41A1,1,0,0,0,19.78,17Z" style="fill:none;stroke:#000;stroke-linecap:round;stroke-linejoin:round;stroke-width:2px"/></g></svg>
        </i>
      </div>

      {if isset($roythemes.g_lay) && $roythemes.g_lay == "4"}</div>{/if}

    </main>

    {block name='javascript_bottom'}
      {include file="_partials/javascript.tpl" javascript=$javascript.bottom}
    {/block}

    {block name='hook_before_body_closing_tag'}
      {hook h='displayBeforeBodyClosingTag'}
    {/block}
    {if $page.page_name == 'category'}
    {include file="catalog/modal-utilisation.tpl"}
    {/if}
  </body>


    {if $page.page_name == 'cart'}
    <script>
    if ($('.nohayonspan').length > 0){
        $('#cart-options').append('<div><span class="material-icons" style="color:#be1e2d;">warning_amber</span><br><p>Un article est trop volumineux pour être déchargé au hayon.</p><p><strong>Vous devez impérativement disposer d\'un chariot élévateur</strong> pour le déchargement.</p></div>');
    }
        if (($('.hayonspan').length > 0) && ($('.nohayonspan').length == 0)) {
        $(' #cart-options').append('<div><p>Si vous ne disposez pas d\'un chariot élévateur pour le déchargement, vous devez prendre l\'option ci-dessous</p><a  class="btn btn-default btn-block" href="/module/ps_buybuttonlite/RedirectManager?id_product=1065&action=1&id_product_attribute=null">Déchargement au hayon</a></div>');
    }
        if ($('.porteurspan').length > 0){
        $('#cart-options').append('<div><p>Si le lieu de livraison n\'est pas accessible en semi-remorque, vous devez prendre l\'option ci-dessous</p><a  class="btn btn-default btn-block" href="/module/ps_buybuttonlite/RedirectManager?id_product=1064&action=1&id_product_attribute=null">Livraison par camion porteur</a></div>');
    }
    </script>
    {/if}



</html>
