{**
 * 2007-2017 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2017 PrestaShop SA
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 * International Registered Trademark & Property of PrestaShop SA
 *}
<div id="order-items" class="l6 m6 s12">

  {block name='order_items_table_head'}
    <h3 class="card-title h3">{l s='Order items' d='Shop.Theme.Checkout'}</h3>
  {/block}

  <div class="order-confirmation-table">

    {block name='order_confirmation_table'}
    <table id="order-articles" data-customer="{$customer.email}">
      {foreach from=$products item=product}
        {if $product.id_category_default != 244}
{assign var="dispo_on_order" value=$product.current_stock + $product.quantity}
      {if $product.height == 0}

      <!-- Dispo order : {$dispo_on_order} -->
      {if $dispo_on_order < 1}
      <tbody class="indispo" data-dispo="indispo" data-mailtxt="{$product.name}%20-%20{$product.reference}%20x {$product.quantity}">
      <tr>
      <td colspan="4" class="text-center text-warning">
      <span>En réapprovisionnement</span>
    </td>
    </tr>
      {else}
      <tbody class="dispo" data-dispo="dispo" data-mailtxt="{$product.name}%20-%20{$product.reference}%20x {$product.quantity}">
      <!-- <tr>
      <td colspan="4" class="text-center text-success">
      <span>Disponible</span>
    </td>
    </tr> -->
      {/if}
      {else}
      <tbody class="dispo" data-dispo="dispo" data-mailtxt="{$product.reference}%20x {$product.quantity}">
      <!-- <tr>
      <td colspan="4" class="text-center text-success">
      Disponible
    </td>
    </tr> -->
      {/if}

        <tr>
          <td>
              <img src="{$product.cover.small.url}" />
          </td>
          <td class="text-right">
            {$product.product_price|number_format:2:",":" "} € <span class="small">HT</span><br/>{$product.price} <span class="small">TTC</span>
          </td>
          <td class="text-right">
             X {$product.quantity}
          </td>
          <td class="text-right">
             {$product.total}
          </td>

        </tr>
      </tbody>
    {/if}
      {/foreach}
</table>
      <hr>

      <table id="order-conf-totals">
        {foreach $subtotals as $subtotal}
          {if $subtotal.type !== 'tax'}
            <tr>
              <td>{$subtotal.label}</td>
              <td>{$subtotal.value}</td>
            </tr>
          {/if}
        {/foreach}
        {if $subtotals.tax.label !== null}
          <tr class="sub">
            <td>{$subtotals.tax.label}</td>
            <td>{$subtotals.tax.value}</td>
          </tr>
        {/if}
        <tr class="font-weight-bold">
          <td><span class="text-uppercase">{$totals.total.label}</span> {$labels.tax_short}</td>
          <td>{$totals.total.value}</td>
        </tr>
      </table>
    {/block}

  </div>
</div>
