{**
 * 2007-2017 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2017 PrestaShop SA
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 * International Registered Trademark & Property of PrestaShop SA
 *}
{if $cart.vouchers.allowed}
  {block name='cart_voucher'}
    <div class="block-promo test">
      {if $cart_rules}
        <ul>
          {foreach from=$cart_rules item=rule}
            <li>Code promo disponible : {$rule.code}</li>
          {/foreach}
        </ul>
      {/if}

      <div class="cart-voucher">
        {if $cart.vouchers.added}
          {block name='cart_voucher_list'}
            <ul class="promo-name card-block">
              {foreach from=$cart.vouchers.added item=voucher}
                <li class="cart-summary-line">
                  <span class="label">{$voucher.name}</span>
                  <a href="{$voucher.delete_url}" data-link-action="remove-voucher"><i class="material-icons">&#xE872;</i></a>
                  <div class="float-xs-right">
                    {$voucher.reduction_formatted}
                    {if $voucher.reduction_percent == 0.00 && $cart.subtotals.tax.value > 0 }
                      TTC
                    {/if}
                  </div>
                </li>
              {/foreach}
            </ul>
          {/block}
        {/if}


        {if $cart.discounts|count > 0}
          <p class="block-promo promo-highlighted">
            Code promo disponible pour cette commande* :
          </p>
          <ul class="js-discount card-block promo-discounts">
            {foreach from=$cart.discounts item=discount}
              <li class="cart-summary-line">
                <span class="label">
                  <span class="code">{$discount.code}</span><span> - {$discount.name}
                    {if $discount.description}
                    <br /><span class="discount-description">{$discount.description}</span>{/if}
                  </span></span>
              </li>
            {/foreach}
          </ul>
          <p class="small" style="margin-bottom:5px;">
            *Offres non cumulables : Un code promo ne peut être utilisé qu'une fois par commande.
    </p>

    {/if}

    <a class="collapse-button promo-code-button btn btn-default btn-sm btn-block" data-toggle="collapse"
      href="#promo-code" aria-expanded="false" aria-controls="promo-code">
      {l s='Have a promo code?' d='Shop.Theme.Checkout'}
    </a>


    <div class="promo-code collapse{if $cart.discounts|count > 0} in{/if}" id="promo-code">
      {block name='cart_voucher_form'}
      <form action="{$urls.pages.cart}" data-link-action="add-voucher" method="post">
        <input type="hidden" name="token" value="{$static_token}">
        <input type="hidden" name="addDiscount" value="1">
        <input class="promo-input" type="text" name="discount_name"
          placeholder="{l s='Promo code' d='Shop.Theme.Checkout'}">
        <button type="submit" class="btn btn-primary"><span>{l s='Add' d='Shop.Theme.Actions'}</span></button>
      </form>
      {/block}

      {block name='cart_voucher_notifications'}
            <div class="alert alert-danger js-error" role="alert">
              <i class="material-icons">&#xE001;</i><span class="ml-1 js-error-text"></span>
            </div>
          {/block}
        </div>

      </div>
    </div>
  {/block}
{/if}