{extends file='customer/_partials/address-form.tpl'}

{block name='form_field'}
  {if $field.name eq "alias"}
    {* we don't ask for alias here *}
  {else if $field.name eq "company"}
    <div class="form-group row company">
    <label class="col-md-3 form-control-label">
              Société
          <div class="text-warning small">Remplissez ce champ pour faire apparaître la société sur votre facture</div></label>
    <div class="col-md-6">
          <input class="form-control" name="company" type="text" value="{$field.value}" maxlength="255">
    </div>

    <div class="col-md-3 form-control-comment">
      
                 Optionnel
              
    </div>
  </div>
  {else}
    {$smarty.block.parent}
  {/if}
{/block}

{block name="address_form_url"}
    <form
      method="POST"
      action="{url entity='order' params=['id_address' => $id_address]}"
      data-id-address="{$id_address}"
      data-refresh-url="{url entity='order' params=['ajax' => 1, 'action' => 'addressForm']}"
    >
{/block}

{block name='form_fields' append}
  <input type="hidden" name="saveAddress" value="{$type}">
  {if $type === "delivery"}
    <div class="form-group row">
      <div class="col-md-9 col-md-offset-3">
        <span class="custom-checkbox">
          <input name = "use_same_address" type = "checkbox" value = "1" {if $use_same_address} checked {/if}>
          <span><i class="material-icons rtl-no-flip checkbox-checked"></i></span>
          <label>{l s='Use this address for invoice too' d='Shop.Theme.Checkout'}</label>
        </span>
      </div>
    </div>
  {/if}
  <iframe name="return" width="100%" height="100"></iframe>
{/block}

{block name='form_buttons'}
  {if !$form_has_continue_button}
    <div class="clearfix checkout-sticky flexmaster">
    <a class="js-cancel-address btn btn-secondary" href="{url entity='order' params=['cancelAddress' => {$type}]}">{l s='Cancel' d='Shop.Theme.Actions'}</a>
    <button type="submit" class="btn btn-primary submitaddress">{l s='Save' d='Shop.Theme.Actions'}</button>
    </div>
  {else}
    <form class="clearfix checkout-sticky flexmaster"> 
      {if $customer.addresses|count > 0}
        <a class="js-cancel-address cancel-address float-xs-right l6 m6 s6" href="{url entity='order' params=['cancelAddress' => {$type}]}">{l s='Cancel' d='Shop.Theme.Actions'}</a>
      {/if}
      <button type="submit" class="{* continue *} btn btn-primary l6 m6 s6 submitaddress">
          {l s='Continue' d='Shop.Theme.Actions'}
      </button>
    </form>
  {/if}
{/block}
