{**
* 2007-2019 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License 3.0 (AFL-3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* https://opensource.org/licenses/AFL-3.0
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
* @author PrestaShop SA <contact@prestashop.com>
  * @copyright 2007-2017 PrestaShop SA
  * @license https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
  * International Registered Trademark & Property of PrestaShop SA
  *}
{extends file=$layout}
{assign var="multiselect" value="0"}
{if $product.id_product == '470' || $product.id_product == '328' || $product.id_product == '313' || $product.id_product == '312' || $product.id_product == '7899' || $product.id_product == '311' || $product.id_product == '3437' || $product.id_product == '471' || $product.id_product == '470' || $product.id_product == '474' || $product.id_product == '193' || $product.id_product == '7913' || $product.id_product == '480' || $product.id_product == '7909' || $product.id_product == '479' || $product.id_product == '1005' || $product.id_product == '1004' || $product.id_product == '188' || $product.id_product == '481' || $product.id_product == '997' || $product.id_product == '337' || $product.id_product == '10363' || $product.id_product == '10963'
}
{$multiselect = 1}
{/if}
{block name='head_seo' prepend}
  <link rel="canonical" href="{$product.canonical_url}">
{/block}

{block name='head' append}
  <meta property="og:type" content="product">
  <meta property="og:url" content="{$urls.current_url}">
  <meta property="og:title" content="{$page.meta.title}">
  <meta property="og:site_name" content="{$shop.name}">
  <meta property="og:description" content="{$page.meta.description}">
  <meta property="og:image" content="{$product.cover.large.url}">
  {if $product.show_price}
    <meta property="product:pretax_price:amount" content="{$product.price_tax_exc}">
    <meta property="product:pretax_price:currency" content="{$currency.iso_code}">
    <meta property="product:price:amount" content="{$product.price_amount}">
    <meta property="product:price:currency" content="{$currency.iso_code}">
  {/if}
  {if isset($product.weight) && ($product.weight != 0)}
    <meta property="product:weight:value" content="{$product.weight}">
    <meta property="product:weight:units" content="{$product.weight_unit}">
  {/if}
{/block}

{block name='content'}

  <section id="main" itemscope itemtype="https://schema.org/Product" class="row" style="margin:0;">
    <meta itemprop="url" content="{$product.url}">
    {if $product.ean13}
      <meta itemprop="gtin13" content="{$product.ean13}">
    {elseif $product.supplier_reference}
      <meta itemprop="gtin" content="{$product.supplier_reference}">

    {else}
      {* <meta itemprop="identifier_exists" content="false"> *}
    {/if}
    <meta itemprop="mpn" content="{$product.supplier_reference}">

    <!-- Détection type Appareil -->
    {if Context::getContext()->isMobile() == 1}
      {if Context::getContext()->getDevice() != 2}
        <!-- // TABLETTE -->
        {assign var="appareil" value="tablette"}
      {else}
        <!-- // MOBILE -->
        {assign var="appareil" value="mobile"}
      {/if}
    {else}
      <!-- // PC -->
      {assign var="appareil" value="desktop"}
    {/if}






    {assign var=tags value=Tag::getProductTags($product->id)}
    {assign var=id_lang value=Context::getContext()->language->id}
    {assign var=product_tags value=$tags[$id_lang] }


    {if $product->cache_is_pack == 0 || strpos({widget name='advancedcustomfields' hook='legacypack'},'do')}

      <!-- Mono Select Layout -->
      <div id="product-flexheader" class='flexmaster'>
        {block name='page_header'}
          <h1 class="h1 product-title" itemprop="name">{block name='page_title'}{$product.name}{/block}</h1>
        {/block}
        <!-- <div class="l6 m6 s12"> -->
        {block name='product_cover_thumbnails'}
          {include file='catalog/_partials/product-cover-thumbnails.tpl'}
        {/block}
        <!-- </div> -->
        <div class="l6 m6 flexmaster">
          {if $multiselect == 0}
            <div class="l4">
              {if isset($product_manufacturer->id)}

                <a href="{$product_brand_url}" data-toggle="tooltip"
                  title="Voir tous les articles {$product_manufacturer->name}" class="l12 m12 s12">
                  {if isset($manufacturer_image_url)}
                    <img src="{$manufacturer_image_url}" class="img img-thumbnail manufacturer-logo"
                      alt="{$product_manufacturer->name}" height="140" width="140">
                  {/if}
                  <div class="manu_text sr-only">
                    <label class="label">{l s='Brand' d='Shop.Theme.Catalog'}</label>
                    <span>
                      {$product_manufacturer->name}
                    </span>
                  </div>
                </a>

              {/if}
              {hook h='ExtraNetreviews'}
            </div>
          {/if}
          {if $product.id_product == 9447 || $product.id_product == 10764}
            {* {if $product.id_product == 9447} *}
              <div class="product-price-and-shipping">
                {include file='catalog/_partials/product-prices-leasing.tpl'}
              </div>
            {else if $multiselect == 1}
              {include file='catalog/_partials/cg-combination-multi-select.tpl'}
            {else}

              <div class="l5">
                {block name='product_prices'}
                  {include file='catalog/_partials/product-prices.tpl'}
                {/block}
              </div>


              <div class="l3 product-actions">
                <form action="{$urls.pages.cart}" method="post" id="add-to-cart-or-refresh">
                  <input type="hidden" name="token" value="{$static_token}">
                  <input type="hidden" name="id_product" value="{$product.id}" id="product_page_product_id">
                  <input type="hidden" name="id_customization" value="{$product.id_customization}"
                    id="product_customization_id">
                  {block name='product_add_to_cart'}
                    {include file='catalog/_partials/product-add-to-cart.tpl'}
                    <div class="alert alert warning" style="display:none">
                      {foreach from=$cart.products item=product}
                        {if $product.id_category_default ==244}ghost
                        {/if}
                      {/foreach}
                    </div>
                  {/block}
                  {block name='product_refresh'}
                    <input class="product-refresh ps-hidden-by-js" name="refresh" type="submit"
                      value="{l s='Refresh' d='Shop.Theme.Actions'}">
                  {/block}
                </form>
                {block name='product_actions'}
                  {hook h='displayProductActions' product=$product category=$category}
                  {hook h='displayProductAdditionalInfo' product=$product category=$category}
                {/block}
              </div>


              <div id="alternatives" class="l12 m12 s12"></div>
              {if $product.width > 0 && $product.id_category_default != 187 && $product.id_category_default != 129}
                <div class="l12 m12 s12 text-center"><button class="btn btn-tertiary showshipping"><i class="fa fa-truck"></i>
                    Estimer les frais de port</button></div>
              {/if}
              {include file='catalog/_partials/cg-checkbox-crossel.tpl'}
              {include file='catalog/_partials/cg-product-rassurance.tpl'}

            {/if}
            {if $multiselect == 0 && $product.id_product != 9447}
              <div class="l12">
                {include file='catalog/_partials/cg-delai-dispo.tpl'}
              </div>
            {/if}

            {include file='catalog/_partials/cg-product-flags-ficheprod.tpl'}
            {if $product.description_short}
              <div class="l12">
                {$product.description_short nofilter}
              </div>
            {/if}

            {include file='catalog/_partials/cg-product-tags.tpl'}
          </div>

        </div>
        {include file='_partials/blocs-consogarage/banniere-configurateur.tpl'}
        {include file='catalog/_partials/cg-product-keypoints.tpl'}
        {* {if $customer.id_default_group === '7'} *}
          <div class="flexmaster gap stretch">
            <div id="leftcolumnproduct" class="l2 m2 shidden">
              <div>
                {hook h="displayRightColumn"}
              </div>
            </div>
            <div class="l10 m10 s12">
              <ul class="nav nav-tabs" id="product-tab" role="tablist">
                <li class="nav-item" role="presentation">
                  <button class="nav-link active" id="presentation-tab" data-toggle="tab" data-target="#description"
                    type="button" role="tab" aria-controls="description" aria-selected="true"><i class="fa fa-eye"></i>
                    Présentation</button>
                </li>
                {if $product.features}
                  <li class="nav-item" role="presentation">
                    <button class="nav-link" id="tech-tab" data-toggle="tab" data-target="#tech" type="button" role="tab"
                      aria-controls="tech" aria-selected="false"><i class="fa fa-sliders"></i> Fiche technique</button>
                  </li>
                {/if}
                {if $product.features}
                  {foreach from=$product.features item=feature}
                    {if $feature.name == 'Garantie'}
                      <li class="nav-item" role="presentation">
                        <button class="nav-link" id="garantie-tab" data-toggle="tab" data-target="#garantie" type="button" role="tab"
                          aria-controls="garantie" aria-selected="false"><i class="fa fa-award"></i> Garantie</button>
                      </li>
                    {/if}
                  {/foreach}
                {/if}
                {if $product.attachments}
                  <li class="nav-item" role="presentation">
                    <button class="nav-link" id="documentation-tab" data-toggle="tab" data-target="#documentation" type="button"
                      role="tab" aria-controls="documentation" aria-selected="false"><i class="fa fa-book"></i>
                      Documentation</button>
                  </li>
                {/if}
                {if $accessories}
                  <li class="nav-item" role="presentation">
                    <button class="nav-link" id="accessoires-tab" data-toggle="tab" data-target="#accessoires" type="button"
                      role="tab" aria-controls="accessoires" aria-selected="false">
                      <i class="fa fa-cogs"></i> Accessoires</button>
                  </li>
                {/if}
                {if $product.width > 0 && $product.id_category_default != 187 && $product.id_category_default != 129}
                  <li class="nav-item" role="presentation">
                    <button class="nav-link" id="shipping-tab" data-toggle="tab" data-target="#shipping" type="button" role="tab"
                      aria-controls="settings" aria-selected="false"><i class="fa fa-truck"></i> Transport</button>
                  </li>
                {/if}

                <!-- Second Buy -->
                {if $multiselect == 0 && $product.upc != 0}
                  <li class="nav-item right-nav-item">
                    <span id="reprise-prix">{$product.price_tax_exc|number_format:2:",":" "|replace:',00':''} € <span
                        class="small">HT</span></span>
                    {if $product.add_to_cart_url}
                      <button id="fakebuy" class="btn btn-primary add-to-cart">
                        <i class="fa fa-cart-plus fa-large" aria-hidden="true"></i>
                      </button>
                    {/if}
                  </li>
                {/if}
                {if $product.width > 99 && $product.id_product != 9447}
                  <li class="nav-item right-nav-item">
                    <button class="nav-link" id="callmebtn" type="button" data-toggle='modal' data-target='#modal-callme'><i
                        class="fa fa-phone"></i> être contacté</button>

                  </li>
                {/if}
              </ul>


              <div id="producttabs" class="tab-content">
                <div class="tab-pane active" id="description" role="tabpanel" aria-labelledby="presentation-tab">
                  <h2>Présentation</h2>
                  {include file='catalog/_partials/cg-textes-auto.tpl' text_position="top"}
                  {$product.description nofilter}
                  {include file='catalog/_partials/cg-textes-auto.tpl' text_position="bottom"}
                </div>
                <div class="tab-pane product-features" id="tech" role="tabpanel" aria-labelledby="tech-tab">
                  {* spec Feature group *}
                  {block name='product_footer'}
                    {hook h='displayFooterProduct' product=$product category=$category}
                  {/block}
                </div>

                {* Garantie *}
                {if $product.features}
                  {foreach from=$product.features item=feature}
                    {if $feature.name == 'Garantie'}
                      <div class="tab-pane" id="garantie" role="tabpanel" aria-labelledby="garantie-tab">
                        <h2>Garantie CONSOGARAGE</h2>
                        {if $feature.value =='2 ans'}
                          <div class="pictobloc">
                            <img src="/themes/modez/assets/img/icones/garantie-2ans-large.svg" width="100" height="100"
                              alt="Icône de la garantie">
                            <div>
                              <h3>Cet article dispose d'une garantie de 2 ans</h3>
              <p>Les Produits vendus sur le Site sont garantis conformément aux dispositions légales du Code de la
                consommation et du Code civil. Voir la <a
                  href="https://www.consogarage.com/info/3-conditions-generales-de-vente-et-dutilisation-cgvcgu#garanties-legales"
                  target="_blank">section 12 de nos CGV</a> pour plus d’informations.</p>
            </div>
          </div>
          {/if}


          {* Extensions de garantie *}
          {if $accessories}
          {assign "hasextension" 0}
          {foreach from=$accessories item="product_accessory"}
          {if $product_accessory.name|strstr:"garantie"}
          {$hasextension = $hasextension + 1}
          {/if}
          {/foreach}
          {if $hasextension > 0}
          <hr class="separator" />
          <h3>Travaillez en toute sérénité avec une extension de garantie</strong> CONSOGARAGE</h3>
          {/if}
          <br />
          <br />
          <div class="flexmaster gap">
            {foreach from=$accessories item="product_accessory"}
            {if $product_accessory.name|strstr:"garantie"}
            <article class="l6 m12 s12 flexmaster">
              {include file='catalog/_partials/miniatures/product-quickbuy.tpl' product=$product_accessory}

              {$product_accessory.cover_thumbnail}
            </article>
            {/if}
            {/foreach}
          </div>
          {/if}

        </div>
        {/if}
        {/foreach}
        {/if}

        {if $product.attachments}
        <div class="tab-pane" id="documentation" role="tabpanel" aria-labelledby="documentation-tab">
          <h2>Documentation</h2>
          <div class="accessoires-list gapcardlist l3 m2 s1">
            {foreach from=$product.attachments item=attachment}
            <div class="attachment card">

              <h3><a
                  href="{url entity='attachment' params=['id_attachment' => $attachment.id_attachment]}">{$attachment.name}</a>
              </h3>
              <p>{$attachment.description}</p> <a
                href="{url entity='attachment' params=['id_attachment' => $attachment.id_attachment]}"><i
                  class="fas fa-book fa-2x"></i>
                {l s='Download' d='Shop.Theme.Actions'} ({$attachment.file_size_formatted})
              </a>
            </div>
            {/foreach}
          </div>
          {assign var=show_connexion_boitier value=[1039,1034,1023,1024]}
          {if in_array( $product.id_product, $show_connexion_boitier)}
          <hr />
          <h2>Tutos et conseils</h2>
          <div class="flexmaster gap">
            <div class="l4 m6 s1 card">
              <h3><a href="https://5ameca.com/branchement-electrique-ponts-consogarage-qjy/" target="_blank"
                  rel="dofollow external">Branchement électrique des ponts élévateurs 2 colonnes Sunshine série QJY</a>
              </h3>
              <a href="https://5ameca.com/branchement-electrique-ponts-consogarage-qjy/" target="_blank"
                rel="dofollow external"><img
                  src="https://5ameca.com/wp-content/uploads/2023/07/AdobeStock_432178372-348x215.jpeg" width="348"
                  height="215" align="left" style="margin-right:20px" /></a>
              <p class="small">En partenariat avec <a href="https://5ameca.com/" target="_blank">5Ameca</a>.</p>
              <p>Rapide tutoriel concernant le raccordement des boîtiers électriques des modèles 220V et 380V. </p>
              <p>Cet article vous permettra de facilement réaliser les opérations suivantes :</p>
              <ul>
                <li>Connexion de l’alimentation électrique</li>
                <li>Branchement du moteur électrique</li>
                <li>Raccordement du contacteur de fin de course</li>
              </ul>
            </div>
          </div>
          {/if}
        </div>
        {/if}
        {if $accessories}
        <div class="tab-pane" id="accessoires" role="tabpanel" aria-labelledby="accessoires-tab">
          <h2>Accessoires</h2>
          <p class="l12 m12 s12">
            Les accessoires présentés dans la liste ci-dessous sont tous compatibles avec votre {$product.name}.
          </p>
          <div class="flexmaster stretch">
            {foreach from=$accessories item="product_accessory"}
            {block name='product_miniature'}
            {include file='catalog/_partials/miniatures/product-ultralight.tpl' product=$product_accessory}
            {/block}
            {/foreach}
          </div>
        </div>
        {/if}

        {if $product.width > 0 && $product.id_category_default != 187 && $product.id_category_default != 129}
        <div class="tab-pane" id="shipping" role="tabpanel" aria-labelledby="shipping-tab">
          <h2>Notes concernant le transport de votre {$product.name}</h2>
          {include file='catalog/_partials/cg-textes-auto-fdp.tpl'}
          {include file='catalog/_partials/cg-estimation-shipping.tpl' template="product"}
        </div>
        {/if}
      </div>


    </div>
  </div>

  {else}
  {include file='catalog/_partials/cg-packs.tpl'}
  {/if}
  <div class=" greyline container-fluid">
    <h2>Articles similaires</h2>
    <div id="similar" class="flexmaster">
      {hook h='displaycrossell1' product=$product category=$category}
    </div>
  </div>
  {block name='after_tabs'}
  {hook h='display_after_tabs'}
  {/block}
  {hook h='TabcontentNetreviews' product=$product}
  <div class="container">
    {hook h='displayHeaderContent'}
  </div>
  {include file='catalog/_partials/catalogues-pdf.tpl'}



  {block name='product_images_modal'}
  {include file='catalog/_partials/product-images-modal.tpl'}
  {/block}

  {if $product.width > 99}
  {include file='catalog/_partials/cg-callmemaybe2022.tpl'}
  {/if}

  {block name='page_footer_container'}
  <footer class="page-footer">
    {block name='page_footer'}
                    <!-- Footer content -->
                  {/block}
                </footer>
              {/block}
            </section>

          {/block}