{**
* 2007-2019 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License 3.0 (AFL-3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* https://opensource.org/licenses/AFL-3.0
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
* @author PrestaShop SA <contact@prestashop.com>
  * @copyright 2007-2017 PrestaShop SA
  * @license https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
  * International Registered Trademark & Property of PrestaShop SA
  *}
  {extends file=$layout}

  {block name='head_seo' prepend}
  <link rel="canonical" href="{$product.canonical_url}">
  {/block}

  {block name='head' append}
  <meta property="og:type" content="product">
  <meta property="og:url" content="{$urls.current_url}">
  <meta property="og:title" content="{$page.meta.title}">
  <meta property="og:site_name" content="{$shop.name}">
  <meta property="og:description" content="{$page.meta.description}">
  <meta property="og:image" content="{$product.cover.large.url}">
  {if $product.show_price}
  <meta property="product:pretax_price:amount" content="{$product.price_tax_exc}">
  <meta property="product:pretax_price:currency" content="{$currency.iso_code}">
  <meta property="product:price:amount" content="{$product.price_amount}">
  <meta property="product:price:currency" content="{$currency.iso_code}">
  {/if}
  {if isset($product.weight) && ($product.weight != 0)}
  <meta property="product:weight:value" content="{$product.weight}">
  <meta property="product:weight:units" content="{$product.weight_unit}">
  {/if}
  {/block}

  {block name='content'}

  <section id="main" itemscope itemtype="https://schema.org/Product">
    <meta itemprop="url" content="{$product.url}">
    {if $product.ean13}
    <meta itemprop="gtin13" content="{$product.ean13}">
    {elseif $product.supplier_reference}
    <meta itemprop="gtin" content="{$product.supplier_reference}">

    {else}
    {* <meta itemprop="identifier_exists" content="false"> *}
    {/if}
    <meta itemprop="mpn" content="{$product.supplier_reference}">

<h1>Titre article</h1>
{assign var=tags value=Tag::getProductTags($product->id)}
{assign var=id_lang value=Context::getContext()->language->id}
{assign var=product_tags value=$tags[$id_lang] }
{block name='product_additional_info'}
{include file='catalog/_partials/product-additional-info.tpl'}
{/block}
<div style="display:inline-block;width:calc(50% - 155px);padding:0 20px;vertical-align:top;">
  {block name='product_cover_thumbnails'}
  {include file='catalog/_partials/product-cover-thumbnails.tpl'}
  {/block}
</div>
<div style="display:inline-block;width:calc(50% - 155px);padding:20px;vertical-align:top;">
  {$product.description_short nofilter}
  <div class="cardlist l3 m3 s2 text-center">
    {block name='product_reference'}
      {if isset($product.reference_to_display)}
        <div class="product-reference">
          <label class="label">{l s='Reference' d='Shop.Theme.Catalog'} </label>
          <span itemprop="sku">{$product.reference_to_display}</span>
        </div>
      {/if}
    {/block}
    <div id="cg-delai-dispo">
      {block name='product_availability'}
        {if $customer.id_default_group === '7'}
        <span id="product-availability" class="" style="font-size:0.7em;font-weight:lighter;opacity:.7;padding-bottom:20px;display:none;">
          Poids {$product.weight} Kg<br>
          Qté {$product.quantity} disponibles<br>
          Hauteur {$product.height} cm (Express impossible si plus de 0)<br>
          Largeur {$product.width} cm (Affrète. si plus de 0)</span>
          {/if}
    {if $product.weight < 30 && $product.width < 1}
      {if $product.height == 0}
          {if $product.quantity >= 10}
            <span class="cggreen" style="color:darkgreen"><svg xmlns="http://www.w3.org/2000/svg" height="20px" viewBox="0 0 24 24" width="20px" fill="darkgreen" style="vertical-align:middle"><path d="M0 0h24v24H0V0z" fill="none"/><path d="M9 16.2L4.8 12l-1.4 1.4L9 19 21 7l-1.4-1.4L9 16.2z"/></svg> En stock. Livraison 24/48h*</span>
            <div class="disclaimer">* Expédition en 24h pour toute commande passée avant <strong>12h00</strong> via un <strong>compte pro</strong></div>
          {/if}
          {if $product.quantity < 10 && $product.quantity > 0}
            <span class="cgorange" style="color:orange"><i class="fas fa-hourglass-half cghourglass"></i> Plus que {$product.quantity} articles en stock. Livraison 24/48h*</span>
            <div class="disclaimer">* Expédition en 24h pour toute commande passée avant <strong>12h00</strong> via un <strong>compte pro</strong></div>
          {/if}
          {if $product.quantity <= 0}
            <span class="cgred" style="color:#be1e2b"><i class="fas fa-cubes"></i> Réapprovisionnement en cours</span>
          {/if}
      {/if}
      {if $product.height > 0}
        <span class="cgorange" style="color:orange"><i class="fas fa-check"></i>Nous consulter - Expédition sous 10j après confirmation.</span>
      {/if}
    {/if}
    {if $product.weight >= 30 && $product.width == 0}
    {if $product.height == 0}
        {if $product.quantity >= 5}
          <span class="cggreen" style="color:darkgreen"><i class="fas fa-check"></i> En stock. Livraison 2 à 3 jours</span>
        {/if}
        {if $product.quantity < 5 && $product.quantity > 0}
          <span class="cgorange" style="color:orange"><i class="fas fa-hourglass-half cghourglass"></i>  Plus que {$product.quantity} articles en stock. Livraison 2 à 3 jours</span>
        {/if}
        {if $product.quantity <= 0}
          <span class="cgred" style="color:#be1e2b"><i class="fas fa-cubes"></i> Réapprovisionnement en cours</span>
        {/if}
    {/if}
    {if $product.height > 0}
      <span class="cgorange" style="color:orange"><i class="fas fa-phone"></i> Nous consulter</span>
    {/if}
    {/if}
    {if $product.width > 0}
    {if $product.height == 0}
        {if $product.quantity >= 5}
          <span class="cggreen" style="color:darkgreen"><i class="fas fa-check"></i> En stock. Livraison 4/5 jours</span>
        {/if}
        {if $product.quantity < 5 && $product.quantity > 0}
          <span class="cgorange" style="color:orange"><i class="fas fa-hourglass-half cghourglass"></i>  Plus que {$product.quantity} articles en stock. Livraison 4 à 5 jours</span>
        {/if}
        {if $product.quantity <= 0}
          <span class="cgred" style="color:#be1e2b"><i class="fas fa-cubes"></i> Réapprovisionnement en cours</span>
        {/if}
    {/if}
    {if $product.height > 0}
      <span class="cgorange" style="color:orange"><i class="fas fa-phone"></i> Nous consulter - Expédition sous 10j après confirmation.</span>
    {/if}
    {/if}


      {/block}
      {block name='product_availability_date'}
        {if $product.availability_date}

        {if $smarty.now|date_format:"%Y%m%d" < $product.availability_date|date_format:"%Y%m%d"}
          <div class="product-availability-date">
            <label>{l s='Availability date:' d='Shop.Theme.Catalog'} </label>
            <span>{$product.availability_date|date_format:"%d / %m / %Y"}</span>
          </div>

        {/if}
        {/if}
      {/block}
    </div>
    {if isset($product_manufacturer->id)}
      <div class="product-manufacturer tip_inside">
        <a href="{$product_brand_url}">
          {if isset($manufacturer_image_url)}
              <img src="{$manufacturer_image_url}" class="img img-thumbnail manufacturer-logo" alt="{$product_manufacturer->name}" height="140" width="140">
          {/if}
          <div class="manu_text sr-only">
            <label class="label">{l s='Brand' d='Shop.Theme.Catalog'}</label>
            <span>
              {$product_manufacturer->name}
            </span>
          </div>
        </a>
          <span class='tip'>
            {l s='View all products of ' d='Shop.Theme.Catalog'}{$product_manufacturer->name}
          </span>
      </div>
    {/if}
  </div>
  {block name='cg-flags'}
  {include file='_partials/cg-product-flags.tpl' product=$product}
  {/block}

  <div id="myCustomTrustBadge"></div>
  <div  class="gapcardlist l2 m2 s1">
      <div style="margin-bottom:10px;">

        <p class="h3" style="font-size:12px;display:inline-block"><img src="/themes/modez/assets/img/consogarage-freeshipping.svg" width="25" height="25" alt="Icône livraison offerte" style="display:inline-block;vertical-align:middle;"> Livraison offerte dès 200€ <span class="small">HT*</span></p><p style="font-size:10px;padding-left:25px;margin-bottom:5px;">* concerne l'outillage et le consommable</p></div>
      <div style="margin-bottom:10px;">

        <p class="h3" style="font-size:12px;display:inline-block"><img src="/themes/modez/assets/img/consogarage-rapide.svg" width="25" height="25" alt="Icône expédition express" style="display:inline-block;vertical-align:middle;"> Expédition en 24/48 heures </p><p style="font-size:10px;padding-left:25px;margin-bottom:5px;"> Pour les articles en stock</p></div>
      <div style="margin-bottom:10px;">

        <p class="h3" style="font-size:12px;display:inline-block"><img src="/themes/modez/assets/img/consogarage-plusieurs-fois.svg" width="25" height="25" alt="Icône paiement en plusieurs fois" style="display:inline-block;vertical-align:middle;"> Paiement sécurisé en plusieurs fois </p><p style="font-size:10px;padding-left:25px;margin-bottom:5px;">Maîtrisez votre budget jusqu'à 2 000 € TTC</p></div>
      <div style="margin-bottom:10px;">

        <p class="h3" style="font-size:12px;display:inline-block"><img src="/themes/modez/assets/img/consogarage-assistance.svg" width="25" height="25" alt="Icône assistance technique" style="display:inline-block;vertical-align:middle;"> Assistance technique par téléphone</p><p style="font-size:10px;padding-left:25px;margin-bottom:5px;"><a href="tel:+33531616114" rel="nofollow external">05 31 61 61 14</a><span class="xstip">Cliquez pour appeler</span></p></div>
      </div>
</div>
<div style="display:inline-block;width:300px;background-color:#eee;padding:20px;position:sticky;top:50px;right:0;vertical-align:top;">

                  {block name='product_discounts'}
                  {include file='catalog/_partials/product-discounts.tpl'}
                  {/block}

                  {block name='product_prices'}
                  {include file='catalog/_partials/product-prices.tpl'}
                  {/block}

                  {block name='product_out_of_stock'}
                  <div class="product-out-of-stock">
                    {hook h='actionProductOutOfStock' product=$product}
                  </div>
                  {/block}
  <div>
          {if $product.description}
          <a href="#presentation" class="productnav">Présentation</a>
          {/if}
          {if $product.features}
          <a href="#specifications" class="productnav">Spécifications</a>
          {/if}

          {if $product.attachments}
          <a href="#documentation" class="productnav">Documentation</a>
          {/if}
          {if $accessories}
          <a href="#accessoires" class="productnav">Accessoires</a>
          {/if}</div>
</div>
<div style="width:calc(100% - 300px);padding:20px;">
{if $product.description}
  <h2>Présentation</h2>
  {$product.description nofilter}
  {/if}
{if $product.features}
  <h2>Fiche technique {$product.name}</h2>
  {include file='catalog/_partials/product-details.tpl'}
  {/if}
  <h2>Info transport</h2>
  <div class="cg-flags">

  <!-- Livraison express -->
  {if $product.height < 1 && $product.quantity > 0}
  <img src="/themes/modez/assets/img/icones/express.svg" width="30" alt="Livraison 24h" data-toggle="tooltip" data-placement="bottom" title="Livré le lendemain" >
  {/if}
  </div>
  <form>
    <div class="cardlist l2 m2 s2">
    <div>  <h3>Entrez votre département</h3>
      <input type="text" class="form-control">
    </div>
    <div class="text-center">
    <div style="font-size:2em; color:dodgerblue">999,99 € <span class="small">ht</span></div>
      (+ 90 € HT si vous ne disposez pas de chariot élévateur et/ou si le lieu de livraison n'est pas accessible en semi-remorque.)
    </div>
    </div>
  </form>
  {if $product.attachments}
  <h2>Documentation {$product.name}</h2>
  <div class="accessoires-list gapcardlist l3 m2 s1">
    {foreach from=$product.attachments item=attachment}
    <div class="attachment">

      <h3><a
          href="{url entity='attachment' params=['id_attachment' => $attachment.id_attachment]}">{$attachment.name}</a>
      </h3>
      <p>{$attachment.description}</p> <a
        href="{url entity='attachment' params=['id_attachment' => $attachment.id_attachment]}"><i class="fas fa-book fa-2x"></i>
      {l s='Download' d='Shop.Theme.Actions'} ({$attachment.file_size_formatted})
      </a>
    </div>
    {/foreach}
  </div>
  {/if}
  {if $accessories}
  <h2>Accessoires</h2>
  <div class=" cardlist l4 m3 s1">
    {foreach from=$accessories item="product_accessory"}
    {block name='product_miniature'}
    {include file='catalog/_partials/miniatures/product.tpl' product=$product_accessory}
    {/block}
    {/foreach}
  </div>
  {/if}

  {block name='extra'}
  {hook h='displayProductTabContent' product=$product category=$category}
  {/block}
</div>





    {block name='product_images_modal'}
    {include file='catalog/_partials/product-images-modal.tpl'}
    {/block}

    {block name='page_footer_container'}
    <footer class="page-footer">
      {block name='page_footer'}
      <!-- Footer content -->
      {/block}
    </footer>
    {/block}
  </section>

  {/block}
