{**
* 2007-2019 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License 3.0 (AFL-3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* https://opensource.org/licenses/AFL-3.0
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
* @author PrestaShop SA <contact@prestashop.com>
  * @copyright 2007-2017 PrestaShop SA
  * @license https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
  * International Registered Trademark & Property of PrestaShop SA
  *}
  {extends file=$layout}

  {block name='head_seo' prepend}
  <link rel="canonical" href="{$product.canonical_url}">
  {/block}

  {block name='head' append}
  <meta property="og:type" content="product">
  <meta property="og:url" content="{$urls.current_url}">
  <meta property="og:title" content="{$page.meta.title}">
  <meta property="og:site_name" content="{$shop.name}">
  <meta property="og:description" content="{$page.meta.description}">
  <meta property="og:image" content="{$product.cover.large.url}">
  {if $product.show_price}
  <meta property="product:pretax_price:amount" content="{$product.price_tax_exc}">
  <meta property="product:pretax_price:currency" content="{$currency.iso_code}">
  <meta property="product:price:amount" content="{$product.price_amount}">
  <meta property="product:price:currency" content="{$currency.iso_code}">
  {/if}
  {if isset($product.weight) && ($product.weight != 0)}
  <meta property="product:weight:value" content="{$product.weight}">
  <meta property="product:weight:units" content="{$product.weight_unit}">
  {/if}
  {/block}

  {block name='content'}

  <section id="main" >

<div>
  <div id="cg-left-column">
    {block name='page_header_container'}
    {block name='page_header'}
    <h1 class="h1 product-title" >{block name='page_title'}{$product.name}{/block}</h1>
    {/block}

    {/block}
      <div class="col-image">
        {block name='page_content_container'}
        <section class="col-image-inside">
          {block name='page_content'}
          {block name='product_flags'}
          <ul class="product-flags">
            {foreach from=$product.flags item=flag}
            <li class="product-flag {$flag.type}">{$flag.label}</li>
            {/foreach}
          </ul>
          {/block}
          <!-- STARS -->
{hook h='hookExtraNetreviews' product=$product}
          {block name='product_cover_thumbnails'}
          {include file='catalog/_partials/product-cover-thumbnails.tpl'}
          {/block}

          {/block}





        </section>
        {/block}
      </div>
<div class="col-middle">

  <div class="cardlist l2 m2 s2">
    {if isset($product_manufacturer->id)}
      <div class="product-manufacturer tip_inside">
        <a href="{$product_brand_url}">
          {if isset($manufacturer_image_url)}
              <img src="{$manufacturer_image_url}" class="img img-thumbnail manufacturer-logo" alt="{$product_manufacturer->name}" height="140" width="140">
          {/if}
          <div class="manu_text sr-only">
            <label class="label">{l s='Brand' d='Shop.Theme.Catalog'}</label>
            <span>
              {$product_manufacturer->name}
            </span>
          </div>
        </a>
          <span class='tip'>
            {l s='View all products of ' d='Shop.Theme.Catalog'}{$product_manufacturer->name}
          </span>
      </div>
    {/if}
    <div>  {block name='product_additional_info'}
      {include file='catalog/_partials/product-additional-info.tpl'}
      {/block}</div>
  </div>
  {block name='product_description_short'}
  <div id="product-description-short-{$product.id}" сlass="product-short-desc">

    {$product.description_short nofilter}</div>
  {/block}
{include file='_partials/cg-product-flags-ficheprod.tpl'}
{include file='catalog/_partials/cg-product-rassurance.tpl'}
{include file="_partials/cgdisclaimer.tpl"}
</div>
</div>
<div class="col-content">
  <div class="col-content-inside">





    {assign var=tags value=Tag::getProductTags($product->id)}
    {assign var=id_lang value=Context::getContext()->language->id}
    {assign var=product_tags value=$tags[$id_lang] }

    {* <ul>
      {foreach from=$product_tags key=k item=v}
      {foreach from=$v item=value}
      <li><a href="{$link->getPageLink('search', true, NULL, "
          tag={$value|urlencode}")}">{$value|escape:html:'UTF-8'}</a></li>
      {/foreach}
      {/foreach}
    </ul> *}




    <div class="product-information">

      {if $product.is_customizable && count($product.customizations.fields)}
      {block name='product_customization'}
      {include file="catalog/_partials/product-customization.tpl" customizations=$product.customizations}
      {/block}
      {/if}

      <div class="product-actions">
        {block name='product_buy'}
        <form action="{$urls.pages.cart}" method="post" id="add-to-cart-or-refresh">
          <input type="hidden" name="token" value="{$static_token}">
          <input type="hidden" name="id_product" value="{$product.id}" id="product_page_product_id">
          <input type="hidden" name="id_customization" value="{$product.id_customization}"
            id="product_customization_id">

          {block name='product_variants'}
          {include file='catalog/_partials/product-variants.tpl'}
          {/block}

          {block name='product_pack'}
          {if $packItems}
          <section class="product-pack">
            <h3 class="h4">{l s='This pack contains' d='Shop.Theme.Catalog'}</h3>
            {foreach from=$packItems item="product_pack"}
            {block name='product_miniature'}
            {include file='catalog/_partials/miniatures/pack-product.tpl' product=$product_pack}
            {/block}
            {/foreach}
          </section>
          {/if}
          {/block}

          {block name='product_discounts'}
          {include file='catalog/_partials/product-discounts.tpl'}
          {/block}

          {block name='product_prices'}
          {include file='catalog/_partials/product-prices.tpl'}
          {/block}

          {block name='product_out_of_stock'}
          <div class="product-out-of-stock">
            {hook h='actionProductOutOfStock' product=$product}
          </div>
          {/block}

          {block name='product_refresh'}
          <input class="product-refresh ps-hidden-by-js" name="refresh" type="submit"
            value="{l s='Refresh' d='Shop.Theme.Actions'}">
          {/block}
        </form>
        {/block}

      </div>
    </div>
    {if $customer.id_default_group === '7'}
    {include file='_partials/cg-livraison-express.tpl'}
  {/if}
  </div>
{include file='catalog/_partials/cg-scrollnav.tpl'}
</div>
<div class="col-middle-xs">
  {block name='product_additional_info'}
  {include file='catalog/_partials/product-additional-info.tpl'}
  {/block}
  {block name='product_description_short'}
  <div id="product-description-short-{$product.id}" сlass="product-short-desc">
    {if isset($product_manufacturer->id)}
      <div class="product-manufacturer tip_inside">
        <a href="{$product_brand_url}">
          {if isset($manufacturer_image_url)}
              <img src="{$manufacturer_image_url}" class="img img-thumbnail manufacturer-logo" alt="{$product_manufacturer->name}" height="140" width="140">
          {/if}
          <div class="manu_text sr-only">
            <label class="label">{l s='Brand' d='Shop.Theme.Catalog'}</label>
            <span>
              {$product_manufacturer->name}
            </span>
          </div>
        </a>
          <span class='tip'>
            {l s='View all products of ' d='Shop.Theme.Catalog'}{$product_manufacturer->name}
          </span>
      </div>
    {/if}
    {$product.description_short nofilter}</div>
  {/block}
{include file='_partials/cg-product-flags-ficheprod.tpl'}
{include file='catalog/_partials/cg-product-rassurance.tpl'}
</div>



    {block name='product_tabs'}

        <!--          Presentation-->
        {if $product.description}
        <a class="anchor" id="presentationanchor">ddd</a>
        <div class="card prodtext expandablock"  id="presentation">
          <h2><span class="material-icons">
        visibility
        </span> Présentation : {$product.name}</h2>
          {$product.description nofilter}
          {include file='catalog/_partials/cg-textes-auto.tpl'}
        </div>
        {/if}
        <!--          Spécifications-->

        {* spec Feature group *}

        {block name='product_footer'}
        {hook h='displayFooterProduct' product=$product category=$category}
        {/block}
        <!-- Garantie -->
                {include file='catalog/_partials/cg-textes-garantie.tpl'}
          <!-- Transport -->
          {if $product.width > 0}
          <a class="anchor" id="transportanchor">ddd</a>
          <div class="card prodtext" id="transport">
          <h2><span class="material-icons">
        local_shipping
      </span> Transport</h2>
      {include file='catalog/_partials/cg-textes-auto-fdp.tpl'}
      </div>
      {/if}
        <!--          Documentation-->
        {if $product.attachments}
        <a class="anchor" id="documentationanchor">ddd</a>
        <div class="card prodtext" id="documentation">
          <h2><span class="material-icons">
        auto_stories
        </span> Documentation : {$product.name}</h2>
          <div class="accessoires-list gapcardlist l3 m2 s1">
            {foreach from=$product.attachments item=attachment}
            <div class="attachment">

              <h3><a
                  href="{url entity='attachment' params=['id_attachment' => $attachment.id_attachment]}">{$attachment.name}</a>
              </h3>
              <p>{$attachment.description}</p> <a
                href="{url entity='attachment' params=['id_attachment' => $attachment.id_attachment]}"><i class="fas fa-book fa-2x"></i>
              {l s='Download' d='Shop.Theme.Actions'} ({$attachment.file_size_formatted})
              </a>
            </div>
            {/foreach}
          </div>
        </div>
        {/if}
        <!--          Accessoires-->
        {if $accessories}
        <a class="anchor" id="accessoiresanchor">ddd</a>
        <div class="card accessoires prodtext" id="accessoires">
          <h2 ><span class="material-icons">
        settings
        </span> Accessoires pour : {$product.name}</h2>
          <div class=" cardlist l4 m3 s1">
            {foreach from=$accessories item="product_accessory"}
            {block name='product_miniature'}
            {include file='catalog/_partials/miniatures/cg-accessoires.tpl' product=$product_accessory}
            {/block}
            {/foreach}
          </div>
        </div>
        {/if}
        <!--          Extras-->
        <!--
           {foreach from=$product.extraContent item=extra key=extraKey}
              <div class="card"><h2 id="{$extra.title}">{$extra.title}</h2>
          </div>
          {/foreach}
-->
<div class="card prodtext" id="avis">
  {block name='extra'}
  <a class="anchor" id="avisanchor">ddd</a>
  {hook h='displayProductTabContent' product=$product category=$category}
  {/block}
</div>
</div>




    {/block}






    {block name='product_images_modal'}
    {include file='catalog/_partials/product-images-modal.tpl'}
    {/block}
    {if in_array(24,Product::getProductCategories($product->id|intval)) || in_array(31,Product::getProductCategories($product->id|intval)) || in_array(32,Product::getProductCategories($product->id|intval)) || in_array(33,Product::getProductCategories($product->id|intval)) || in_array(34,Product::getProductCategories($product->id|intval)) || in_array(177,Product::getProductCategories($product->id|intval)) || in_array(29,Product::getProductCategories($product->id|intval)) || in_array(30,Product::getProductCategories($product->id|intval)) || in_array(35,Product::getProductCategories($product->id|intval)) || in_array(129,Product::getProductCategories($product->id|intval)) || in_array(130,Product::getProductCategories($product->id|intval)) || in_array(107,Product::getProductCategories($product->id|intval)) || in_array(187,Product::getProductCategories($product->id|intval)) || in_array(188,Product::getProductCategories($product->id|intval)) || in_array(41,Product::getProductCategories($product->id|intval)) || in_array(121,Product::getProductCategories($product->id|intval)) || in_array(122,Product::getProductCategories($product->id|intval)) || in_array(123,Product::getProductCategories($product->id|intval)) || in_array(125,Product::getProductCategories($product->id|intval)) || in_array(101,Product::getProductCategories($product->id|intval))}

    {include file='catalog/_partials/cg-callmemaybe2022.tpl'}

    {/if}


    {block name='page_footer_container'}
    <footer class="page-footer">
      {block name='page_footer'}
      <!-- Footer content -->
      {/block}
    </footer>
    {/block}
  </section>

  {/block}
