{**
* 2007-2019 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License 3.0 (AFL-3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* https://opensource.org/licenses/AFL-3.0
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
* @author PrestaShop SA <contact@prestashop.com>
  * @copyright 2007-2017 PrestaShop SA
  * @license https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
  * International Registered Trademark & Property of PrestaShop SA
  *}
  {extends file=$layout}

  {block name='head_seo' prepend}
  <link rel="canonical" href="{$product.canonical_url}">
  {/block}

  {block name='head' append}
  <meta property="og:type" content="product">
  <meta property="og:url" content="{$urls.current_url}">
  <meta property="og:title" content="{$page.meta.title}">
  <meta property="og:site_name" content="{$shop.name}">
  <meta property="og:description" content="{$page.meta.description}">
  <meta property="og:image" content="{$product.cover.large.url}">
  {if $product.show_price}
  <meta property="product:pretax_price:amount" content="{$product.price_tax_exc}">
  <meta property="product:pretax_price:currency" content="{$currency.iso_code}">
  <meta property="product:price:amount" content="{$product.price_amount}">
  <meta property="product:price:currency" content="{$currency.iso_code}">
  {/if}
  {if isset($product.weight) && ($product.weight != 0)}
  <meta property="product:weight:value" content="{$product.weight}">
  <meta property="product:weight:units" content="{$product.weight_unit}">
  {/if}
  {/block}

  {block name='content'}

  <section id="main" itemscope itemtype="https://schema.org/Product" class="row" style="margin:0;">
    <meta itemprop="url" content="{$product.url}">
    {if $product.ean13}
    <meta itemprop="gtin13" content="{$product.ean13}">
    {elseif $product.supplier_reference}
    <meta itemprop="gtin" content="{$product.supplier_reference}">

    {else}
    {* <meta itemprop="identifier_exists" content="false"> *}
    {/if}
    <meta itemprop="mpn" content="{$product.supplier_reference}">

<!-- Détection type Appareil -->
{if Context::getContext()->isMobile() == 1}
    {if Context::getContext()->getDevice() != 2}
        <!-- // TABLETTE -->
        {assign var="appareil" value="tablette"}
    {else}
        <!-- // MOBILE -->
        {assign var="appareil" value="mobile"}
    {/if}
{else}
    <!-- // PC -->
    {assign var="appareil" value="desktop"}
{/if}

{block name='page_header'}
<h1 class="h1 product-title col-xs-11" itemprop="name">{block name='page_title'}{$product.name}{/block}</h1>
{/block}

{block name='product_cover_thumbnails'}
{include file='catalog/_partials/product-cover-thumbnails.tpl'}
{/block}

<div id="cg-product-resume">
  <!-- STARS -->
{hook h='ExtraNetreviews'}
<!-- FIN STARS -->

  {if isset($product_manufacturer->id)}

      <a href="{$product_brand_url}" data-toggle="tooltip" title="Voir tous les articles {$product_manufacturer->name}" class="col-md-6">
        {if isset($manufacturer_image_url)}
            <img src="{$manufacturer_image_url}" class="img img-thumbnail manufacturer-logo" alt="{$product_manufacturer->name}" height="140" width="140">
        {/if}
        <div class="manu_text sr-only">
          <label class="label">{l s='Brand' d='Shop.Theme.Catalog'}</label>
          <span>
            {$product_manufacturer->name}
          </span>
        </div>
      </a>

  {/if}
  {assign var=tags value=Tag::getProductTags($product->id)}
  {assign var=id_lang value=Context::getContext()->language->id}
  {assign var=product_tags value=$tags[$id_lang] }
  {include file='catalog/_partials/cg-product-flags-ficheprod.tpl'}
  {include file='catalog/_partials/cg-product-rassurance.tpl'}
</div>

<div id="cg-buyblock" class="product-actions">
  {block name='product_buy'}
  <form action="{$urls.pages.cart}" method="post" id="add-to-cart-or-refresh">
    <input type="hidden" name="token" value="{$static_token}">
    <input type="hidden" name="id_product" value="{$product.id}" id="product_page_product_id">
    <input type="hidden" name="id_customization" value="{$product.id_customization}"
      id="product_customization_id">


    {block name='product_pack'}
    {if $packItems}
    <section class="product-pack">
      <h3 class="h4">{l s='This pack contains' d='Shop.Theme.Catalog'}</h3>
      {foreach from=$packItems item="product_pack"}
      {block name='product_miniature'}
      {include file='catalog/_partials/miniatures/pack-product.tpl' product=$product_pack}
      {/block}
      {/foreach}
    </section>
    {/if}
    {/block}

    {block name='product_discounts'}
    {include file='catalog/_partials/product-discounts.tpl'}
    {/block}

    {block name='product_prices'}
    {include file='catalog/_partials/product-prices.tpl'}
    {/block}

    {block name='product_out_of_stock'}
    <div class="product-out-of-stock">
      {hook h='actionProductOutOfStock' product=$product}
    </div>
    {/block}

    {block name='product_refresh'}
    <input class="product-refresh ps-hidden-by-js" name="refresh" type="submit"
      value="{l s='Refresh' d='Shop.Theme.Actions'}">
    {/block}
  </form>
  {/block}
{include file='catalog/_partials/cg-scrollnav.tpl'}
</div>
{if $product.height == 0 && $product.quantity <= 0}
<div id="alternatives" class=" product-section"></div>
{/if}
{if $product.description_short}
<div class=" product-section">
{$product.description_short nofilter}
</div>
{/if}

<div class=" product-section">

      <h2>Articles similaires</h2>
      <div class="flexmaster l3 m2 s1 gap stretch">{hook h='displaycrossell1' product=$product category=$category}</div>


    </div>





<!-- <div id="cg-product-main-info"> -->
<div class="product-section" id="presentation">
  <h2><span class="material-icons">
visibility
</span> Présentation : {$product.name}</h2>
  {$product.description nofilter}
  {include file='catalog/_partials/cg-textes-auto.tpl'}


</div>
<!--          Spécifications-->
<div class="product-section" id="fichetechnique">
{* spec Feature group *}
{block name='product_footer'}
{hook h='displayFooterProduct' product=$product category=$category}
{/block}
</div>
<!-- Garantie -->
        {include file='catalog/_partials/cg-textes-garantie.tpl'}
  <!-- Transport -->
  {if $product.width > 0 && $product.id_category_default != 187 && $product.id_category_default != 129}
  <div class="product-section" id="transport">
  <h2><span class="material-icons">
local_shipping
</span> Transport</h2>
{include file='catalog/_partials/cg-textes-auto-fdp.tpl'}
</div>
{/if}
{if $product.attachments}
<div class="product-section" id="documentation">
<h2><span class="material-icons">
auto_stories
</span> Documentation : {$product.name}</h2>
<div class="accessoires-list gapcardlist l3 m2 s1">
{foreach from=$product.attachments item=attachment}
<div class="attachment card">

  <h3><a
      href="{url entity='attachment' params=['id_attachment' => $attachment.id_attachment]}">{$attachment.name}</a>
  </h3>
  <p>{$attachment.description}</p> <a
    href="{url entity='attachment' params=['id_attachment' => $attachment.id_attachment]}"><i class="fas fa-book fa-2x"></i>
  {l s='Download' d='Shop.Theme.Actions'} ({$attachment.file_size_formatted})
  </a>
</div>
{/foreach}
</div>
</div>
{/if}
{if $accessories}
<div class="product-section" id="accessoires">
    <h2> <span class="material-icons">
  settings
  </span> Accessoires</h2>

  <div class=" cardlist l4 m3 s1">
    {foreach from=$accessories item="product_accessory"}
    {block name='product_miniature'}
    {include file='catalog/_partials/miniatures/product-slide-light-nometa.tpl' product=$product_accessory}
    {/block}
    {/foreach}
  </div>
</div>


{/if}
 {hook h='TabcontentNetreviews' product=$product}
<!-- </div> -->







    {block name='product_images_modal'}
    {include file='catalog/_partials/product-images-modal.tpl'}
    {/block}
  


    {block name='page_footer_container'}
    <footer class="page-footer">
      {block name='page_footer'}
      <!-- Footer content -->
      {/block}
    </footer>
    {/block}
  </section>

  {/block}
