{**
 * 2007-2017 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2017 PrestaShop SA
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 * International Registered Trademark & Property of PrestaShop SA
 *}
<div class="images-container l6 m6 s12">
  {block name='product_cover'}
    <div class="product-cover">
      <img class="js-qv-product-cover" src="{$product.cover.bySize.medium_default.url}" alt="{$product.cover.legend}" title="{$product.cover.legend}"  itemprop="image" width="452" height="452">
      <div class="layer hidden-sm-down" data-toggle="modal" data-target="#product-modal">
          <i class="zoom-in"></i>
      </div>
    </div>
  {/block}

  {block name='product_images'}
    <div class="js-qv-mask mask">
      <ul class="product-images js-qv-product-images" data-max-slides="{if isset($roythemes.nc_pp_qq3)}{$roythemes.nc_pp_qq3}{else}3{/if}">
        {foreach from=$product.images item=image}
          <li class="thumb-container">
            <img
              class="thumb js-thumb {if $image.id_image == $product.cover.id_image} selected {/if}"
              data-image-medium-src="{$image.bySize.small_default.url}"
              data-image-large-src="{$image.bySize.large_default.url}"
              src="{$image.bySize.home_default.url}"
              alt="{$image.legend}"
              title="{$image.legend}"
              width="100"
              height="100"
              itemprop="image"
            >
          </li>
        {/foreach}
      </ul>
    </div>
  {/block}
  {if $multiselect == 1}
  <div class="flexmaster">
  <div class="l4">
    {if isset($product_manufacturer->id)}

        <a href="{$product_brand_url}" data-toggle="tooltip" title="Voir tous les articles {$product_manufacturer->name}" class="l12 m12 s12">
          {if isset($manufacturer_image_url)}
              <img src="{$manufacturer_image_url}" class="img img-thumbnail manufacturer-logo" alt="{$product_manufacturer->name}" height="140" width="140">
          {/if}
          <div class="manu_text sr-only">
            <label class="label">{l s='Brand' d='Shop.Theme.Catalog'}</label>
            <span>
              {$product_manufacturer->name}
            </span>
          </div>
        </a>

    {/if}

  </div>
  {hook h='ExtraNetreviews'}
  </div>
  {/if}
</div>
{hook h='displayAfterProductThumbs'}
