<?php
/**
 * upgrade_module_1_5_28
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  upgrade_module_1_5_28
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * upgrade_module_1_5_28
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Function
 *
 * 2016 ROJA45.COM - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

function upgrade_module_1_5_28($module)
{
    RojaFortyFiveQuotationsProCore::errorLog('Updating: '.$module->name);
    $return = true;

    $list_fields = Db::getInstance()->executeS('SHOW FIELDS FROM `' . _DB_PREFIX_ . 'roja45_quotationspro_product`');
    $add_tables = true;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'position') {
            $add_tables = false;
        }
    }
    if ($add_tables) {
        $sql =
            'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_quotationspro_product` 
            ADD `position` int(10) AFTER `id_shop`';
        $return &= Db::getInstance()->execute($sql);
    }
    if ($quotations = RojaQuotation::getQuotations()) {
        foreach ($quotations as $quotation) {
            $quotation = new RojaQuotation($quotation['id_roja45_quotation']);
            if (Validate::isLoadedObject($quotation)) {
                $counter = 1;
                $sql = new DbQuery();
                $sql->select('*');
                $sql->from('roja45_quotationspro_product', 'qp');
                $sql->where('qp.`id_roja45_quotation` = ' . (int) $quotation->id_roja45_quotation);
                $sql->orderBy('qp.`position` ASC');
                if ($quotation_products = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql)) {
                    foreach ($quotation_products as $quotation_product) {
                        $quotation_product = new QuotationProduct($quotation_product['id_roja45_quotation_product']);
                        $quotation_product->position = $counter;
                        $quotation_product->save();
                        $counter++;
                    }
                }
            }
        }
    }

    return $return;
}
