<?php
/**
 * upgrade_module_1_5_27
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  upgrade_module_1_5_27
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * upgrade_module_1_5_27
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Function
 *
 * 2016 ROJA45.COM - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

function upgrade_module_1_5_27($module)
{
    RojaFortyFiveQuotationsProCore::errorLog('Updating: '.$module->name);
    $return = true;

    $list_fields = Db::getInstance()->executeS('SHOW FIELDS FROM `' . _DB_PREFIX_ . 'roja45_quotationspro_status_lang`');
    $add_tables = true;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'display_code') {
            $add_tables = false;
        }
    }
    if ($add_tables) {
        $sql =
            'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_quotationspro_status_lang` 
            ADD `display_code` varchar(255) AFTER `status`';
        $return &= Db::getInstance()->execute($sql);
    }

    $statuses = QuotationStatus::getQuotationStates(Context::getCOntext()->language->id);
    foreach ($statuses as $status) {
        $status = new QuotationStatus($status['id_roja45_quotation_status']);
        foreach (Language::getLanguages(false) as $language) {
            $status->display_code[$language['id_lang']] = $status->code;
        }
        $status->save();
    }

    return $return;
}
