<?php
/**
 * upgrade_module_1_5_13
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  upgrade_module_1_5_13
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * upgrade_module_1_5_13
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Function
 *
 * 2016 ROJA45.COM - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

function upgrade_module_1_5_13($module)
{
    RojaFortyFiveQuotationsProCore::errorLog('Updating: '.$module->name);
    $return = true;

    $list_fields = Db::getInstance()->executeS('SHOW FIELDS FROM `' . _DB_PREFIX_ . 'roja45_quotationspro_product`');
    $add_tables = true;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'id_tax_rules_group') {
            $add_tables = false;
        }
    }
    if ($add_tables) {
        $sql =
            'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_quotationspro_product` 
            ADD `id_tax_rules_group` INT(10) NULL AFTER `id_specific_price`';
        $return &= Db::getInstance()->execute($sql);
        $sql =
            'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_quotationspro_product` 
            ADD `tax_rate` DOUBLE(20,6) NULL AFTER `id_tax_rules_group`';
        $return &= Db::getInstance()->execute($sql);
    }

    $sql = new DbQuery();
    $sql->select('*');
    $sql->from('roja45_quotationspro_product', 'rp');
    if ($rows = Db::getInstance()->executeS($sql)) {
        foreach ($rows as $row) {
            $quotation_product = new QuotationProduct($row['id_roja45_quotation_product']);
            $quotation = new RojaQuotation($row['id_roja45_quotation']);

            if (Validate::isLoadedObject($quotation_product)) {
                $id_tax_rules_group = Product::getIdTaxRulesGroupByIdProduct(
                    (int) $row['id_product'],
                    Context::getContext()
                );
                $product_tax_calculator = TaxManagerFactory::getManager(
                    $quotation->getTaxAddress(),
                    $id_tax_rules_group
                )->getTaxCalculator();
                $tax_rate = $product_tax_calculator->getTotalRate();
                $quotation_product->id_tax_rules_group = $id_tax_rules_group;
                $quotation_product->tax_rate = $tax_rate;
                $quotation_product->save();
            }
        }
    }

    return $return;
}
