/**
 * 2007-2017 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2018 PrestaShop SA
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 * International Registered Trademark & Property of PrestaShop SA
 */
import $ from 'jquery';
import prestashop from 'prestashop';

$(document).ready(function () {
  createProductSpin();
  createInputFile();
  coverImage();
  thumbsInit();
  whiteborder();
  shareclick();

  prestashop.on('updatedProduct', function (event) {
    thumbsDestroy();
    createProductSpin()
    createInputFile();
    coverImage();
    if (event && event.product_minimal_quantity) {
      const minimalProductQuantity = parseInt(event.product_minimal_quantity, 10);
      const quantityInputSelector = '#quantity_wanted';
      let quantityInput = $(quantityInputSelector);

      // @see http://www.virtuosoft.eu/code/bootstrap-touchspin/ about Bootstrap TouchSpin
      quantityInput.trigger('touchspin.updatesettings', {min: minimalProductQuantity});
    }
    $($('.tabs .nav-link.active').attr('href')).addClass('active').removeClass('fade');
    $('.js-product-images-modal').replaceWith(event.product_images_modal);
    thumbsInit();
    whiteborder();
    updateCounters();
    shareclick();
  });


  function thumbsDestroy() {
    $('.images-container .product-images').trigger('destroy.owl.carousel').removeClass('owl-carousel owl-loaded');
    $('.images-container .product-images').find('.owl-stage-outer').children().unwrap();
  }
  function thumbsInit() {
    var maxsthumbs = parseInt($('#main .js-qv-product-images').attr('data-max-slides'));
    var thumbs_count_lis = $('#main .js-qv-product-images li');
    var thumbs_count;
    if (thumbs_count_lis.length >= maxsthumbs) {
      thumbs_count = maxsthumbs;
    } else if (thumbs_count_lis.length == 1) {
      thumbs_count = thumbs_count_lis.length;
      $('#main .js-qv-mask').addClass('hide_it_pls');
    } else {
      thumbs_count = thumbs_count_lis.length;
    }
    $('#main .images-container .product-images').addClass('owl-carousel').owlCarousel({
    	loop:false,
    	margin:22,
    	autoplay:false,
    	mouseDrag:true,
    	touchDrag:true,
    	nav:false,
      navText:'  ',
    	navSpeed:400,
    	dots:false,
    	responsive:{
    		0:{
    			items:1,
          margin:0,
    			nav:true,
    			dots:true
    		},
    		768:{
          nav:true,
    			items:thumbs_count
    		}
    	}
    });
    $('.quickview .images-container .product-images').addClass('owl-carousel').owlCarousel({
        loop:false,
        margin:12,
        items:1,
        autoplay:false,
        mouseDrag:true,
        touchDrag:true,
        navText:'  ',
        nav:true,
        navSpeed:400,
        dots:true,
        responsive:{
            0:{
                dots:true,
                nav:false
            },
            768:{
              dots:true
            }
        }
    });
    $('.js-qv-mask').addClass('showit');
  }

  function coverImage() {
    $('.js-thumb').on(
      'click',
      (event) => {
        $('.js-modal-product-cover').attr('src',$(event.target).data('image-large-src'));
        $('.selected').removeClass('selected');
        $(event.target).addClass('selected');
        $('.js-qv-product-cover').prop('src', $(event.currentTarget).data('image-large-src'));
      }
    );
  }

  function createInputFile()
  {
    $('.js-file-input').on('change', (event) => {
      let target, file;

      if ((target = $(event.currentTarget)[0]) && (file = target.files[0])) {
        $(target).prev().text(file.name);
      }
    });
  }

  function createProductSpin()
  {
    const $quantityInput = $('#quantity_wanted');

    $quantityInput.TouchSpin({
      verticalbuttons: true,
      verticalupclass: 'material-icons touchspin-up',
      verticaldownclass: 'material-icons touchspin-down',
      buttondown_class: 'btn btn-touchspin js-touchspin',
      buttonup_class: 'btn btn-touchspin js-touchspin',
      min: parseInt($quantityInput.attr('min'), 10),
      max: 1000000
    });

    $('body').on('change keyup', '#quantity_wanted', (e) => {
      $(e.currentTarget).trigger('touchspin.stopspin');
      prestashop.emit('updateProduct', {
          eventType: 'updatedProductQuantity',
          event: e
      });
    });
  }

  var atts_list = $('.product-variants-item').find('ul'),
      atts_select = $('.product-variants-item').find('select');
  atts_list.hover(function () {
     $(this).closest('.product-variants-item').toggleClass('hover');
  })
  atts_select.hover(function () {
     $(this).closest('.product-variants-item').toggleClass('hover');
  })

  // white color
  function whiteborder()
  {
    $('.color').each(function() {
      if( $(this).css('background-color') === 'rgb(255, 255, 255)') {
        $(this).addClass('white');
      }
    });
  }

  // share

  function shareclick() {
    $('.share_text').click(function(e) {
      e.preventDefault;
      var share_dad = $('.share_text').parent('.social-sharing');
      if (!share_dad.hasClass('click')) {
        share_dad.addClass('click');
      }
    });
  }

  function updateCounters() {
  	$(".countcontainer").each(function(e) {
  		var $roycountdown = $(this).find(".roycountdown");
  		var $roycount = $roycountdown.find(".roycount");
  		var $dataspecificpriceto = $roycount.attr('data-specific-price-to');
  		if ($roycountdown.length) {
  			$roycountdown.county({
  				endDateTime: new Date($dataspecificpriceto.replace(/-/g, "/")) , reflection: false, animation: 'none', theme: 'black',
  				titleDays:$roycount.data('days'),titleHours:$roycount.data('hours'),titleMinutes:$roycount.data('minutes'),titleSeconds:$roycount.data('seconds')
  			});
  		}
  	});
  }

});
