{**
 * 2007-2017 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2017 PrestaShop SA
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 * International Registered Trademark & Property of PrestaShop SA
 *}
{block name='cart_detailed_totals'}
<div class="cart-detailed-totals">

  <div class="card-block">


    {foreach from=$cart.subtotals item="subtotal"}
      {if $subtotal.value && $subtotal.type !== 'tax'}
        <div class="cart-summary-line" id="cart-subtotal-{$subtotal.type}">
          <span class="label{if 'products' === $subtotal.type} js-subtotal{/if}">
            {if 'products' == $subtotal.type}
              {$cart.summary_string}
            {else}
              {$subtotal.label}
            {/if}
          </span>
          <span class="value" style="display:none">{$subtotal.value}</span>
          {if $subtotal.type === 'shipping'}
              <div><small class="value">{hook h='displayCheckoutSubtotalDetails' subtotal=$subtotal}</small></div>
          {/if}
        </div>
      {/if}
    {/foreach}
  </div>

  {block name='cart_voucher'}
    {include file='checkout/_partials/cart-voucher.tpl'}
  {/block}

  <hr class="separator">

  <div class="card-block">
    {block name='cart_summary_total_ht'}
      <div class="cart-summary-line">
        <span class="label sub">Total articles HT</span>
        <!-- <span class="value sub" style="font-weight:500">{$cart.totals.total.amount-$cart.subtotals.tax.amount|number_format:2:",":" "} {$currency.sign}</span> -->
        <span id="totalproductht" class="value sub" myval="" style="font-weight:500"></span><br>


      </div>
    {/block}
    {block name='cart_detailed_fdp_ht'}
      <div class="cart-summary-line">
        <span class="label sub">Frais de port</span>
        <span class="value sub" style="font-weight:500"><span class="small">à calculer</span></span>
      </div>
    {/block}
    <div class="cart-summary-line" style="border-bottom:dotted 1px #f2f2f2;padding-bottom:10px;margin-bottom:10px;">
      <small class="label">+ taxes</small>
      <small id="totalproducttax" class="value" style="font-weight:500">
        <!-- {$cart.subtotals.tax.value} -->

      </small>
    </div>
    <div class="cart-summary-line cart-total">
      <span class="label">{$cart.totals.total.label} {$cart.labels.tax_short}</span>
      <!-- <span class="value">{$cart.totals.total.value}</span> -->
      <span class="value" id="totalproductttc" myval="{$cart.subtotals.products.amount}">{$cart.subtotals.products.value} </span>
    </div>
    <span class="small">Hors frais de port</span>


  </div>

  <hr class="separator">
  <div id="totalproductwidth" style="text-align:center;color:#327897"></div>
  <div id="higherdelay" style="text-align:center;color:#327897"></div>
</div>
{/block}
