{** * 2007-2017 PrestaShop * * NOTICE OF LICENSE * * This source file is subject to the Academic Free License 3.0 (AFL-3.0) * that is bundled with this package in the file LICENSE.txt. * It is also available through the world-wide-web at this URL: * https://opensource.org/licenses/AFL-3.0 * If you did not receive a copy of the license and are unable to * obtain it through the world-wide-web, please send an email * to license@prestashop.com so we can send you a copy immediately. * * DISCLAIMER * * Do not edit or add to this file if you wish to upgrade PrestaShop to newer * versions in the future. If you wish to customize PrestaShop for your * needs please refer to http://www.prestashop.com for more information. * * @author PrestaShop SA
<contact@prestashop.com>
    * @copyright 2007-2017 PrestaShop SA * @license https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0) * International Registered Trademark & Property of PrestaShop SA *} {extends file=$layout} {block name='head_seo' prepend}
    <link rel="canonical" href="{$product.canonical_url}"> {/block} {block name='head' append}
    <meta property="og:type" content="product">
    <meta property="og:url" content="{$urls.current_url}">
    <meta property="og:title" content="{$page.meta.title}">
    <meta property="og:site_name" content="{$shop.name}">
    <meta property="og:description" content="{$page.meta.description}">
    <meta property="og:image" content="{$product.cover.large.url}">
    <meta property="product:pretax_price:amount" content="{$product.price_tax_exc}">
    <meta property="product:pretax_price:currency" content="{$currency.iso_code}">
    <meta property="product:price:amount" content="{$product.price_amount}">
    <meta property="product:price:currency" content="{$currency.iso_code}"> {if isset($product.weight) && ($product.weight != 0)}
    <meta property="product:weight:value" content="{$product.weight}">
    <meta property="product:weight:units" content="{$product.weight_unit}"> {/if} {/block} {block name='content'}
  
<!--Microdonnées à valider 2020/08/03-->

    <div itemtype="http://schema.org/Product" itemscope>
<!--      <meta itemprop="mpn" content="925872" />-->
      <meta itemprop="name" content="{$product.name}" />
      <link itemprop="image" href="{$product.cover.bySize.large_default.url}" />
      <meta itemprop="description" content="{$product.description_short nofilter}" />
        <meta itemprop="availability" content="https://schema.org/InStock" />
        <meta itemprop="gtin" content="{$product.gtin}" />
        <meta itemprop="itemCondition" content="new" />
      <div itemprop="offers" itemtype="http://schema.org/AggregateOffer" itemscope>
        <meta itemprop="price" content="{$product.price_amount}" />
        <meta itemprop="offerCount" content="1" />
        <meta itemprop="priceCurrency" content="{$currency.iso_code}" />
      </div>
<!--
      <div itemprop="aggregateRating" itemtype="http://schema.org/AggregateRating" itemscope>
        <meta itemprop="reviewCount" content="89" />
        <meta itemprop="ratingValue" content="4.4" />
      </div>
-->
<!--
      <div itemprop="review" itemtype="http://schema.org/Review" itemscope>
        <div itemprop="author" itemtype="http://schema.org/Person" itemscope>
          <meta itemprop="name" content="Fred Benson" />
        </div>
        <div itemprop="reviewRating" itemtype="http://schema.org/Rating" itemscope>
          <meta itemprop="ratingValue" content="4" />
          <meta itemprop="bestRating" content="5" />
        </div>
      </div>
-->
      <meta itemprop="sku" content="{$product.reference}" />
      <div itemprop="brand" itemtype="http://schema.org/Brand" itemscope>
        <meta itemprop="name" content="{Manufacturer::getNameById((int) $product.id_manufacturer)}" />
      </div>
    </div>
         <!--FIN Microdonnées à valider 2020/08/03-->
<!--    <section id="main" itemscope itemtype="https://schema.org/Product">-->
    <section id="main">
<!--
        <meta itemprop="url" content="{$product.url}">
        <meta itemprop="brand" content="{Manufacturer::getNameById((int) $product.id_manufacturer)}">
        <meta itemprop="sku" content="{$product.reference}">
        <meta itemprop="gtin" content="{$product.gtin}">
        <meta itemprop="itemCondition" content="new" />
        <meta itemprop="priceCurrency" content="{$currency.iso_code}" />
        <meta itemprop="price" content="{$product.price_amount}" />
        <meta itemprop="availability" content="https://schema.org/InStock" />
        <div itemprop="seller" itemtype="http://schema.org/Organization" itemscope>
            <meta itemprop="name" content="{$shop.name}" />
        </div>
-->



        <div class="row">
            <div class="col-lg-6 col-image">
                <div id="MyCustomTrustbadge"></div>
                {block name='page_content_container'}
                <section class="col-image-inside">
                    {block name='page_content'} {block name='product_flags'}
                    <ul class="product-flags">
                        {foreach from=$product.flags item=flag}
                        <li class="product-flag {$flag.type}">{$flag.label}</li>
                        {/foreach}
                    </ul>
                    {/block} {block name='product_cover_thumbnails'} {include file='catalog/_partials/product-cover-thumbnails.tpl'} {/block} {/block} {block name='product_additional_info'} {include file='catalog/_partials/product-additional-info.tpl'} {/block}

                    <!-- block name='product-reassurance'
              include file='catalog/_partials/product-reassurance.tpl'
            /block> -->
<div id="nocontract">Images non contractuelles</div>
                    
                </section>
                {/block}
                
            </div>
            <div class="col-lg-6 col-content">
                <div class="col-content-inside">

                    {block name='page_header_container'} {block name='page_header'}
                    <h1 class="h1 product-title" itemprop="name">{block name='page_title'}{$product.name}{/block}</h1>
                    {/block} {/block}
                 

                    {if isset($nbComments) && $nbComments > 0}
                    <div class="comments_note">
                        <div class="star_content clearfix">
                            {section name="i" start=0 loop=5 step=1} {if $averageTotal le $smarty.section.i.index}
                            <div class="star"></div>
                            {else}
                            <div class="star star_on"></div>
                            {/if} {/section}
                            <span class="nb-comments"><span>{l s='%s'|sprintf:$nbComments mod='productcomments'}</span> {l s='Review(s)'}</span>
                        </div>
                    </div>
                    {/if}

                    <div class="product-information">
                        {if in_array(124,Product::getProductCategories($product->id|intval))}
<div class="alert alert-success text-center" style="padding:3px;"><b><i class="fa fa-truck"></i>&nbsp;Livraison offerte</b><div style="font-size:10px;">En France continentale</div></div>
          {/if}
                        {if $product.is_customizable && count($product.customizations.fields)} {block name='product_customization'} {include file="catalog/_partials/product-customization.tpl" customizations=$product.customizations} {/block} {/if}

                        <div class="product-actions">
                            {block name='product_buy'}
                            <form action="{$urls.pages.cart}" method="post" id="add-to-cart-or-refresh">
                                <input type="hidden" name="token" value="{$static_token}">
                                <input type="hidden" name="id_product" value="{$product.id}" id="product_page_product_id">
                                <input type="hidden" name="id_customization" value="{$product.id_customization}" id="product_customization_id"> {block name='product_variants'} {include file='catalog/_partials/product-variants.tpl'} {/block} <!--{block name='product_pack'} {if $packItems}
                                <section class="product-pack">
                                    <h3 class="h4">{l s='This pack contains' d='Shop.Theme.Catalog'}</h3>
                                    {foreach from=$packItems item="product_pack"} {block name='product_miniature'} {include file='catalog/_partials/miniatures/pack-product.tpl' product=$product_pack} {/block} {/foreach}
                                </section>
                                {/if} {/block}--> {block name='product_discounts'} {include file='catalog/_partials/product-discounts.tpl'} {/block} {block name='product_prices'} {include file='catalog/_partials/product-prices.tpl'} {/block} {block name='product_out_of_stock'}
                                <div class="product-out-of-stock">
                                    {hook h='actionProductOutOfStock' product=$product}
                                </div>
                                {/block} {block name='product_refresh'}
                                <input class="product-refresh ps-hidden-by-js" name="refresh" type="submit" value="{l s='Refresh' d='Shop.Theme.Actions'}"> {/block}
                            </form>
                            {/block}

                        </div>
                    </div>
                </div>
            </div>
        </div>


        {block name='product_tabs'} {if $product.features}
        <h2 class="productsection">Données techniques</h2>
        <div id="fichetec" class="prodsection">
            {block name='product_details'} {include file='catalog/_partials/product-details.tpl'} {/block}{if $product.description}{/if}
        </div>{/if} 
        
        <!--            Affichage du contenu des packs-->
            {block name='product_pack'} {if $packItems}
                                
                                    <h2 class="productsection">{l s='This pack contains' d='Shop.Theme.Catalog'}</h2>
                                    <div id="contenupack"  class="product-pack prodsection">
                                        <div class="row clearfix">{foreach from=$packItems item="product_pack"} {block name='product_miniature'} {include file='catalog/_partials/miniatures/pack-product.tpl' product=$product_pack} {/block} {/foreach}</div></div>
                                
                                {/if} {/block}
   <!--           FIN Affichage du contenu des packs--> 
        <h2 class="productsection" id="featurestitle">Données technique</h2>
        <div id="myfeaturetab" class="prodsection"></div>
        {if $product.features}feature{/if}
        {if $product.description}<h2 class="productsection">{l s='Description' d='Shop.Theme.Catalog'}</h2>
        <div id="descriptionproduit" class="prodsection">
            {include file='blocs-consogarage/fiches-produit-debut.tpl'} 
        
            {block name='product_description'} {$product.description nofilter}
        {/block}{block name='produit-contenu-auto'}{include file='catalog/_partials/produit-contenu-auto.tpl'}  {/block}
<!--        Bloc à propos du fabricant-->
            <hr/>
         <div id="productbrand"> {if isset($manufacturer_image_url)}
            <img src="{$manufacturer_image_url}" class="productbrandlogo" alt="{$product_manufacturer->name}" />
        {/if} {$product_manufacturer->description_short nofilter}{$manufacturer->short_description} {$product_manufacturer->description nofilter}</div>
        </div>{/if} {if $product.attachments} 
        
        
        
            <h2 class="productsection"><!--{l s='Attachments' d='Shop.Theme.Catalog'}-->Documentation <span class="small">{$product.name} - {$product.reference}</span></h2> {block name='product_attachments'} {if $product.attachments}
<div id="documentation" class="prodsection ">
            <div class="row text-center">
                
                {foreach from=$product.attachments item=attachment}
                <div class="col-xs-12 col-sm-6 col-md-4 col-lg-3 text-center onedoc">
                   <a href="{url entity='attachment' params=['id_attachment' => $attachment.id_attachment]}"> <svg height="50px" viewBox="-65 0 512 512.00125" width="50px" xmlns="http://www.w3.org/2000/svg"><g fill-rule="evenodd"><path d="m328.429688 0c-102.21875 0-204.4375 0-306.65625 0-11.984376 0-21.773438 9.753906-21.773438 21.667969v383.019531c0 11.914062 9.789062 21.667969 21.773438 21.667969h22.296874l306.128907-354.019531v-50.667969c0-11.914063-9.816407-21.667969-21.769531-21.667969zm0 0" fill="#c4cccf"/><path d="m301.605469 38.867188h-236.585938c-11.542969 0-20.949219 9.40625-20.949219 20.941406v369.996094c0 11.503906 9.4375 20.90625 20.949219 20.90625h295.027344c11.515625 0 20.953125-9.402344 20.953125-20.90625v-296.113282c0-2.628906 0-5.023437-.027344-7.242187zm0 0" fill="#eceff1"/><path d="m301.605469 38.867188-.058594 66.640624c0 11.507813 9.4375 20.9375 20.949219 20.9375h58.476562c-.292968-17.460937-2.28125-23.15625-16.628906-38.722656l-14.144531-15.386718-13.0625-14.136719c-13.820313-15.039063-15.078125-19.332031-35.53125-19.332031zm0 0" fill="#90a4ae"/></g><path d="m297.042969 231.535156h-190.554688c-4.300781 0-7.785156-3.484375-7.785156-7.785156s3.484375-7.785156 7.785156-7.785156h190.554688c4.300781 0 7.785156 3.484375 7.785156 7.785156s-3.484375 7.785156-7.785156 7.785156zm0 0" fill="#35505c"/><path d="m297.042969 183.382812h-190.554688c-4.300781 0-7.785156-3.488281-7.785156-7.789062s3.484375-7.785156 7.785156-7.785156h190.554688c4.300781 0 7.785156 3.484375 7.785156 7.785156s-3.484375 7.789062-7.785156 7.789062zm0 0" fill="#35505c"/><path d="m350.230469 429.800781c0 11.476563-9.378907 20.882813-20.867188 20.910157h30.683594c11.515625 0 20.953125-9.402344 20.953125-20.910157v-296.113281c0-2.625 0-5.023438-.03125-7.242188h-30.769531c1.519531 100.894532.03125 202.34375.03125 303.355469zm0 0" fill="#c4cccf" fill-rule="evenodd"/><path d="m180.945312 297.601562c-6.050781 0-11.046874 4.585938-11.046874 10.222657v75.75h-14.875c-35.445313 1.753906-36.234376 29.730469-21.59375 48.535156l14.492187 18.601563 36.089844 46.375c16.367187 19.886718 42.78125 19.886718 57.042969 0l36.089843-46.375 14.496094-18.601563c14.640625-18.804687 13.851563-46.78125-21.597656-48.535156h-14.902344v-75.75c0-5.636719-4.96875-10.222657-11.046875-10.222657zm0 0" fill="#8bc34a" fill-rule="evenodd"/><path d="m266.742188 415.640625-14.496094 18.601563-12.828125 16.46875-23.261719 29.875c-8.53125 11.882812-21.359375 16.675781-33.808594 14.367187l1.664063 2.132813c16.367187 19.886718 42.78125 19.886718 57.042969 0l36.089843-46.375 14.496094-18.601563c14.027344-17.988281 13.910156-44.417969-17.242187-48.183594 3.359374 9.753907-.089844 21.960938-7.65625 31.714844zm0 0" fill="#689f38" fill-rule="evenodd"/><path d="m227.730469 135.199219h-121.242188c-4.300781 0-7.785156-3.488281-7.785156-7.789063 0-4.300781 3.484375-7.785156 7.785156-7.785156h121.242188c4.296875 0 7.78125 3.484375 7.78125 7.785156 0 4.300782-3.484375 7.789063-7.78125 7.789063zm0 0" fill="#35505c"/></svg></a><h4><a href="{url entity='attachment' params=['id_attachment' => $attachment.id_attachment]}">{$attachment.name}</a></h4>
                    <p>{$attachment.description}</p> <a href="{url entity='attachment' params=['id_attachment' => $attachment.id_attachment]}">
                    {l s='Download' d='Shop.Theme.Actions'} ({$attachment.file_size_formatted})
                    </a>
                </div>
                {/foreach}
            </div>

            {/if} {/block}</div>{/if}
        
         {foreach from=$product.extraContent item=extra key=extraKey}
        <h2 class="productsection title{$extra.title|strip:'-'}">{$extra.title}</h2>
                <div id="{$extra.title|strip:'-'}" class="prodsection">
                    
{$extra.content nofilter}
                </div>
                {/foreach}
        


        {/block} {block name='product_accessories'} {if $accessories}

         
                <h2 class="productsection">
                    {l s='You might also like' d='Shop.Theme.Catalog'}
                </h2>
        <div class="productsectionsub" >Ces accessoires sont tous compatibles avec {$product.name} - {$product.reference} </div>
                <div id="accessoires" class="products prodsection">
                     
                    {foreach from=$accessories item="product_accessory"} {block name='product_miniature'} {include file='catalog/_partials/miniatures/product.tpl' product=$product_accessory} {/block} {/foreach}
                </div>
            

        {/if} {/block} {block name='product_footer'} {hook h='displayFooterProduct' product=$product category=$category} {/block} {block name='product_images_modal'} {include file='catalog/_partials/product-images-modal.tpl'} {/block} {block name='page_footer_container'}
        <footer class="page-footer">
            {block name='page_footer'}
            <!-- Footer content -->
            {/block}
        </footer>
        {/block}
    </section>

    {/block}

