{**
 * 2007-2017 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2017 PrestaShop SA
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 * International Registered Trademark & Property of PrestaShop SA
 *}
{extends file=$layout}

{block name='content'}
  <section id="main">
      <div id="gondole" class="row cgonly hidden-sm-down text-center">{foreach from=$listing.products item="product"}
          {if in_array(144,Product::getProductCategories($product->id|intval))}
          <div class="col-sm-6 tete-de-gondole"><img
              src = "{$product.cover.bySize.home_default.url}"onerror="this.onerror=''; this.src='themes/theme-consogarage/img/consogarage-no-picture.svg';"
              alt = "{if !empty($product.cover.legend)}{$product.cover.legend}{else}{$product.name|truncate:30:'...'}{/if}"
              data-full-size-image-url = "{$product.cover.large.url}"
            ><h3 class="h3">{$product.name}</h3><p>{$product.description_short nofilter}</p></div>
          {/if}
          {/foreach}
         <div class="col-xs-12"><hr/></div> 
      </div>
<!--      bloc marque-->
      {if $page.page_name == 'manufacturer'}
       <img src="{$base_dir}img/m/{$product->id_manufacturer}-small_default.jpg" alt="{Manufacturer::getNameById($product->id_manufacturer)}" title="{Manufacturer::getNameById($product->id_manufacturer)}">
      <h1>{$manufacturer.name}</h1>
      <div id="manufacturer-short_description">{$manufacturer.short_description nofilter}</div>
  <div id="manufacturer-description">{$manufacturer.description nofilter}</div>
      <hr/>
      {/if}
<!--FIN BLOC MARQUE-->
    {block name='product_list_header'}
      <h2 class="h2">{$listing.label}</h2>
    {/block}
      
      

      
      
    <section id="products">
      {if $listing.products|count}

        <div id="">
          {block name='product_list_top'}
            {include file='catalog/_partials/products-top.tpl' listing=$listing}
          {/block}
        </div>

        {block name='product_list_active_filters'}
          <div id="" class="hidden-sm-down">
            {$listing.rendered_active_filters nofilter}
          </div>
        {/block}

        <div id="">
          {block name='product_list'}
            {include file='catalog/_partials/products.tpl' listing=$listing}
          {/block}
        </div>

        <div id="js-product-list-bottom">
          {block name='product_list_bottom'}
            {include file='catalog/_partials/products-bottom.tpl' listing=$listing}
          {/block}
        </div>

      {else}

        {include file='errors/not-found.tpl'}

      {/if}
    </section>

  </section>
{/block}
