<?php

class CategoryController extends CategoryControllerCore
{

    public function initContent()
    {

        parent::initContent();

        // sort products so they are grouped by category
		$this->sortProductsByCategory();

    }


    protected function sortProductsByCategory() {

    	// get product listing
        $listing = $this->context->smarty->getTemplateVars('listing');

        // find all categories in product listing
        $categories = array();
        foreach ($listing['products'] as $product) {
        	$categories[] = $product['id_category_default'];
        }

        // sort product listing by categories
        array_multisort($categories, SORT_ASC, $listing['products']);

        // send listing variable back to smarty template
        $this->context->smarty->assign( 'listing' , $listing );

    }

}
?>