/*
 * contactable 1.5 - jQuery Ajax contact form
 *
 * Copyright (c) 2009 Philip Beel (http://www.theodin.co.uk/)
 * Dual licensed under the MIT (http://www.opensource.org/licenses/mit-license.php)
 * and GPL (http://www.opensource.org/licenses/gpl-license.php) licenses.
 *
 * Revision: $Id: jquery.contactable.min.js 2012-05-26 $
 *
 */

(function(jQuery){

	// Define the new for the plugin ans how to call it
	jQuery.fn.contactable = function(options) {
		// Set default options
		var defaults = {
			url: 'mail.php',
			header: '',
			name: 'Name',
			email: 'Email',
            customermail:'',
			dropdownTitle: '',
			dropdownOptions: ['General', 'Website bug', 'Feature request'],
			message : 'Message',
			subject : 'A contactable message',
			submit : 'SEND',
			recievedMsg : 'Thank you for your message',
			notRecievedMsg : 'Thank you for your message',
			footer: 'Please feel free to get in touch, we value your feedback',
			hideOnSubmit: true
		};

		var options = jQuery.extend(defaults, options);

		return this.each(function() {

			// Create the form and inject it into the DOM
			var dropdown = ''
			,	filter = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/
			,	dropdownLen = options.dropdownOptions.length
			,	i;

			// Add select option if applicable
			if(options.dropdownTitle) {
				dropdown += '<p><label for="contactable-dropdown">'+options.dropdownTitle+' </label><br /><select name="dropdown" id="contactable-dropdown" class="contactable-dropdown">';

				for(i=0; i < dropdownLen; i++) {
					dropdown += '<option value="'+options.dropdownOptions[i]+'">'+options.dropdownOptions[i]+'</option>';
				}

				dropdown += '</select></p>';
			}
			// Form layout
			/*
			*	<div id="contactable-inner"></div>
			*	<form id="contactable-contactForm" method="" action="">
			*  		<div id="contactable-loading"></div>
			*		<div id="contactable-callback"></div>
			* 		<div class="contactable-holder">
			*			<p class="contactable-header">Header text</p>
			* 			<p>
			*				<label for="contactable-name">Name<span class="contactable-green"> * </span></label><br />
			*				<input id="contactable-name" class="contactable-contact contactable-validate" name="name" />
			*			</p>
			*			<p>
			*				<label for="contactable-email"> Email address <span class="contactable-green"> * </span></label><br />
			* 				<input id="contactable-email" class="contactable-contact contactable-validate" name="email" />
			*			</p>
			* 			<p>
			*				<label for="contactable-message"> Message <span class="contactable-green"> * </span></label><br />
			* 				<textarea id="contactable-message" name="message" class="contactable-message contactable-validate" rows="4" cols="30" ></textarea>
			*			</p>
			*			<p>
			*				<input class="contactable-submit" type="submit" value="Submit"/>
			*			</p>
			*			<p class="contactable-footer">Footer text</p>
			*		</div>
			*	</form>
			*/

			jQuery(this).html('<div id="contactable-inner"></div><form id="contactable-contactForm" method="" action=""><div id="contactable-loading"></div><div id="contactable-callback"></div><div class="contactable-holder"><p class="contactable-header">'+options.header+'</p><p class="contactable-name">'+'<input id="contactable-name" class="contactable-contact contactable-validate" name="name" placeholder="'+options.name+'" /></p><p class="contactable-email">'+'<input id="contactable-email" class="contactable-contact contactable-validate" name="email" placeholder="'+options.email+'" value="'+options.customermail+'" /></p>'+dropdown+'<p class="contactable-text">'+'<textarea id="contactable-message" name="message" class="contactable-message contactable-validate" rows="4" cols="30" placeholder="'+options.message+'" ></textarea></p><p class="contactable-sub"><input class="contactable-submit btn btn-primary" type="submit" value="'+options.submit+'"/></p><p class="contactable-footer">'+options.footer+'</p></div></form>');

			// hide header or footer when empty
			if(options.header.length === 0) {
				jQuery(this).find(".contactable-header").hide();
			}
			if(options.footer.length === 0) {
				jQuery(this).find(".contactable-footer").hide();
			}

			// Toggle the form visibility
			jQuery.fn.toggleClick = function() {
				var functions = arguments, iteration = 0
				return this.click(function() {
					functions[iteration].apply(this, arguments)
					iteration = (iteration + 1) % functions.length
				})
			}

			jQuery('#contactable-inner').toggleClick(function() {
				jQuery('#contactable-overlay').css({display: 'block'});
				jQuery(this).animate({"marginLeft": "-=5px"}, "2000");
				jQuery('#contactable-contactForm').animate({"marginLeft": "-=0px"}, "2000");
                jQuery(this).animate({"marginLeft": "-=5px"}, "2000");
				jQuery('#contactable-contactForm').animate({"marginLeft": "+=0px"}, "4000");
			},
			function() {
				jQuery('#contactable-contactForm').animate({"marginLeft": "-=0px"}, "4000");
				jQuery(this).animate({"marginLeft": "-=5px"}, "4000").animate({"marginLeft": "+=5px"}, "2000");
				jQuery('#contactable-overlay').css({display: 'none'});
			});

			// Submit the form
			jQuery("#contactable-contactForm").submit(function() {

				// Validate the entries
				var valid = true
				,	params;

				//Remove any previous errors
				jQuery("#contactable-contactForm .contactable-validate").each(function() {
					jQuery(this).removeClass('contactable-invalid');
				});

				// Loop through required field
				jQuery("#contactable-contactForm .contactable-validate").each(function() {

					// Check the min length
					if(jQuery(this).val().length < 2) {
						jQuery(this).addClass("contactable-invalid");
						valid = false;
					}

					//Check email is valid
					if (!filter.test(jQuery("#contactable-contactForm #contactable-email").val())) {
						jQuery("#contactable-contactForm #contactable-email").addClass("contactable-invalid");
						valid = false;
					}
				});

				if(valid === true) {
					submitForm();
				}
				return false;
			});

			function submitForm() {
				// Display loading animation
				jQuery('.contactable-holder').hide();
				jQuery('#contactable-loading').show();

				// Trigger form submission if form is valid
				jQuery.ajax({
					type: 'POST',
					url: options.url,
                    dataType: 'json',
					data: {
                        subject:options.subject,
						name:jQuery('#contactable-name').val(),
						email:jQuery('#contactable-email').val(),
						issue:jQuery('#contactable-dropdown').val(),
						message:jQuery('#contactable-message').val()
					},
					success: function(data) {
						// Hide loading animation
						jQuery('#contactable-loading').css({display:'none'});

						// Check for a valid server side response
						if( data.response === 'success') {
							jQuery('#contactable-callback').show().append(options.recievedMsg+'<br /><span class="try_again">Send another message</span>.');
							if(options.hideOnSubmit === true) {
								//hide the tab after successful submition if requested
								jQuery('#contactable-inner').click();
							}
                            $(".try_again").click(function() {
                                $('.contactable-holder').show();
                                $('#contactable-callback').hide().html('');
                            });
						} else {
							jQuery('#contactable-callback').show().append(options.notRecievedMsg+'<br /><span class="try_again">Send another message</span>.');
							setTimeout(function(){
								jQuery('.contactable-holder').show();
								jQuery('#contactable-callback').hide().html('');
							},2000);
                            $(".try_again").click(function() {
                                $('.contactable-holder').show();
                                $('#contactable-callback').hide().html('');
                            });
						}
					},
					error:function(e){
						jQuery('#contactable-loading').css({display:'none'});
						jQuery('#contactable-callback').show().append(options.notRecievedMsg+'<br /><span class="try_again">Send another message</span>.');
                        $(".try_again").click(function() {
                            $('.contactable-holder').show();
                            $('#contactable-callback').hide().html('');
                        });
					}
				});
			}
		});
	};

})(jQuery);
