
{if $product.show_price}
  <div class="product-prices">

    {block name='product_price'}
      <div
        class="product-price h5 {if $product.has_discount}has-discount{/if}"
        itemprop="offers"
        itemscope
        itemtype="https://schema.org/Offer"
      >
        <link itemprop="availability" href="https://schema.org/InStock"/>
        <meta itemprop="url" content="{$product.url}">
   <meta itemprop="gtin13" content="{$product.ean13}">



    <meta itemprop="gtin" content="{$product.supplier_reference}">






        <meta itemprop="priceValidUntil" content="{"+1 month"|date_format:'%Y-%m-%d %H:%M:%S'}">
        <meta itemprop="priceCurrency" content="{$currency.iso_code}">
{if $product.has_discount}
          <div class="product-discount">
            {hook h='displayProductPriceBlock' product=$product type="old_price"}
            {* <span class="regular-price" style="text-decoration: line-through;"> {$product.regular_price}</span> *}
            <span class="regular-price" style="text-decoration: line-through;">{math equation="x / y" x=$product.regular_price_amount y=1.2 format="%.2f"} € <span class="small">HT</span></span>

          </div>
          {/if}
        <div class="current-price">
          <span itemprop="price" content="{$product.price_amount}">
      {$product.price_tax_exc|string_format:"%.2f"|replace:'.':','} € <span class="small">HT</span>
          {* {$product.price} *}
          </span>
        </div>
          <div class="prix-ttc"><span class="small">Soit</span> {$product.price}<span class="small"> TTC</span></div>
        {if $product.has_discount}

          {if $product.discount_type === 'percentage'}
            <span class="discount discount-percentage">{l s=' -%percentage%' d='Shop.Theme.Catalog' sprintf=['%percentage%' => $product.discount_percentage_absolute|ceil]}%</span>
          {else}
            <span class="discount discount-amount">
                {* {l s='Discount -%amount%' d='Shop.Theme.Catalog' sprintf=['%amount%' => $product.discount_to_display]} *}
               - {$product.discount_to_display}
            </span>
          {/if}
        {/if}

        {block name='product_unit_price'}
          {if $displayUnitPrice}
            <p class="product-unit-price sub">{l s='(%unit_price%)' d='Shop.Theme.Catalog' sprintf=['%unit_price%' => $product.unit_price_full]}</p>
          {/if}
        {/block}
      </div>
    {/block}

    {block name='product_without_taxes'}
      {if $priceDisplay == 2}
        <p class="product-without-taxes">{l s='%price% tax excl.' d='Shop.Theme.Catalog' sprintf=['%price%' => $product.price_tax_exc]}</p>
      {/if}
    {/block}

    {block name='product_pack_price'}
      {if $displayPackPrice}
        <p class="product-pack-price"><span>{l s='Instead of %price%' d='Shop.Theme.Catalog' sprintf=['%price%' => $noPackPrice]}</span></p>
      {/if}
    {/block}

    {block name='product_ecotax'}
      {if $product.ecotax.amount > 0}
        <p class="price-ecotax">{l s='Including %amount% for ecotax' d='Shop.Theme.Catalog' sprintf=['%amount%' => $product.ecotax.value]}
          {if $product.has_discount}
            {l s='(not impacted by the discount)' d='Shop.Theme.Catalog'}
          {/if}
        </p>
      {/if}
    {/block}

    {hook h='displayProductPriceBlock' product=$product type="weight" hook_origin='product_sheet'}

    <div class="tax-shipping-delivery-label">
      {if $configuration.display_taxes_label}
        {$product.labels.tax_long}
      {/if}
      {hook h='displayProductPriceBlock' product=$product type="price"}
      {hook h='displayProductPriceBlock' product=$product type="after_price"}
      {if isset($product.additional_delivery_times)}
        {if $product.additional_delivery_times == 1}
          {if $product.delivery_information}
            <span class="delivery-information">{$product.delivery_information}</span>
          {/if}
		{elseif $product.additional_delivery_times == 2}
		  {if $product.quantity > 0}
			<span class="delivery-information">{$product.delivery_in_stock}</span>
		  {* Out of stock message should not be displayed if customer can't order the product. *}
		  {elseif $product.quantity == 0 && $product.add_to_cart_url}
			<span class="delivery-information">{$product.delivery_out_stock}</span>
		  {/if}
		{/if}
      {/if}
    </div>




    {block name='product_add_to_cart'}
      {include file='catalog/_partials/product-add-to-cart.tpl'}
    {/block}


    <div class="product-info">
     {block name='product_quantities'}
       {if $product.show_quantities}
         <div class="product-quantities" style="display:none;">
           <label class="label">{l s='In stock' d='Shop.Theme.Catalog'}</label>
           <span data-stock="{$product.quantity}" data-allow-oosp="{$product.allow_oosp}">{$product.quantity}</span>
         </div>
       {/if}
     {/block}

     {block name='product_reference'}
       {if isset($product.reference_to_display)}
         <div class="product-reference">
           <label class="label">{l s='Reference' d='Shop.Theme.Catalog'} </label>
           <span itemprop="sku">{$product.reference_to_display}</span>
         </div>
       {/if}
     {/block}

{include file='catalog/_partials/cg-delai-dispo.tpl'}





     {if isset($product_manufacturer->id)}
       <div class="product-manufacturer tip_inside">
         <a href="{$product_brand_url}">
           {if isset($manufacturer_image_url)}
               <img src="{$manufacturer_image_url}" class="img img-thumbnail manufacturer-logo" alt="{$product_manufacturer->name}" height="140" width="140">
           {/if}
           <div class="manu_text sr-only">
             <label class="label">{l s='Brand' d='Shop.Theme.Catalog'}</label>
             <span>
               {$product_manufacturer->name}
             </span>
           </div>
         </a>
           <span class='tip'>
             {l s='View all products of ' d='Shop.Theme.Catalog'}{$product_manufacturer->name}
           </span>
       </div>
     {/if}

    </div>


  </div>

{/if}

  <div  class="gapcardlist l2 m2 s1">
      <!-- <div style="margin-bottom:10px;">

        <p class="h3" style="font-size:12px;display:inline-block"><img src="/themes/modez/assets/img/consogarage-freeshipping.svg" width="25" height="25" alt="Icône livraison offerte" style="display:inline-block;vertical-align:middle;"> Livraison offerte dès 200€ <span class="small">HT*</span></p><p style="font-size:10px;padding-left:25px;margin-bottom:5px;">* concerne l'outillage et le consommable</p></div> -->
      <div style="margin-bottom:10px;">

        <p class="h3" style="font-size:12px;display:inline-block"><img src="/themes/modez/assets/img/consogarage-rapide.svg" width="25" height="25" alt="Icône expédition express" style="display:inline-block;vertical-align:middle;"> Expédition en 24/48 heures </p><p style="font-size:10px;padding-left:25px;margin-bottom:5px;"> Pour les articles en stock</p></div>
      <div style="margin-bottom:10px;">

        <p class="h3" style="font-size:12px;display:inline-block"><img src="/themes/modez/assets/img/consogarage-plusieurs-fois.svg" width="25" height="25" alt="Icône paiement en plusieurs fois" style="display:inline-block;vertical-align:middle;"> Paiement sécurisé en plusieurs fois </p><p style="font-size:10px;padding-left:25px;margin-bottom:5px;">Maîtrisez votre budget jusqu'à 2 000 € TTC</p></div>
      <div style="margin-bottom:10px;">

        <p class="h3" style="font-size:12px;display:inline-block"><img src="/themes/modez/assets/img/consogarage-assistance.svg" width="25" height="25" alt="Icône assistance technique" style="display:inline-block;vertical-align:middle;"> Assistance technique par téléphone</p><p style="font-size:10px;padding-left:25px;margin-bottom:5px;"><a href="tel:+33531616114" rel="nofollow external">05 31 61 61 14</a><span class="xstip">Cliquez pour appeler</span></p></div>
      </div>
