<?php
/**
 * Advanced Pack 5
 *
 * @author    Presta-Module.com <support@presta-module.com> - https://www.presta-module.com
 * @copyright Presta-Module 2020 - https://www.presta-module.com
 * @license   Commercial
 *
 *           ____     __  __
 *          |  _ \   |  \/  |
 *          | |_) |  | |\/| |
 *          |  __/   | |  | |
 *          |_|      |_|  |_|
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

class AdvancedPackOverride extends AdvancedPack
{

    public static function getPackPriceTable($packContent, $packFixedPriceList = array(), $packIdTaxRulesGroup = 0, $useTax = true, $includeEcoTax = true, $useGroupReduction = false, $attributesList = array())
    {
        $packFixedPrice = 0;
        $productCategoryReduction = null;
        $packCategoryReduction = null;
        $currentIdGroup = null;
        if ($packContent !== false && is_array($packContent)) {
            $currentIdGroup = (int)Group::getCurrent()->id;
            $packContentFirstItem = current($packContent);
            if (!empty($packContentFirstItem['id_pack'])) {
                $idPack = (int)$packContentFirstItem['id_pack'];
                $packCategoryReduction = GroupReduction::getValueForProduct((int)$idPack, $currentIdGroup);
                if (is_float($packCategoryReduction + 0)) {
                    $packCategoryReduction = $packCategoryReduction * 100;
                } else {
                    $packCategoryReduction = null;
                }
            }
            if (is_array($packFixedPriceList) && isset($packFixedPriceList[$currentIdGroup]) && $packFixedPriceList[$currentIdGroup] > 0) {
                $packFixedPrice = $packFixedPriceList[$currentIdGroup];
            }
        }
        if ($packCategoryReduction !== null) {
            $useGroupReduction = false;
            if ($packFixedPrice > 0) {
                $packFixedPrice -= ($packFixedPrice * $packCategoryReduction / 100);
            }
        }
        $excludeVATCase = false;
        list($address) = self::getAddressInstance();
        if (!$packIdTaxRulesGroup
        && !empty($address->vat_number)
        && $address->id_country != Configuration::get('VATNUMBER_COUNTRY')
        && Configuration::get('VATNUMBER_MANAGEMENT')) {
            $excludeVATCase = true;
        } elseif (!$packIdTaxRulesGroup && Validate::isLoadedObject(self::getContext()->customer) && self::getContext()->customer->id != self::PACK_FAKE_CUSTOMER_ID) {
            $excludeVATCase = (Product::getTaxCalculationMethod(self::getContext()->customer->id) == 0);
        }
        $cacheId = self::getPMCacheId((int)self::$usePackReductionReduction.__METHOD__.json_encode($packContent).(float)$packFixedPrice.(int)$packIdTaxRulesGroup.(int)$useTax.(int)$excludeVATCase.(int)$includeEcoTax.(int)$useGroupReduction.serialize($attributesList), true);
        if (self::$forceUseOfAnotherContext || !self::isInCache($cacheId)) {
            $groupReduction = Group::getReductionByIdGroup($currentIdGroup);
            $totalClassicPriceWithoutTaxes = $totalClassicPriceWithTaxes = $totalEcoTax = 0;
            if ($packContent !== false) {
                $priceRounding = null;
                if (Module::isEnabled('pricerounding') && Tools::file_exists_cache(_PS_MODULE_DIR_.'pricerounding/classes/PriceroundingConfiguration.php')) {
                    include_once(_PS_MODULE_DIR_.'pricerounding/classes/PriceroundingConfiguration.php');
                    $priceRounding = new PriceroundingConfiguration();
                }
                foreach ($packContent as &$packProduct) {
                    $productPackIdAttribute = (isset($attributesList[(int)$packProduct['id_product_pack']]) ? $attributesList[(int)$packProduct['id_product_pack']] : (isset($packProduct['id_product_attribute']) && (int)$packProduct['id_product_attribute'] ? (int)$packProduct['id_product_attribute'] : (int)$packProduct['default_id_product_attribute']));
                    $specificPriceOutput = null;
                    $productPackPriceWt = $productClassicPriceWt = self::getPriceStaticPack($packProduct['id_product'], true, $productPackIdAttribute, 6, null, false, (bool)$packProduct['use_reduc'], (int)$packProduct['quantity'], null, null, null, $specificPriceOutput, false, $useGroupReduction);
                    $productPackPrice = $productClassicPrice = self::getPriceStaticPack($packProduct['id_product'], false, $productPackIdAttribute, 6, null, false, (bool)$packProduct['use_reduc'], (int)$packProduct['quantity'], null, null, null, $specificPriceOutput, false, $useGroupReduction);
                    if ($packFixedPrice > 0) {
                        if ($packCategoryReduction === null) {
                            $specificCategoryReduction = null;
                            $productCategoryReduction = GroupReduction::getValueForProduct((int)$packProduct['id_product'], $currentIdGroup);
                            if (is_float($productCategoryReduction + 0)) {
                                $productCategoryReduction = $productCategoryReduction * 100;
                            } else {
                                $productCategoryReduction = null;
                            }
                            $specificCategoryReduction = $productCategoryReduction;
                            if ($specificCategoryReduction === null && $groupReduction > 0) {
                                $specificCategoryReduction = (float)$groupReduction;
                            }
                            if ($specificCategoryReduction !== null && $specificCategoryReduction > 0) {
                                $productClassicPriceWtTmp = self::getPriceStaticPack($packProduct['id_product'], true, $productPackIdAttribute, 6, null, false, (bool)$packProduct['use_reduc'], (int)$packProduct['quantity'], null, null, null, $specificPriceOutput, false, false);
                                $productClassicPriceTmp = self::getPriceStaticPack($packProduct['id_product'], false, $productPackIdAttribute, 6, null, false, (bool)$packProduct['use_reduc'], (int)$packProduct['quantity'], null, null, null, $specificPriceOutput, false, false);
                                $packProduct['customPercentageDiscount'] = $specificCategoryReduction;
                                if ($packIdTaxRulesGroup) {
                                    $totalClassicPriceWithTaxes -= ($productClassicPriceTmp * $specificCategoryReduction / 100);
                                } else {
                                    $totalClassicPriceWithoutTaxes -= ($productClassicPriceWtTmp * $specificCategoryReduction / 100);
                                }
                            }
                        }
                    } else {
                        if ($packCategoryReduction === null && self::$usePackReductionReduction && !$useGroupReduction) {
                            $productCategoryReduction = GroupReduction::getValueForProduct((int)$packProduct['id_product'], $currentIdGroup);
                            if (is_float($productCategoryReduction + 0)) {
                                $productCategoryReduction = $productCategoryReduction * 100;
                            } else {
                                $productCategoryReduction = null;
                            }
                            if ($productCategoryReduction != null && $productCategoryReduction > 0) {
                                $packProduct['customPercentageDiscount'] = $productCategoryReduction;
                                $productPackPrice -= ($productPackPrice * $productCategoryReduction / 100);
                                $productPackPriceWt -= ($productPackPriceWt * $productCategoryReduction / 100);
                                $productClassicPrice -= ($productClassicPrice * $productCategoryReduction / 100);
                                $productClassicPriceWt -= ($productClassicPriceWt * $productCategoryReduction / 100);
                            }
                        } elseif ($packCategoryReduction !== null && $packCategoryReduction > 0) {
                            $productPackPrice -= ($productPackPrice * $packCategoryReduction / 100);
                            $productPackPriceWt -= ($productPackPriceWt * $packCategoryReduction / 100);
                            $productClassicPrice -= ($productClassicPrice * $packCategoryReduction / 100);
                            $productClassicPriceWt -= ($productClassicPriceWt * $packCategoryReduction / 100);
                            $packProduct['customPercentageDiscount'] = $packCategoryReduction;
                        }
                    }
                    $taxManager = TaxManagerFactory::getManager($address, Product::getIdTaxRulesGroupByIdProduct((int)$packProduct['id_product']));
                    $productTaxCalculator = $taxManager->getTaxCalculator();
                    $ecoTaxManager = TaxManagerFactory::getManager($address, (int)Configuration::get('PS_ECOTAX_TAX_RULES_GROUP_ID'));
                    $ecoTaxCalculator = $ecoTaxManager->getTaxCalculator();
                    $packReductionType = $packProduct['reduction_type'];
                    $packReductionAmount = $packProduct['reduction_amount'];
                    if (isset($packProduct['combinationsInformations']) && isset($packProduct['combinationsInformations'][$productPackIdAttribute]) && $packProduct['combinationsInformations'][$productPackIdAttribute]['reduction_type'] != null) {
                        $packReductionType = $packProduct['combinationsInformations'][$productPackIdAttribute]['reduction_type'];
                        $packReductionAmount = $packProduct['combinationsInformations'][$productPackIdAttribute]['reduction_amount'];
                        $packProduct['reduction_type'] = $packReductionType;
                        $packProduct['reduction_amount'] = $packReductionAmount;
                    }
                    if ($packReductionType == 'amount') {
                        $packReductionAmount = Tools::convertPrice($packReductionAmount, self::getContext()->currency);
                        $packProduct['reduction_amount'] = $packReductionAmount;
                        $productPackPrice -= Tools::ps_round($packReductionAmount, 6);
                        $productPackPriceWt -= Tools::ps_round($useTax ? $productTaxCalculator->addTaxes($packReductionAmount) : $packReductionAmount, 6);
                    } elseif ($packReductionType == 'percentage') {
                        $productPackPrice *= (1 - $packReductionAmount);
                        $productPackPriceWt *= (1 - $packReductionAmount);
                    }
                    if (version_compare(_PS_VERSION_, '1.6.1.0', '<') && !(bool)$packProduct['use_reduc'] && $useGroupReduction && $groupReduction > 0) {
                        $productPackPrice -= ($productPackPrice * $groupReduction / 100);
                        $productPackPriceWt -= ($productPackPriceWt * $groupReduction / 100);
                    }
                    if ($productPackPrice < 0) {
                        $productPackPrice = $productPackPriceWt = 0;
                    }
                    if ($packFixedPrice > 0 && $productPackIdAttribute != (int)$packProduct['default_id_product_attribute']) {
                        $defaultCombinationPriceImpact = Combination::getPrice($packProduct['default_id_product_attribute']);
                        $combinationPriceImpact = Combination::getPrice($productPackIdAttribute);
                        if ($productPackPrice > 0 && $defaultCombinationPriceImpact > 0) {
                            $combinationPriceImpact -= $defaultCombinationPriceImpact;
                        }
                        $packFixedPrice += $combinationPriceImpact;
                    }
                    $productEcoTax = $productEcoTaxWt = self::getProductEcoTax((int)$packProduct['id_product'], (int)$productPackIdAttribute);
                    $productEcoTaxWt = $ecoTaxCalculator->addTaxes($productEcoTaxWt);
                    if ($packFixedPrice > 0 && $excludeVATCase) {
                        $address2 = clone($address);
                        if (!empty($address2->vat_number)) {
                            $address2->vat_number = null;
                        } else {
                            $address2->id_country = (int)Configuration::get('PS_COUNTRY_DEFAULT');
                            $address2->id_state = 0;
                        }
                        $taxManager2 = TaxManagerFactory::getManager($address2, Product::getIdTaxRulesGroupByIdProduct((int)$packProduct['id_product']));
                        $productTaxCalculator2 = $taxManager2->getTaxCalculator();
                        $totalClassicPriceWithoutTaxes += $productClassicPrice * (int)$packProduct['quantity'];
                        $totalClassicPriceWithTaxes += $productTaxCalculator2->addTaxes($productClassicPrice) * (int)$packProduct['quantity'];
                    } else {
                        $totalClassicPriceWithoutTaxes += $productClassicPrice * (int)$packProduct['quantity'];
                        $totalClassicPriceWithTaxes += $productClassicPriceWt * (int)$packProduct['quantity'];
                    }
                    $packProduct['priceInfos'] = array(
                        'productPackPrice' => $productPackPrice,
                        'productPackPriceWt' => $productPackPriceWt,
                        'productClassicPrice' => $productClassicPrice,
                        'productClassicPriceWt' => $productClassicPriceWt,
                        'taxesClassic' => $productClassicPriceWt - $productClassicPrice,
                        'taxesPack' => $productPackPriceWt - $productPackPrice,
                        'productEcoTax' => $productEcoTax,
                        'productEcoTaxWt' => $productEcoTaxWt,
                        'quantity' =>  (int)$packProduct['quantity'],
                    );
                    if ($priceRounding != null && method_exists($priceRounding, 'getRoundedPrice')) {
                        $prConfigs = null;
                        if (method_exists($priceRounding, 'getPRConfigurations')) {
                            $context = self::getContext();
                            $prConfigs = $priceRounding->getPRConfigurations(
                                $context->shop->id,
                                (int)$packProduct['id_product'],
                                (int)(Validate::isLoadedObject($context->customer) && !empty($context->customer->id) ? $context->customer->id : 0),
                                (int)$address->id_country,
                                (int)$address->id_state,
                                (int)$context->currency->id,
                                (int)$context->language->id
                            );
                        }
                        if ($prConfigs === null || (is_array($prConfigs) && !empty($prConfigs))) {
                            $productPackPriceWt = $priceRounding->getRoundedPrice((int)$packProduct['id_product'], $productPackPriceWt);
                            $packProduct['priceInfos']['productPackPriceWt'] = $productPackPriceWt;
                            $packProduct['priceInfos']['taxesPack'] = $productPackPriceWt - $productPackPrice;
                        }
                    }
                    if ($packReductionType == 'amount') {
                        $packProduct['priceInfos']['reductionAmountWt'] = Tools::ps_round($useTax ? $productTaxCalculator->addTaxes($packReductionAmount) : $packReductionAmount, 6);
                        $packProduct['priceInfos']['reductionAmount'] = Tools::ps_round($packReductionAmount, 6);
                    } else {
                        $packProduct['priceInfos']['reductionAmountWt'] = 0;
                        $packProduct['priceInfos']['reductionAmount'] = 0;
                    }
                }
                if ($packFixedPrice > 0) {
                    foreach ($packContent as &$packProduct) {
                        $taxManager = TaxManagerFactory::getManager($address, Product::getIdTaxRulesGroupByIdProduct((int)$packProduct['id_product']));
                        $productTaxCalculator = $taxManager->getTaxCalculator();
                        if ($totalClassicPriceWithoutTaxes > 0 || $totalClassicPriceWithTaxes > 0) {
                            if ($packIdTaxRulesGroup) {

                                $packProduct['priceInfos']['productPackPriceWt'] = Tools::ps_round((($packProduct['priceInfos']['productPackPriceWt'] * (int)$packProduct['quantity']) / $totalClassicPriceWithoutTaxes) * $packFixedPrice, 6) / (int)$packProduct['quantity'];
                                $packProduct['priceInfos']['productPackPrice'] = Tools::ps_round((($packProduct['priceInfos']['productPackPrice'] * (int)$packProduct['quantity']) / $totalClassicPriceWithoutTaxes) * $packFixedPrice, 6) / (int)$packProduct['quantity'];
                            } else {
                                $packProduct['priceInfos']['productPackPriceWt'] = Tools::ps_round((($packProduct['priceInfos']['productPackPriceWt'] * (int)$packProduct['quantity']) / $totalClassicPriceWithTaxes) * $packFixedPrice, 6) / (int)$packProduct['quantity'];
                                $packProduct['priceInfos']['productPackPrice'] = Tools::ps_round((($packProduct['priceInfos']['productPackPrice'] * (int)$packProduct['quantity']) / $totalClassicPriceWithTaxes) * $packFixedPrice, 6) / (int)$packProduct['quantity'];
                            }
                        }
                    }
                } else {
                    foreach ($packContent as &$packProduct) {
                        $packProduct['priceInfos']['productPackPrice'] = Tools::ps_round($packProduct['priceInfos']['productPackPrice'], 6);
                        $packProduct['priceInfos']['productPackPriceWt'] = Tools::ps_round($packProduct['priceInfos']['productPackPriceWt'], 6);
                        $packProduct['priceInfos']['productClassicPrice'] = Tools::ps_round($packProduct['priceInfos']['productClassicPrice'], 6);
                        $packProduct['priceInfos']['productClassicPriceWt'] = Tools::ps_round($packProduct['priceInfos']['productClassicPriceWt'], 6);
                        $packProduct['priceInfos']['taxesClassic'] = Tools::ps_round($packProduct['priceInfos']['taxesClassic'], 6);
                        $packProduct['priceInfos']['taxesPack'] = Tools::ps_round($packProduct['priceInfos']['taxesPack'], 6);
                        $packProduct['priceInfos']['productEcoTax'] = Tools::ps_round($packProduct['priceInfos']['productEcoTax'], 6);
                        $packProduct['priceInfos']['productEcoTaxWt'] = Tools::ps_round($packProduct['priceInfos']['productEcoTaxWt'], 6);
                    }
                }
            }
        } else {
            return self::getFromCache($cacheId);
        }
        self::storeInCache($cacheId, $packContent);
        return $packContent;
    }

}
