<?php
class OrderController extends OrderControllerCore
{
    /*
    * module: quantitydiscountpro
    * date: 2023-03-14 11:12:56
    * version: 2.1.43
    */
    protected function bootstrap()
    {
        parent::bootstrap();
        if (Module::isEnabled('quantitydiscountpro') && Tools::getValue('action') == 'updateCarrier') {
            include_once(_PS_MODULE_DIR_.'quantitydiscountpro/quantitydiscountpro.php');
            $quantityDiscount = new QuantityDiscountRule();
            $quantityDiscount->createAndRemoveRules();
        }
    }
    /*
    * module: opartlimitquantity
    * date: 2023-11-03 10:48:10
    * version: 1.4.10
    */
    public function initContent()
    {
        
        $limitQtyObj = null;
        if (Module::isEnabled('opartlimitquantity')) {
            $limitQtyObj = Module::getInstanceByName('opartlimitquantity');
        }
        if (version_compare(_PS_VERSION_, '1.7', '>=')) {
            if ($limitQtyObj) {
                if ($qtyErrors = $limitQtyObj->checkCartQuantities()) {
                    $this->errors = array_merge($this->errors, $qtyErrors);
                }
                if (count($this->errors)) {
                    Tools::redirect($this->context->link->getPageLink('cart') . '?action=show');
                    die;
                }
            }
            parent::initContent();
        } else {
            if ($limitQtyObj) {
                if ($qtyErrors = $limitQtyObj->checkCartQuantities()) {
                    $this->errors = array_merge($this->errors, $qtyErrors);
                    $this->step = 0;
                }
            }
            parent::initContent();
        }
    }
}
