/**
* Sofinco PrestaShop Module
*
* Feel free to contact Verifone at support@paybox.com for any
* question.
*
* LICENSE: This source file is subject to the version 3.0 of the Open
* Software License (OSL-3.0) that is available through the world-wide-web
* at the following URI: http://opensource.org/licenses/OSL-3.0. If
* you did not receive a copy of the OSL-3.0 license and are unable
* to obtain it through the web, please send a note to
* support@e-transactions.fr so we can mail you a copy immediately.
*
*  @category  Module / payments_gateways
*  @version   3.0.6
*  @author    BM Services <contact@bm-services.com>
*  @copyright 2012-2016 Sofinco
*  @license   http://opensource.org/licenses/OSL-3.0
*  @link      http://www.e-transactions.fr/
*/

$(document).ready(function () {

    if (refundAvailable == 1) {
        sofincoCreateCreditSlip();

        $('#generateDiscount').on('click', function () {
            sofincoToggleCreditSlip();
        });
        $('#generateCreditSlip').on('click', function () {
            sofincoToggleCreditSlip();
        });
    }

    /**
     * Intercept Ajax calls for page reload on product modification or deletion
     */
    $(document).ajaxSuccess(function (event, xhr, settings, data) {
        if (typeof data !== 'undefined' && data !== null) {
            if (typeof data.documents_html !== 'undefined' && data.documents_html !== null) {
                window.location.reload(true);
            }
        }
    });


    if ($('.alert-sofinco').length) {
        $('html, body').animate({
            scrollTop: ($('.alert-sofinco').offset().top - 150)
        }, 2000);
    }
});

/**
 * Create Checkbox for refund
 */
function sofincoCreateCreditSlip()
{
    html =
        '<p class="checkbox" id="sofincoRefundSpan" style="display: none;">'+
            '<label for="sofincoRefund">'+
                '<input type="checkbox" id="sofincoRefund" name="sofincoRefund" />'+
                refundCheckboxText +
            '</label>'+
        '</p>';

    $('#spanShippingBack').after(html);

}

/**
 * Handle validation of refund checkbox
 * => only available if generateCreditSlip checked and generateDiscount unchecked
 */
function sofincoToggleCreditSlip()
{
    generateDiscount = $('#generateDiscount').attr("checked");
    generateCreditSlip = $('#generateCreditSlip').attr("checked");
    if (generateDiscount != 'checked' && generateCreditSlip == 'checked') {
        $('#sofincoRefundSpan').css('display', 'block');
    } else {
        $('#sofincoRefundSpan input[type=checkbox]').attr("checked", false);
        // $('#sofincoRefundSpan').css('display', 'none');
    }
}
