<?php
/**
 * 2013 - 2023 PayPlug SAS
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0).
 * It is available through the world-wide-web at this URL:
 * https://opensource.org/licenses/osl-3.0.php
 * If you are unable to obtain it through the world-wide-web, please send an email
 * to contact@payplug.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PayPlug module to newer
 * versions in the future.
 *
 * @author    PayPlug SAS
 * @copyright 2013 - 2023 PayPlug SAS
 * @license   https://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 *  International Registered Trademark & Property of PayPlug SAS
 */

namespace PayLaterModule\src\application\adapter;

use OrderSlip;
use PayLaterModule\src\interfaces\OrderSlipInterface;

class OrderSlipAdapter implements OrderSlipInterface
{
    public function get($idOrderSlip = null)
    {
        return new OrderSlip($idOrderSlip);
    }

    public function getOrdersSlip($idCustomer, $idOrder = false)
    {
        return OrderSlip::getOrdersSlip($idCustomer, $idOrder);
    }
}
