<?php
/**
 * 2013 - 2023 PayPlug SAS
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0).
 * It is available through the world-wide-web at this URL:
 * https://opensource.org/licenses/osl-3.0.php
 * If you are unable to obtain it through the world-wide-web, please send an email
 * to contact@payplug.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PayPlug module to newer
 * versions in the future.
 *
 * @author    PayPlug SAS
 * @copyright 2013 - 2023 PayPlug SAS
 * @license   https://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 *  International Registered Trademark & Property of PayPlug SAS
 */

namespace PayLaterModule\src\application\adapter;

use Media;
use PayLaterModule\src\interfaces\MediaInterface;

class MediaAdapter implements MediaInterface
{
    public function addJsDef($files = [])
    {
        foreach ($files as &$file) {
            if ($file && is_string($file)) {
                $file = addslashes($file);
            }
        }

        return Media::addJsDef($files);
    }

    public static function getMediaPath($path)
    {
        return Media::getMediaPath($path);
    }

    public function getJsDef()
    {
        return Media::getJsDef();
    }
}
