<?php
/**
 * 2013 - 2023 PayPlug SAS
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0).
 * It is available through the world-wide-web at this URL:
 * https://opensource.org/licenses/osl-3.0.php
 * If you are unable to obtain it through the world-wide-web, please send an email
 * to contact@payplug.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PayPlug module to newer
 * versions in the future.
 *
 * @author    PayPlug SAS
 * @copyright 2013 - 2023 PayPlug SAS
 * @license   https://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 *  International Registered Trademark & Property of PayPlug SAS
 */

namespace PayLaterModule\src\application\adapter;

use Configuration;
use PayLaterModule\src\interfaces\ConfigurationInterface;

class ConfigurationAdapter implements ConfigurationInterface
{
    private $psConfiguration;

    public function __construct()
    {
        $this->psConfiguration = new Configuration();
    }

    public static function factory()
    {
        return new ConfigurationAdapter();
    }

    public function get($configuration_name)
    {
        // Old PHP configs can't accept $this->classVar::staticMethod()
        // But only $var::staticMethod()
        $config = $this->psConfiguration;

        return $config::get($configuration_name);
    }

    public function updateValue($key, $value)
    {
        $config = $this->psConfiguration;

        return $config::updateValue($key, $value);
    }

    public function deleteByName($key)
    {
        $config = $this->psConfiguration;

        return $config::deleteByName($key);
    }

    public function loadConfiguration()
    {
        return Configuration::loadConfiguration();
    }
}
