/**
 * pm_advancedcookiebanner
 *
 * @author    Presta-Module.com <support@presta-module.com> - http://www.presta-module.com
 * @copyright Presta-Module - http://www.presta-module.com
 * @license   see file: LICENSE.txt
 *
 *           ____     __  __
 *          |  _ \   |  \/  |
 *          | |_) |  | |\/| |
 *          |  __/   | |  | |
 *          |_|      |_|  |_|
 */

var pmAcbConsentLevels = {
    'all': 3,
    'marketing': 2,
    'analytics': 1,
    'mandatory': 0,
};

let pmAcbCustomizeConsentPanelOpened = false;

// Keep this function for legacy overrides
function acb_createCookie(consentLevel) {
    // Abort if we are in simulation mode
    if (acbConfigMode == 1) {
        return location.reload();
    }

    return acb_makeRequest({
        ajax: true,
        consentLevel: (typeof (consentLevel) !== 'undefined' ? consentLevel : 0),
        token: (typeof (prestashop) == 'undefined' ? static_token : prestashop.static_token),
    });
}

function acb_makeRequest(data) {
    return $.ajax({
        type: 'POST',
        url: acbControllerURL,
        data: data,
    }).done(function () {
        location.reload(true);
    });
}

$(document).ready(function() {
    initAcbEvents();
});

function initAcbEvents() {
    // Allow click on label to check a consent checkbox
    $(document).on('click', '.acbCheckboxContainer label', function() {
        if ($(this).prev('input').prop('disabled') !== true) {
            $(this).prev('input').prop('checked', !$(this).prev('input').prop('checked'));
            // Uniform related
            if ($(this).parent().find('div.checker').length > 0 && $(this).parent().find('div.checker input').attr('name') != 'acbConsentMandatory') {
                if ($(this).parent().find('div.checker span').hasClass('checked')) {
                    $(this).parent().find('div.checker span').removeClass('checked');
                    $(this).parent().find('div.checker input').prop('checked', false);
                } else {
                    $(this).parent().find('div.checker span').addClass('checked');
                    $(this).parent().find('div.checker input').prop('checked', true);
                }
            }
        }
    });
    if (typeof (acbControllerURL) != 'undefined') {
        $(document).on('click', '#acb-deny-all-button', function () {
            $("#acb-banner").addClass("hide");
            var consentLevel = pmAcbConsentLevels['mandatory'];
            acb_createCookie(consentLevel);
        });
        $(document).on('click', '#acb-accept-all-button', function () {
            $("#acb-banner").addClass("hide");
            var consentLevel = pmAcbConsentLevels['all'];
            acb_createCookie(consentLevel);
        });
        $(document).on('click', '#acb-close-button', function() {
            $("#acb-banner").addClass("hide");
            var consentLevel = getConsentLevelValue();
            acb_createCookie(consentLevel);
        });
        document.querySelector('#acbCustomize').addEventListener('click', () => {
            if (!pmAcbCustomizeConsentPanelOpened) {
                openCustomConsentPanel();
            } else {
                closeCustomConsentPanel();
            }
        });
        document.querySelector('#acb-close-panel').addEventListener('click', () => {
            closeCustomConsentPanel();
        });
        document.querySelector('#acb-custom-panel form').addEventListener('submit', (e) => {
            e.preventDefault();

            // Build a JSON object from the form inputs
            const formData = new FormData(e.currentTarget);
            const selectedModules = Array.from(formData.entries()).map((row) => (row[0]));

            return acb_makeRequest({
                ajax: true,
                // Build the consent array using a FormData
                consentData: selectedModules,
                token: (typeof (prestashop) == 'undefined' ? static_token : prestashop.static_token),
            });
        });
    } else {
        const pmAcbUnsetLinkSelector = 'a[href="' + acbUnsetControllerURL + '"]';
        if ($(pmAcbUnsetLinkSelector).length > 0) {
            $(document).on('click', pmAcbUnsetLinkSelector, function(e) {
                e.preventDefault();
                document.__defineSetter__('cookie', function(e) {});
                window.location.href = $(this).attr('href');
            });
        }
    }
}

function openCustomConsentPanel() {
    document.querySelector('#acb-content').classList.add('hide');
    document.querySelector('#acb-action').classList.add('hide');
    document.querySelector('#acb-custom-panel').classList.remove('hide');
    document.querySelector('#acb-banner').classList.add('acb-panel-opened');
}

function closeCustomConsentPanel() {
    document.querySelector('#acb-content').classList.remove('hide');
    document.querySelector('#acb-action').classList.remove('hide');
    document.querySelector('#acb-custom-panel').classList.add('hide');
    document.querySelector('#acb-banner').classList.remove('acb-panel-opened');
}

function getConsentLevelValue() {
    var acbConsentAnalytics = $('input[name="acbConsentAnalytics"]').prop('checked');
    var acbConsentMarketing = $('input[name="acbConsentMarketing"]').prop('checked');

    // Both analytics and marketing
    if (acbConsentMarketing === true && acbConsentAnalytics === true) {
        return pmAcbConsentLevels['all'];
    // Only marketing
    } else if (acbConsentMarketing === true) {
        return pmAcbConsentLevels['marketing'];
    // Only analytics
    } else if (acbConsentAnalytics === true) {
        return pmAcbConsentLevels['analytics'];
    // Only the "no consent required" modules
    } else {
        return pmAcbConsentLevels['mandatory'];
    }
}
