<?php
/**
* 2012-2018 Patryk Marek PrestaDev.pl
*
* Patryk Marek PrestaDev.pl - PD Free delivery Pro © All rights reserved.
*
* DISCLAIMER
*
* Do not edit, modify or copy this file.
* If you wish to customize it, contact us at info@prestadev.pl.
*
* @author    Patryk Marek PrestaDev.pl <info@prestadev.pl>
* @copyright 2012-2018 Patryk Marek - PrestaDev.pl
* @link      http://prestadev.pl
* @package   PD Free delivery Pro - PrestaShop 1.5.x and 1.6.x Module
* @version   1.4.5
* @license   License is for use in domain / or one multistore enviroment (do not modify or reuse this code or part of it) if you want any changes please contact with me at info@prestadev.pl
* @date      10-06-2015
*/

class AdminProductsController extends AdminProductsControllerCore
{
	
	public function __construct()
	{
		parent::__construct();

		$module_instance = Module::getInstanceByName('pdfreedeliverypro');
        if ($module_instance->active) {
            $label_free_delivery = $module_instance->controller_overide_label;
        } else {
        	$label_free_delivery = $this->l('Free delivery');
        }

		if (Shop::isFeatureActive() && Shop::getContext() != 4) {
	        $this->fields_list['free_delivery'] = array(
	            'title' => $label_free_delivery,
	            'active' => 'free_delivery',
	            'type' => 'bool',
	            'class' => 'fixed-width-sm',
	            'filter_key' => 'a!free_delivery',
	            'orderby' => false
	        );
    	} elseif (Shop::isFeatureActive() == false) {
    		$this->fields_list['free_delivery'] = array(
	            'title' => $label_free_delivery,
	            'active' => 'free_delivery',
	            'type' => 'bool',
	            'class' => 'fixed-width-sm',
	            'filter_key' => 'a!free_delivery',
	            'orderby' => false
	        );
    	}
	}

	public function initProcess()
	{
		parent::initProcess();
		
		if ((isset($_GET['free_delivery'.$this->table]) || isset($_GET['free_delivery'])) && Tools::getValue($this->identifier)) {
            $id_product = (int)Tools::getValue('id_product');
            $object = new Product($id_product);
            $object->free_delivery = $object->free_delivery ? 0 : 1;
            $object->update();

		}
	}
}
