<?php
/**
* 2012-2018 Patryk Marek PrestaDev.pl
*
* Patryk Marek PrestaDev.pl - PD Free delivery Pro © All rights reserved.
*
* DISCLAIMER
*
* Do not edit, modify or copy this file.
* If you wish to customize it, contact us at info@prestadev.pl.
*
* @author    Patryk Marek PrestaDev.pl <info@prestadev.pl>
* @copyright 2012-2018 Patryk Marek - PrestaDev.pl
* @link      http://prestadev.pl
* @package   PD Free delivery Pro - PrestaShop 1.5.x and 1.6.x Module
* @version   1.4.5
* @license   License is for use in domain / or one multistore enviroment (do not modify or reuse this code or part of it) if you want any changes please contact with me at info@prestadev.pl
* @date      10-06-2015
*/

class Carrier extends CarrierCore
{
    public function doFreeDliveryCheck($cart)
    {
        $id_carrier = (int)$this->id;
        $module_instance = Module::getInstanceByName('pdfreedeliverypro');
        if ($module_instance->active) {
            return $module_instance->doFreeDeliveryCheckByParams($id_carrier, $cart);
        } else {
            return false;
        }
    }

    public function getDeliveryPriceByPrice($orderTotal, $id_zone, $id_currency = null, $cart = null)
    {
        if ($cart == null) {
            $cart = Context::getContext()->cart;
        }

        if (!$cart instanceOf Cart) {
            $cart = new Cart();
        }

        $check = $this->doFreeDliveryCheck($cart);
        $totalWeight = $cart->getTotalWeight();

        if (is_array($check)) {
            $freePrice = isset($check['free_price']) ? $check['free_price'] : 0;
            $freeMode = isset($check['free_mode']) ? $check['free_mode'] : 0;
            $isFree = $check['is_free'];
            $nf_p_count = isset($check['nf_p_count']) ? $check['nf_p_count'] : 0;
            
            if ($freeMode == 1 && $isFree) {
                return 0;
            } elseif ($freeMode == 2 && $isFree && $freePrice > 0 && $nf_p_count > 0) {
                $orderPriceReduced = abs($orderTotal - $freePrice);
                return parent::getDeliveryPriceByPrice($orderPriceReduced, $id_zone, $id_currency);
            } elseif ($freeMode == 2 && $isFree && $nf_p_count == 0) {
                return 0;
            } elseif ($freeMode == 3 && $isFree) {
                return 0;
            } elseif ($freeMode == 4 && $isFree) {
                return 0;
            } elseif ($freeMode == 5 && $isFree) {
                return 0;
            } elseif ($freeMode == 6 && $isFree) {
                return 0;
            } else {
                return parent::getDeliveryPriceByPrice($orderTotal, $id_zone, $id_currency);
            }
        } else {
            return parent::getDeliveryPriceByPrice($orderTotal, $id_zone, $id_currency);
        }
    }

    public function getDeliveryPriceByWeight($totalWeight, $id_zone, $cart = null)
    {
        if ($cart == null) {
            $cart = Context::getContext()->cart;
        }

        if (!$cart instanceOf Cart) {
            $cart = new Cart();
        }

        
        $check = $this->doFreeDliveryCheck($cart);
        $orderTotal = $cart->getOrderTotal(true, 8);

        if (is_array($check)) {
            $freeWeight = isset($check['free_weight']) ? $check['free_weight'] : 0;
            $freeMode = isset($check['free_mode']) ? $check['free_mode'] : 0;
            $isFree = $check['is_free'];
            $nf_p_count = isset($check['nf_p_count']) ? $check['nf_p_count'] : 0;

            if ($freeMode == 1 && $isFree) {
                return 0;
            } elseif ($freeMode == 2 && $isFree && $freeWeight > 0 && $nf_p_count > 0) {
                $orderWeightReduced = abs($totalWeight - $freeWeight);
                return parent::getDeliveryPriceByWeight($orderWeightReduced, $id_zone);
            } elseif ($freeMode == 2 && $isFree && $nf_p_count == 0) {
                return 0;
            } elseif ($freeMode == 3 && $isFree) {
                return 0;
            } elseif ($freeMode == 4 && $isFree) {
                return 0;
            } elseif ($freeMode == 5 && $isFree) {
                return 0;
            } elseif ($freeMode == 6 && $isFree) {
                return 0;
            } else {
                return parent::getDeliveryPriceByWeight($totalWeight, $id_zone);
            }
        } else {
            return parent::getDeliveryPriceByWeight($totalWeight, $id_zone);
        }
    }
}
