<?php
/**
* 2012-2018 Patryk Marek PrestaDev.pl
*
* Patryk Marek PrestaDev.pl - PD Free delivery Pro © All rights reserved.
*
* DISCLAIMER
*
* Do not edit, modify or copy this file.
* If you wish to customize it, contact us at info@prestadev.pl.
*
* @author    Patryk Marek PrestaDev.pl <info@prestadev.pl>
* @copyright 2012-2018 Patryk Marek - PrestaDev.pl
* @link      http://prestadev.pl
* @package   PD Free delivery Pro - PrestaShop 1.5.x and 1.6.x Module
* @version   1.4.5
* @license   License is for use in domain / or one multistore enviroment (do not modify or reuse this code or part of it) if you want any changes please contact with me at info@prestadev.pl
* @date      10-06-2015
*/

include_once dirname(__FILE__).'/../../models/FreeDeliveryModel.php';

class AdminFreeDeliveryProNewController extends AdminController
{
    protected $countries_array = array();
    protected $carriers_array = array();
    protected $shops_array = array();

    public $module = null;
    public $module_name = 'pdfreedeliverypro';

    public function __construct()
    {
        $this->table = 'pdfreedeliverypro';
        $this->className = 'FreeDeliveryModel';
        $this->lang = false;
        $this->bootstrap = true;

        if (Module::isInstalled($this->module_name)) {
            $this->module = Module::getInstanceByName($this->module_name);
        }


        $this->addRowAction('edit');
        $this->addRowAction('delete');
        $this->allow_export = true;
        $this->ps_ver_15 = (version_compare(Tools::substr(_PS_VERSION_, 0, 3), '1.5', '=')) ? true : false;
        $this->ps_ver_16 = (version_compare(Tools::substr(_PS_VERSION_, 0, 3), '1.6', '=')) ? true : false;
        $this->ps_ver_17 = (version_compare(Tools::substr(_PS_VERSION_, 0, 3), '1.7', '=')) ? true : false;
        $this->context = Context::getContext();

        $this->default_form_language = $this->context->language->id;

        $this->_select = 's.`name` as shop, c.`name` as carrier, cl.`name` as country, gl.`name` as groupname';
        $this->_join = 'LEFT JOIN `'._DB_PREFIX_.'shop` s ON (s.id_shop = a.id_shop)
                        LEFT JOIN `'._DB_PREFIX_.'carrier` c ON (c.id_carrier = a.id_carrier)
                        LEFT JOIN `'._DB_PREFIX_.'country_lang` cl ON (cl.`id_country` = a.`id_country` AND cl.`id_lang` = '.(int)$this->context->language->id.')
                        LEFT JOIN `'._DB_PREFIX_.'group` g ON (g.id_group = a.id_group)
                        LEFT JOIN `'._DB_PREFIX_.'group_lang` gl ON (gl.`id_group` = a.`id_group` AND gl.`id_lang` = '.(int)$this->context->language->id.')
                        ';

        parent::__construct();

        $this->bulk_actions = array(
            'delete' => array(
                'text' => $this->l('Delete selected'),
                'confirm' => $this->l('Delete selected items?')
            ),
            'enableSelection' => array('text' => $this->l('Enable selection')),
            'disableSelection' => array('text' => $this->l('Disable selection'))
        );

        $this->list_free_mode = array(
            1 => '1: '.$this->l('Free all products in cart'),
            2 => '2: '.$this->l('Substract free product weight / price (not use free form price or free from weight ranges)'),
            3 => '3: '.$this->l('Substract free product weight / price (when use free form price or free from weight ranges)'),
            4 => '4: '.$this->l('Use free form price or free from weight ranges (to replace standard PrestaShop options)'),
            5 => '5: '.$this->l('Free for all products in cart when using free from price and free up to weight'),
            6 => '6: '.$this->l('Free only if in cart are only free products'),
        );

        $countries = Country::getCountries((int)$this->context->language->id, true, false, false);
        foreach ($countries as $country) {
            $this->countries_array[$country['id_country']] = $country['name'];
        }

        $carriers = Carrier::getCarriers((int)$this->context->language->id, true, false, false, null, Carrier::PS_CARRIERS_AND_CARRIER_MODULES_NEED_RANGE);
        foreach ($carriers as $carrier) {
            $this->carriers_array[$carrier['id_carrier']] = $carrier['name'];
        }

        $groups = Group::getGroups((int)$this->context->language->id);
        foreach ($groups as $group) {
            $this->groups_array[$group['id_group']] = $group['name'];
        }
        $shops = Shop::getShops(true);
        foreach ($shops as $shop) {
            $this->shops_array[$shop['id_shop']] = $shop['name'];
        }


        $this->fields_list = array(
            'id_pdfreedeliverypro' => array(
                'title' => $this->l('Id'),
                'align' => 'center',
                'filter' => false,
                'width' => 25
            ),
            'active' => array(
                'title' => $this->l('Active'),
                'align' => 'center',
                'active' => 'status',
                'type' => 'bool',
                'filter' => false,
                'orderby' => false,
                'width' => 25
            ),
            'shop' => array(
                'title' => $this->l('Shop'),
                'type' => 'select',
                'list' => $this->shops_array,
                'filter_key' => 's!id_shop'
            ),
            'carrier' => array(
                'title' => $this->l('Carrier'),
                'type' => 'select',
                'list' => $this->carriers_array,
                'filter_key' => 'c!id_carrier'
            ),
            'country' => array(
                'title' => $this->l('Country'),
                'type' => 'select',
                'list' => $this->countries_array,
                'filter_key' => 'a!id_country'
            ),
            'groupname' => array(
                'title' => $this->l('Customer group'),
                'type' => 'select',
                'list' => $this->groups_array,
                'filter_key' => 'g!id_group'
            ),
            'free_mode' => array(
                'title' => $this->l('Free delivery type'),
                'type' => 'select',
                'list' => $this->list_free_mode,
                'filter_key' => 'a!free_mode'
            ),
            'free_quantity' => array(
                'title' => $this->l('From quantity'),
                'width' => 'auto',
                'filter' => false,
            ),
            'free_from_price' => array(
                'title' => $this->l('From price'),
                'width' => 'auto',
                'filter' => false,
            ),
            'free_upto_weight' => array(
                'title' => $this->l('To weight'),
                'width' => 'auto',
                'filter' => false,
            ),
            'free_from_weight' => array(
                'title' => $this->l('From weight'),
                'width' => 'auto',
                'filter' => false,
            ),
            'date_add' => array(
                'title' => $this->l('Date add'),
                'align' => 'right',
                'width' => 'auto',
                'filter' => false,
                'type' => 'datetime'
            ),
            'date_upd' => array(
                'title' => $this->l('Date updated'),
                'align' => 'right',
                'width' => 'auto',
                'filter' => false,
                'type' => 'datetime'
            )
        );
    }

    public function setMedia($isNewTheme = false)
    {
        parent::setMedia();

        $this->addJS(array(
            $this->module->uri_location.'views/js/init.js',
        ));
    }


    /**
     * Modifying initial getList method
     */
    public function getList($id_lang, $order_by = null, $order_way = null, $start = 0, $limit = null, $id_lang_shop = false)
    {
        parent::getList($id_lang, $order_by, $order_way, $start, $limit, $id_lang_shop);

        foreach ($this->_list as $key => $list) {
            if ($list['free_mode'] == 1) {
                $this->_list[$key]['free_mode'] = $this->list_free_mode['1'];
            } elseif ($list['free_mode'] == 2) {
                $this->_list[$key]['free_mode'] = $this->list_free_mode['2'];
            } elseif ($list['free_mode'] == 3) {
                $this->_list[$key]['free_mode'] = $this->list_free_mode['3'];
            } elseif ($list['free_mode'] == 4) {
                $this->_list[$key]['free_mode'] = $this->list_free_mode['4'];
            } elseif ($list['free_mode'] == 5) {
                $this->_list[$key]['free_mode'] = $this->list_free_mode['5'];
            } elseif ($list['free_mode'] == 6) {
                $this->_list[$key]['free_mode'] = $this->list_free_mode['6'];
            }


            if ($list['carrier'] == '0') {
                $this->_list[$key]['carrier'] = Configuration::get('PS_SHOP_NAME');
            }
        }
    }


    /**
     * Function used to render the list to display for this controller
     */
    public function renderList()
    {
        $this->displayInformation('&nbsp;<b>'.$this->l('How do I create new free delivery configuration?').'</b>
            <br />
            <ul>
                <li>'.$this->l('If you want to add manually then click "Add new configuration" button, then configure free delivery configuration per country, shop, carrier, customer group, quantity and type of free delivery and click save "Save" button.').'<br /></li>
                <li>'.$this->l('Or if You want to create configurations for all countries You might want to use generator bellowe to create configs combinations from selected countries, carriers, shops and click "Generate configurations" button, later You can modify each settings when needed.').'<br /></li>
                <li>'.$this->l('Please read free delivery types before start adding new configurations, it\'s important to understand changes before them.').'<br /></li>
                <li>'.$this->l('Don\'t forget to update GeoIP database and add if You want to add hook for displaying "Free delivery" label on your product images (instructions written below).').'<br /></li>
                <li>'.$this->l('Don\'t forget to assign free delivery for selected products in product editing page tab "Free delivery" or use mass assigment per category, manufacturer, supplier, shop form belowe, you as well can set free deliver auto assigment for new products in module configuration').'<br /></li>
            </ul>');

        // init and render the first list
        $lists = parent::renderList();

        parent::initToolbar();
        
        $lists .= $this->renderFormUpdateGeoIp();
        if ($this->ps_ver_15) {
            $lists .= '<br />';
        }
        $lists .= $this->renderFormGenerator();
        if ($this->ps_ver_15) {
            $lists .= '<br />';
        }
        $lists .= $this->renderFormAssignProducts();
        if ($this->ps_ver_15) {
            $lists .= '<br />';
        }
        
        $lists .= $this->displayInstallationInfos();

        return $lists;
    }
    
    public function renderFormUpdateGeoIp()
    {
        $fields_form_1 = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->l('GeoIP database update'),
                    'icon' => 'icon-cogs'
                ),
                'input' => array(
                array(
                    'type' => 'text',
                    'label' => $this->l('Size'),
                    'name' => 'PD_FDP_GEOIP_DB_SIZE',
                    'desc' => $this->l('GeoIP database size'),
                    'disabled' => true,
                    ),
                array(
                    'type' => 'text',
                    'label' => $this->l('Last update'),
                    'name' => 'PD_FDP_GEOIP_LAST_UPDATE',
                    'desc' => $this->l('New database is available every first thursday each month (is a free GeoIP database from Maxmind)'),
                    'disabled' => true,
                    ),
                ),

                'submit' => array(
                    'title' => $this->l('Update GeoIP database'),
                )
            ),
        );

        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $lang = new Language((int)Configuration::get('PS_LANG_DEFAULT'));
        $helper->default_form_language = $lang->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
        $this->fields_form = array();

        $helper->identifier = $this->identifier;
        $helper->submit_action = 'update_geoip_db';
        $helper->currentIndex = self::$currentIndex;
        $helper->token = $this->token;
        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFieldsValuesGeo(),
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id
        );

        return $helper->generateForm(array($fields_form_1));
    }


    public function getConfigFieldsValuesGeo()
    {
        $return = array();
        $return['PD_FDP_GEOIP_DB_SIZE'] = $this->module->checkSizeGeoIPData('GeoLite2-City.mmdb');
        $return['PD_FDP_GEOIP_LAST_UPDATE'] = Configuration::get('PD_FDP_GEOIP_LAST_UPDATE');

        return $return;
    }


    public function renderFormAssignProducts()
    {
        // Categories form
        $root_category = Category::getRootCategory();
        $root_category = array('id_category' => $root_category->id, 'name' => $root_category->name);

        if (Tools::getValue('assign_ids_categories')) {
            $selected_categories = Tools::getValue('assign_ids_categories');
        } else {
            $selected_categories = array();
        }

        $fields_form_2 = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->l('Assign / unassign free delivery to products by shop, manufacturer, category (you can chose multiple criterions)'),
                    'icon' => 'icon-cogs'
                ),
                'input' => array(
                     array(
                        'type' => 'select',
                        'label' => $this->l('Action set / unset free delivery'),
                        'desc' => $this->l('Choose if You want to assign or unassign free delivery'),
                        'name' => 'assign_action',
                        'options' => array(
                            'query' => array(
                                array(
                                'action' => 1,
                                'name' => $this->l('Assign')
                                ),
                                array(
                                'action' => 0,
                                'name' => $this->l('Unassign')
                                ),
                            ),
                            'id' => 'action',
                            'name' => 'name'
                            )
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Select Shop'),
                        'name' => 'assign_id_shop',
                        'desc' => $this->l('Select shop for products to assign free delivery'),
                        'options' => array(
                            'query' => Shop::getShops(true),
                            'id' => 'id_shop',
                            'name' => 'name'
                        )
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Select manufacturer / manufacturers'),
                        'name' => 'assign_ids_manufacturer[]',
                        'desc' => $this->l('Select products by manufacturers for assign free delivery (multiple selection with holding CTRL key and clicking right mouse click)'),
                        'multiple' => true,
                        'options' => array(
                            'query' => Manufacturer::getManufacturers(),
                            'id' => 'id_manufacturer',
                            'name' => 'name'
                        )
                    ),
                     array(
                        'type' => 'select',
                        'label' => $this->l('Select supplier / suppliers'),
                        'name' => 'assign_ids_suppliers[]',
                        'desc' => $this->l('Select products by suppliers for assign free delivery (multiple selection with holding CTRL key and clicking right mouse click)'),
                        'multiple' => true,
                        'options' => array(
                            'query' => Supplier::getSuppliers(),
                            'id' => 'id_supplier',
                            'name' => 'name'
                        )
                    ),
                    array(
                        'type' => 'categories',
                        'label' => $this->l('Select category / categories'),
                        'name' => 'assign_ids_categories',
                        'desc' => $this->l('Select products by categories for assign free delivery'),
                        'required' => true,
                        'tree' => array(
                            'use_search' => false,
                            'id' => 'assign_ids_categories',
                            'use_checkbox' => true,
                            'selected_categories' => $selected_categories,
                        ),
                        //retro compat 1.5 for category tree
                        'values' => array(
                            'trads' => array(
                                'Root' => $root_category,
                                'selected' => $this->l('Selected'),
                                'Collapse All' => $this->l('Collapse All'),
                                'Expand All' => $this->l('Expand All'),
                                'Check All' => $this->l('Check All'),
                                'Uncheck All' => $this->l('Uncheck All')
                            ),
                            'selected_cat' => $selected_categories,
                            'input_name' => 'assign_ids_categories[]',
                            'use_radio' => false,
                            'use_search' => false,
                            'disabled_categories' => array(),
                            'top_category' => Category::getTopCategory(),
                            'use_context' => true,
                        )
                    )
                ),
                'submit' => array(
                    'name' => 'submitAssignSelected',
                    'title' => $this->l('Assign products'),
                ),
            ),
        );

        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $lang = new Language((int)Configuration::get('PS_LANG_DEFAULT'));
        $helper->default_form_language = $lang->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
        $this->fields_form = array();

        $helper->identifier = $this->identifier;
        $helper->currentIndex = self::$currentIndex;
        $helper->token = $this->token;
        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFieldsValuesAssign(),
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id
        );

        return $helper->generateForm(array($fields_form_2));
    }

    public function getConfigFieldsValuesAssign()
    {
        $return = array();
        $return['assign_ids_manufacturer[]'] = Tools::getValue('assign_ids_manufacturer');
        $return['assign_ids_suppliers[]'] = Tools::getValue('assign_ids_suppliers');
        $return['assign_ids_categories'] = Tools::getValue('assign_ids_categories');
        $return['assign_action'] = Tools::getValue('assign_action');
        $return['assign_id_shop'] = Tools::getValue('assign_id_shop');

        return $return;
    }


    public function renderFormGenerator()
    {
        $currency = new Currency((int)(Configuration::get('PS_CURRENCY_DEFAULT')));
        $weight_unit = Configuration::get('PS_WEIGHT_UNIT');
        $switch = version_compare(_PS_VERSION_, '1.6.0', '>=') ? 'switch' : 'radio';
        
        $fields_form_2 = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->l('Generate for chosen parameters free delivery configurations'),
                    'icon' => 'icon-cogs'
                ),
                'input' => array(
                    array(
                        'type' => $switch,
                        'label' => $this->l('Active'),
                        'name' => 'gen_active',
                        'is_bool' => true,
                        'class' => 't',
                        'desc' => $this->l('Set if configuration should be active or not'),
                        'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => 1,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => 0,
                                'label' => $this->l('Disabled')
                            )
                        ),
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Free delivery mode'),
                        'desc' => $this->l('Type 1: makes whole cart free delivery if in cart is at least one product with free delivery enabled (optionaly we can use free from weight and free from price), Type 2: used to subtract free delivery enabled product weight / price from all cart products weight / price and that subtracted value is used for calculating delivery cost accordingly with ranges defined on that carrier, Type 3: used to subtract free delivery enabled products weight or price from cart total / weight or price used for calculating free from price or free from weight ranges in free delivery configuration on bottom of that page, Type 4: used to replace standard PrestaShop function free from price or free from weight with carrier, country, group, shop restrictions, Type 5: makes whole cart free delivery when free form price and free to weight ranges are used and in cart is at least one product with free delivery enabled, Type 6: makes whole cart free delivery if in cart all products has free delivery enabled'),
                        'name' => 'gen_free_mode',
                        'options' => array(
                            'query' => array(
                                array(
                                'mode' => 1,
                                'name' => '1: '.$this->l('Free all products in cart')
                                ),
                                array(
                                'mode' => 2,
                                'name' => '2: '.$this->l('Substract free product weight / price (not use free form price or free from weight ranges)')
                                ),
                                array(
                                'mode' => 3,
                                'name' => '3: '.$this->l('Substract free product weight / price (when use free form price or free from weight ranges)')
                                ),
                                array(
                                'mode' => 4,
                                'name' => '4: '.$this->l('Use free form price or free from weight ranges (to replace standard PrestaShop options)')
                                ),
                                array(
                                'mode' => 5,
                                'name' => '5: '.$this->l('Free for all products in cart when using free from price and free up to weight')
                                ),
                                array(
                                'mode' => 6,
                                'name' => '6: '.$this->l('Free delivery if in cart all products has free delivery enabled free')
                                )
                            ),
                            'id' => 'mode',
                            'name' => 'name'
                            )
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Select Shop'),
                        'name' => 'gen_id_shop[]',
                        'desc' => $this->l('Select shop for that configuration'),
                        'multiple' => true,
                        'options' => array(
                            'query' => Shop::getShops(true),
                            'id' => 'id_shop',
                            'name' => 'name'
                        )
                    ),
                
                    array(
                        'type' => 'select',
                        'label' => $this->l('Carrier'),
                        'name' => 'gen_id_carrier[]',
                        'desc' => $this->l('Select carrier for that configuration'),
                        'multiple' => true,
                        'options' => array(
                            'query' => Carrier::getCarriers((int)$this->context->language->id, true, false, false, null, Carrier::PS_CARRIERS_AND_CARRIER_MODULES_NEED_RANGE),
                            'id' => 'id_carrier',
                            'name' => 'name'
                        )
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Coutry'),
                        'name' => 'gen_id_country[]',
                        'desc' => $this->l('Select country for that configuration'),
                        'multiple' => true,
                        'options' => array(
                            'query' => Country::getCountries((int)$this->context->language->id, true, false, false),
                            'id' => 'id_country',
                            'name' => 'name'
                        )
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Customer group'),
                        'name' => 'gen_id_group[]',
                        'desc' => $this->l('Select customer group/s used in generated configurations'),
                        'multiple' => true,
                        'options' => array(
                            'query' => Group::getGroups((int)$this->context->language->id),
                            'id' => 'id_group',
                            'name' => 'name'
                        )
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Free from quantity'),
                        'desc' => $this->l('Select minimal product quantity with free delivery enabled for that configuration (if user add selected here quantity then product delivery will become free for that product) default is 1'),
                        'lang' => false,
                        'name' => 'gen_free_quantity'
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Free from price'),
                        'desc' => $this->l('Range free from price, leave 0 to disable that option'),
                        'lang' => false,
                        'suffix' => $currency->sign,
                        'name' => 'gen_free_from_price'
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Free upto weight'),
                        'desc' => $this->l('Range free up to weight, leave 0 to disable that option'),
                        'lang' => false,
                        'suffix' => $weight_unit,
                        'name' => 'gen_free_upto_weight'
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Free from weight'),
                        'desc' => $this->l('Range free from weight, leave 0 to disable that option'),
                        'lang' => false,
                        'suffix' => $weight_unit,
                        'name' => 'gen_free_from_weight'
                    )
                ),

                'submit' => array(
                    'title' => $this->l('Generate configurations'),
                ),
            ),
        );

        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $lang = new Language((int)Configuration::get('PS_LANG_DEFAULT'));
        $helper->default_form_language = $lang->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
        $this->fields_form = array();

        $helper->identifier = $this->identifier;
        $helper->submit_action = 'generate_configs';
        $helper->currentIndex = self::$currentIndex;
        $helper->token = $this->token;
        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFieldsValuesGenerator(),
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id
        );

        return $helper->generateForm(array($fields_form_2));
    }

    public function getConfigFieldsValuesGenerator()
    {
        $all_shops = array();
        foreach (Shop::getShops(true) as $shop) {
            $all_shops[] = $shop['id_shop'];
        }

        $all_carriers = array();
        foreach (Carrier::getCarriers((int)$this->context->language->id, true, false, false, null, Carrier::PS_CARRIERS_AND_CARRIER_MODULES_NEED_RANGE) as $carrier) {
            $all_carriers[] = $carrier['id_carrier'];
        }

        $all_countries = array();
        foreach (Country::getCountries((int)$this->context->language->id, true, false, false) as $country) {
            $all_countries[] = $country['id_country'];
        }

        $all_groups = array();
        foreach (Group::getGroups((int)$this->context->language->id) as $group) {
            $all_groups[] = $group['id_group'];
        }
        $return = array();
        $return['gen_active'] = 1;
        $return['gen_id_country[]'] = $all_countries;
        $return['gen_id_carrier[]'] = $all_carriers;
        $return['gen_id_shop[]'] = $all_shops;
        $return['gen_id_group[]'] = $all_groups;
        $return['gen_free_mode'] = 1;
        $return['gen_free_quantity'] = 1;
        $return['gen_free_from_price'] = 0;
        $return['gen_free_from_weight'] = 0;
        $return['gen_free_upto_weight'] = 0;

        return $return;
    }

    public function getCombinations($arrays)
    {
        $result = array(array());
        foreach ($arrays as $property => $propertyValues) {
            $tmp = array();
            foreach ($result as $resultItem) {
                foreach ($propertyValues as $propertyValue) {
                    $tmp[] = array_merge($resultItem, array($property => $propertyValue));
                }
            }

            $result = $tmp;
        }
        return $result;
    }

    public function displayConfirmation($string)
    {
        $output = '
        <div class="bootstrap">
        <div class="module_confirmation conf confirm alert alert-success">
            <button type="button" class="close" data-dismiss="alert">&times;</button>
            '.$string.'
        </div>
        </div>';
        return  $this->content .= $output;
    }


    public function postProcess()
    {
        // Update GeoIp database
        if (Tools::isSubmit('update_geoip_db')) {
            $error = $this->module->downloadGeoIPData(true);
            if ($error == false) {
                $this->errors[] = $this->l('Problem with dowloading free GeoIP database from Maxmind LLC servers.');
            } else {
                $this->displayConfirmation($this->l('GeoIP database updated'));
            }
        }

        // Assign free delivery to products by params
        if (Tools::isSubmit('submitAssignSelected')) {
            $assign_id_shop = Tools::getValue('assign_id_shop');
            $assign_action = Tools::getValue('assign_action');
            $manufacturers_ids = Tools::getValue('assign_ids_manufacturer');
            $suppliers_ids = Tools::getValue('assign_ids_suppliers');
            $categories_ids = Tools::getValue('assign_ids_categories');


            if (!count($this->errors)) {
                $error = $this->module->assignFreeDeliveryToProducts($assign_id_shop, $categories_ids, $manufacturers_ids, $suppliers_ids, $assign_action);
                if ($error == false) {
                    $this->errors[] = $this->l('There is no products matching criteria selected or You don\'t select any criteria');
                } else {
                    $this->displayConfirmation($this->l('Free delivery to chosen products was assigned sucesfully'));
                }
            }
        }

        // Generate configurations by customer set parameters
        if (Tools::isSubmit('generate_configs')) {
            // Gererator values
            $active = Tools::getValue('gen_active');
            $shops = Tools::getValue('gen_id_shop');
            $countries = Tools::getValue('gen_id_country');
            $groups = Tools::getValue('gen_id_group');
            $carriers = Tools::getValue('gen_id_carrier');
            $free_mode = Tools::getValue('gen_free_mode');
            $free_quantity = Tools::getValue('gen_free_quantity');
            $free_from_price = Tools::getValue('gen_free_from_price');
            $free_from_weight = Tools::getValue('gen_free_from_weight');
            $free_upto_weight = Tools::getValue('gen_free_upto_weight');

            $configs = array(
                'id_country' => $countries,
                'id_carrier' => $carriers,
                'id_group' => $groups,
                'id_shop' => $shops
                );

            // Generate combinations
            $conf_combinations = $this->getCombinations($configs);

            if (count($conf_combinations)) {
                foreach ($conf_combinations as $cc) {
                    // Check if already exist combination of country, shop, group and carrier > because their need to be unique
                    $config_by_params_exist = $this->module->getFreeConfigByParams((int)$cc['id_country'], (int)$cc['id_shop'], (int)$cc['id_carrier'], (int)$cc['id_group']);

                    if ($config_by_params_exist) {
                        $this->errors[] = sprintf(
                            Tools::displayError($this->l('Free delivery configuration for that combination of country, carrier, shop, group alredy exist with ID%s, please select that one and edit it!')),
                            Tools::safeOutput($config_by_params_exist)
                        );
                    }

                    $object = new $this->className();
                    $object->active = (int)$active;
                    $object->id_shop = (int)$cc['id_shop'];
                    $object->id_carrier = (int)$cc['id_carrier'];
                    $object->id_country = (int)$cc['id_country'];
                    $object->id_group = (int)$cc['id_group'];
                    $object->free_mode = (int)$free_mode;
                    $object->free_quantity = (int)$free_quantity;
                    $object->free_from_price = (float)$free_from_price;
                    $object->free_from_weight = (float)$free_from_weight;
                    $object->free_upto_weight = (float)$free_upto_weight;
                    $object->date_add = date('Y-m-d H:i:s');
                    $object->date_upd = '0000-00-00 00:00:00';

                    if (!count($this->errors)) {
                        if (!$object->add()) {
                            $this->errors[] = Tools::displayError($this->l('An error occurred while creating an object.')).' <b>'.$this->table.' 
                            ('.Db::getInstance()->getMsgError().')</b>';
                        }
                    }
                }
            }

            $this->errors = array_unique($this->errors);
            if (!count($this->errors)) {
                $this->displayConfirmation($this->l('Configurations was generated sucesfully'));
            }
        }

        return parent::postProcess();
    }



    public function displayInstallationInfos()
    {
        $html = '';

        if ($this->ps_ver_16 || $this->ps_ver_17) {
            $html .= '<div class="form-horizontal clearfix"><fieldset class="panel">
                        <div class="panel-heading">
                            <i class="icon-cogs"></i> '.$this->l('Instruction how to add to products label with free delivery').'
                        </div>
                        <div class="form-wrapper">
                        <ul>
                            <li>'.$this->l('Free delivery label can be add to product-list.pl, product.tpl and any module tpl which is displaying products.').'</li>
                            <li>'.$this->l('To add label please copy and paste one line of code:').'</li>
                            <textarea rows="1">{hook h="displayFreeDeliveryLabel" product=$product}</textarea>
                            <li>'.$this->l('In most cases code is add in beetwen').' &lt;a&gt; &lt;/a&gt; '.$this->l('tag containing tag').' &lt;img&gt; '.$this->l('with product image, just paste it before opening tag').' &lt;img&gt;</li>
                            <li>'.$this->l('if You will have any problems with instaling label please contact with me at info@prestadev.pl i\'m more than happy to help You with it ').'</li>
                        <ul>
                
                        </div></fieldset></div>';
        } else {
            $html .= '<fieldset>
                        <legend>'.$this->l('Instruction how to add to products label with free delivery').'</legend>
                        
                            <p>
                            <ul style="list-style:disc; font-size:12px; padding-left:20px">
                                <li style="padding:4px 0">'.$this->l('Free delivery label can be add to product-list.pl, product.tpl and any module tpl which is displaying products.').'</li>
                                <li style="padding:4px 0">'.$this->l('To add label please copy and paste one line of code:').'</li>
                                <textarea style="padding:4px 0" rows="1" cols="55">{hook h="displayFreeDeliveryLabel" product=$product}</textarea>
                                <li style="padding:4px 0">'.$this->l('In most cases code is add in beetwen').' &lt;a&gt; &lt;/a&gt; '.$this->l('tag containing tag').' &lt;img&gt; '.$this->l('with product image, just paste it before opening tag').' &lt;img&gt;</li>
                                <li style="padding:4px 0">'.$this->l('if You will have any problems with instaling label please contact with me at info@prestadev.pl i\'m more than happy to help You with it ').'</li>
                            <ul>        
                            </p>
                            <div class="clear"></div>
                        </fieldset>';
        }
        return $html;
    }


    public function initPageHeaderToolbar()
    {
        if (empty($this->display)) {
            $this->page_header_toolbar_btn['new_configuration'] = array(
                'href' => self::$currentIndex.'&addpdfreedeliverypro&token='.$this->token,
                'desc' => $this->l('Add new configuration', null, null, false),
                'icon' => 'process-icon-new'
            );
        }

        parent::initPageHeaderToolbar();
    }

    public function renderForm()
    {
        if (!($obj = $this->loadObject(true))) {
            return;
        }

        $currency = new Currency((int)(Configuration::get('PS_CURRENCY_DEFAULT')));
        $weight_unit = Configuration::get('PS_WEIGHT_UNIT');

        // Switch or radio for ps 1.5 compatibility
        $switch = version_compare(_PS_VERSION_, '1.6.0', '>=') ? 'switch' : 'radio';

        $this->fields_form = array(
            'legend' => array(
                'title' => $this->l('New free delivery configuration'),
                'icon' => 'icon-user'
            ),
            'input' => array(
                    array(
                        'type' => $switch,
                        'label' => $this->l('Active'),
                        'name' => 'active',
                        'is_bool' => true,
                        'class' => 't',
                        'desc' => $this->l('Set if configuration should be active or not'),
                        'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => 1,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => 0,
                                'label' => $this->l('Disabled')
                            )
                        ),
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Free delivery mode'),
                        'desc' => $this->l('Type 1: makes whole cart free delivery if in cart is at least one product with free delivery enabled (optionaly we can use free from weight and free from price), Type 2: used to subtract free delivery enabled product weight / price from all cart products weight / price and that subtracted value is used for calculating delivery cost accordingly with ranges defined on that carrier, Type 3: used to subtract free delivery enabled products weight or price from cart total / weight or price used for calculating free from price or free from weight ranges in free delivery configuration on bottom of that page, Type 4: used to replace standard PrestaShop function free from price or free from weight with carrier, country, group, shop restrictions, Type 5: makes whole cart free delivery when free form price and free to weight ranges are used and in cart is at least one product with free delivery enabled'),
                        'name' => 'free_mode',
                        'options' => array(
                            'query' => array(
                                array(
                                'mode' => 1,
                                'name' => '1: '.$this->l('Free all products in cart')
                                ),
                                array(
                                'mode' => 2,
                                'name' => '2: '.$this->l('Substract free product weight / price (not use free form price or free from weight ranges)')
                                ),
                                array(
                                'mode' => 3,
                                'name' => '3: '.$this->l('Substract free product weight / price (when use free form price or free from weight ranges)')
                                ),
                                array(
                                'mode' => 4,
                                'name' => '4: '.$this->l('Use free form price or free from weight ranges (to replace standard PrestaShop options)')
                                ),
                                array(
                                'mode' => 5,
                                'name' => '5: '.$this->l('Free for all products in cart when using free from price and free up to weight')
                                )
                            ),
                            'id' => 'mode',
                            'name' => 'name'
                            )
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Select Shop'),
                        'name' => 'id_shop',
                        'desc' => $this->l('Select shop for that configuration'),
                        'multiple' => false,
                        'options' => array(
                            'query' => Shop::getShops(true),
                            'id' => 'id_shop',
                            'name' => 'name'
                        )
                    ),
                
                    array(
                        'type' => 'select',
                        'label' => $this->l('Carrier'),
                        'name' => 'id_carrier',
                        'desc' => $this->l('Select carrier for that configuration'),
                        'multiple' => false,
                        'options' => array(
                            'query' => Carrier::getCarriers((int)$this->context->language->id, true, false, false, null, Carrier::PS_CARRIERS_AND_CARRIER_MODULES_NEED_RANGE),
                            'id' => 'id_carrier',
                            'name' => 'name'
                        )
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Coutry'),
                        'name' => 'id_country',
                        'desc' => $this->l('Select country for that configuration'),
                        'multiple' => false,
                        'options' => array(
                            'query' => Country::getCountries((int)$this->context->language->id, true, false, false),
                            'id' => 'id_country',
                            'name' => 'name'
                        )
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Customer group'),
                        'name' => 'id_group',
                        'desc' => $this->l('Select customer group for that configuration'),
                        'multiple' => false,
                        'options' => array(
                            'query' => Group::getGroups((int)$this->context->language->id),
                            'id' => 'id_group',
                            'name' => 'name'
                        )
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Free from quantity'),
                        'desc' => $this->l('Select minimal product quantity with free delivery enabled for that configuration (if user add selected here quantity then product delivery will become free for that product) default is 1'),
                        'lang' => false,
                        'name' => 'free_quantity'
                    ),

                    array(
                        'type' => 'text',
                        'label' => $this->l('Free from price'),
                        'desc' => $this->l('Range free from price, leave 0 to disable that option'),
                        'lang' => false,
                        'suffix' => $currency->sign,
                        'name' => 'free_from_price'
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Free upto weight'),
                        'desc' => $this->l('Range free up to weight, leave 0 to disable that option'),
                        'lang' => false,
                        'suffix' => $weight_unit,
                        'name' => 'free_upto_weight'
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Free from weight'),
                        'desc' => $this->l('Range free from weight, leave 0 to disable that option'),
                        'lang' => false,
                        'suffix' => $weight_unit,
                        'name' => 'free_from_weight'
                    ),
            )
        );
       

        // Display this fields free_from_price / free_from_weight only in some free modes
        // if ($obj->free_mode == 2)
        // {
        //     unset($this->fields_form['input'][6],$this->fields_form['input'][7]);
        // }


        $this->fields_form['submit'] = array(
            'title' => $this->l('Save'),
            'icon' => 'process-icon-save',
            'class' => 'btn btn-default pull-right'
        );

        if (!($obj = $this->loadObject(true))) {
            return;
        }

        return parent::renderForm();
    }

    public function processAdd()
    {
        if (Tools::isSubmit('submitAddpdfreedeliverypro')) {
            $config_by_params_exist = $this->module->getFreeConfigByParams(Tools::getValue('id_country'), Tools::getValue('id_shop'), Tools::getValue('id_carrier'), Tools::getValue('id_group'));

            if ($config_by_params_exist) {
                $this->errors[] = sprintf(
                    Tools::displayError('Free delivery configuration for that combination of country, carrier, shop, custpomer group alredy exist with ID%s, please select that one and edit it!'),
                    Tools::safeOutput($config_by_params_exist)
                );
            }

            if (!count($this->errors)) {
                $object = new $this->className();
                $object->active = Tools::getValue('active');
                $object->id_shop = Tools::getValue('id_shop');
                $object->id_carrier = Tools::getValue('id_carrier');
                $object->id_country = Tools::getValue('id_country');
                $object->id_group = Tools::getValue('id_group');
                $object->free_mode = Tools::getValue('free_mode');
                $object->free_quantity = Tools::getValue('free_quantity');
                $object->free_from_price = Tools::getValue('free_from_price');
                $object->free_from_weight = Tools::getValue('free_from_weight');
                $object->free_upto_weight = Tools::getValue('free_upto_weight');
                $object->date_add = date('Y-m-d H:i:s');
                $object->date_upd = '0000-00-00 00:00:00';
                

                if (!$object->add()) {
                    $this->errors[] = Tools::displayError($this->l('An error occurred while creating an object.')).' <b>'.$this->table.' ('.Db::getInstance()->getMsgError().')</b>';
                }
            }

            $this->errors = array_unique($this->errors);
            
            if (!empty($this->errors)) {
                // if we have errors, we stay on the form instead of going back to the list
                $this->display = 'edit';
                return false;
            }
        }
    }

    public function processUpdate()
    {
        if (Tools::isSubmit('submitAddpdfreedeliverypro')) {
            $id_pdfreedeliverypro = (int)Tools::getValue('id_pdfreedeliverypro');

            $object = new $this->className($id_pdfreedeliverypro);
            $object->active = Tools::getValue('active');
            $object->id_shop = Tools::getValue('id_shop');
            $object->id_carrier = Tools::getValue('id_carrier');
            $object->id_country = Tools::getValue('id_country');
            $object->id_group = Tools::getValue('id_group');
            $object->free_mode = Tools::getValue('free_mode');
            $object->free_quantity = Tools::getValue('free_quantity');
            $object->free_from_price = Tools::getValue('free_from_price');
            $object->free_from_weight = Tools::getValue('free_from_weight');
            $object->free_upto_weight = Tools::getValue('free_upto_weight');

            $object->date_upd = date('Y-m-d H:i:s');

            if (!$object->update()) {
                $this->errors[] = Tools::displayError($this->l('An error occurred while updating an object.')).' <b>'.$this->table.' ('.Db::getInstance()->getMsgError().')</b>';
            }
        }
    
        $this->errors = array_unique($this->errors);
        
        if (!empty($this->errors)) {
            // if we have errors, we stay on the form instead of going back to the list
            $this->display = 'edit';
            return false;
        }
    }
}
