{**
*
* NOTICE OF LICENSE
*
*  @author    IntelliPresta <tehran.alishov@gmail.com>
*  @copyright 2019 IntelliPresta
*  @license   Commercial License
*/
*}

<div id="fader"></div>
<img id='spinner' src='{$module_dir|escape:'html'}views/img/spinner.svg' style="display:none" />

<div class="modal fade" id="emailModal3" role="dialog">
    <div class="modal-dialog">
        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><i class="icon icon-exclamation-triangle" style="color:orange;" aria-hidden="true"></i> {l s='Warning' mod='ordersexportpro'}</h4>
            </div>
            <div class="modal-body">
                <p>{l s='Seems connection lost.' mod='ordersexportpro'}</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">{l s='Close' mod='ordersexportpro'}</button>
            </div>
        </div>
    </div>
</div>

<div id="data_export">
    <form id="data_export_form" class="defaultForm form-horizontal AdminOrdersExport" action="" method="post" enctype="multipart/form-data" autocomplete="off" novalidate>
        {*        <input id="pdf_blank" type="hidden" name="pdf_blank" value="1" />*}
        <input type="hidden" id="orders_selectedColumns" name="orders_selectedColumns" value="" />
        <div class="panel" id="data_export_orders_panel">
            <div class="panel-heading">
                <i class="icon-credit-card" style="font-size:13px" aria-hidden="true"></i>
                {l s='Orders' mod='ordersexportpro'}
            </div>
            <div class="panel-body">
                <div class="form-wrapper">
                    <ul class="nav nav-tabs">
                        <li class="active"><a data-toggle="tab" href="#data_export_orders_general_settings">
                                <i class="icon icon-wrench"></i>
                                {l s='General Settings' mod='ordersexportpro'}</a></li>
                        <li><a data-toggle="tab" href="#data_export_orders_filter_data">
                                <i class="icon icon-filter"></i>
                                {l s='Data Filter' mod='ordersexportpro'}</a></li>
                        <li><a data-toggle="tab" href="#data_export_orders_filter_fields">
                                <i class="icon icon-sliders"></i>
                                {l s='Columns Filter' mod='ordersexportpro'}</a></li>
                        <li><a data-toggle="tab" href="#data_export_orders_save">
                                <i class="icon icon-save"></i>
                                {l s='Save' mod='ordersexportpro'}</a></li>
                        <li><a data-toggle="tab" href="#data_export_orders_autoexport">
                                <i class="icon icon-arrow-circle-o-right"></i>
                                {l s='Auto Export' mod='ordersexportpro'}</a></li>
                        <li><a data-toggle="tab" href="#data_export_orders_schedule">
                                <i class="icon icon-clock-o"></i>
                                {l s='Cron' mod='ordersexportpro'}</a></li>
                        <li><a data-toggle="tab" href="#data_export_orders_documentation">
                                <i class="icon icon-tags"></i>
                                {l s='Documentation' mod='ordersexportpro'}</a></li>
                        <li><a data-toggle="tab" href="#data_export_orders_support">
                                <i class="icon icon-support"></i>
                                {l s='Support' mod='ordersexportpro'}</a></li>
                    </ul>
                    <div class="tab-content">
                        <div id="data_export_orders_general_settings" class="tab-pane in active">
                            <div class="alert alert-info alert-dismissible fade in">
                                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                <span>{l s='Here you define main options of the document you will export.' mod='ordersexportpro'}</span>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-lg-3">
                                    <b>{l s='Export as ' mod='ordersexportpro'}</b>
                                </label>
                                <div class="col-lg-9">
                                    <div class="radio">
                                        <label><input type="radio" name="orders_export_as" value="excel" checked>{l s='Excel' mod='ordersexportpro'}</label>
                                    </div>
                                    <div class="radio">
                                        <label class="p1_5"><input type="radio" name="orders_export_as" value="csv">{l s='CSV' mod='ordersexportpro'}</label>
                                    </div>
                                    <div class="radio">
                                        <label class="p1_5"><input type="radio" name="orders_export_as" value="pdf">{l s='PDF' mod='ordersexportpro'}</label>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-lg-3 required">
                                    {l s='File name' mod='ordersexportpro'}
                                </label>
                                <div class="col-lg-3">
                                    <input type="text"
                                           name="orders_doc_name"
                                           id="data_export_orders_doc_name"
                                           value="{l s='Orders' mod='ordersexportpro'}"
                                           class="fixed-width-xxl"
                                           size="33"	
                                           required="required" />
                                    <p class="help-block">
                                        {l s='This is a name of the document you will download.' mod='ordersexportpro'}
                                    </p>
                                </div>
                            </div>
                            <div class="csv_options collapse">
                                <div class="form-group">
                                    <label class="control-label col-lg-3">
                                        <span class="label-tooltip" data-toggle="tooltip" title="" data-original-title="{l s='e.g. a,b,c or a;b;c or a   b   c' mod='ordersexportpro'}">
                                            {l s='CSV delimiter' mod='ordersexportpro'}
                                        </span>
                                    </label>
                                    <div class="col-lg-9">
                                        <select name="orders_csv_delimiter"
                                                class="fixed-width-xxl"
                                                id="data_export_orders_csv_delimiter">
                                            <option value=";">; {l s='(semicolon)' mod='ordersexportpro'}</option>
                                            <option value=",">, {l s='(colon)' mod='ordersexportpro'}</option>
                                            <option value="t">\t {l s='(tab)' mod='ordersexportpro'}</option>
                                        </select>
                                        <p class="help-block">
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="pdf_options collapse">
                                <div class="form-group">
                                    <label class="control-label col-lg-3">
                                        <span class="label-tooltip" data-toggle="tooltip" title="" data-original-title="{l s='Specify whether the export file should open in a new browser tab or download' mod='ordersexportpro'}">
                                            {l s='PDF action' mod='ordersexportpro'}
                                        </span>
                                    </label>
                                    <div class="col-lg-9">
                                        <select name="orders_pdf_action"
                                                class="fixed-width-xxl"
                                                id="data_export_orders_pdf_action">
                                            <option value="open">{l s='Open in a new tab' mod='ordersexportpro'}</option>
                                            <option value="download">{l s='Download' mod='ordersexportpro'}</option>
                                        </select>
                                        <p class="help-block">
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="pdf_options collapse">
                                <div class="form-group">
                                    <label class="control-label col-lg-3">
                                        {l s='PDF table style' mod='ordersexportpro'}
                                    </label>
                                    <div class="col-lg-9">
                                        <select name="orders_pdf_table_style"
                                                class="fixed-width-xxl"
                                                id="data_export_orders_pdf_table_style">
                                            <option value="striped">{l s='Striped' mod='ordersexportpro'}</option>
                                            <option value="simple">{l s='Simple' mod='ordersexportpro'}</option>
                                        </select>
                                        <p class="help-block">
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-lg-3">
                                    {l s='Language' mod='ordersexportpro'}
                                </label>
                                <div class="col-lg-3">
                                    <select name="orders_language"
                                            class="{if $languages|@count gt 10} chosen {/if} fixed-width-xxl"
                                            id="data_export_orders_language">
                                        {foreach from=$languages item=language}
                                            {if $lang_id neq $language.id_lang}
                                                <option value="{$language.id_lang|escape:'html'}">{$language.name|escape:'html'}</option>
                                            {else}
                                                <option selected value="{$language.id_lang|escape:'html'}">{$language.name|escape:'html'}</option>
                                            {/if}
                                        {/foreach}
                                    </select>
                                    <p class="help-block">
                                        {l s='The language of data (Headers may be excluded)' mod='ordersexportpro'}
                                    </p> 
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-lg-3">
                                    {l s='Each order in one line' mod='ordersexportpro'}
                                </label>
                                <div class="col-lg-9">
                                    <span class="switch prestashop-switch fixed-width-lg">
                                        <input type="radio" name="orders_merge" id="data_export_orders_merge" value="1"  checked="checked"/>
                                        <label for="data_export_orders_merge">{l s='Yes' mod='ordersexportpro'}</label>
                                        <input type="radio" name="orders_merge" id="data_export_orders_unmerge" value="0"/>
                                        <label for="data_export_orders_unmerge">{l s='No' mod='ordersexportpro'}</label>
                                        <a class="slide-button btn"></a>
                                    </span>
                                    <p class="help-block">
                                        {l s='This causes to merge the same rows of an order.' mod='ordersexportpro'}
                                    </p>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-lg-3">
                                    {l s='Sort By' mod='ordersexportpro'}
                                </label>
                                <div class="col-lg-3">
                                    <select name="orders_sort" {*multiple*}
                                            class="fixed-width-xxl"
                                            id="data_export_orders_sort">
                                    </select>
                                    <p class="help-block">
                                        {l s='Select a column' mod='ordersexportpro'}
                                    </p>
                                </div>
                                <div class="col-lg-5 col-lg-offset-1 data_export_sort_radio">
                                    <span class="switch prestashop-switch fixed-width-lg">
                                        <input type="radio" name="orders_sort_asc" id="data_export_orders_sort_asc" value="1" checked="checked"/>
                                        <label for="data_export_orders_sort_asc">{l s='ASC' mod='ordersexportpro'}</label>
                                        <input type="radio" name="orders_sort_asc" id="data_export_orders_sort_desc" value="0"/>
                                        <label for="data_export_orders_sort_desc">{l s='DESC' mod='ordersexportpro'}</label>
                                        <a class="slide-button btn"></a>
                                    </span>
                                    <p class="help-block">
                                        {l s='Ascending or descending' mod='ordersexportpro'}
                                    </p>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-lg-3">
                                    {l s='Date format' mod='ordersexportpro'}
                                </label>
                                <div class="col-lg-9">
                                    <select name="orders_date_format"
                                            class="fixed-width-xxl"
                                            id="data_export_orders_date_format">
                                        <option value="Y-m-d">yyyy-mm-dd (e.g. 2018-04-07)&lrm;</option>
                                        <option value="d/m/Y">dd/mm/yyyy (e.g. 07/04/2018)&lrm;</option>
                                        <option value="m/d/e">mm/dd/yyyy (e.g. 04/07/2018)&lrm;</option>
                                        <option value="d.m.Y">dd.mm.yyyy (e.g. 07.04.2018)&lrm;</option>
                                        <option value="e/c/Y">d/m/yyyy (e.g. 7/4/2018)&lrm;</option>
                                        <option value="c/e/Y">m/d/yyyy (e.g. 4/7/2018)&lrm;</option>
                                        <option value="e.c.Y">d.m.yyyy (e.g. 7.4.2018)&lrm;</option>
                                        <option value="e/c/y">d/m/yy (e.g. 7/4/18)&lrm;</option>
                                        <option value="c/e/Y">m/d/yy (e.g. 4/7/2018)&lrm;</option>
                                        <option value="e.c.y">d.m.yy (e.g. 7.4.18)&lrm;</option>
                                        <option value="d b Y">dd mmm yyyy (e.g. 07 Apr 2018)&lrm;</option>
                                        <option value="e b Y">d mmm yyyy (e.g. 7 Apr 2018)&lrm;</option>
                                        <option value="e b y">d mmm yy (e.g. 7 Apr 18)&lrm;</option>
                                        <option value="d M Y">dd mmmm yyyy (e.g. 07 April 2018)&lrm;</option>
                                        <option value="e M Y">d mmmm yyyy (e.g. 7 April 2018)&lrm;</option>
                                        <option value="e M y">d mmmm yy (e.g. 7 April 18)&lrm;</option>
                                    </select>
                                    <p class="help-block">
                                        {l s='The date in the sample is the 7th April, 2018.' mod='ordersexportpro'}
                                    </p>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-lg-3">
                                    {l s='Time format' mod='ordersexportpro'}
                                </label>
                                <div class="col-lg-9">
                                    <select name="orders_time_format"
                                            class="fixed-width-xxl"
                                            id="data_export_orders_time_format">
                                        <option value="H:i:s">HH:mm:ss (e.g. 09:23:51)&lrm;</option>
                                        <option value="k:i:s"> H:mm:ss (e.g. 9:23:51)&lrm;</option>
                                        <option value="h:i:s p"> hh:mm:ss (e.g. 09:23:51 AM)&lrm;</option>
                                        <option value="l:i:s p"> h:mm:ss (e.g. 9:23:51 AM)&lrm;</option>
                                    </select>
                                    <p class="help-block">
                                        {l s='The time in the sample is 9:23:51 morning.' mod='ordersexportpro'}
                                    </p>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-lg-3">
                                    {l s='Decimal symbol' mod='ordersexportpro'}
                                </label>
                                <div class="col-lg-9">
                                    <select name="orders_decimal_separator"
                                            class="fixed-width-lg"
                                            id="data_export_orders_decimal_separator">
                                        <option value="dot">. ({l s='Dot' mod='ordersexportpro'})</option>
                                        <option value="comma">, ({l s='Comma' mod='ordersexportpro'})</option>
                                    </select>
                                    <p class="help-block">
                                    </p>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-lg-3">
                                    {l s='Rounded fractional part' mod='ordersexportpro'}
                                </label>
                                <div class="col-lg-9">
                                    <select name="orders_round"
                                            class="fixed-width-lg"
                                            id="data_export_orders_round">
                                        <option value="-1">-</option>
                                        <option value="0">{l s='0 digit' mod='ordersexportpro'}</option>
                                        <option value="1">{l s='1 digit' mod='ordersexportpro'}</option>
                                        <option selected value="2">{l s='2 digits' mod='ordersexportpro'}</option>
                                        <option value="3">{l s='3 digits' mod='ordersexportpro'}</option>
                                        <option value="4">{l s='4 digits' mod='ordersexportpro'}</option>
                                    </select>
                                    <p class="help-block">
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div id="data_export_orders_filter_data" class="tab-pane">
                            <div class="alert alert-info alert-dismissible fade in">
                                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                <span>{l s='If all items of a group (e.g. Customers) are selected or deselected, they are not included in the filter.' mod='ordersexportpro'}</span>
                            </div>
                            <h3>{l s='Filter By Date' mod='ordersexportpro'}</h3>
                            <div class="form-group date_collapser">
                                <label class="control-label col-lg-3">
                                    {l s='Order Creation Date ' mod='ordersexportpro'}
                                </label>
                                <div class="col-lg-9">
                                    <select id="data_export_orders_creation_date" name="orders_creation_date" class="fixed-width-xl">
                                        <option value="no_date">{l s='--All time--' mod='ordersexportpro'}</option> 
                                        <option value="today">{l s='Today' mod='ordersexportpro'}</option> 
                                        <option value="yesterday">{l s='Yesterday' mod='ordersexportpro'}</option>
                                        <option value="this_week">{l s='This week' mod='ordersexportpro'}</option>
                                        <option value="last_week">{l s='Last week' mod='ordersexportpro'}</option>
                                        <option selected="selected" value="this_month">{l s='This month' mod='ordersexportpro'}</option>
                                        <option value="last_month">{l s='Last month' mod='ordersexportpro'}</option>
                                        <option value="select_date">{l s='Select date' mod='ordersexportpro'}</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group collapse">
                                <label class="control-label col-lg-3">
                                    {l s='Select a period ' mod='ordersexportpro'}
                                </label>
                                <div class="col-lg-9">
                                    <div class="col-lg-4">
                                        <div class="input-group fixed-width-xl">
                                            <span class="input-group-addon">
                                                <i class="icon-calendar"></i>
                                                {l s='From' mod='ordersexportpro'}
                                            </span>
                                            <input
                                                id="data_export_orders_from_date"
                                                name="orders_from_date"
                                                type="text"
                                                data-hex="true"
                                                class="datepicker"
                                                value="" />
                                        </div>
                                    </div>
                                    {*<div class="col-lg-2">
                                    </div>*}
                                    <div class="col-lg-4">
                                        <div class="input-group datepicker fixed-width-xl">
                                            <span class="input-group-addon">
                                                <i class="icon-calendar"></i>
                                                {l s='Till' mod='ordersexportpro'}
                                            </span>
                                            <input
                                                id="data_export_orders_to_date"
                                                name="orders_to_date"
                                                type="text"
                                                data-hex="true"
                                                class=""
                                                value="" />
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <br>
                            <br>

                            <hr>
                            <h3>{l s='Filter By Shop' mod='ordersexportpro'}</h3>
                            <select id="ctrl-show-selected-shops" name="ctrl-show-selected-shops" class="show_selected">
                                <option value="all" selected>{l s='Show all' mod='ordersexportpro'}</option>
                                <option value="selected">{l s='Show selected' mod='ordersexportpro'}</option>
                                <option value="not-selected">{l s='Show not selected' mod='ordersexportpro'}</option>
                            </select>
                            <br>
                            <table id="shops_table" class="table table-striped table-bordered" style="width:100%;table-layout: fixed;">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th>{l s='ID' mod='ordersexportpro'}</th>
                                        <th>{l s='Name' mod='ordersexportpro'}</th>
                                        <th>{l s='Group' mod='ordersexportpro'}</th>
                                    </tr>
                                </thead>
                            </table>
                            <br>
                            <br>
                            <br>


                            <hr>
                            <h3>{l s='Filter By Customer Group' mod='ordersexportpro'}</h3>
                            <div class="form-group">
                                <label class="control-label col-lg-3">
                                    <i>{l s='Without Group' mod='ordersexportpro'}</i>
                                </label>
                                <div class="col-lg-9">
                                    <span class="switch prestashop-switch fixed-width-lg">
                                        <input type="radio" name="orders_group_without" id="data_export_orders_group_yes_without" value="1" checked="checked"/>
                                        <label for="data_export_orders_group_yes_without">{l s='Yes' mod='ordersexportpro'}</label>
                                        <input type="radio" name="orders_group_without" id="data_export_orders_group_no_without" value="0"/>
                                        <label for="data_export_orders_group_no_without">{l s='No' mod='ordersexportpro'}</label>
                                        <a class="slide-button btn"></a>
                                    </span>
                                    <p class="help-block">
                                        {l s='Orders without group (if any)' mod='ordersexportpro'}
                                    </p>
                                </div>
                            </div>
                            <select id="ctrl-show-selected-groups" name="ctrl-show-selected-groups" class="show_selected">
                                <option value="all" selected>{l s='Show all' mod='ordersexportpro'}</option>
                                <option value="selected">{l s='Show selected' mod='ordersexportpro'}</option>
                                <option value="not-selected">{l s='Show not selected' mod='ordersexportpro'}</option>
                            </select>
                            <br>
                            <table id="groups_table" class="table table-striped table-bordered" style="width:100%;table-layout: fixed;">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th>{l s='ID' mod='ordersexportpro'}</th>
                                        <th>{l s='Name' mod='ordersexportpro'}</th>
                                        <th>{l s='Discount' mod='ordersexportpro'}</th>
                                        <th>{l s='Members' mod='ordersexportpro'}</th>
                                    </tr>
                                </thead>
                            </table>
                            <br>
                            <br>
                            <br>


                            <hr>
                            <h3>{l s='Filter By Customer' mod='ordersexportpro'}</h3>
                            <div class="form-group">
                                <label class="control-label col-lg-3">
                                    <i>{l s='Without Customer' mod='ordersexportpro'}</i>
                                </label>
                                <div class="col-lg-9">
                                    <span class="switch prestashop-switch fixed-width-lg">
                                        <input type="radio" name="orders_customer_without" id="data_export_orders_customer_yes_without" value="1" checked="checked"/>
                                        <label for="data_export_orders_customer_yes_without">{l s='Yes' mod='ordersexportpro'}</label>
                                        <input type="radio" name="orders_customer_without" id="data_export_orders_customer_no_without" value="0"/>
                                        <label for="data_export_orders_customer_no_without">{l s='No' mod='ordersexportpro'}</label>
                                        <a class="slide-button btn"></a>
                                    </span>
                                    <p class="help-block">
                                        {l s='Orders without customer (if any)' mod='ordersexportpro'}
                                    </p>
                                </div>
                            </div>
                            <select id="ctrl-show-selected-customers" name="ctrl-show-selected-customers" class="show_selected">
                                <option value="all" selected>{l s='Show all' mod='ordersexportpro'}</option>
                                <option value="selected">{l s='Show selected' mod='ordersexportpro'}</option>
                                <option value="not-selected">{l s='Show not selected' mod='ordersexportpro'}</option>
                            </select>
                            <br>
                            <table id="customers_table" class="table table-striped table-bordered" style="width:100%;table-layout: fixed;">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th>{l s='ID' mod='ordersexportpro'}</th>
                                        <th>{l s='First Name' mod='ordersexportpro'}</th>
                                        <th>{l s='Last Name' mod='ordersexportpro'}</th>
                                        <th>{l s='Email' mod='ordersexportpro'}</th>
                                    </tr>
                                </thead>
                            </table>
                            <br>
                            <br>
                            <br>


                            <hr>
                            <h3>{l s='Filter By Order State' mod='ordersexportpro'}</h3>
                            <select id="ctrl-show-selected-orderStates" name="ctrl-show-selected-orderStates" class="show_selected">
                                <option value="all" selected>{l s='Show all' mod='ordersexportpro'}</option>
                                <option value="selected">{l s='Show selected' mod='ordersexportpro'}</option>
                                <option value="not-selected">{l s='Show not selected' mod='ordersexportpro'}</option>
                            </select>
                            <br>
                            <table id="orderStates_table" class="table table-striped table-bordered" style="width:100%;table-layout: fixed;">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th>{l s='ID' mod='ordersexportpro'}</th>
                                        <th>{l s='Name' mod='ordersexportpro'}</th>
                                        <th>{l s='Icon' mod='ordersexportpro'}</th>
                                    </tr>
                                </thead>
                            </table>
                            <br>
                            <br>
                            <br>


                            <hr>
                            <h3>{l s='Filter By Payment Method' mod='ordersexportpro'}</h3>
                            <select id="ctrl-show-selected-paymentMethods" name="ctrl-show-selected-paymentMethods" class="show_selected">
                                <option value="all" selected>{l s='Show all' mod='ordersexportpro'}</option>
                                <option value="selected">{l s='Show selected' mod='ordersexportpro'}</option>
                                <option value="not-selected">{l s='Show not selected' mod='ordersexportpro'}</option>
                            </select>
                            <br>
                            <table id="paymentMethods_table" class="table table-striped table-bordered" style="width:100%;table-layout: fixed;">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th>{l s='ID' mod='ordersexportpro'}</th>
                                        <th>{l s='Logo' mod='ordersexportpro'}</th>
                                        <th>{l s='Name' mod='ordersexportpro'}</th>
                                        <th>{l s='Module Name' mod='ordersexportpro'}</th>
                                    </tr>
                                </thead>
                            </table>
                            <br>
                            <br>
                            <br>


                            <hr>
                            <h3>{l s='Filter By Carrier' mod='ordersexportpro'}</h3>
                            <div class="form-group">
                                <label class="control-label col-lg-3">
                                    <i>{l s='Without Carrier' mod='ordersexportpro'}</i>
                                </label>
                                <div class="col-lg-9">
                                    <span class="switch prestashop-switch fixed-width-lg">
                                        <input type="radio" name="orders_carrier_without" id="data_export_orders_carrier_yes_without" value="1" checked="checked"/>
                                        <label for="data_export_orders_carrier_yes_without">{l s='Yes' mod='ordersexportpro'}</label>
                                        <input type="radio" name="orders_carrier_without" id="data_export_orders_carrier_no_without" value="0"/>
                                        <label for="data_export_orders_carrier_no_without">{l s='No' mod='ordersexportpro'}</label>
                                        <a class="slide-button btn"></a>
                                    </span>
                                    <p class="help-block">
                                        {l s='Orders without carrier (if any)' mod='ordersexportpro'}
                                    </p>
                                </div>
                            </div>
                            <select id="ctrl-show-selected-carriers" name="ctrl-show-selected-carriers" class="show_selected">
                                <option value="all" selected>{l s='Show all' mod='ordersexportpro'}</option>
                                <option value="selected">{l s='Show selected' mod='ordersexportpro'}</option>
                                <option value="not-selected">{l s='Show not selected' mod='ordersexportpro'}</option>
                            </select>
                            <br>
                            <table id="carriers_table" class="table table-striped table-bordered" style="width:100%;table-layout: fixed;">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th>{l s='ID' mod='ordersexportpro'}</th>
                                        <th>{l s='Reference' mod='ordersexportpro'}</th>
                                        <th>{l s='Name' mod='ordersexportpro'}</th>
                                        <th>{l s='Logo' mod='ordersexportpro'}</th>
                                    </tr>
                                </thead>
                            </table>
                            <br>
                            <br>
                            <br>


                            <hr>
                            <h3>{l s='Filter By Manufacturer' mod='ordersexportpro'}</h3>
                            <div class="form-group">
                                <label class="control-label col-lg-3">
                                    <i>{l s='Without Manufacturer' mod='ordersexportpro'}</i>
                                </label>
                                <div class="col-lg-9">
                                    <span class="switch prestashop-switch fixed-width-lg">
                                        <input type="radio" name="orders_manufacturer_without" id="data_export_orders_manufacturer_yes_without" value="1" checked="checked"/>
                                        <label for="data_export_orders_manufacturer_yes_without">{l s='Yes' mod='ordersexportpro'}</label>
                                        <input type="radio" name="orders_manufacturer_without" id="data_export_orders_manufacturer_no_without" value="0"/>
                                        <label for="data_export_orders_manufacturer_no_without">{l s='No' mod='ordersexportpro'}</label>
                                        <a class="slide-button btn"></a>
                                    </span>
                                    <p class="help-block">
                                        {l s='Orders without manufacturer (if any)' mod='ordersexportpro'}
                                    </p>
                                </div>
                            </div>
                            <select id="ctrl-show-selected-manufacturers" name="ctrl-show-selected-manufacturers" class="show_selected">
                                <option value="all" selected>{l s='Show all' mod='ordersexportpro'}</option>
                                <option value="selected">{l s='Show selected' mod='ordersexportpro'}</option>
                                <option value="not-selected">{l s='Show not selected' mod='ordersexportpro'}</option>
                            </select>
                            <br>
                            <table id="manufacturers_table" class="table table-striped table-bordered" style="width:100%;table-layout: fixed;">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th>{l s='ID' mod='ordersexportpro'}</th>
                                        <th>{l s='Logo' mod='ordersexportpro'}</th>
                                        <th>{l s='Name' mod='ordersexportpro'}</th>
                                    </tr>
                                </thead>
                            </table>
                            <br>
                            <br>
                            <br>


                            <hr>
                            <h3>{l s='Filter By Supplier' mod='ordersexportpro'}</h3>
                            <div class="form-group">
                                <label class="control-label col-lg-3">
                                    <i>{l s='Without Supplier' mod='ordersexportpro'}</i>
                                </label>
                                <div class="col-lg-9">
                                    <span class="switch prestashop-switch fixed-width-lg">
                                        <input type="radio" name="orders_supplier_without" id="data_export_orders_supplier_yes_without" value="1" checked="checked"/>
                                        <label for="data_export_orders_supplier_yes_without">{l s='Yes' mod='ordersexportpro'}</label>
                                        <input type="radio" name="orders_supplier_without" id="data_export_orders_supplier_no_without" value="0"/>
                                        <label for="data_export_orders_supplier_no_without">{l s='No' mod='ordersexportpro'}</label>
                                        <a class="slide-button btn"></a>
                                    </span>
                                    <p class="help-block">
                                        {l s='Orders without supplier (if any)' mod='ordersexportpro'}
                                    </p>
                                </div>
                            </div>
                            <select id="ctrl-show-selected-suppliers" name="ctrl-show-selected-suppliers" class="show_selected">
                                <option value="all" selected>{l s='Show all' mod='ordersexportpro'}</option>
                                <option value="selected">{l s='Show selected' mod='ordersexportpro'}</option>
                                <option value="not-selected">{l s='Show not selected' mod='ordersexportpro'}</option>
                            </select>
                            <br>
                            <table id="suppliers_table" class="table table-striped table-bordered" style="width:100%;table-layout: fixed;">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th>{l s='ID' mod='ordersexportpro'}</th>
                                        <th>{l s='Logo' mod='ordersexportpro'}</th>
                                        <th>{l s='Name' mod='ordersexportpro'}</th>
                                    </tr>
                                </thead>
                            </table>
                            <br>
                            <br>
                            <br>


                            <hr>
                            <h3>{l s='Filter By Currency' mod='ordersexportpro'}</h3>
                            <select id="ctrl-show-selected-currencies" name="ctrl-show-selected-currencies" class="show_selected">
                                <option value="all" selected>{l s='Show all' mod='ordersexportpro'}</option>
                                <option value="selected">{l s='Show selected' mod='ordersexportpro'}</option>
                                <option value="not-selected">{l s='Show not selected' mod='ordersexportpro'}</option>
                            </select>
                            <br>
                            <table id="currencies_table" class="table table-striped table-bordered" style="width:100%;table-layout: fixed;">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th>{l s='ID' mod='ordersexportpro'}</th>
                                        <th>{l s='Name' mod='ordersexportpro'}</th>
                                        <th>{l s='ISO Code' mod='ordersexportpro'}</th>
                                    </tr>
                                </thead>
                            </table>
                            <br>
                            <br>
                            <br>
                        </div>
                        <div id="data_export_orders_filter_fields" class="tab-pane data_export_filter_fields">
                            <div class="alert alert-info alert-dismissible fade in order">
                                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                {l s='Here you define the columns of an order.' mod='ordersexportpro'}
                            </div>
                            <div class="alert alert-info alert-dismissible fade in product hidden">
                                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                {l s='Here you define the columns of the products in an order.' mod='ordersexportpro'}
                            </div>
                            <div class="alert alert-info alert-dismissible fade in payment hidden">
                                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                {l s='Here you define the columns of the payment of an order.' mod='ordersexportpro'}
                            </div>
                            <div class="alert alert-info alert-dismissible fade in customer hidden">
                                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                {l s='Here you define the columns of the customer who has placed an order.' mod='ordersexportpro'}
                            </div>
                            <div class="alert alert-info alert-dismissible fade in carrier hidden">
                                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                {l s='Here you define the columns of the carrier of an order.' mod='ordersexportpro'}
                            </div>
                            <div class="alert alert-info alert-dismissible fade in address hidden">
                                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                {l s='Here you define the columns of the shipping or the invoice address of an order.' mod='ordersexportpro'}
                            </div>
                            <div class="alert alert-info alert-dismissible fade in shop hidden">
                                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                {l s='Here you define the columns of the shop where an order has been placed.' mod='ordersexportpro'}
                            </div>
                            <div class="row">
                                <div class="list-group col-xs-4 col-md-3">
                                    <fieldset>
                                        <legend>{l s='Select a group to filter its fields:' mod='ordersexportpro'}&nbsp;</legend>
                                        <div id="orders_columns_group" class="columns_group">
                                            <a href="#" id="orders_filter_fields_order" class="list-group-item list-group-item-action active">{l s='Order' mod='ordersexportpro'}
                                                <span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span>
                                                <span class="badge">0</span>
                                            </a>
                                            <a href="#" id="orders_filter_fields_product" class="list-group-item list-group-item-action">{l s='Product' mod='ordersexportpro'}
                                                <span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span>
                                                <span class="badge">0</span>
                                            </a>
                                            <a href="#" id="orders_filter_fields_payment" class="list-group-item list-group-item-action">{l s='Payment' mod='ordersexportpro'}
                                                <span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span>
                                                <span class="badge">0</span>
                                            </a>
                                            <a href="#" id="orders_filter_fields_customer" class="list-group-item list-group-item-action">{l s='Customer' mod='ordersexportpro'}
                                                <span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span>
                                                <span class="badge">0</span>
                                            </a>
                                            <a href="#" id="orders_filter_fields_carrier" class="list-group-item list-group-item-action">{l s='Carrier' mod='ordersexportpro'}
                                                <span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span>
                                                <span class="badge">0</span>
                                            </a>
                                            <a href="#" id="orders_filter_fields_address" class="list-group-item list-group-item-action">{l s='Address' mod='ordersexportpro'}
                                                <span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span>
                                                <span class="badge">0</span>
                                            </a>
                                            <a href="#" id="orders_filter_fields_shop" class="list-group-item list-group-item-action">{l s='Shop' mod='ordersexportpro'}
                                                <span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span>
                                                <span class="badge">0</span>
                                            </a>
                                        </div>
                                    </fieldset>
                                </div>
                                <fieldset class="col-xs-7 pull-right">
                                    <legend>{l s='Order columns:' mod='ordersexportpro'}&nbsp;</legend>
                                    <div class="row" id="columns_header">
                                        <button id="data_export_orders_select_all_columns" class="btn btn-default data_export_select_all_columns column_button"><i class="icon-check-square-o"></i> {l s='Select all' mod='ordersexportpro'}</button>&nbsp;&nbsp;
                                        <button id="data_export_orders_reset_columns" class="btn btn-default data_export_reset_columns  column_button" href="#" data-value="0">{l s='Reset' mod='ordersexportpro'}</button>&nbsp;&nbsp;
                                        <button id="data_export_orders_show_all" class="btn btn-default data_export_show_all  column_button" href="#" data-value="1">{l s='Show selected' mod='ordersexportpro'}</button>&nbsp;&nbsp;
                                        <input id="columns_search" type="search" placeholder="{l s='Search...' mod='ordersexportpro'}" class="pull-right" />
                                    </div>
                                    {*<p>
                                    <a id="data_export_orders_select_all_columns" class="data_export_select_all_columns" href="#"><b><i class="icon-check-square-o"></i> {l s='Select all' mod='ordersexportpro'}</b></a>
                                    <a id="data_export_orders_show_all" class="pull-right data_export_show_all" href="#" data-value="0"><b>{l s='Show all' mod='ordersexportpro'}</b></a>
                                    <a id="data_export_orders_reset_columns" class="pull-right data_export_reset_columns" href="#" data-value="0"><b>{l s='Reset' mod='ordersexportpro'}</b></a>
                                    </p>*}
                                    <div id="data_export_orders_scroll_colunms" class="scrollable">
                                        <ul id="data_export_orders_order_columns" class="list-group item-list data_export_columns">
                                            <!-- 3 fileds are unavailable: 1) total_products_wt, 2) round_mode, 3) round_type -->
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="id_order"></i> {l s='Order ID' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="reference"></i> {l s='Order Reference' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="new_client"></i> {l s='New Client' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="id_cart"></i> {l s='Cart ID' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="id_lang"></i> {l s='Language ID' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="lang.name"></i> {l s='Language' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item absent"><i class="icon-check-square-o" data-value="order_state.name"></i> {l s='Current State' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="secure_key"></i> {l s='Secure Key' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="payment"></i> {l s='Payment Method' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="conversion_rate"></i> {l s='Conversion Rate' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="order_messages.message"></i> {l s='Order Messages' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="module"></i> {l s='Module' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="recyclable"></i> {l s='Recyclable' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="gift"></i> {l s='Gift' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="gift_message"></i> {l s='Gift Message' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="total_discounts"></i> {l s='Total Discounts' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="total_discounts_tax_incl"></i> {l s='Total Discounts (Tax included)' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="total_discounts_tax_excl"></i> {l s='Total Discounts (Tax excluded)' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="total_paid"></i> {l s='Total Paid' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="total_paid_tax_incl"></i> {l s='Total Paid (Tax included)' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="total_paid_tax_excl"></i> {l s='Total Paid (Tax excluded)' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="total_paid_real"></i> {l s='Total Really Paid' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="total_products_wt"></i> {l s='Total Products Price' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="total_products"></i> {l s='Total Products Price (Tax excluded)' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="total_shipping"></i> {l s='Total Shipping' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="total_shipping_tax_incl"></i> {l s='Total Shipping (Tax included)' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="total_shipping_tax_excl"></i> {l s='Total Shipping (Tax excluded)' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="carrier_tax_rate"></i> {l s='Carrier Tax Rate' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="total_wrapping"></i> {l s='Total Wrapping' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="total_wrapping_tax_incl"></i> {l s='Total Wrapping (Tax included)' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="total_Wrapping_tax_excl"></i> {l s='Total Wrapping (Tax excluded)' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="invoice_number"></i> {l s='Invoice Number' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="delivery_number"></i> {l s='Delivery Number' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="invoice_date"></i> {l s='Invoice Date' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="delivery_date"></i> {l s='Delivery Date' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="valid"></i> {l s='Valid' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="date_add"></i> {l s='Order Creation Date' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="date_upd"></i> {l s='Order Update Date' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                        </ul>
                                        <ul id="data_export_orders_product_columns" class="list-group item-list data_export_columns hidden">
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="product_id"></i> {l s='Product ID' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="prod.reference"></i> {l s='Product Reference' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="order_detail_lang.product_name"></i> {l s='Product Name' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item absent"><i class="icon-check-square-o" data-value="product_image"></i> {l s='Product Image' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="prod_customs.customs"></i> {l s='Product Customizations' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="product_name"></i> {l s='Product Details' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="cl.id_category"></i> {l s='Default Category ID' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="cl.name"></i> {l s='Default Category Name' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="product_attribute_id"></i> {l s='Product Attribute ID' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="order_detail_lang.attributes"></i> {l s='Product Attributes' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item absent"><i class="icon-check-square-o" data-value="attribute_image"></i> {l s='Attribute Image' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="attrib_customs.customs"></i> {l s='Attribute Customizations' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="product_features.features"></i> {l s='Product Features' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="product_quantity"></i> {l s='Product Quantity' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="product_quantity_in_stock"></i> {l s='Product Quantity In Stock' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="product_quantity_refunded"></i> {l s='Product Quantity Refunded' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="product_quantity_return"></i> {l s='Product Quantity Returned' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="product_quantity_reinjected"></i> {l s='Product Quantity Reinjected' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="product_price"></i> {l s='Product Price' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="total_price_tax_incl"></i> {l s='Total Price (Tax included)' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="total_price_tax_excl"></i> {l s='Total Price (Tax excluded)' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="prod.unit_price_ratio"></i> {l s='Price per Unit' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="prod.unity"></i> {l s='Unity' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="unit_price_tax_incl"></i> {l s='Unit Price (Tax included)' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="unit_price_tax_excl"></i> {l s='Unit Price (Tax excluded)' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="total_shipping_price_tax_incl"></i> {l s='Total Shipping Price (Tax included)' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="total_shipping_price_tax_excl"></i> {l s='Total Shipping Price (Tax excluded)' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="purchase_supplier_price"></i> {l s='Purchase Price from Supplier' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="original_product_price"></i> {l s='Original Product Price' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                                {if $show_orijinal_wholesale_price gt -1}
                                                <li class="list-group-item advanced"><i class="icon-square-o" data-value="original_wholesale_price"></i> {l s='Original Wholesale Price' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                                {/if}
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="manufacturer.name"></i> {l s='Manufacturer Name' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="supplier.name"></i> {l s='Supplier Name' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="reduction_percent"></i> {l s='Reduction Percent' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="reduction_amount"></i> {l s='Reduction Amount' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="reduction_amount_tax_incl"></i> {l s='Reduction Amount (Tax included)' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="reduction_amount_tax_excl"></i> {l s='Reduction Amount (Tax excluded)' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="group_reduction"></i> {l s='Group Reduction' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="product_quantity_discount"></i> {l s='Product Quantity Discount' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="product_ean13"></i> {l s='Product EAN-13' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="product_upc"></i> {l s='Product UPC' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="product_reference"></i> {l s='Product Reference' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="product_supplier_reference"></i> {l s='Product Supplier Reference' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="product_weight"></i> {l s='Product Weight' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                                {if $show_id_tax_rule_group gt -1}
                                                <li class="list-group-item advanced"><i class="icon-square-o" data-value="id_tax_rules_group"></i> {l s='Tax Rules Group ID' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                                <li class="list-group-item"><i class="icon-check-square-o" data-value="tax_rules_group.name"></i> {l s='Tax Rules Group Name' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                                {/if}
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="tax_computation_method"></i> {l s='Tax Computation Method' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="order_details_tax.id_tax"></i> {l s='Tax ID' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="tax_name"></i> {l s='Tax Name (for older versions)' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="tax_rate"></i> {l s='Tax Rate (for older versions)' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="order_details_tax.name"></i> {l s='Tax Name' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="order_details_tax.rate"></i> {l s='Tax Rate' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="order_details_tax.unit_amount_tax"></i> {l s='Tax of Unit Amount' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="order_details_tax.total_amount_tax"></i> {l s='Tax of Total Amount' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="ecotax"></i> {l s='Ecotax' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="ecotax_tax_rate"></i> {l s='Ecotax Tax Rate' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="discount_quantity_applied"></i> {l s='Discount Quantity Applied' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="download_hash"></i> {l s='Download Hash' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="download_nb"></i> {l s='Number of Downloads' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="download_deadline"></i> {l s='Download Deadline' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                        </ul>
                                        <ul id="data_export_orders_payment_columns" class="list-group item-list data_export_columns hidden">
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="id_order_payment"></i> {l s='Payment ID' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="id_currency"></i> {l s='Currency ID' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item absent"><i class="icon-check-square-o" data-value="currency_name"></i> {l s='Currency Name' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="amount"></i> {l s='Total Payment Amount' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="detailed_amnt"></i> {l s='Payment Amount' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="payment_dt_add"></i> {l s='Payment Date' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                                {*<li class="list-group-item"><i class="icon-check-square-o" data-value="payment_method"></i> Payment Method<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>*}
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="transaction_id"></i> {l s='Transaction ID' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="card_number"></i> {l s='Card Number' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="card_brand"></i> {l s='Card Brand' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="card_expiration"></i> {l s='Card Expiration Date' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="card_holder"></i> {l s='Card Holder' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                        </ul>
                                        <ul id="data_export_orders_customer_columns" class="list-group item-list data_export_columns hidden">
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="id_customer"></i> {l s='Customer ID' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="email"></i> {l s='Customer Email' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="gender_lang.name"></i> {l s='Customer Gender' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li> 
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="firstname"></i> {l s='Customer Firstname' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="lastname"></i> {l s='Customer Lastname' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="def_group.id_group"></i> {l s='Default Group ID' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="def_group.name"></i> {l s='Default Group Name' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="groupp.group_ids"></i> {l s='Group IDs' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="groupp.group_names"></i> {l s='Group Names' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="birthday"></i> {l s='Customer Birthday' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="date_add"></i> {l s='Customer Registration Date' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="newsletter_date_add"></i> {l s='Date Subscribed to Newsletter' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                        </ul>
                                        <ul id="data_export_orders_carrier_columns" class="list-group item-list data_export_columns hidden">
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="id_carrier"></i> {l s='Carrier ID' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="carrier_name.name"></i> {l s='Carrier Name' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="weight"></i> {l s='Weight (total)' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="tracking_number"></i> {l s='Tracking Number' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="date_add"></i> {l s='Carrier Creation Date' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                        </ul>
                                        <ul id="data_export_orders_address_columns" class="list-group item-list data_export_columns hidden">
                                            <li class="list-group-item advanced absent"><i class="icon-square-o" data-value="order.id_address_invoice"></i> {l s='Invoice Address ID' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="address_invoice.firstname"></i> {l s='Invoice Address Firstname' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="address_invoice.lastname"></i> {l s='Invoice Address Lastname' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="address_invoice.alias"></i> {l s='Invoice Address Alias' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced absent"><i class="icon-square-o" data-value="invoice_country_lang.name"></i> {l s='Invoice Address Country' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced absent"><i class="icon-square-o" data-value="invoice_state.name"></i> {l s='Invoice Address State' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="address_invoice.city"></i> {l s='Invoice Address City' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="address_invoice.address1"></i> {l s='Invoice Address 1' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="address_invoice.address2"></i> {l s='Invoice Address 2' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="address_invoice.postcode"></i> {l s='Invoice Address Postcode' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="address_invoice.company"></i> {l s='Invoice Address Company' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="address_invoice.vat_number"></i> {l s='Invoice Address VAT Number' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="address_invoice.dni"></i> {l s='Invoice Address DNI' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="address_invoice.phone"></i> {l s='Invoice Address Phone' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="address_invoice.phone_mobile"></i> {l s='Invoice Address Mobile Phone' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced absent"><i class="icon-square-o" data-value="order.id_address_delivery"></i> {l s='Delivery Address ID' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="address_delivery.firstname"></i> {l s='Delivery Address Firstname' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="address_delivery.lastname"></i> {l s='Delivery Address Lastname' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="address_delivery.alias"></i> {l s='Delivery Address Alias' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced absent"><i class="icon-square-o" data-value="delivery_country_lang.name"></i> {l s='Delivery Country' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced absent"><i class="icon-square-o" data-value="delivery_state.name"></i> {l s='Delivery State' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="address_delivery.city"></i> {l s='Delivery City' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="address_delivery.address1"></i> {l s='Delivery Address 1' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="address_delivery.address2"></i> {l s='Delivery Address 2' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="address_delivery.postcode"></i> {l s='Delivery Address Postcode' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="address_delivery.company"></i> {l s='Delivery Address Company' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="address_delivery.vat_number"></i> {l s='Delivery Address VAT Number' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="address_delivery.dni"></i> {l s='Delivery Address DNI' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="address_delivery.phone"></i> {l s='Delivery Address Phone' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="address_delivery.phone_mobile"></i> {l s='Delivery Address Mobile Phone' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                        </ul>
                                        <ul id="data_export_orders_shop_columns" class="list-group item-list data_export_columns hidden">
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="id_shop"></i> {l s='Shop ID' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item"><i class="icon-check-square-o" data-value="name"></i> {l s='Shop Name' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced"><i class="icon-square-o" data-value="id_shop_group"></i> {l s='Shop Group ID' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                            <li class="list-group-item advanced absent"><i class="icon-square-o" data-value="shop_group.name"></i> {l s='Shop Group Name' mod='ordersexportpro'}<span class="pull-right ui-icon ui-icon-arrowthick-2-n-s"></span></li>
                                        </ul>
                                    </div>
                                </fieldset>   
                            </div>
                        </div>
                        <div id="data_export_orders_save" class="tab-pane">
                            <div class="alert alert-info alert-dismissible fade in">
                                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                <span>{l s='Here you can save the configurations you set in the previous tabs.' mod='ordersexportpro'}</span>
                            </div>
                            <h3>{l s='Save Selected Settings:' mod='ordersexportpro'}</h3>
                            <div id="notification" style="display:none;"></div>
                            <div class="row">
                                <div class="form-group">
                                    <label class="control-label col-sm-5 col-md-3 required">
                                        {l s='Name of the settings' mod='ordersexportpro'}
                                    </label>
                                    <div class=" col-sm-5 col-md-3">
                                        <input type="text"
                                               autocomplete="no"
                                               id="data_export_orders_settings_name"
                                               value=""
                                               class=""
                                               size="33"	
                                               required="required" />
                                    </div>
                                    <div class="col-sm-2 col-md-1">
                                        <button class="data_export_form_save_btn btn btn-default">
                                            <i class="process-icon-save"></i> {l s='Save' mod='ordersexportpro'}
                                        </button>
                                    </div>
                                </div>
                                <hr />
                                <h3>{l s='Apply from saved settings:' mod='ordersexportpro'}</h3>
                                <ul id="configs" class="list-group col-xs-8 col-md-6 scrollable">
                                    {foreach from=$configs item=config}
                                        <li data-id="{$config.id_orders_export_pro|escape:'html'}" data-name="{$config.name|escape:'html'}" data-config='{$config.configuration|escape:'html'}' data-datatables='{$config.datatables|escape:'html'}' class="list-group-item"><b>{$config.name|escape:'html'}</b>
                                            <span class="pull-right">
                                                <input type="button" class="btn btn-default apply_config" value="{l s='Apply' mod='ordersexportpro'}"> | 
                                                <i title="{$config.title|escape:'html'}" class="icon-trash" style="color:#c50000" aria-hidden="true"></i>
                                            </span>
                                        </li>
                                    {/foreach}
                                    {if $configs|@count eq 0}
                                        <span style="color: #999;"><i class="icon-warning-sign"></i> {l s='No saved setting' mod='ordersexportpro'}</span>
                                    {/if}
                                </ul>
                                <div class="col-md-6">
                                    <button id="data_export_orders_reset_settings" class="btn btn-default pull-right"><i class="icon-refresh"></i>
                                        {l s='Reset Settings' mod='ordersexportpro'}
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div id="data_export_orders_autoexport" class="tab-pane">
                            <div class="alert alert-info alert-dismissible fade in">
                                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                <span>{l s='When there is a new order, it will be sent (with attachment) to the emails provided below.' mod='ordersexportpro'}</span>
                            </div>
                            <div id="notification2" style="display:none;"></div>
                            <div class="form-group">
                                <label class="control-label col-lg-3">
                                    {l s='Enable AutoExport' mod='ordersexportpro'}
                                </label>
                                <div class="col-lg-9">
                                    <span class="switch prestashop-switch fixed-width-lg">
                                        <input type="radio" name="orders_autoexport" id="data_export_orders_autoexport_yes" value="1" {if $autoexport_enabled eq '1'} checked="checked"{/if} />
                                        <label for="data_export_orders_autoexport_yes">{l s='Yes' mod='ordersexportpro'}</label>
                                        <input type="radio" name="orders_autoexport" id="data_export_orders_autoexport_no" value="0" {if $autoexport_enabled ne '1'} checked="checked"{/if}  />
                                        <label for="data_export_orders_autoexport_no">{l s='No' mod='ordersexportpro'}</label>
                                        <a class="slide-button btn"></a>
                                    </span>
                                    <p class="help-block">
                                    </p>
                                    <br />
                                </div>
                            </div>
                            <div class="auto-export collapse {if $autoexport_enabled eq '1'} in {/if} ">
                                {*<div class="form-group">
                                <label class="col-lg-3 col-lg-offset-3">
                                {l s='Send the exported file' mod='ordersexportpro'}
                                </label>
                                </div>*}
                                <div class="form-group">
                                    <label class="control-label col-lg-3">
                                        {l s='By Email' mod='ordersexportpro'}
                                    </label>
                                    <div class="col-lg-9">
                                        <span class="switch prestashop-switch fixed-width-lg">
                                            <input type="radio" name="orders_autoexport_use_email" id="data_export_orders_autoexport_use_email_yes" value="1" {if $autoexport_email_enabled eq '1'} checked="checked"{/if} />
                                            <label for="data_export_orders_autoexport_use_email_yes">{l s='Yes' mod='ordersexportpro'}</label>
                                            <input type="radio" name="orders_autoexport_use_email" id="data_export_orders_autoexport_use_email_no" value="0" {if $autoexport_email_enabled ne '1'} checked="checked"{/if} />
                                            <label for="data_export_orders_autoexport_use_email_no">{l s='No' mod='ordersexportpro'}</label>
                                            <a class="slide-button btn"></a>
                                        </span>
                                        {*<p class="help-block">
                                        </p>*}
                                    </div>
                                </div>
                                <div class="auto-export-email collapse {if $autoexport_email_enabled eq '1'} in {/if} ">

                                    <div class="form-group">
                                        <label class="control-label col-lg-3">
                                            <span class="label-tooltip" data-toggle="tooltip" title="" data-original-title="{l s='Destination emails that file will be sent' mod='ordersexportpro'}">
                                                {l s='Receiver Emails' mod='ordersexportpro'}
                                            </span>
                                        </label>
                                        <div class="col-lg-9">
                                            <input type="text"
                                                   id="data_export_orders_autoexport_to_emails"
                                                   value="{$autoexport_to_emails|escape:'html'}"
                                                   class=""
                                                   size="33" />
                                            <p class="help-block">
                                                {l s='Type an email and' mod='ordersexportpro'}
                                                <b style="color:#555;">{l s='hit Enter' mod='ordersexportpro'}</b>
                                                {l s='or' mod='ordersexportpro'}
                                                <b style="color:#555;">{l s='Spacebar' mod='ordersexportpro'}</b>
                                            </p>
                                        </div>
                                    </div>

                                </div>
                                <br>
                                <div class="form-group">
                                    <label class="control-label col-lg-3">
                                        {l s='By FTP' mod='ordersexportpro'}
                                    </label>
                                    <div class="col-lg-9">
                                        <span class="switch prestashop-switch fixed-width-lg">
                                            <input type="radio" name="orders_autoexport_use_ftp" id="data_export_orders_autoexport_use_ftp_yes" value="1" {if $autoexport_ftp_enabled eq '1'} checked="checked" {/if} />
                                            <label for="data_export_orders_autoexport_use_ftp_yes">{l s='Yes' mod='ordersexportpro'}</label>
                                            <input type="radio" name="orders_autoexport_use_ftp" id="data_export_orders_autoexport_use_ftp_no" value="0" {if $autoexport_ftp_enabled ne '1'} checked="checked" {/if} />
                                            <label for="data_export_orders_autoexport_use_ftp_no">{l s='No' mod='ordersexportpro'}</label>
                                            <a class="slide-button btn"></a>
                                        </span>
                                        {*<p class="help-block">
                                        </p>*}
                                    </div>
                                </div>
                                <div class="auto-export-ftp collapse {if $autoexport_ftp_enabled eq '1'} in {/if}">
                                    <div class="form-group">
                                        <label class="control-label col-lg-3">
                                            {l s='FTP Type' mod='ordersexportpro'}
                                        </label>
                                        <div class="col-lg-9">
                                            <span class="switch prestashop-switch fixed-width-lg">
                                                <input type="radio" name="orders_autoexport_ftp_type" id="data_export_orders_autoexport_ftp_type_sftp" value="sftp" {if $autoexport_ftp_type eq 'sftp'} checked="checked" {/if} />
                                                <label for="data_export_orders_autoexport_ftp_type_sftp">{l s='SFTP' mod='ordersexportpro'}</label>
                                                <input type="radio" name="orders_autoexport_ftp_type" id="data_export_orders_autoexport_ftp_type_ftp" value="ftp" {if $autoexport_ftp_type ne 'sftp'} checked="checked" {/if} />
                                                <label for="data_export_orders_autoexport_ftp_type_ftp">{l s='FTP' mod='ordersexportpro'}</label>
                                                <a class="slide-button btn"></a>
                                            </span>
                                            {*<p class="help-block">
                                            </p>*}
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label col-lg-3 required">
                                            <span class="label-tooltip" data-toggle="tooltip" title="" data-original-title="{l s='Domain name or IP address' mod='ordersexportpro'}">
                                                {l s='FTP URL' mod='ordersexportpro'}
                                            </span>
                                        </label>
                                        <div class="col-lg-3">
                                            <div class="input-group fixed-width-xxl">
                                                <span class="input-group-addon">
                                                    <i class="icon-link"></i>
                                                </span>
                                                <input type="text"
                                                       name="orders_autoexport_ftp_url"
                                                       id="data_export_orders_autoexport_ftp_url"
                                                       value="{$autoexport_ftp_url|escape:'html'}"
                                                       class=""
                                                       size="33"	
                                                       required="required" />
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label col-lg-3">
                                            <span class="label-tooltip" data-toggle="tooltip" title="" data-original-title="{l s='Default FTP port is 21 for FTP, and 22 for SFTP, if no port specified.' mod='ordersexportpro'}">
                                                {l s='FTP Port' mod='ordersexportpro'}
                                            </span>
                                        </label>
                                        <div class="col-lg-3">
                                            <div class="input-group fixed-width-xxl">
                                                <span class="input-group-addon">
                                                    <i class="icon-circle-thin"></i>
                                                </span>
                                                <input type="text"
                                                       name="orders_autoexport_ftp_port"
                                                       id="data_export_orders_autoexport_ftp_port"
                                                       value="{$autoexport_ftp_port|escape:'html'}"
                                                       class=""
                                                       size="33" />
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label col-lg-3 required">
                                            {l s='FTP Username' mod='ordersexportpro'}
                                        </label>
                                        <div class="col-lg-3">
                                            <div class="input-group fixed-width-xxl">
                                                <span class="input-group-addon">
                                                    <i class="icon-user"></i>
                                                </span>
                                                <input type="text"
                                                       name="orders_autoexport_ftp_username"
                                                       id="data_export_orders_autoexport_ftp_username"
                                                       value="{$autoexport_ftp_usrnm|escape:'html'}"
                                                       class=""
                                                       size="33"	
                                                       required="required" />
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label col-lg-3 required">
                                            {l s='FTP Password' mod='ordersexportpro'}
                                        </label>
                                        <div class="col-lg-3">
                                            <div class="input-group fixed-width-xxl">
                                                <span class="input-group-addon">
                                                    <i class="icon-lock"></i>
                                                </span>
                                                <input type="password"
                                                       name="orders_autoexport_ftp_password"
                                                       id="data_export_orders_autoexport_ftp_password"
                                                       value="{$autoexport_ftp_pswd|escape:'html'}"
                                                       class=""
                                                       size="33"	
                                                       required="required" />
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label col-lg-3">
                                            <span class="label-tooltip" data-toggle="tooltip" title="" data-original-title="{l s='The default folder is public_ftp if no name is written here, the file name is always the order\'s ID with "Order_" prepended, and the type is XLSX if no setting selected.' mod='ordersexportpro'}">
                                                {l s='FTP Folder Name' mod='ordersexportpro'}
                                            </span>
                                        </label>
                                        <div class="col-lg-3">
                                            <div class="input-group fixed-width-xxl">
                                                <span class="input-group-addon">
                                                    <i class="icon-folder-open"></i>
                                                </span>
                                                <input type="text"
                                                       name="orders_autoexport_ftp_file_path"
                                                       id="data_export_orders_autoexport_ftp_file_path"
                                                       value="{$autoexport_ftp_file_path|escape:'html'}"
                                                       class=""
                                                       size="33" />
                                            </div>
                                            <p class="help-block">
                                                {l s='e.g. public_ftp/Orders' mod='ordersexportpro'}
                                            </p>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label col-lg-3">
                                            <span class="label-tooltip" data-toggle="tooltip" title="" data-original-title="{l s='Adds timestamp in "Y-m-d His" format to file name to avoid overwriting. e.g. Orders_2020-01-14 152852.xlsx' mod='ordersexportpro'}">
                                                {l s='Add Timestamp' mod='ordersexportpro'}
                                            </span>
                                        </label>
                                        <div class="col-lg-9">
                                            <span class="switch prestashop-switch fixed-width-lg">
                                                <input type="radio" name="orders_autoexport_ftp_add_ts" id="data_export_orders_autoexport_ftp_add_ts_yes" value="1" {if $autoexport_ftp_add_ts eq '1'} checked="checked" {/if} />
                                                <label for="data_export_orders_autoexport_ftp_add_ts_yes">{l s='Yes' mod='ordersexportpro'}</label>
                                                <input type="radio" name="orders_autoexport_ftp_add_ts" id="data_export_orders_autoexport_ftp_add_ts_no" value="0" {if $autoexport_ftp_add_ts ne '1'} checked="checked" {/if} />
                                                <label for="data_export_orders_autoexport_ftp_add_ts_no">{l s='No' mod='ordersexportpro'}</label>
                                                <a class="slide-button btn"></a>
                                            </span>
                                            {*<p class="help-block">
                                            </p>*}
                                        </div>
                                    </div>
                                </div>
                                {*<div class="row">
                                <button id="data_export_orders_autoexport_save" class="pull-right btn btn-default">
                                <i class="process-icon-save"></i> {l s='Save' mod='ordersexportpro'}
                                </button>
                                </div>*}

                                <br />
                                <hr style="border-top-color: #d8d8d8;">
                                <br />


                                <div class="form-group">
                                    <label class="control-label col-lg-3">
                                        {l s='Select a setting with which exports should be created' mod='ordersexportpro'}
                                    </label>
                                    <div class="col-lg-9">
                                        <select class="fixed-width-xl"
                                                id="data_export_orders_autoexport_setting">
                                            <option value="orders_default">{l s='--Default--' mod='ordersexportpro'}</option>
                                            {foreach from=$configs item=config}
                                                <option {if $config.name eq $autoexport_setting}selected{/if} value="{$config.name|escape:'html'}">{$config.name|escape:'html'}</option>
                                            {/foreach}
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <button id="data_export_orders_autoexport_save" class="pull-right btn btn-default">
                                    <i class="process-icon-save"></i> {l s='Save' mod='ordersexportpro'}
                                </button>
                            </div>
                        </div>
                        <div id="data_export_orders_schedule" class="tab-pane">
                            <div class="alert alert-info alert-dismissible fade in">
                                <p>
                                    {l s='You can set cron jobs and export your orders any time you want.' mod='ordersexportpro'}<br>
                                    {l s="Make sure the 'curl' library is installed on your server." mod='ordersexportpro'}
                                    <br>
                                    {l s='To execute your cron tasks, please insert the following line in your cron tasks manager:' mod='ordersexportpro'}
                                </p>
                                <br>
                                <ul class="list-unstyled">
                                    <li><code>0 0 * * * curl "{$schedule_url|escape:'html'}"</code></li>
                                </ul>
                            </div>
                            <div id="notification3" style="display:none;"></div>
                            <div class="form-group">
                                <label class="control-label col-lg-3">
                                    {l s='Enable Cron' mod='ordersexportpro'}
                                </label>
                                <div class="col-lg-9">
                                    <span class="switch prestashop-switch fixed-width-lg">
                                        <input type="radio" name="orders_schedule" id="data_export_orders_schedule_yes" value="1" {if $schedule_enabled eq '1'} checked="checked"{/if} />
                                        <label for="data_export_orders_schedule_yes">{l s='Yes' mod='ordersexportpro'}</label>
                                        <input type="radio" name="orders_schedule" id="data_export_orders_schedule_no" value="0" {if $schedule_enabled ne '1'} checked="checked"{/if}  />
                                        <label for="data_export_orders_schedule_no">{l s='No' mod='ordersexportpro'}</label>
                                        <a class="slide-button btn"></a>
                                    </span>
                                    <p class="help-block">
                                    </p>
                                    <br />
                                </div>
                            </div>
                            <div class="schedule collapse {if $schedule_enabled eq '1'} in {/if} ">
                                {*<div class="form-group">
                                <label class="col-lg-3 col-lg-offset-3">
                                {l s='Send the exported file' mod='ordersexportpro'}
                                </label>
                                </div>*}
                                <div class="form-group">
                                    <label class="control-label col-lg-3">
                                        {l s='By Email' mod='ordersexportpro'}
                                    </label>
                                    <div class="col-lg-9">
                                        <span class="switch prestashop-switch fixed-width-lg">
                                            <input type="radio" name="orders_schedule_use_email" id="data_export_orders_schedule_use_email_yes" value="1" {if $schedule_email_enabled eq '1'} checked="checked"{/if} />
                                            <label for="data_export_orders_schedule_use_email_yes">{l s='Yes' mod='ordersexportpro'}</label>
                                            <input type="radio" name="orders_schedule_use_email" id="data_export_orders_schedule_use_email_no" value="0" {if $schedule_email_enabled ne '1'} checked="checked"{/if} />
                                            <label for="data_export_orders_schedule_use_email_no">{l s='No' mod='ordersexportpro'}</label>
                                            <a class="slide-button btn"></a>
                                        </span>
                                        {*<p class="help-block">
                                        </p>*}
                                    </div>
                                </div>
                                <div class="schedule-email collapse {if $schedule_email_enabled eq '1'} in {/if} ">

                                    <div class="form-group">
                                        <label class="control-label col-lg-3">
                                            <span class="label-tooltip" data-toggle="tooltip" title="" data-original-title="{l s='Destination emails that the file will be sent' mod='ordersexportpro'}">
                                                {l s='Receiver Emails' mod='ordersexportpro'}
                                            </span>
                                        </label>
                                        <div class="col-lg-9">
                                            <input type="text"
                                                   id="data_export_orders_schedule_to_emails"
                                                   value="{$schedule_to_emails|escape:'html'}"
                                                   class=""
                                                   size="33" />
                                            <p class="help-block">
                                                {l s='Type an email and' mod='ordersexportpro'}
                                                <b style="color:#555;">{l s='hit Enter' mod='ordersexportpro'}</b>
                                                {l s='or' mod='ordersexportpro'}
                                                <b style="color:#555;">{l s='Spacebar' mod='ordersexportpro'}</b>
                                            </p>
                                        </div>
                                    </div>

                                </div>
                                <br>
                                <div class="form-group">
                                    <label class="control-label col-lg-3">
                                        {l s='By FTP' mod='ordersexportpro'}
                                    </label>
                                    <div class="col-lg-9">
                                        <span class="switch prestashop-switch fixed-width-lg">
                                            <input type="radio" name="orders_schedule_use_ftp" id="data_export_orders_schedule_use_ftp_yes" value="1" {if $schedule_ftp_enabled eq '1'} checked="checked" {/if} />
                                            <label for="data_export_orders_schedule_use_ftp_yes">{l s='Yes' mod='ordersexportpro'}</label>
                                            <input type="radio" name="orders_schedule_use_ftp" id="data_export_orders_schedule_use_ftp_no" value="0" {if $schedule_ftp_enabled ne '1'} checked="checked" {/if} />
                                            <label for="data_export_orders_schedule_use_ftp_no">{l s='No' mod='ordersexportpro'}</label>
                                            <a class="slide-button btn"></a>
                                        </span>
                                        {*<p class="help-block">
                                        </p>*}
                                    </div>
                                </div>
                                <div class="schedule-ftp collapse {if $schedule_ftp_enabled eq '1'} in {/if}">
                                    <div class="form-group">
                                        <label class="control-label col-lg-3">
                                            {l s='FTP Type' mod='ordersexportpro'}
                                        </label>
                                        <div class="col-lg-9">
                                            <span class="switch prestashop-switch fixed-width-lg">
                                                <input type="radio" name="orders_schedule_ftp_type" id="data_export_orders_schedule_ftp_type_sftp" value="sftp" {if $schedule_ftp_type eq 'sftp'} checked="checked" {/if} />
                                                <label for="data_export_orders_schedule_ftp_type_sftp">{l s='SFTP' mod='ordersexportpro'}</label>
                                                <input type="radio" name="orders_schedule_ftp_type" id="data_export_orders_schedule_ftp_type_ftp" value="ftp" {if $schedule_ftp_type ne 'sftp'} checked="checked" {/if} />
                                                <label for="data_export_orders_schedule_ftp_type_ftp">{l s='FTP' mod='ordersexportpro'}</label>
                                                <a class="slide-button btn"></a>
                                            </span>
                                            {*<p class="help-block">
                                            </p>*}
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label col-lg-3 required">
                                            <span class="label-tooltip" data-toggle="tooltip" title="" data-original-title="{l s='Domain name or IP address' mod='ordersexportpro'}">
                                                {l s='FTP URL' mod='ordersexportpro'}
                                            </span>
                                        </label>
                                        <div class="col-lg-3">
                                            <div class="input-group fixed-width-xxl">
                                                <span class="input-group-addon">
                                                    <i class="icon-link"></i>
                                                </span>
                                                <input type="text"
                                                       name="orders_schedule_ftp_url"
                                                       id="data_export_orders_schedule_ftp_url"
                                                       value="{$schedule_ftp_url|escape:'html'}"
                                                       class=""
                                                       size="33"	
                                                       required="required" />
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label col-lg-3">
                                            <span class="label-tooltip" data-toggle="tooltip" title="" data-original-title="{l s='Default FTP port is 21 for FTP, and 22 for SFTP, if no port specified.' mod='ordersexportpro'}">
                                                {l s='FTP Port' mod='ordersexportpro'}
                                            </span>
                                        </label>
                                        <div class="col-lg-3">
                                            <div class="input-group fixed-width-xxl">
                                                <span class="input-group-addon">
                                                    <i class="icon-circle-thin"></i>
                                                </span>
                                                <input type="text"
                                                       name="orders_schedule_ftp_port"
                                                       id="data_export_orders_schedule_ftp_port"
                                                       value="{$schedule_ftp_port|escape:'html'}"
                                                       class=""
                                                       size="33" />
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label col-lg-3 required">
                                            {l s='FTP Username' mod='ordersexportpro'}
                                        </label>
                                        <div class="col-lg-3">
                                            <div class="input-group fixed-width-xxl">
                                                <span class="input-group-addon">
                                                    <i class="icon-user"></i>
                                                </span>
                                                <input type="text"
                                                       name="orders_schedule_ftp_username"
                                                       id="data_export_orders_schedule_ftp_username"
                                                       value="{$schedule_ftp_usrnm|escape:'html'}"
                                                       class=""
                                                       size="33"	
                                                       required="required" />
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label col-lg-3 required">
                                            {l s='FTP Password' mod='ordersexportpro'}
                                        </label>
                                        <div class="col-lg-3">
                                            <div class="input-group fixed-width-xxl">
                                                <span class="input-group-addon">
                                                    <i class="icon-lock"></i>
                                                </span>
                                                <input type="password"
                                                       name="orders_schedule_ftp_password"
                                                       id="data_export_orders_schedule_ftp_password"
                                                       value="{$schedule_ftp_pswd|escape:'html'}"
                                                       class=""
                                                       size="33"	
                                                       required="required" />
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label col-lg-3">
                                            <span class="label-tooltip" data-toggle="tooltip" title="" data-original-title="{l s='The default folder is public_ftp if no name is written here, the file name is always the name you enter for file, and the type is XLSX if no setting selected.' mod='ordersexportpro'}">
                                                {l s='FTP Folder Name' mod='ordersexportpro'}
                                            </span>
                                        </label>
                                        <div class="col-lg-3">
                                            <div class="input-group fixed-width-xxl">
                                                <span class="input-group-addon">
                                                    <i class="icon-folder-open"></i>
                                                </span>
                                                <input type="text"
                                                       name="orders_schedule_ftp_file_path"
                                                       id="data_export_orders_schedule_ftp_file_path"
                                                       value="{$schedule_ftp_file_path|escape:'html'}"
                                                       class=""
                                                       size="33" />
                                            </div>
                                            <p class="help-block">
                                                {l s='e.g. public_ftp/Orders' mod='ordersexportpro'}
                                            </p>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label col-lg-3">
                                            <span class="label-tooltip" data-toggle="tooltip" title="" data-original-title="{l s='Adds timestamp in "Y-m-d His" format to file name to avoid overwriting. e.g. Orders_2020-01-14 152852.xlsx' mod='ordersexportpro'}">
                                                {l s='Add Timestamp' mod='ordersexportpro'}
                                            </span>
                                        </label>
                                        <div class="col-lg-9">
                                            <span class="switch prestashop-switch fixed-width-lg">
                                                <input type="radio" name="orders_schedule_ftp_add_ts" id="data_export_orders_schedule_ftp_add_ts_yes" value="1" {if $schedule_ftp_add_ts eq '1'} checked="checked" {/if} />
                                                <label for="data_export_orders_schedule_ftp_add_ts_yes">{l s='Yes' mod='ordersexportpro'}</label>
                                                <input type="radio" name="orders_schedule_ftp_add_ts" id="data_export_orders_schedule_ftp_add_ts_no" value="0" {if $schedule_ftp_add_ts ne '1'} checked="checked" {/if} />
                                                <label for="data_export_orders_schedule_ftp_add_ts_no">{l s='No' mod='ordersexportpro'}</label>
                                                <a class="slide-button btn"></a>
                                            </span>
                                            {*<p class="help-block">
                                            </p>*}
                                        </div>
                                    </div>
                                </div>
                                {*<div class="row">
                                <button id="data_export_orders_schedule_save" class="pull-right btn btn-default">
                                <i class="process-icon-save"></i> {l s='Save' mod='ordersexportpro'}
                                </button>
                                </div>*}

                                <br />
                                <hr style="border-top-color: #d8d8d8;">
                                <br />


                                <div class="form-group">
                                    <label class="control-label col-lg-3">
                                        {l s='Select a setting with which exports should be created' mod='ordersexportpro'}
                                    </label>
                                    <div class="col-lg-9">
                                        <select class="fixed-width-xl"
                                                id="data_export_orders_schedule_setting">
                                            <option value="orders_default">{l s='--Default--' mod='ordersexportpro'}</option>
                                            {foreach from=$configs item=config}
                                                <option {if $config.name eq $schedule_setting}selected{/if} value="{$config.name|escape:'html'}">{$config.name|escape:'html'}</option>
                                            {/foreach}
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <button id="data_export_orders_schedule_save" class="pull-right btn btn-default">
                                    <i class="process-icon-save"></i> {l s='Save' mod='ordersexportpro'}
                                </button>
                            </div>
                        </div>
                        <div id="data_export_orders_documentation" class="tab-pane">
                            <p>
                                &raquo; {l s='You can get a PDF documentation to configure this module' mod='ordersexportpro'}:
                            </p>
                            <ul>
                                <li><a href="{$doc_link|escape:'html'}&action=getDoc&lang=en" target="_blank">{l s='English' mod='ordersexportpro'}</a></li>
                                <li><a href="{$doc_link|escape:'html'}&action=getDoc&lang=fr" target="_blank">{l s='French' mod='ordersexportpro'}</a></li>
                                <li><a href="{$doc_link|escape:'html'}&action=getDoc&lang=es" target="_blank">{l s='Spanish' mod='ordersexportpro'}</a></li>
                                <li><a href="{$doc_link|escape:'html'}&action=getDoc&lang=de" target="_blank">{l s='German' mod='ordersexportpro'}</a></li>
                                <li><a href="{$doc_link|escape:'html'}&action=getDoc&lang=it" target="_blank">{l s='Italian' mod='ordersexportpro'}</a></li>
                                <li><a href="{$doc_link|escape:'html'}&action=getDoc&lang=nl" target="_blank">{l s='Dutch' mod='ordersexportpro'}</a></li>
                                <li><a href="{$doc_link|escape:'html'}&action=getDoc&lang=ru" target="_blank">{l s='Russian' mod='ordersexportpro'}</a></li>
                                    {*                                <li><a href="{$doc_link|escape:'html'}&action=getDoc&lang=tr" target="_blank">{l s='Turkish' mod='ordersexportpro'}</a></li>*}
                                    {*<li><a href="{$doc_link|escape:'html'}&action=getDoc&lang=ar" target="_blank">{l s='Arabic' mod='ordersexportpro'}</a></li>
                                    <li><a href="{$doc_link|escape:'html'}&action=getDoc&lang=fa" target="_blank">{l s='Persian' mod='ordersexportpro'}</a></li>*}
                            </ul>
                        </div>
                        <div id="data_export_orders_support" class="tab-pane">
                            <p>
                                <b>{l s='Any questions or additional features?' mod='ordersexportpro'}</b>
                            </p>
                            <b><a target="_blank" href="https://addons.prestashop.com/en/contact-us?id_product=42545">
                                    <i class="icon icon-external-link"></i> {l s='Contact us' mod='ordersexportpro'}
                                </a>
                            </b>
                        </div>
                    </div>
                </div>
                <!-- /.form-wrapper -->
            </div>
            <div class="panel-footer" id="data_export_submit_panel">
                <div class="text-center">
                    <button type="submit" value="1" id="data_export_form_submit_btn" name="get_orders" class="btn btn-default">
                        <i class="process-icon-export"></i>{l s='Export Orders' mod='ordersexportpro'}
                    </button>
                </div>
            </div>
        </div>
        {*<div class="panel col-xs-4 col-xs-push-4" id="data_export_submit_panel">
        </div>*}
    </form>
</div>

<script>
    var lang_iso_code = "{$lang_iso_code|escape:'html'}";
    var doc_link = "{$doc_link|escape:'html'|unescape:'html'}";
    var ajax_fetch_url = "{$ajax_fetch_url|escape:'html'|unescape:'html'}";
    var setGroupsTable = true;
    var setCustomersTable = true;
    var setOrderStatesTable = true;
    var setPaymentMethodsTable = true;
    var setManufacturersTable = true;
    var setSuppliersTable = true;
    var setCarriersTable = true;
    var setShopsTable = true;
    var setCurrenciesTable = true;
    var orders = "{l s='Orders' mod='ordersexportpro'}";
    var default_setting = "{l s='--Default--' mod='ordersexportpro'}";
    var invalid_settings_mame = "{l s='Enter a valid settings name' mod='ordersexportpro'}";
    var settings_reset = "{l s='Settings reset.' mod='ordersexportpro'}";
    var settings_applied = "{l s='Settings applied.' mod='ordersexportpro'}";
    var invalid_receiver_emails = "{l s='Invalid receiver email(s)' mod='ordersexportpro'}";
    var no_saved_setting = "{l s='No saved setting' mod='ordersexportpro'}";
    var sure_to_delete = "{l s='Are you sure to delete?' mod='ordersexportpro'}";
</script>