/**
 *
 * NOTICE OF LICENSE
 *
 *  @author    IntelliPresta <tehran.alishov@gmail.com>
 *  @copyright 2019 IntelliPresta
 *  @license   Commercial License
 */

$(document).ready(function () {
    var
            selectedColumns,
            show_all,
            apply,
            show_selected,
            keyColumns,
            optGroup,
            deletedConfig,
            showFieldsFilterAlert = true;
    switch (lang_iso_code) {
        case 'fr':
            show_all = 'Montre tout';
            show_selected = 'Montrer sélectionné';
            apply = 'Appliquer';
            keyColumns = {
                order: "Colonnes de commande",
                product: "Colonnes de produit",
                payment: "Colonnes de paiement",
                customer: "Colonnes de client",
                carrier: "Colonnes de transporteur",
                address: "Colonnes d'adresse",
                shop: "Colonnes de boutique"
            };
            optGroup = {
                order: "Commande",
                product: "Produit",
                payment: "Paiement",
                customer: "Client",
                carrier: "Transporteur",
                address: "Adresse",
                shop: "Boutique"
            };
            break;
        case 'de':
            show_all = 'Zeige alles';
            show_selected = 'Ausgewählte anzeigen';
            apply = 'Sich bewerben';
            keyColumns = {
                order: "Spalten der Bestellung",
                product: "Spalten des Produkts",
                payment: "Spalten der Zahlung",
                customer: "Spalten des Kunden",
                carrier: "Spalten des Trägers",
                address: "Spalten der Adresse",
                shop: "Spalten des Shop"
            };
            optGroup = {
                order: "Bestellung",
                product: "Produkt",
                payment: "Zahlung",
                customer: "Kunde",
                carrier: "Träger",
                address: "Adresse",
                shop: "Shop"
            };
            break;
        case 'es':
            show_all = 'Mostrar todo';
            show_selected = 'Mostrar seleccionado';
            apply = 'Aplicar';
            keyColumns = {
                order: "Columnas de pedido",
                product: "Columnas de producto",
                payment: "Columnas de pago",
                customer: "Columnas de cliente",
                carrier: "Columnas de portador",
                address: "Columnas de direccion",
                shop: "Columnas de tienda"
            };
            optGroup = {
                order: "Pedido",
                product: "Producto",
                payment: "Pago",
                customer: "Cliente",
                carrier: "Portador",
                address: "Dirección",
                shop: "Tienda"
            };
            break;
        case 'it':
            show_all = 'Mostra tutto';
            show_selected = 'Mostra selezionato';
            apply = 'Applicare';
            keyColumns = {
                order: "Colonne d'ordine",
                product: "Colonne di prodotto",
                payment: "Colonne di pagamento",
                customer: "Colonne di cliente",
                carrier: "Colonne di corriere",
                address: "Colonne di indirizzo",
                shop: "Colonne del negozio"
            };
            optGroup = {
                order: "Ordine",
                product: "Prodotto",
                payment: "Pagamento",
                customer: "Cliente",
                carrier: "Vettore",
                address: "Indirizzo",
                shop: "Negozio"
            };
            break;
        case 'ru':
            show_all = 'Показать все';
            show_selected = 'Показать выбранное';
            apply = 'Применять';
            keyColumns = {
                order: "Столбцы заказа",
                product: "Столбцы товара",
                payment: "Столбцы оплаты",
                customer: "Столбцы клиента",
                carrier: "Столбцы перевозчика",
                address: "Столбцы адреса",
                shop: "Столбцы магазина"
            };
            optGroup = {
                order: "Заказ",
                product: "Товар",
                payment: "Оплата",
                customer: "Покупатель",
                carrier: "Перевозчик",
                address: "Адрес",
                shop: "Магазин"
            };
            break;
        case 'tr':
            show_all = 'Hepsini göster';
            show_selected = 'Seçileni göster';
            apply = 'Uygulamak';
            keyColumns = {
                order: "Sipariş sütunları",
                product: "Ürün sütunları",
                payment: "Ödeme sütunları",
                customer: "Müşteri sütunları",
                carrier: "Taşıyıcı sütunları",
                address: "Adres sütunları",
                shop: "Dükkan sütunları"
            };
            optGroup = {
                order: "Sipariş",
                product: "Ürün",
                payment: "Ödeme",
                customer: "Müşteri",
                carrier: "Taşıyıcı",
                address: "Adres",
                shop: "Dükkan"
            };
            break;
        case 'nl':
            show_all = 'Toon alles';
            show_selected = 'Toon geselecteerd';
            apply = 'Van toepassing zijn';
            keyColumns = {
                order: "Kolommen van bestelling",
                product: "Kolommen van product",
                payment: "Kolommen van betaling",
                customer: "Kolommen van klant",
                carrier: "Kolommen van vervoerder",
                address: "Kolommen von adres",
                shop: "Kolommen van winkel"
            };
            optGroup = {
                order: "Bestellen",
                product: "Product",
                payment: "Betaling",
                customer: "Klant",
                carrier: "Vervoerder",
                address: "Adres",
                shop: "Winkel"
            };
            break;
        default:
            show_all = 'Show all';
            show_selected = 'Show selected';
            apply = 'Apply';
            keyColumns = {
                order: "Order columns",
                product: "Product columns",
                payment: "Payment columns",
                customer: "Customer columns",
                carrier: "Carrier columns",
                address: "Address columns",
                shop: "Shop columns"
            };
            optGroup = {
                order: "Order",
                product: "Product",
                payment: "Payment",
                customer: "Customer",
                carrier: "Carrier",
                address: "Address",
                shop: "Shop"
            };
    }

    function controlSortingByProduct() {
//        console.log($('input[type=radio][name=orders_merge]:checked').val());
        if ($('input[type=radio][name=orders_merge]:checked').val() === '1') {
            $('#data_export_orders_sort optgroup[label=' + optGroup.product + ']').attr('disabled', 'disabled');
        } else {
            $('#data_export_orders_sort optgroup[label=' + optGroup.product + ']').removeAttr('disabled');
        }
    }
    $(".collapse").collapse({toggle: false});
    $('input[name="orders_export_as"]').change(function () {
        if ($(this).is(':checked')) {
            if ($(this).val() === 'csv') {
                $('.csv_options').collapse('show');
                $('.pdf_options').collapse('hide');
            } else if ($(this).val() === 'pdf') {
                $('.csv_options').collapse('hide');
                $('.pdf_options').collapse('show');
            } else {
                $('.csv_options').collapse('hide');
                $('.pdf_options').collapse('hide');
            }
        }
    });

    var applySelected = (function applySelectedFunc() {
        selectedColumns = {};
        $('#data_export_orders_filter_fields .list-group a').each(function (index) {
            var key = $(this).attr('id').replace('orders_filter_fields_', '');
            var selectedItems = $('#data_export_orders_' + key + '_columns>li:not(.hidden)').find('i.icon-check-square-o');
            var unselectedItems = $('#data_export_orders_' + key + '_columns>li:not(.hidden)').find('i.icon-square-o');
            var totalItems = selectedItems.length + unselectedItems.length;
            $(this).children('span').text(selectedItems.length);
            selectedColumns[key] = {};
            if ($(this).hasClass('active')) {
                for (var i = 0; i < selectedItems.length; i++) {
                    var attr = $(selectedItems[i]).attr('data-value');
                    selectedColumns[key][attr] = $(selectedItems[i]).parent().clone().children().remove().end().text().trim();
                    $(selectedItems[i]).parent().css('background-color', '#f5f5f5');
                }
            } else {
                for (var i = 0; i < selectedItems.length; i++) {
                    var attr = $(selectedItems[i]).attr('data-value');
                    selectedColumns[key][attr] = $(selectedItems[i]).parent().clone().children().remove().end().text().trim();
                }
            }

            if ($(this).hasClass('active')) {
                for (var i = 0; i < unselectedItems.length; i++) {
                    $(unselectedItems[i]).parent().css('background-color', '#ffffff');
                }
                if (selectedItems.length === 0) {
                    $('#data_export_orders_select_all_columns').
                            find('i').
                            removeClass('icon-minus-square-o icon-check-square-o').
                            addClass('icon-square-o');
                } else if (selectedItems.length < totalItems) {
                    $('#data_export_orders_select_all_columns').
                            find('i').
                            removeClass('icon-square-o icon-check-square-o').
                            addClass('icon-minus-square-o');
                } else if (selectedItems.length === totalItems) {
                    $('#data_export_orders_select_all_columns').
                            find('i').
                            removeClass('icon-square-o icon-minus-square-o').
                            addClass('icon-check-square-o');
                }
            }
        });
//        console.log($('input[type=radio][name=orders_merge]:checked').val());
        controlSortingByProduct();

        $('#orders_selectedColumns').val(JSON.stringify(selectedColumns));
        return applySelectedFunc;

    })();


    var key, item, selectedOptions;
    function fillSortngSelect() {
        selectedOptions = '<option value="order.id_order">-</option>'/*, allOptions = selectedOptions*/;
        $('#data_export_orders_filter_fields .list-group a').each(function (index) {
            key = $(this).attr('id').replace('orders_filter_fields_', '');
//        allOptions += '<optgroup label="' + optGroup[key] + '">';
            selectedOptions += '<optgroup label="' + optGroup[key] + '">';

            $('#data_export_orders_' + key + '_columns>li').find('i.icon-check-square-o').each(function () {
                item = $(this).attr('data-value');
                if (item !== 'product_image' && item !== 'attribute_image') {
                    selectedOptions += '<option value="'
                            + (item.indexOf('.') === -1 ? key + '.' + item : item)
                            + '">' + $(this).parent().clone().children().remove().end().text().trim();
                    +'</option>';
                }
            });
            selectedOptions += '</optgroup>';
        });
        $('#data_export_orders_sort').children('optgroup, option').remove().end().append(selectedOptions);
    }

    fillSortngSelect();
    controlSortingByProduct();
//    if ($('input[type=radio][name=orders_merge]').val() === '1') {
//        $('#data_export_orders_sort optgroup[label=' + optGroup.product + ']').attr('disabled', 'disabled');
//    }

    if (!$('#data_export_orders_autoexport_ftp_url').val()) {
        $('#data_export_orders_autoexport_ftp_url').val(location.hostname);
    }
    if (!$('#data_export_orders_schedule_ftp_url').val()) {
        $('#data_export_orders_schedule_ftp_url').val(location.hostname);
    }
//    if (!$('#data_export_orders_autoexport_ftp_file_path').val()) {
//        $('#data_export_orders_autoexport_ftp_file_path').val('public_ftp/' + orders);
//    }

    var defaults = $('#data_export_form').serialize();
//    console.log(decodeURIComponent(defaults).replace(/\+/g, ' '));
    // Sub left list
    $('.data_export_filter_fields .list-group a').click(function (e) {
        e.preventDefault();
        var key = $(this).attr('id').replace('orders_filter_fields_', '');
        $(this).addClass('active').siblings().removeClass('active');
        $('#data_export_orders_' + key + '_columns').
                removeClass('hidden').siblings().filter(':not(p):not(legend)').addClass('hidden');
        $('#data_export_orders_filter_fields .col-xs-7 legend').html(keyColumns[key] + ':&nbsp;');
        var hiddenList = $('#data_export_orders_' + key + '_columns>li.hidden');
        if (hiddenList.length > 0) {
            $('#data_export_orders_show_all').html(show_all).attr('data-value', '0');
        } else {
            $('#data_export_orders_show_all').html(show_selected).attr('data-value', '1');
        }
        if (showFieldsFilterAlert) {
            $('#data_export_orders_filter_fields .alert.' + key)
                    .removeClass('hidden')
                    .siblings(':not(.row)')
                    .addClass('hidden');
        }
        applySelected();
    });
    $('.columns_group, .data_export_columns').sortable({
        cursor: "move",
        axis: "y",
        stop: function (event, ui) {
            ui.item.css('left', '');
            applySelected();
        }
    });
    $('.data_export_columns>li').click(function () {
        if ($(this).children('i').hasClass('icon-check-square-o')) {
            $(this).children('i').removeClass('icon-check-square-o').addClass('icon-square-o');
        } else if ($(this).children('i').hasClass('icon-square-o')) {
            $(this).children('i').removeClass('icon-square-o').addClass('icon-check-square-o');
        }
        fillSortngSelect();
        applySelected();
    });

    $('.date_collapser').on('change', 'select', function () {

        if ($(this).val() === 'select_date') {
            $(this).closest('.form-group.date_collapser').next().addClass('in');
//            $(this).closest('.form-group.date_collapser').next().collapse("show");
        } else {
            $(this).closest('.form-group.date_collapser').next().removeClass('in');
//            $(this).closest('.form-group.date_collapser').next().collapse("hide");
        }
    });

    $('input[type=radio][name=orders_merge]').change(function () {
        controlSortingByProduct();
    });

    $('#data_export_orders_autoexport_yes').change(function () {
        if ($(this).attr('checked') === 'checked') {
            $('.auto-export').collapse("show");
        }
    });
    $('#data_export_orders_autoexport_no').change(function () {
        if ($(this).attr('checked') === 'checked') {
            $('.auto-export').collapse("hide");
        }
    });

    $('#data_export_orders_autoexport_use_email_yes').change(function () {
        if ($(this).attr('checked') === 'checked') {
            $('.auto-export-email').collapse("show");
        }
    });
    $('#data_export_orders_autoexport_use_email_no').change(function () {
        if ($(this).attr('checked') === 'checked') {
            $('.auto-export-email').collapse("hide");
        }
    });

    $('#data_export_orders_autoexport_use_ftp_yes').change(function () {
        if ($(this).attr('checked') === 'checked') {
            $('.auto-export-ftp').collapse("show");
        }
    });
    $('#data_export_orders_autoexport_use_ftp_no').change(function () {
        if ($(this).attr('checked') === 'checked') {
            $('.auto-export-ftp').collapse("hide");
        }
    });

    $('#data_export_orders_schedule_yes').change(function () {
        if ($(this).attr('checked') === 'checked') {
            $('.schedule').collapse("show");
        }
    });
    $('#data_export_orders_schedule_no').change(function () {
        if ($(this).attr('checked') === 'checked') {
            $('.schedule').collapse("hide");
        }
    });

    $('#data_export_orders_schedule_use_email_yes').change(function () {
        if ($(this).attr('checked') === 'checked') {
            $('.schedule-email').collapse("show");
        }
    });
    $('#data_export_orders_schedule_use_email_no').change(function () {
        if ($(this).attr('checked') === 'checked') {
            $('.schedule-email').collapse("hide");
        }
    });

    $('#data_export_orders_schedule_use_ftp_yes').change(function () {
        if ($(this).attr('checked') === 'checked') {
            $('.schedule-ftp').collapse("show");
        }
    });
    $('#data_export_orders_schedule_use_ftp_no').change(function () {
        if ($(this).attr('checked') === 'checked') {
            $('.schedule-ftp').collapse("hide");
        }
    });


    $('.data_export_filter_fields>.alert a.close').click(function (e) {
        showFieldsFilterAlert = false;
    });
    $('.data_export_select_all_columns').click(function (e) {
        e.preventDefault();
        $(this).blur();
        if ($(this).find('i').hasClass('icon-check-square-o')) {
            $(this).find('i').removeClass('icon-check-square-o').addClass('icon-square-o');
            $('#data_export_orders_scroll_colunms').find('ul:not(.hidden)>li:not(.hidden)').find('i').removeClass('icon-check-square-o').addClass('icon-square-o');
        } else if ($(this).find('i').hasClass('icon-square-o')) {
            $(this).find('i').removeClass('icon-square-o').addClass('icon-check-square-o');
            $('#data_export_orders_scroll_colunms').find('ul:not(.hidden)>li:not(.hidden)').find('i').removeClass('icon-square-o').addClass('icon-check-square-o');
        } else if ($(this).find('i').hasClass('icon-minus-square-o')) {
            $(this).find('i').removeClass('icon-minus-square-o').addClass('icon-square-o');
            $('#data_export_orders_scroll_colunms').find('ul:not(.hidden)>li:not(.hidden)').find('i').removeClass('icon-check-square-o').addClass('icon-square-o');
        }
        applySelected();
    });
    $('#columns_search').keyup(function (e) {
        var value = $(this).val().toLowerCase();

        $(".list-group.item-list.data_export_columns > li").each(function () {
            if ($(this).text().toLowerCase().search(value) > -1) {
                $(this).show();
            } else {
                $(this).hide();
            }
        });
    });
    $('.data_export_show_all').click(function (e) {
        e.preventDefault();
        $(this).blur();
        if ($(this).attr('data-value') === '0') {
            $(this).attr('data-value', '1').html(show_selected);
            $('#data_export_orders_scroll_colunms').children('ul:not(.hidden)').children('li.hidden').removeClass('hidden');
        } else if ($(this).attr('data-value') === '1') {
            $(this).attr('data-value', '0').html(show_all);
            $('#data_export_orders_scroll_colunms').children('ul:not(.hidden)').find('i.icon-square-o').parent().addClass('hidden');
        }
        applySelected();
    });
    $('.data_export_reset_columns').click(function (e) {
        e.preventDefault();
        $(this).blur();
        $('#data_export_orders_scroll_colunms').children('ul:not(.hidden)').children('li:not(.advanced)').children('i').removeClass('icon-square-o').addClass('icon-check-square-o');
        $('#data_export_orders_scroll_colunms').children('ul:not(.hidden)').children('li.advanced').children('i').removeClass('icon-check-square-o').addClass('icon-square-o');
        if ($('.data_export_show_all').attr('data-value') === '0') {
            $('#data_export_orders_scroll_colunms')
                    .children('ul:not(.hidden)')
                    .children('li:not(.advanced)')
                    .removeClass('hidden');
            $('#data_export_orders_scroll_colunms')
                    .children('ul:not(.hidden)')
                    .children('li.advanced')
                    .addClass('hidden');
        }
        applySelected();
    });
    $('#data_export_orders_from_date, #data_export_orders_to_date').datepicker({
        dateFormat: "yy-mm-dd"
    });
//    var date = new Date();
//    $('#data_export_orders_to_date').datepicker('setDate', date);
//    date.setMonth(date.getMonth() - 1);
//    $('#data_export_orders_from_date').datepicker('setDate', date);

    $('#data_export_form').submit(function (e) {

        e.preventDefault();

        collectShops();
        collectGroups();
        collectCustomers();
        collectOrderStates();
        collectCarriers();
        collectManufacturers();
        collectSuppliers();
        collectPaymentMethods();
        collectCurrencies();

        var form = $(this);
        var url = form.attr('action').replace('index.php', 'ajax-tab.php');

        var request = {
            type: "POST",
            url: url,
            dataType: "json",
            data: form.serialize(), // serializes the form's elements.
            success: function (data)
            {
                $('#fader, #spinner').css('display', 'none');
                if (data.type === 'pdf') {
                    if (data.pdf_action === 'open') {
                        open(doc_link + '&action=getFile&id=' + data.id + '&type=' + data.type + '&name=' + data.name, '_blank');
                    } else {
                        location.replace(doc_link + '&action=getFile&id=' + data.id + '&type=' + data.type + '&name=' + data.name + '&pdf_action=download');
                    }
                } else {
                    location.replace(doc_link + '&action=getFile&id=' + data.id + '&type=' + data.type + '&name=' + data.name);
                }

            },
            error: function (data) {
                $('#fader, #spinner').css('display', 'none');
                if (data.statusText === 'error') {
                    $('#emailModal3').modal('show');
                }
            }
        };

        $.ajax(request);

        $('#fader, #spinner').css('display', 'block');
    });

    $('.data_export_form_save_btn').click(function (e) {
        e.preventDefault();
        var config = $('#data_export_form').serialize();

        var name = $('#data_export_orders_settings_name').val();
        var dataTables = JSON.stringify({
            shops: {type: shops.type, data: shops.data, state: shopsTable.state()},
            groups: {type: groups.type, data: groups.data, state: groupsTable.state()},
            customers: {type: customers.type, data: customers.data, state: customersTable.state()},
            orderStates: {type: orderStates.type, data: orderStates.data, state: orderStatesTable.state()},
            manufacturers: {type: manufacturers.type, data: manufacturers.data, state: manufacturersTable.state()},
            suppliers: {type: suppliers.type, data: suppliers.data, state: suppliersTable.state()},
            carriers: {type: carriers.type, data: carriers.data, state: carriersTable.state()},
            paymentMethods: {type: paymentMethods.type, data: paymentMethods.data, state: paymentMethodsTable.state()},
            currencies: {type: currencies.type, data: currencies.data, state: currenciesTable.state()}
        });
        if (name) {
            $('#fader, #spinner').css('display', 'block');
            $.post(ajax_fetch_url, {ajax_action: 'saveConfig', name: name, config: config, datatables: dataTables},
                    function (result) {
                        var json = JSON.parse(result);
                        if (json.type === 'success') {
                            showSuccessMessage(json.message);
                        } else {
                            showErrorMessage(json.message);
                        }
                        if (json.configs) {
                            var html = '',
                                    html2 = '<option value="orders_default">' + default_setting + '</option>',
                                    html3 = html2,
                                    html2Val = $('#data_export_orders_autoexport_setting').val(),
                                    html3Val = $('#data_export_orders_schedule_setting').val();
                            $.each(json.configs, function (index, value) {
//                            if (value.group === mainWord) {
                                html += '<li data-id="' + value.id_orders_export_pro + '" data-config=\''
                                        + value.configuration + '\' data-datatables=\''
                                        + value.datatables + '\' class="list-group-item"><b>' +
                                        value.name + '</b><span class="pull-right">'
                                        + '<button class="btn btn-default apply_config">' + apply + '</button> | <i title="' + value.title
                                        + '" class="icon-trash" aria-hidden="true"></i></span></li>';
                                if (html2Val === value.name || deletedConfig === value.name) {
                                    html2 += '<option selected value="' + value.name + '">' + value.name + '</option>';
                                } else {
                                    html2 += '<option value="' + value.name + '">' + value.name + '</option>';
                                }
                                if (html3Val === value.name || deletedConfig === value.name) {
                                    html3 += '<option selected value="' + value.name + '">' + value.name + '</option>';
                                } else {
                                    html3 += '<option value="' + value.name + '">' + value.name + '</option>';
                                }
//                            }
                            });
                            $('#configs').html(html);
                            $('#data_export_orders_autoexport_setting').html(html2);
                            $('#data_export_orders_schedule_setting').html(html3);
                            $('#data_export_orders_settings_name').val('');
                        }
                        $('#fader, #spinner').css('display', 'none');
                    });
        } else {
            alert(invalid_settings_mame);
        }
    });
    $('#configs i.icon-trash').live('click', function (e) {
        if (confirm(sure_to_delete)) {
            $('#fader, #spinner').css('display', 'block');
            deletedConfig = $(this).parent().parent().attr('data-name');
            $.post(ajax_fetch_url, {ajax_action: 'deleteConfig', id: $(this).parent().parent().attr('data-id')},
                    function (result) {
                        var json = JSON.parse(result);
                        if (json.type === 'success') {
                            showSuccessMessage(json.message);
                        } else {
                            showErrorMessage(json.message);
                        }
                        if (json.configs) {
                            var html = '',
                                    html2 = '<option value="orders_default">' + default_setting + '</option>',
                                    html3 = html2,
                                    html2Val = $('#data_export_orders_autoexport_setting').val(),
                                    html3Val = $('#data_export_orders_schedule_setting').val();
                            $.each(json.configs, function (index, value) {
//                                if (value.group === mainWord) {
                                html += '<li data-id="' + value.id_orders_export_pro + '" data-config=\''
                                        + value.configuration + '\' data-datatables=\''
                                        + value.datatables + '\' class="list-group-item"><b>' +
                                        value.name + '</b><span class="pull-right">'
                                        + '<button class="btn btn-default apply_config">' + apply + '</button> | <i title="' + value.title
                                        + '" class="icon-trash" aria-hidden="true"></i></span></li>';
                                if (html2Val === value.name) {
                                    html2 += '<option selected value="' + value.name + '">' + value.name + '</option>';
                                } else {
                                    html2 += '<option value="' + value.name + '">' + value.name + '</option>';
                                }
                                if (html3Val === value.name) {
                                    html3 += '<option selected value="' + value.name + '">' + value.name + '</option>';
                                } else {
                                    html3 += '<option value="' + value.name + '">' + value.name + '</option>';
                                }
//                                }
                            });
                            if (json.configs.length < 1) {
                                html = '<span style="color: #999;"><i class="icon-warning-sign"></i> ' + no_saved_setting + '</span>';
                            }
                            $('#configs').html(html);
                            $('#data_export_orders_autoexport_setting').html(html2);
                            $('#data_export_orders_schedule_setting').html(html3);
                        }
                        $('#fader, #spinner').css('display', 'none');
                    });
        }
    });
    $('.apply_config').live('click', function (e) {
        e.preventDefault();
        var config = $(this).parent().parent().attr('data-config');
        var pairs = (config[0] === '?' ? config.substr(1) : config).split('&');

        for (var i = 0; i < pairs.length; i++) {
            var pair = pairs[i].split('=');
            if (pair[0] === 'orders_selectedColumns') {
                $('[name="' + pair[0] + '"]').val(pair[1]);
                $('#data_export_orders_scroll_colunms')
                        .find('li.advanced')
                        .removeClass('hidden');
                $('#data_export_orders_show_all').attr('data-value', '1').html(show_selected);
                $.each(JSON.parse(pair[1]), function (key, value) {

                    $('#orders_columns_group').append($('#orders_filter_fields_' + key));

                    var selectedCount = 0, sortedList = [];
                    var values = Object.keys(value);
                    var list = $('#data_export_orders_' + key + '_columns').children('li');

                    for (var i = 0; i < list.length; i++) {
                        if (values.indexOf($(list[i]).children('i').attr('data-value')) === -1) {
                            sortedList[i] = $(list[i])
                                    .children('i')
                                    .removeClass('icon-check-square-o')
                                    .addClass('icon-square-o')
                                    .parent()
                                    .css('background-color', '#ffffff');
                        } else {
                            sortedList[i] = $('#data_export_orders_' + key + '_columns')
                                    .find('i[data-value="' + values[selectedCount] + '"]')
                                    .removeClass('icon-square-o')
                                    .addClass('icon-check-square-o')
                                    .parent()
                                    .css('background-color', '#f5f5f5');
                            selectedCount++;
                        }
                    }

                    $('#data_export_orders_' + key + '_columns').append(sortedList);
                    $('#orders_filter_fields_' + key).children('span').text(selectedCount);

                    if ($('#orders_filter_fields_' + key).hasClass('active')) {
                        if (selectedCount === 0) {
                            $('#data_export_orders_select_all_columns').
                                    find('i').
                                    removeClass('icon-minus-square-o icon-check-square-o').
                                    addClass('icon-square-o');
                        } else if (selectedCount < list.length) {
                            $('#data_export_orders_select_all_columns').
                                    find('i').
                                    removeClass('icon-square-o icon-check-square-o').
                                    addClass('icon-minus-square-o');
                        } else if (selectedCount === list.length) {
                            $('#data_export_orders_select_all_columns').
                                    find('i').
                                    removeClass('icon-square-o icon-minus-square-o').
                                    addClass('icon-check-square-o');
                        }
                    }
                });
            } else if ($('[name="' + pair[0] + '"]').attr('type') === 'radio') {
                $('input[name="' + pair[0] + '"][value="' + pair[1] + '"]').prop('checked', true);
            } else {
                $('[name="' + pair[0] + '"]').val(pair[1]);
            }
        }

        var datatables = JSON.parse($(this).parent().parent().attr('data-datatables'));
//        console.log(datatables);
        for (var prop in datatables) {
            eval(prop).type = datatables[prop].type;
            eval(prop).data = datatables[prop].data;
            if (datatables[prop].state) {
                eval(prop + 'Table').page.len(datatables[prop].state.length).search(datatables[prop].state.search.search).order(datatables[prop].state.order).page(datatables[prop].state.start / datatables[prop].state.length).draw(false);
            }
            if (eval(prop).data.length !== 0 && parseInt(eval(prop).total) !== eval(prop).data.length) {
                $('#' + prop + '_table thead .dt-checkboxes').prop('indeterminate', true);
            }
        }

        $('[name="orders_export_as"]').change();
        $('.date_collapser').change();
        showSuccessMessage(settings_applied);
    });
    $('#data_export_orders_reset_settings').live('click', function (e) {
        e.preventDefault();
        var config = decodeURIComponent(defaults).replace(/\+/g, ' ');
        var pairs = (config[0] === '?' ? config.substr(1) : config).split('&');
        for (var i = 0; i < pairs.length; i++) {
            var pair = pairs[i].split('=');
            if (pair[0] === 'orders_selectedColumns') {
                $('[name="' + pair[0] + '"]').val(pair[1]);
                $('#data_export_orders_scroll_colunms')
                        .find('li.advanced')
                        .removeClass('hidden');
                $('#data_export_orders_show_all').attr('data-value', '1').html(show_selected);
                $.each(JSON.parse(pair[1]), function (key, value) {

                    $('#orders_columns_group').append($('#orders_filter_fields_' + key));

                    var selectedCount = 0, sortedList = [];
                    var values = Object.keys(value);
                    var list = $('#data_export_orders_' + key + '_columns').children('li');

                    for (var i = 0; i < list.length; i++) {
                        if (values.indexOf($(list[i]).children('i').attr('data-value')) === -1) {
                            sortedList[i] = $(list[i])
                                    .children('i')
                                    .removeClass('icon-check-square-o')
                                    .addClass('icon-square-o')
                                    .parent()
                                    .css('background-color', '#ffffff');
                        } else {
                            sortedList[i] = $('#data_export_orders_' + key + '_columns')
                                    .find('i[data-value="' + values[selectedCount] + '"]')
                                    .removeClass('icon-square-o')
                                    .addClass('icon-check-square-o')
                                    .parent()
                                    .css('background-color', '#f5f5f5');
                            selectedCount++;
                        }
                    }

                    $('#data_export_orders_' + key + '_columns').append(sortedList);
                    $('#orders_filter_fields_' + key).children('span').text(selectedCount);

                    if ($('#orders_filter_fields_' + key).hasClass('active')) {
                        if (selectedCount === 0) {
                            $('#data_export_orders_select_all_columns').
                                    find('i').
                                    removeClass('icon-minus-square-o icon-check-square-o').
                                    addClass('icon-square-o');
                        } else if (selectedCount < list.length) {
                            $('#data_export_orders_select_all_columns').
                                    find('i').
                                    removeClass('icon-square-o icon-check-square-o').
                                    addClass('icon-minus-square-o');
                        } else if (selectedCount === list.length) {
                            $('#data_export_orders_select_all_columns').
                                    find('i').
                                    removeClass('icon-square-o icon-minus-square-o').
                                    addClass('icon-check-square-o');
                        }
                    }
                });
            } else if ($('[name="' + pair[0] + '"]').attr('type') === 'radio') {
                $('input[name="' + pair[0] + '"][value="' + pair[1] + '"]').prop('checked', true);
            } else {
                $('[name="' + pair[0] + '"]').val(pair[1]);
            }
        }

        groups = {type: "unselected", data: [], total: 0, filtered: 0};
        groupsTable.draw();
        customers = {type: "unselected", data: [], total: 0, filtered: 0};
        customersTable.draw();
        orderStates = {type: "unselected", data: [], total: 0, filtered: 0};
        orderStatesTable.draw();
        paymentMethods = {type: "unselected", data: [], total: 0, filtered: 0};
        paymentMethodsTable.draw();
        manufacturers = {type: "unselected", data: [], total: 0, filtered: 0};
        manufacturersTable.draw();
        suppliers = {type: "unselected", data: [], total: 0, filtered: 0};
        suppliersTable.draw();
        carriers = {type: "unselected", data: [], total: 0, filtered: 0};
        carriersTable.draw();
        shops = {type: "unselected", data: [], total: 0, filtered: 0};
        shopsTable.draw();
        currencies = {type: "unselected", data: [], total: 0, filtered: 0};
        currenciesTable.draw();

        $('[name="orders_export_as"]').change();
        $('.date_collapser').change();

//        var date = new Date();
//        $('#data_export_orders_to_date').datepicker('setDate', date);
//        date.setMonth(date.getMonth() - 1);
//        $('#data_export_orders_from_date').datepicker('setDate', date);

        showSuccessMessage(settings_reset);
    });

    $('#data_export_orders_autoexport_save').click(function (e) {
        e.preventDefault();
        $('#fader, #spinner').css('display', 'block');
        var autoexportData = {
            ajax_action: "saveAutoexport",
            enable_autoexport: $('[name="orders_autoexport"]:checked').val(),
            enable_autoexport_email: $('[name="orders_autoexport_use_email"]:checked').val(),
            to_emails: $('#data_export_orders_autoexport_to_emails').tagify('serialize'),
            enable_autoexport_ftp: $('[name="orders_autoexport_use_ftp"]:checked').val(),
            ftp_type: $('[name="orders_autoexport_ftp_type"]:checked').val(),
            ftp_url: $('#data_export_orders_autoexport_ftp_url').val(),
            ftp_port: $('#data_export_orders_autoexport_ftp_port').val(),
            ftp_username: $('#data_export_orders_autoexport_ftp_username').val(),
            ftp_password: $('#data_export_orders_autoexport_ftp_password').val(),
            ftp_file_path: $('#data_export_orders_autoexport_ftp_file_path').val(),
            ftp_file_add_ts: $('[name="orders_autoexport_ftp_add_ts"]:checked').val(),
            autoexport_setting: $('#data_export_orders_autoexport_setting').val()
        };

        $.post(ajax_fetch_url, autoexportData, function (result) {
            $('#fader, #spinner').css('display', 'none');
            var json = JSON.parse(result);
            if (json.type === 'success') {
                showSuccessMessage(json.message);
            } else {
                showErrorMessage(json.message);
            }
        });
    });

    $('#data_export_orders_schedule_save').click(function (e) {
        e.preventDefault();
        $('#fader, #spinner').css('display', 'block');
        var scheduleData = {
            ajax_action: "saveSchedule",
            enable_schedule: $('[name="orders_schedule"]:checked').val(),
            enable_schedule_email: $('[name="orders_schedule_use_email"]:checked').val(),
            to_emails: $('#data_export_orders_schedule_to_emails').tagify('serialize'),
            enable_schedule_ftp: $('[name="orders_schedule_use_ftp"]:checked').val(),
            ftp_type: $('[name="orders_schedule_ftp_type"]:checked').val(),
            ftp_url: $('#data_export_orders_schedule_ftp_url').val(),
            ftp_port: $('#data_export_orders_schedule_ftp_port').val(),
            ftp_username: $('#data_export_orders_schedule_ftp_username').val(),
            ftp_password: $('#data_export_orders_schedule_ftp_password').val(),
            ftp_file_path: $('#data_export_orders_schedule_ftp_file_path').val(),
            ftp_file_add_ts: $('[name="orders_schedule_ftp_add_ts"]:checked').val(),
            schedule_setting: $('#data_export_orders_schedule_setting').val()
        };

        $.post(ajax_fetch_url, scheduleData, function (result) {
            $('#fader, #spinner').css('display', 'none');
            var json = JSON.parse(result);
            if (json.type === 'success') {
                showSuccessMessage(json.message);
            } else {
                showErrorMessage(json.message);
            }
        });
    });

    $('#data_export_orders_autoexport_to_emails, #data_export_orders_schedule_to_emails').tagify({
        delimiters: [13, 32, 188, 190],
        duplicates: false,
        addTagOnBlur: true,
        placeholder: ''
    });

    if (typeof setGroupsTable !== 'undefined') {

        function updateGroupsSelectInfo() {
            $('#groups_select_info').text(groups.type === 'selected' ? groups.data.length + ' rows selected' : groups.total - groups.data.length + ' rows selected');

        }

        var groups = {type: "unselected", data: [], total: 0, filtered: 0};
        var allGroupsClicked = false;

        var groupsTable = $('#groups_table').DataTable({
            order: [[1, 'asc']],
            bAutoWidth: false,
            processing: true,
            serverSide: true,
            lengthMenu: [10, 25, 50, 100, 250, 500, 1000],
            ajax: {
                url: ajax_fetch_url,
                type: "POST",
                data: function (d) {
                    d.ajax_action = 'getGroups';
                    d.extra_search_type = $('#ctrl-show-selected-groups').val();
                    d.extra_search_params = {type: groups.type, data: groups.data};
                }
            },
            language: {
                select: {
                    rows: {
                        '_': ''
                    }
                }
            },
            columns: [
                {data: "id"},
                {data: "id"},
                {data: "name"},
                {data: "reduction"},
                {data: "members"}
            ],
            stateSave: true,
            stateSaveCallback: function (settings, data) {
//                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data));
            },
            stateLoadCallback: function (settings) {
//                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance));
            },
            drawCallback: function (settings) {
                if ($('#groups_select_info').length === 0) {
                    $('#groups_table_info').append('<span id="groups_select_info" class="select_info"></span>');
                }
                updateGroupsSelectInfo();
            },
            columnDefs: [
                {
                    targets: 0,
                    width: "70px",
//                    width: "55px",
                    render: function (data, type, row, meta) {
                        if (type === 'display') {
                            data = '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>';
                        }

                        return data;
                    },
                    checkboxes: {
                        selectRow: true,
                        selectAllRender: '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>',
                        selectCallback: function (nodes, selected) {

                            var index;
                            if (nodes.selector.rows) {

                                if (groups.type === 'unselected') {
                                    index = groups.data.indexOf(nodes.ajax.json().data[nodes.selector.rows].id);

                                    if (selected) {
                                        if (index > -1) {
                                            groups.data.splice(index, 1);
                                        }
                                    } else {
                                        if (index === -1) {
                                            groups.data.push(nodes.ajax.json().data[nodes.selector.rows].id);
                                        }
                                    }
                                } else {
                                    index = groups.data.indexOf(nodes.ajax.json().data[nodes.selector.rows].id);
//                                            
                                    if (selected) {
                                        if (index === -1) {
                                            groups.data.push(nodes.ajax.json().data[nodes.selector.rows].id);
                                        }
                                    } else {
                                        if (index > -1) {
                                            groups.data.splice(index, 1);
                                        }
                                    }
                                }
                                updateGroupsSelectInfo();
                            }
                        },
                        selectAllCallback: function (nodes, selected, indeterminate) {
                            if (!indeterminate && allGroupsClicked) {
                                if (selected) {
                                    groups.type = 'unselected';
                                } else {
                                    groups.type = 'selected';
                                }
                                groups.data = [];
                                allGroupsClicked = false;
                            }
                            updateGroupsSelectInfo();

                            if (!indeterminate && groups.data.length !== 0 && parseInt(groups.total) !== groups.data.length) {
                                $('#groups_table thead .dt-checkboxes').prop('indeterminate', true);
                            }
                        }
                    },
                    'createdCell': function (td, cellData, rowData, row, col) {

                        if (groups.type === 'unselected') {

                            if (groups.data.includes(cellData)) {
                                this.api().cell(td).checkboxes.deselect();
                            } else {
                                this.api().cell(td).checkboxes.select();
                            }
                        } else {
                            if (groups.data.includes(cellData)) {
                                this.api().cell(td).checkboxes.select();
                            } else {
                                this.api().cell(td).checkboxes.deselect();
                            }
                        }
                    }
                },
                {
                    targets: 1,
                    width: "70px"
                },
                {
                    targets: 3,
//                    width: "220px",
                    render: function (data, type, row, meta) {
                        return data + '%';
                    }
                },
                {
                    targets: 4,
                    className: "dt-center"

                }
            ],
            select: {
                style: 'os multi',
                info: false
            }
        });


        groupsTable.on('xhr', function () {
            var json = groupsTable.ajax.json();
            groups.total = json.recordsTotal;
        });

        $('#groups_table th.dt-checkboxes-select-all').click(function () {
            allGroupsClicked = true;
        });
        $('#ctrl-show-selected-groups').on('change', function () {
            groupsTable.ajax.reload();
        });

        var collectGroups = function () {
            $('input[name="groups_type"]').remove();
            $('input[name="groups_data"]').remove();
            $('#data_export_form').append($("<input>")
                    .attr("type", "hidden")
                    .attr("name", "groups_type").val(groups.type));
            $('#data_export_form').append($("<input>")
                    .attr("type", "hidden")
                    .attr("name", "groups_data").val(groups.data));
        };
    }

    if (typeof setCustomersTable !== 'undefined') {

        function updateCustomersSelectInfo() {
            $('#customers_select_info').text(customers.type === 'selected' ? customers.data.length + ' rows selected' : customers.total - customers.data.length + ' rows selected');

        }

        var customers = {type: "unselected", data: [], total: 0, filtered: 0};
        var allCustomersClicked = false;

        var customersTable = $('#customers_table').DataTable({
            order: [[1, 'asc']],
            bAutoWidth: false,
            processing: true,
            serverSide: true,
            ajax: {
                url: ajax_fetch_url,
                type: "POST",
                data: function (d) {
                    d.ajax_action = 'getCustomers';
                    d.extra_search_type = $('#ctrl-show-selected-customers').val();
                    d.extra_search_params = {type: customers.type, data: customers.data};
                }
            },
            language: {
                select: {
                    rows: {
                        '_': ''
                    }
                }
            },
            columns: [
                {data: "id"},
                {data: "id"},
                {data: "firstname"},
                {data: "lastname"},
                {data: "email"}
            ],
            stateSave: true,
            stateSaveCallback: function (settings, data) {
//                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data));
            },
            stateLoadCallback: function (settings) {
//                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance));
            },
            drawCallback: function (settings) {
                if ($('#customers_select_info').length === 0) {
                    $('#customers_table_info').append('<span id="customers_select_info" class="select_info"></span>');
                }
                updateCustomersSelectInfo();
            },
            columnDefs: [
                {
                    targets: 0,
                    width: "7%",
//                    width: "55px",
                    render: function (data, type, row, meta) {
                        if (type === 'display') {
                            data = '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>';
                        }

                        return data;
                    },
                    checkboxes: {
                        selectRow: true,
                        selectAllRender: '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>',
                        selectCallback: function (nodes, selected) {

                            var index;
                            if (nodes.selector.rows) {

                                if (customers.type === 'unselected') {
                                    index = customers.data.indexOf(nodes.ajax.json().data[nodes.selector.rows].id);

                                    if (selected) {
                                        if (index > -1) {
                                            customers.data.splice(index, 1);
                                        }
                                    } else {
                                        if (index === -1) {
                                            customers.data.push(nodes.ajax.json().data[nodes.selector.rows].id);
                                        }
                                    }
                                } else {
                                    index = customers.data.indexOf(nodes.ajax.json().data[nodes.selector.rows].id);
//                                            
                                    if (selected) {
                                        if (index === -1) {
                                            customers.data.push(nodes.ajax.json().data[nodes.selector.rows].id);
                                        }
                                    } else {

                                        if (index > -1) {
                                            customers.data.splice(index, 1);
                                        }
                                    }
                                }
                                updateCustomersSelectInfo();
                            }
                        },
                        selectAllCallback: function (nodes, selected, indeterminate) {

                            if (!indeterminate && allCustomersClicked) {
                                if (selected) {
                                    customers.type = 'unselected';
                                } else {
                                    customers.type = 'selected';
                                }
                                customers.data = [];
                                allCustomersClicked = false;
                            }
                            updateCustomersSelectInfo();

                            if (!indeterminate && customers.data.length !== 0 && parseInt(customers.total) !== customers.data.length) {
                                $('#customers_table thead .dt-checkboxes').prop('indeterminate', true);
                            }
                        }
                    },
                    'createdCell': function (td, cellData, rowData, row, col) {

                        if (customers.type === 'unselected') {

                            if (customers.data.includes(cellData)) {
                                this.api().cell(td).checkboxes.deselect();
                            } else {
                                this.api().cell(td).checkboxes.select();
                            }
                        } else {
                            if (customers.data.includes(cellData)) {
                                this.api().cell(td).checkboxes.select();
                            } else {
                                this.api().cell(td).checkboxes.deselect();
                            }
                        }
                    }
                },
                {
                    targets: 1,
                    width: "8%"
                },
                {
                    targets: 4,
                    width: "35%"
                }
            ],
            select: {
                style: 'os multi',
                info: false
            }
        });


        customersTable.on('xhr', function () {
            var json = customersTable.ajax.json();
            customers.total = json.recordsTotal;
        });

        $('#customers_table th.dt-checkboxes-select-all').click(function () {
            allCustomersClicked = true;
        });
        $('#ctrl-show-selected-customers').on('change', function () {
            customersTable.ajax.reload();
        });

        var collectCustomers = function () {
            $('input[name="customers_type"]').remove();
            $('input[name="customers_data"]').remove();
            $('#data_export_form').append($("<input>")
                    .attr("type", "hidden")
                    .attr("name", "customers_type").val(customers.type));
            $('#data_export_form').append($("<input>")
                    .attr("type", "hidden")
                    .attr("name", "customers_data").val(customers.data));
        };
    }


    if (typeof setOrderStatesTable !== 'undefined') {

        function updateOrderStatesSelectInfo() {
            $('#orderStates_select_info').text(orderStates.type === 'selected' ? orderStates.data.length + ' rows selected' : orderStates.total - orderStates.data.length + ' rows selected');

        }

        var orderStates = {type: "unselected", data: [], total: 0, filtered: 0};
        var allOrderStatesClicked = false;

        var orderStatesTable = $('#orderStates_table').DataTable({
            order: [[1, 'asc']],
            bAutoWidth: false,
            processing: true,
            serverSide: true,
            ajax: {
                url: ajax_fetch_url,
                type: "POST",
                data: function (d) {
                    d.ajax_action = 'getOrderStates';
                    d.extra_search_type = $('#ctrl-show-selected-orderStates').val();
                    d.extra_search_params = {type: orderStates.type, data: orderStates.data};
                }
            },
            language: {
                select: {
                    rows: {
                        '_': ''
                    }
                }
            },
            columns: [
                {data: "id"},
                {data: "id"},
                {data: "name"},
                {data: "icon"}
            ],
            stateSave: true,
            stateSaveCallback: function (settings, data) {
//                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data));
            },
            stateLoadCallback: function (settings) {
//                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance));
            },
            drawCallback: function (settings) {
                if ($('#orderStates_select_info').length === 0) {
                    $('#orderStates_table_info').append('<span id="orderStates_select_info" class="select_info"></span>');
                }
                updateOrderStatesSelectInfo();
            },
            columnDefs: [
                {
                    targets: 0,
                    width: "7%",
//                    width: "55px",
                    render: function (data, type, row, meta) {
                        if (type === 'display') {
                            data = '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>';
                        }

                        return data;
                    },
                    checkboxes: {
                        selectRow: true,
                        selectAllRender: '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>',
                        selectCallback: function (nodes, selected) {

                            var index;
                            if (nodes.selector.rows) {

                                if (orderStates.type === 'unselected') {
                                    index = orderStates.data.indexOf(nodes.ajax.json().data[nodes.selector.rows].id);

                                    if (selected) {
                                        if (index > -1) {
                                            orderStates.data.splice(index, 1);
                                        }
                                    } else {
                                        if (index === -1) {
                                            orderStates.data.push(nodes.ajax.json().data[nodes.selector.rows].id);
                                        }
                                    }
                                } else {
                                    index = orderStates.data.indexOf(nodes.ajax.json().data[nodes.selector.rows].id);
//                                            
                                    if (selected) {
                                        if (index === -1) {
                                            orderStates.data.push(nodes.ajax.json().data[nodes.selector.rows].id);
                                        }
                                    } else {

                                        if (index > -1) {
                                            orderStates.data.splice(index, 1);
                                        }
                                    }
                                }
                                updateOrderStatesSelectInfo();
                            }
                        },
                        selectAllCallback: function (nodes, selected, indeterminate) {
//                            console.log('All trigger');
                            if (!indeterminate && allOrderStatesClicked) {
                                if (selected) {
                                    orderStates.type = 'unselected';
                                } else {
                                    orderStates.type = 'selected';
                                }
                                orderStates.data = [];
                                allOrderStatesClicked = false;
                            }
                            updateOrderStatesSelectInfo();

                            if (!indeterminate && orderStates.data.length !== 0 && parseInt(orderStates.total) !== orderStates.data.length) {
                                $('#orderStates_table thead .dt-checkboxes').prop('indeterminate', true);
                            }
                        }
                    },
                    'createdCell': function (td, cellData, rowData, row, col) {

                        if (orderStates.type === 'unselected') {

                            if (orderStates.data.includes(cellData)) {
                                this.api().cell(td).checkboxes.deselect();
                            } else {
                                this.api().cell(td).checkboxes.select();
                            }
                        } else {
                            if (orderStates.data.includes(cellData)) {
                                this.api().cell(td).checkboxes.select();
                            } else {
                                this.api().cell(td).checkboxes.deselect();
                            }
                        }
                    }
                },
                {
                    targets: 1,
                    width: "10%"
                },
                {
                    targets: 2,
                    width: "50%",
                    render: function (data, type, row, meta) {
                        return '<span class="label color_field" style="background-color:' + row.color + ';color:' + row.font_color + ';">' + data + '</span>';
                    }
                },
                {
                    targets: 3,
                    orderable: false,
                    render: function (data, type, row, meta) {
                        return data ? data : '';
                    }
                }
            ],
            select: {
                style: 'os multi',
                info: false
            }
        });


        orderStatesTable.on('xhr', function () {
            var json = orderStatesTable.ajax.json();
            orderStates.total = json.recordsTotal;
        });

        $('#orderStates_table th.dt-checkboxes-select-all').click(function () {
            allOrderStatesClicked = true;
        });
        $('#ctrl-show-selected-orderStates').on('change', function () {
//            console.log('Order State Change');
            orderStatesTable.ajax.reload();
        });

        var collectOrderStates = function () {
            $('input[name="order_states_type"]').remove();
            $('input[name="order_states_data"]').remove();
            $('#data_export_form').append($("<input>")
                    .attr("type", "hidden")
                    .attr("name", "order_states_type").val(orderStates.type));
            $('#data_export_form').append($("<input>")
                    .attr("type", "hidden")
                    .attr("name", "order_states_data").val(orderStates.data));
        };
    }


    if (typeof setPaymentMethodsTable !== 'undefined') {

        function updatePaymentMethodsSelectInfo() {
            $('#paymentMethods_select_info').text(paymentMethods.type === 'selected' ? paymentMethods.data.length + ' rows selected' : paymentMethods.total - paymentMethods.data.length + ' rows selected');

        }

        var paymentMethods = {type: "unselected", data: [], total: 0, filtered: 0};
        var allPaymentMethodsClicked = false;

        var paymentMethodsTable = $('#paymentMethods_table').DataTable({
            order: [[1, 'asc']],
            bAutoWidth: false,
            processing: true,
            serverSide: true,
            lengthMenu: [10, 25, 50, 100, 250, 500, 1000],
            ajax: {
                url: ajax_fetch_url,
                type: "POST",
                data: function (d) {
                    d.ajax_action = 'getPaymentMethods';
                    d.extra_search_type = $('#ctrl-show-selected-paymentMethods').val();
                    d.extra_search_params = {type: paymentMethods.type, data: paymentMethods.data};
                }
            },
            language: {
                select: {
                    rows: {
                        '_': ''
                    }
                }
            },
            columns: [
                {data: "id"},
                {data: "id"},
                {data: "logo"},
                {data: "name"},
                {data: "module_name"}
            ],
            stateSave: true,
            stateSaveCallback: function (settings, data) {
//                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data));
            },
            stateLoadCallback: function (settings) {
//                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance));
            },
            drawCallback: function (settings) {
                if ($('#paymentMethods_select_info').length === 0) {
                    $('#paymentMethods_table_info').append('<span id="paymentMethods_select_info" class="select_info"></span>');
                }
                updatePaymentMethodsSelectInfo();
            },
            columnDefs: [
                {
                    targets: 0,
                    width: "7%",
//                    width: "55px",
                    render: function (data, type, row, meta) {
                        if (type === 'display') {
                            data = '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>';
                        }

                        return data;
                    },
                    checkboxes: {
                        selectRow: true,
                        selectAllRender: '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>',
                        selectCallback: function (nodes, selected) {

                            var index;
                            if (nodes.selector.rows) {

                                if (paymentMethods.type === 'unselected') {
                                    index = paymentMethods.data.indexOf(nodes.ajax.json().data[nodes.selector.rows].name);

                                    if (selected) {
                                        if (index > -1) {
                                            paymentMethods.data.splice(index, 1);
                                        }
                                    } else {
                                        if (index === -1) {
                                            paymentMethods.data.push(nodes.ajax.json().data[nodes.selector.rows].name);
                                        }
                                    }
                                } else {
                                    index = paymentMethods.data.indexOf(nodes.ajax.json().data[nodes.selector.rows].name);
//                                            
                                    if (selected) {
                                        if (index === -1) {
                                            paymentMethods.data.push(nodes.ajax.json().data[nodes.selector.rows].name);
                                        }
                                    } else {

                                        if (index > -1) {
                                            paymentMethods.data.splice(index, 1);
                                        }
                                    }
                                }
                                updatePaymentMethodsSelectInfo();
                            }
                        },
                        selectAllCallback: function (nodes, selected, indeterminate) {
                            if (!indeterminate && allPaymentMethodsClicked) {
                                if (selected) {
                                    paymentMethods.type = 'unselected';
                                } else {
                                    paymentMethods.type = 'selected';
                                }
                                paymentMethods.data = [];
                                allPaymentMethodsClicked = false;
                            }
                            updatePaymentMethodsSelectInfo();

                            if (!indeterminate && paymentMethods.data.length !== 0 && parseInt(paymentMethods.total) !== paymentMethods.data.length) {
                                $('#paymentMethods_table thead .dt-checkboxes').prop('indeterminate', true);
                            }
                        }
                    },
                    'createdCell': function (td, cellData, rowData, row, col) {

                        if (paymentMethods.type === 'unselected') {

                            if (paymentMethods.data.includes(rowData.name)) {
                                this.api().cell(td).checkboxes.deselect();
                            } else {
                                this.api().cell(td).checkboxes.select();
                            }
                        } else {
                            if (paymentMethods.data.includes(rowData.name)) {
                                this.api().cell(td).checkboxes.select();
                            } else {
                                this.api().cell(td).checkboxes.deselect();
                            }
                        }
                    }
                },
                {
                    targets: 1,
                    width: "10%"
                },
                {
                    targets: 2,
//                    width: "30%",
                    orderable: false,
                    className: "dt-center",
                    render: function (data, type, row, meta) {
                        return data ? data : '';
                    }
                }
            ],
            select: {
                style: 'os multi',
                info: false
            }
        });


        paymentMethodsTable.on('xhr', function () {
            var json = paymentMethodsTable.ajax.json();
            paymentMethods.total = json.recordsTotal;
        });

        $('#paymentMethods_table th.dt-checkboxes-select-all').click(function () {
            allPaymentMethodsClicked = true;
        });
        $('#ctrl-show-selected-paymentMethods').on('change', function () {
            paymentMethodsTable.ajax.reload();
        });

        var collectPaymentMethods = function () {
            $('input[name="payment_methods_type"]').remove();
            $('input[name="payment_methods_data"]').remove();
            $('#data_export_form').append($("<input>")
                    .attr("type", "hidden")
                    .attr("name", "payment_methods_type").val(paymentMethods.type));
            $('#data_export_form').append($("<input>")
                    .attr("type", "hidden")
                    .attr("name", "payment_methods_data").val(paymentMethods.data));
        };
    }


    if (typeof setManufacturersTable !== 'undefined') {

        function updateManufacturersSelectInfo() {
            $('#manufacturers_select_info').text(manufacturers.type === 'selected' ? manufacturers.data.length + ' rows selected' : manufacturers.total - manufacturers.data.length + ' rows selected');

        }

        var manufacturers = {type: "unselected", data: [], total: 0, filtered: 0};
        var allManufacturersClicked = false;

        var manufacturersTable = $('#manufacturers_table').DataTable({
            order: [[1, 'asc']],
            bAutoWidth: false,
            processing: true,
            serverSide: true,
            ajax: {
                url: ajax_fetch_url,
                type: "POST",
                data: function (d) {
                    d.ajax_action = 'getManufacturers';
                    d.extra_search_type = $('#ctrl-show-selected-manufacturers').val();
                    d.extra_search_params = {type: manufacturers.type, data: manufacturers.data};
                }
            },
            language: {
                select: {
                    rows: {
                        '_': ''
                    }
                }
            },
            columns: [
                {data: "id"},
                {data: "id"},
                {data: "logo"},
                {data: "name"}
            ],
            stateSave: true,
            stateSaveCallback: function (settings, data) {
//                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data));
            },
            stateLoadCallback: function (settings) {
//                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance));
            },
            drawCallback: function (settings) {
                if ($('#manufacturers_select_info').length === 0) {
                    $('#manufacturers_table_info').append('<span id="manufacturers_select_info" class="select_info"></span>');
                }
                updateManufacturersSelectInfo();
            },
            columnDefs: [
                {
                    targets: 0,
                    width: "7%",
//                    width: "55px",
                    render: function (data, type, row, meta) {
                        if (type === 'display') {
                            data = '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>';
                        }

                        return data;
                    },
                    checkboxes: {
                        selectRow: true,
                        selectAllRender: '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>',
                        selectCallback: function (nodes, selected) {

                            var index;
                            if (nodes.selector.rows) {

                                if (manufacturers.type === 'unselected') {
                                    index = manufacturers.data.indexOf(nodes.ajax.json().data[nodes.selector.rows].id);

                                    if (selected) {
                                        if (index > -1) {
                                            manufacturers.data.splice(index, 1);
                                        }
                                    } else {
                                        if (index === -1) {
                                            manufacturers.data.push(nodes.ajax.json().data[nodes.selector.rows].id);
                                        }
                                    }
                                } else {
                                    index = manufacturers.data.indexOf(nodes.ajax.json().data[nodes.selector.rows].id);
//                                            
                                    if (selected) {
                                        if (index === -1) {
                                            manufacturers.data.push(nodes.ajax.json().data[nodes.selector.rows].id);
                                        }
                                    } else {

                                        if (index > -1) {
                                            manufacturers.data.splice(index, 1);
                                        }
                                    }
                                }
                                updateManufacturersSelectInfo();
                            }
                        },
                        selectAllCallback: function (nodes, selected, indeterminate) {
                            if (!indeterminate && allManufacturersClicked) {
                                if (selected) {
                                    manufacturers.type = 'unselected';
                                } else {
                                    manufacturers.type = 'selected';
                                }
                                manufacturers.data = [];
                                allManufacturersClicked = false;
                            }
                            updateManufacturersSelectInfo();

                            if (!indeterminate && manufacturers.data.length !== 0 && parseInt(manufacturers.total) !== manufacturers.data.length) {
                                $('#manufacturers_table thead .dt-checkboxes').prop('indeterminate', true);
                            }
                        }
                    },
                    'createdCell': function (td, cellData, rowData, row, col) {

                        if (manufacturers.type === 'unselected') {

                            if (manufacturers.data.includes(cellData)) {
                                this.api().cell(td).checkboxes.deselect();
                            } else {
                                this.api().cell(td).checkboxes.select();
                            }
                        } else {
                            if (manufacturers.data.includes(cellData)) {
                                this.api().cell(td).checkboxes.select();
                            } else {
                                this.api().cell(td).checkboxes.deselect();
                            }
                        }
                    }
                },
                {
                    targets: 1,
                    width: "15%"
                },
                {
                    targets: 2,
                    width: "30%",
                    orderable: false,
                    render: function (data, type, row, meta) {
                        return data ? data : '';
                    }
                }
            ],
            select: {
                style: 'os multi',
                info: false
            }
        });


        manufacturersTable.on('xhr', function () {
            var json = manufacturersTable.ajax.json();
            manufacturers.total = json.recordsTotal;
        });

        $('#manufacturers_table th.dt-checkboxes-select-all').click(function () {
            allManufacturersClicked = true;
        });
        $('#ctrl-show-selected-manufacturers').on('change', function () {
            manufacturersTable.ajax.reload();
        });

        var collectManufacturers = function () {
            $('input[name="manufacturers_type"]').remove();
            $('input[name="manufacturers_data"]').remove();
            $('#data_export_form').append($("<input>")
                    .attr("type", "hidden")
                    .attr("name", "manufacturers_type").val(manufacturers.type));
            $('#data_export_form').append($("<input>")
                    .attr("type", "hidden")
                    .attr("name", "manufacturers_data").val(manufacturers.data));
        };
    }

    if (typeof setSuppliersTable !== 'undefined') {

        function updateSuppliersSelectInfo() {
            $('#suppliers_select_info').text(suppliers.type === 'selected' ? suppliers.data.length + ' rows selected' : suppliers.total - suppliers.data.length + ' rows selected');

        }

        var suppliers = {type: "unselected", data: [], total: 0, filtered: 0};
        var allSuppliersClicked = false;

        var suppliersTable = $('#suppliers_table').DataTable({
            order: [[1, 'asc']],
            bAutoWidth: false,
            processing: true,
            serverSide: true,
            ajax: {
                url: ajax_fetch_url,
                type: "POST",
                data: function (d) {
                    d.ajax_action = 'getSuppliers';
                    d.extra_search_type = $('#ctrl-show-selected-suppliers').val();
                    d.extra_search_params = {type: suppliers.type, data: suppliers.data};
                }
            },
            language: {
                select: {
                    rows: {
                        '_': ''
                    }
                }
            },
            columns: [
                {data: "id"},
                {data: "id"},
                {data: "logo"},
                {data: "name"}
            ],
            stateSave: true,
            stateSaveCallback: function (settings, data) {
//                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data));
            },
            stateLoadCallback: function (settings) {
//                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance));
            },
            drawCallback: function (settings) {
                if ($('#suppliers_select_info').length === 0) {
                    $('#suppliers_table_info').append('<span id="suppliers_select_info" class="select_info"></span>');
                }
                updateSuppliersSelectInfo();
            },
            columnDefs: [
                {
                    targets: 0,
                    width: "7%",
//                    width: "55px",
                    render: function (data, type, row, meta) {
                        if (type === 'display') {
                            data = '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>';
                        }

                        return data;
                    },
                    checkboxes: {
                        selectRow: true,
                        selectAllRender: '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>',
                        selectCallback: function (nodes, selected) {

                            var index;
                            if (nodes.selector.rows) {

                                if (suppliers.type === 'unselected') {
                                    index = suppliers.data.indexOf(nodes.ajax.json().data[nodes.selector.rows].id);

                                    if (selected) {
                                        if (index > -1) {
                                            suppliers.data.splice(index, 1);
                                        }
                                    } else {
                                        if (index === -1) {
                                            suppliers.data.push(nodes.ajax.json().data[nodes.selector.rows].id);
                                        }
                                    }
                                } else {
                                    index = suppliers.data.indexOf(nodes.ajax.json().data[nodes.selector.rows].id);
//                                            
                                    if (selected) {
                                        if (index === -1) {
                                            suppliers.data.push(nodes.ajax.json().data[nodes.selector.rows].id);
                                        }
                                    } else {

                                        if (index > -1) {
                                            suppliers.data.splice(index, 1);
                                        }
                                    }
                                }
                                updateSuppliersSelectInfo();
                            }
                        },
                        selectAllCallback: function (nodes, selected, indeterminate) {
                            if (!indeterminate && allSuppliersClicked) {
                                if (selected) {
                                    suppliers.type = 'unselected';
                                } else {
                                    suppliers.type = 'selected';
                                }
                                suppliers.data = [];
                                allSuppliersClicked = false;
                            }
                            updateSuppliersSelectInfo();

                            if (!indeterminate && suppliers.data.length !== 0 && parseInt(suppliers.total) !== suppliers.data.length) {
                                $('#suppliers_table thead .dt-checkboxes').prop('indeterminate', true);
                            }
                        }
                    },
                    'createdCell': function (td, cellData, rowData, row, col) {

                        if (suppliers.type === 'unselected') {

                            if (suppliers.data.includes(cellData)) {
                                this.api().cell(td).checkboxes.deselect();
                            } else {
                                this.api().cell(td).checkboxes.select();
                            }
                        } else {
                            if (suppliers.data.includes(cellData)) {
                                this.api().cell(td).checkboxes.select();
                            } else {
                                this.api().cell(td).checkboxes.deselect();
                            }
                        }
                    }
                },
                {
                    targets: 1,
                    width: "15%"
                },
                {
                    targets: 2,
                    width: "30%",
                    orderable: false,
                    render: function (data, type, row, meta) {
                        return data ? data : '';
                    }
                }
            ],
            select: {
                style: 'os multi',
                info: false
            }
        });


        suppliersTable.on('xhr', function () {
            var json = suppliersTable.ajax.json();
            suppliers.total = json.recordsTotal;
        });

        $('#suppliers_table th.dt-checkboxes-select-all').click(function () {
            allSuppliersClicked = true;
        });
        $('#ctrl-show-selected-suppliers').on('change', function () {
            suppliersTable.ajax.reload();
        });

        var collectSuppliers = function () {
            $('input[name="suppliers_type"]').remove();
            $('input[name="suppliers_data"]').remove();
            $('#data_export_form').append($("<input>")
                    .attr("type", "hidden")
                    .attr("name", "suppliers_type").val(suppliers.type));
            $('#data_export_form').append($("<input>")
                    .attr("type", "hidden")
                    .attr("name", "suppliers_data").val(suppliers.data));
        };
    }

    if (typeof setCarriersTable !== 'undefined') {

        function updateCarriersSelectInfo() {
            $('#carriers_select_info').text(carriers.type === 'selected' ? carriers.data.length + ' rows selected' : carriers.total - carriers.data.length + ' rows selected');

        }

        var carriers = {type: "unselected", data: [], total: 0, filtered: 0};
        var allCarriersClicked = false;

        var carriersTable = $('#carriers_table').DataTable({
            order: [[1, 'asc']],
            bAutoWidth: false,
            processing: true,
            serverSide: true,
            ajax: {
                url: ajax_fetch_url,
                type: "POST",
                data: function (d) {
                    d.ajax_action = 'getCarriers';
                    d.extra_search_type = $('#ctrl-show-selected-carriers').val();
                    d.extra_search_params = {type: carriers.type, data: carriers.data};
                }
            },
            language: {
                select: {
                    rows: {
                        '_': ''
                    }
                }
            },
            columns: [
                {data: "reference"},
                {data: "id"},
                {data: "reference"},
                {data: "name"},
                {data: "logo"}
            ],
            stateSave: true,
            stateSaveCallback: function (settings, data) {
//                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data));
            },
            stateLoadCallback: function (settings) {
//                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance));
            },
            drawCallback: function (settings) {
                if ($('#carriers_select_info').length === 0) {
                    $('#carriers_table_info').append('<span id="carriers_select_info" class="select_info"></span>');
                }
                updateCarriersSelectInfo();
            },
            columnDefs: [
                {
                    targets: 0,
                    width: "7%",
//                    width: "55px",
                    render: function (data, type, row, meta) {
                        if (type === 'display') {
                            data = '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>';
                        }

                        return data;
                    },
                    checkboxes: {
                        selectRow: true,
                        selectAllRender: '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>',
                        selectCallback: function (nodes, selected) {

                            var index;
                            if (nodes.selector.rows) {

                                if (carriers.type === 'unselected') {
                                    index = carriers.data.indexOf(nodes.ajax.json().data[nodes.selector.rows].reference);

                                    if (selected) {
                                        if (index > -1) {
                                            carriers.data.splice(index, 1);
                                        }
                                    } else {
                                        if (index === -1) {
                                            carriers.data.push(nodes.ajax.json().data[nodes.selector.rows].reference);
                                        }
                                    }
                                } else {
                                    index = carriers.data.indexOf(nodes.ajax.json().data[nodes.selector.rows].reference);
//                                            
                                    if (selected) {
                                        if (index === -1) {
                                            carriers.data.push(nodes.ajax.json().data[nodes.selector.rows].reference);
                                        }
                                    } else {

                                        if (index > -1) {
                                            carriers.data.splice(index, 1);
                                        }
                                    }
                                }
                                updateCarriersSelectInfo();
                            }
                        },
                        selectAllCallback: function (nodes, selected, indeterminate) {
                            if (!indeterminate && allCarriersClicked) {
                                if (selected) {
                                    carriers.type = 'unselected';
                                } else {
                                    carriers.type = 'selected';
                                }
                                carriers.data = [];
                                allCarriersClicked = false;
                            }
                            updateCarriersSelectInfo();

                            if (!indeterminate && carriers.data.length !== 0 && parseInt(carriers.total) !== carriers.data.length) {
                                $('#carriers_table thead .dt-checkboxes').prop('indeterminate', true);
                            }
                        }
                    },
                    'createdCell': function (td, cellData, rowData, row, col) {

                        if (carriers.type === 'unselected') {

                            if (carriers.data.includes(cellData)) {
                                this.api().cell(td).checkboxes.deselect();
                            } else {
                                this.api().cell(td).checkboxes.select();
                            }
                        } else {
                            if (carriers.data.includes(cellData)) {
                                this.api().cell(td).checkboxes.select();
                            } else {
                                this.api().cell(td).checkboxes.deselect();
                            }
                        }
                    }
                },
                {
                    targets: 1,
                    width: "15%"
                },
                {
                    targets: 2,
                    width: "15%"
                },
                {
                    targets: 4,
//                    width: "90px",
                    className: "dt-center",
                    orderable: false,
                    render: function (data, type, row, meta) {
                        return data ? data : '';
                    }
                }
            ],
            select: {
                style: 'os multi',
                info: false
            }
        });


        carriersTable.on('xhr', function () {
            var json = carriersTable.ajax.json();
            carriers.total = json.recordsTotal;
        });

        $('#carriers_table th.dt-checkboxes-select-all').click(function () {
            allCarriersClicked = true;
        });
        $('#ctrl-show-selected-carriers').on('change', function () {
            carriersTable.ajax.reload();
        });

        var collectCarriers = function () {
            $('input[name="carriers_type"]').remove();
            $('input[name="carriers_data"]').remove();
            $('#data_export_form').append($("<input>")
                    .attr("type", "hidden")
                    .attr("name", "carriers_type").val(carriers.type));
            $('#data_export_form').append($("<input>")
                    .attr("type", "hidden")
                    .attr("name", "carriers_data").val(carriers.data));
        };
    }

    if (typeof setShopsTable !== 'undefined') {

        function updateShopsSelectInfo() {
            $('#shops_select_info').text(shops.type === 'selected' ? shops.data.length + ' rows selected' : shops.total - shops.data.length + ' rows selected');

        }

        var shops = {type: "unselected", data: [], total: 0, filtered: 0};
        var allShopsClicked = false;

        var shopsTable = $('#shops_table').DataTable({
            order: [[1, 'asc']],
            bAutoWidth: false,
            processing: true,
            serverSide: true,
            lengthMenu: [10, 25, 50, 100, 250, 500, 1000],
            ajax: {
                url: ajax_fetch_url,
                type: "POST",
                data: function (d) {
                    d.ajax_action = 'getShops';
                    d.extra_search_type = $('#ctrl-show-selected-shops').val();
                    d.extra_search_params = {type: shops.type, data: shops.data};
                }
            },
            language: {
                select: {
                    rows: {
                        '_': ''
                    }
                }
            },
            columns: [
                {data: "id"},
                {data: "id"},
                {data: "name"},
                {data: "sg_name"}
            ],
            stateSave: true,
            stateSaveCallback: function (settings, data) {
//                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data));
            },
            stateLoadCallback: function (settings) {
//                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance));
            },
            drawCallback: function (settings) {
                if ($('#shops_select_info').length === 0) {
                    $('#shops_table_info').append('<span id="shops_select_info" class="select_info"></span>');
                }
                updateShopsSelectInfo();
            },
            columnDefs: [
                {
                    targets: 0,
                    width: "70px",
//                    width: "55px",
                    render: function (data, type, row, meta) {
                        if (type === 'display') {
                            data = '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>';
                        }

                        return data;
                    },
                    checkboxes: {
                        selectRow: true,
                        selectAllRender: '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>',
                        selectCallback: function (nodes, selected) {

                            var index;
                            if (nodes.selector.rows) {

                                if (shops.type === 'unselected') {
                                    index = shops.data.indexOf(nodes.ajax.json().data[nodes.selector.rows].id);

                                    if (selected) {
                                        if (index > -1) {
                                            shops.data.splice(index, 1);
                                        }
                                    } else {
                                        if (index === -1) {
                                            shops.data.push(nodes.ajax.json().data[nodes.selector.rows].id);
                                        }
                                    }
                                } else {
                                    index = shops.data.indexOf(nodes.ajax.json().data[nodes.selector.rows].id);
//                                            
                                    if (selected) {
                                        if (index === -1) {
                                            shops.data.push(nodes.ajax.json().data[nodes.selector.rows].id);
                                        }
                                    } else {

                                        if (index > -1) {
                                            shops.data.splice(index, 1);
                                        }
                                    }
                                }
                                updateShopsSelectInfo();
                            }
                        },
                        selectAllCallback: function (nodes, selected, indeterminate) {
                            if (!indeterminate && allShopsClicked) {
                                if (selected) {
                                    shops.type = 'unselected';
                                } else {
                                    shops.type = 'selected';
                                }
                                shops.data = [];
                                allShopsClicked = false;
                            }
                            updateShopsSelectInfo();

                            if (!indeterminate && shops.data.length !== 0 && parseInt(shops.total) !== shops.data.length) {
                                $('#shops_table thead .dt-checkboxes').prop('indeterminate', true);
                            }
                        }
                    },
                    'createdCell': function (td, cellData, rowData, row, col) {

                        if (shops.type === 'unselected') {

                            if (shops.data.includes(cellData)) {
                                this.api().cell(td).checkboxes.deselect();
                            } else {
                                this.api().cell(td).checkboxes.select();
                            }
                        } else {
                            if (shops.data.includes(cellData)) {
                                this.api().cell(td).checkboxes.select();
                            } else {
                                this.api().cell(td).checkboxes.deselect();
                            }
                        }
                    }
                },
                {
                    targets: 1,
                    width: "70px"
                }
            ],
            select: {
                style: 'os multi',
                info: false
            }
        });


        shopsTable.on('xhr', function () {
            var json = shopsTable.ajax.json();
            shops.total = json.recordsTotal;
        });

        $('#shops_table th.dt-checkboxes-select-all').click(function () {
            allShopsClicked = true;
        });
        $('#ctrl-show-selected-shops').on('change', function () {
            shopsTable.ajax.reload();
        });

        var collectShops = function () {
            $('input[name="shops_type"]').remove();
            $('input[name="shops_data"]').remove();
            $('#data_export_form').append($("<input>")
                    .attr("type", "hidden")
                    .attr("name", "shops_type").val(shops.type));
            $('#data_export_form').append($("<input>")
                    .attr("type", "hidden")
                    .attr("name", "shops_data").val(shops.data));
        };
    }

    if (typeof setCurrenciesTable !== 'undefined') {

        function updateCurrenciesSelectInfo() {
            $('#currencies_select_info').text(currencies.type === 'selected' ? currencies.data.length + ' rows selected' : currencies.total - currencies.data.length + ' rows selected');

        }

        var currencies = {type: "unselected", data: [], total: 0, filtered: 0};
        var allCurrenciesClicked = false;

        var currenciesTable = $('#currencies_table').DataTable({
            order: [[1, 'asc']],
            bAutoWidth: false,
            processing: true,
            serverSide: true,
            ajax: {
                url: ajax_fetch_url,
                type: "POST",
                data: function (d) {
                    d.ajax_action = 'getCurrencies';
                    d.extra_search_type = $('#ctrl-show-selected-currencies').val();
                    d.extra_search_params = {type: currencies.type, data: currencies.data};
                }
            },
            language: {
                select: {
                    rows: {
                        '_': ''
                    }
                }
            },
            columns: [
                {data: "id"},
                {data: "id"},
                {data: "name"},
                {data: "iso_code"}
            ],
            stateSave: true,
            stateSaveCallback: function (settings, data) {
//                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data));
            },
            stateLoadCallback: function (settings) {
//                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance));
            },
            drawCallback: function (settings) {
                if ($('#currencies_select_info').length === 0) {
                    $('#currencies_table_info').append('<span id="currencies_select_info" class="select_info"></span>');
                }
                updateCurrenciesSelectInfo();
            },
            columnDefs: [
                {
                    targets: 0,
                    width: "7%",
//                    width: "55px",
                    render: function (data, type, row, meta) {
                        if (type === 'display') {
                            data = '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>';
                        }

                        return data;
                    },
                    checkboxes: {
                        selectRow: true,
                        selectAllRender: '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>',
                        selectCallback: function (nodes, selected) {

                            var index;
                            if (nodes.selector.rows) {

                                if (currencies.type === 'unselected') {
                                    index = currencies.data.indexOf(nodes.ajax.json().data[nodes.selector.rows].id);

                                    if (selected) {
                                        if (index > -1) {
                                            currencies.data.splice(index, 1);
                                        }
                                    } else {
                                        if (index === -1) {
                                            currencies.data.push(nodes.ajax.json().data[nodes.selector.rows].id);
                                        }
                                    }
                                } else {
                                    index = currencies.data.indexOf(nodes.ajax.json().data[nodes.selector.rows].id);
//                                            
                                    if (selected) {
                                        if (index === -1) {
                                            currencies.data.push(nodes.ajax.json().data[nodes.selector.rows].id);
                                        }
                                    } else {

                                        if (index > -1) {
                                            currencies.data.splice(index, 1);
                                        }
                                    }
                                }
                                updateCurrenciesSelectInfo();
                            }
                        },
                        selectAllCallback: function (nodes, selected, indeterminate) {
                            if (!indeterminate && allCurrenciesClicked) {
                                if (selected) {
                                    currencies.type = 'unselected';
                                } else {
                                    currencies.type = 'selected';
                                }
                                currencies.data = [];
                                allCurrenciesClicked = false;
                            }
                            updateCurrenciesSelectInfo();

                            if (!indeterminate && currencies.data.length !== 0 && parseInt(currencies.total) !== currencies.data.length) {
                                $('#currencies_table thead .dt-checkboxes').prop('indeterminate', true);
                            }
                        }
                    },
                    'createdCell': function (td, cellData, rowData, row, col) {

                        if (currencies.type === 'unselected') {

                            if (currencies.data.includes(cellData)) {
                                this.api().cell(td).checkboxes.deselect();
                            } else {
                                this.api().cell(td).checkboxes.select();
                            }
                        } else {
                            if (currencies.data.includes(cellData)) {
                                this.api().cell(td).checkboxes.select();
                            } else {
                                this.api().cell(td).checkboxes.deselect();
                            }
                        }
                    }
                },
                {
                    targets: 1,
                    width: "10%"
                },
//                {
//                    targets: 2,
//                    width: "50%",
//                    render: function (data, type, row, meta) {
//                        return '<span class="label color_field" style="background-color:' + row.color + ';color:' + row.font_color + ';">' + data + '</span>';
//                    }
//                },
//                {
//                    targets: 3,
//                    orderable: false,
//                    render: function (data, type, row, meta) {
//
//                        var http = new XMLHttpRequest();
//                        http.open('HEAD', data, false);
//                        http.send();
//
//                        return http.status !== 404 ? '<img src="' + data + '" />' : '';
//                    }
//                }
            ],
            select: {
                style: 'os multi',
                info: false
            }
        });


        currenciesTable.on('xhr', function () {
            var json = currenciesTable.ajax.json();
            currencies.total = json.recordsTotal;
        });

        $('#currencies_table th.dt-checkboxes-select-all').click(function () {
            allCurrenciesClicked = true;
        });
        $('#ctrl-show-selected-currencies').on('change', function () {
            currenciesTable.ajax.reload();
        });

        var collectCurrencies = function () {
            $('input[name="currencies_type"]').remove();
            $('input[name="currencies_data"]').remove();
            $('#data_export_form').append($("<input>")
                    .attr("type", "hidden")
                    .attr("name", "currencies_type").val(currencies.type));
            $('#data_export_form').append($("<input>")
                    .attr("type", "hidden")
                    .attr("name", "currencies_data").val(currencies.data));
        };
    }

});