<?php

/**
 *
 * NOTICE OF LICENSE
 *
 *  @author    IntelliPresta <tehran.alishov@gmail.com>
 *  @copyright 2019 IntelliPresta
 *  @license   Commercial License
 */
class AdminOrdersExportProController extends ModuleAdminController
{

    public function init()
    {
        $actions_list = array(
            'getFile' => 'getFile',
            'getDoc'  => 'getDoc'
        );
        $action = Tools::getValue('action');
        if (isset($actions_list[$action])) {
            $this->{$actions_list[$action]}();
        }
        parent::init();
    }

    private function getConfig()
    {
        return DB::getInstance()->executeS('SELECT *, "' . $this->l('delete') . '" `title` FROM `'
                . _DB_PREFIX_ . 'orders_export_pro`
                                               WHERE name <> "orders_default"
                                               ORDER BY `id_orders_export_pro` DESC;');
    }

    public function setMedia($isNewTheme = false)
    {
        // We call the parent method
        parent::setMedia($isNewTheme);
        $this->bootstrap = true;
        // Save the module path in a variable
        $this->path = __PS_BASE_URI__ . 'modules/ordersexportpro/';
        // Include the module CSS and JS files needed
        if (version_compare(_PS_VERSION_, '1.6.0.5') === -1) {
            $this->context->controller->addJS($this->path . 'views/js/bootstrap.min.js');
            $this->context->controller->addJQueryUI('ui.datepicker');
            $this->context->controller->addCSS($this->path . 'views/css/bootstrap.min.css', 'all');
            $this->context->controller->addCSS($this->path . 'views/css/font.css', 'all');
            $this->context->controller->addCSS($this->path . 'views/css/1.5.css', 'all');
        }
        $this->context->controller->addJquery();
        $this->context->controller->addJS($this->path . 'views/js/datatables.min.js');
        $this->context->controller->addJS($this->path . 'views/js/dataTables.checkboxes.min.js');
        $this->context->controller->addJS($this->path . 'views/js/orders_export.js');
        $this->context->controller->addJQueryUI('ui.sortable');
//            $this->context->controller->addCSS($this->path.'views/css/font-awesome.min.css', 'all');
        $this->context->controller->addCSS($this->path . 'views/css/datatables.min.css', 'all');
        $this->context->controller->addCSS($this->path . 'views/css/dataTables.checkboxes.css', 'all');
//            $this->context->controller->addCSS($this->path.'views/css/awesome-bootstrap-checkbox.css', 'all');
        $this->context->controller->addCSS($this->path . 'views/css/orders_export.css', 'all');
        $this->context->controller->addJqueryPlugin('tagify');
    }

    public function initContent()
    {

        parent::initContent();

        error_reporting(0);
        ini_set('max_execution_time', 0);
//        $order = new Order(1);
//        $this->hookActionValidateOrder(array('order' => $order));
        /*
         * If values have been submitted in the form, process.
         */
        if ((bool) Tools::isSubmit('orders_export_as')) {
            $this->doExport();
            exit;
        } elseif ((bool) Tools::isSubmit('ajax_action')) {
            $action = Tools::getValue('ajax_action');
            if (method_exists($this, $action)) {
                $this->{$action}();
            }
        }

        $lang_id = $this->context->language->id;
        $schedule_url = $this->context->link->getModuleLink('ordersexportpro', 'export', array('schedule' => md5(Configuration::get('OXP_SECURE_KEY'))));

        $this->context->smarty->assign(array(
            'show_id_tax_rule_group'        => version_compare(_PS_VERSION_, '1.6.1.0'),
            'show_orijinal_wholesale_price' => version_compare(_PS_VERSION_, '1.6.1.3'),
            'lang_id'                       => $lang_id,
            'lang_iso_code'                 => $this->context->language->iso_code,
            'languages'                     => $this->context->controller->getLanguages(),
//            'customers' => $customers,
//            'order_states' => $order_states,
//            'payment_methods' => PaymentModule::getInstalledPaymentModules(),
//            'payment_methods' => $payment_methods,
//            'carriers' => $carriers,
//            'shops' => $shops,
//            'currencies' => $currencies,
//            'manufacturers' => $manufacturers,
//            'suppliers' => $suppliers,
            'module_dir'                    => __PS_BASE_URI__ . 'modules/ordersexportpro/',
            'configs'                       => $this->getConfig(),
            'doc_link'                      => $this->context->link->getAdminLink('AdminOrdersExportPro'),
//            'from_email' => Configuration::get('ORDERSEXPORTPRO_FROM_EMAIL'),
            'autoexport_enabled'            => Configuration::get('OXP_AUTOEXP_ENABLE'),
            'autoexport_email_enabled'      => Configuration::get('OXP_AUTOEXP_USE_EMAIL'),
            'autoexport_to_emails'          => Configuration::get('OXP_AUTOEXP_EMAILS'),
            'autoexport_ftp_enabled'        => Configuration::get('OXP_AUTOEXP_USE_FTP'),
            'autoexport_ftp_type'           => Configuration::get('OXP_AUTOEXP_FTP_TYPE'),
            'autoexport_ftp_url'            => Configuration::get('OXP_AUTOEXP_FTP_URL'),
            'autoexport_ftp_port'           => Configuration::get('OXP_AUTOEXP_FTP_PORT'),
            'autoexport_ftp_usrnm'          => Configuration::get('OXP_AUTOEXP_FTP_USRNM'),
            'autoexport_ftp_pswd'           => Configuration::get('OXP_AUTOEXP_FTP_PSWD'),
            'autoexport_ftp_file_path'      => Configuration::get('OXP_AUTOEXP_FTP_FL_PTH'),
            'autoexport_ftp_add_ts'         => Configuration::get('OXP_AUTOEXP_ADD_TS'),
            'autoexport_setting'            => Configuration::get('OXP_AUTOEXP_SETTING'),
            'schedule_enabled'              => Configuration::get('OXP_SCHDL_ENABLE'),
            'schedule_email_enabled'        => Configuration::get('OXP_SCHDL_USE_EMAIL'),
            'schedule_to_emails'            => Configuration::get('OXP_SCHDL_EMAILS'),
            'schedule_ftp_enabled'          => Configuration::get('OXP_SCHDL_USE_FTP'),
            'schedule_ftp_type'             => Configuration::get('OXP_SCHDL_FTP_TYPE'),
            'schedule_ftp_url'              => Configuration::get('OXP_SCHDL_FTP_URL'),
            'schedule_ftp_port'             => Configuration::get('OXP_SCHDL_FTP_PORT'),
            'schedule_ftp_usrnm'            => Configuration::get('OXP_SCHDL_FTP_USRNM'),
            'schedule_ftp_pswd'             => Configuration::get('OXP_SCHDL_FTP_PSWD'),
            'schedule_ftp_file_path'        => Configuration::get('OXP_SCHDL_FTP_FL_PTH'),
            'schedule_ftp_add_ts'           => Configuration::get('OXP_SCHDL_ADD_TS'),
            'schedule_setting'              => Configuration::get('OXP_SCHDL_SETTING'),
            'schedule_url'                  => $schedule_url,
            'ajax_fetch_url'                => $this->context->link->getAdminLink('AdminModules') . '&configure=' . $this->module->name
        ));
        $template_file = dirname(__FILE__) . '/../../views/templates/admin/export.tpl';
        $content = $this->context->smarty->fetch($template_file);
        $this->context->smarty->assign(array(
            'content' => $content,
        ));
    }

    private function getFile()
    {
        $id = pSQL(Tools::getValue('id'));
        $type = pSQL(Tools::getValue('type'));
        $name = pSQL(Tools::getValue('name'));
        $filePath = realpath(dirname(__FILE__) . '/../../output/' . $id . '.' . ($type === 'excel' ? 'xlsx' : $type));
        $size = filesize($filePath);

        if (file_exists($filePath)) {
            if ($type === 'excel') {
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header('Content-Disposition: attachment; filename="' . $name . '.xlsx"');
            } elseif ($type === 'csv') {
                header('Content-Type: text/csv');
                header('Content-Disposition: attachment; filename="' . $name . '.csv"');
            } elseif ($type === 'pdf') {
                $pdf_action = pSQL(Tools::getValue('pdf_action'));
                header('Content-Type: application/pdf');
                if ($pdf_action === 'download') {
                    header('Content-Disposition: attachment; filename="' . $name . '.pdf"');
                } else {
                    header('Content-Disposition: inline; filename="' . $name . '.pdf"');
                }
            }
            header('Content-Length: ' . $size);

            header('Cache-Control: max-age=0');
            // If you're serving to IE 9, then the following may be needed
//            header('Cache-Control: max-age=1');
            // If you're serving to IE over SSL, then the following may be needed
            header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
            header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
            header('Cache-Control: cache, must-revalidate'); // HTTP/1.1

            header('Pragma: public'); // HTTP/1.0
            readfile($filePath);
            unlink($filePath);
            die;
        } else {
            die($this->l("File doesn't exist."));
        }
    }

    private function getDoc()
    {
        $lang = pSQL(Tools::getValue('lang'));
        $file_path = realpath(dirname(__FILE__) . '/../../doc/readme_' . $lang . '.pdf');
        if (file_exists($file_path)) {
            header('Content-type:application/pdf');
            header('Content-Disposition:inline;filename="Orders Export Pro"');
            readfile($file_path);
            die;
        } else {
            die($this->l("File doesn't exist."));
        }
    }

}
