<?php
/**
 * 2012-2018 NetReviews.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    NetReviews SAS <contact@avis-verifies.com>
 * @copyright 2012-2018 NetReviews SAS
 * @license   NetReviews
 *
 * @version   Release: $Revision: 7.9.8
 *
 * @date      02/03/2022
 *  International Registered Trademark & Property of NetReviews SAS
 */
require_once _PS_MODULE_DIR_ . 'netreviews/netreviews.php';

class NetreviewsAjaxModuleFrontController extends ModuleFrontController
{
    public function initContent()
    {
        parent::initContent();

        if (Tools::getValue('ajax')) {
            $consent = Tools::getValue('collect_consent');
            $idShop = (int) Tools::getValue('idShop');
            $groupName = Tools::getValue('groupName');
            $idCustomer = (int) Tools::getValue('idCustomer');
            echo $consent;

            $netreviews = new Netreviews();
            $order = $netreviews->getLastIdOrder($idShop, $idCustomer);
            $idOrder = $order['id_order'];

            if ('no' == $consent) {
                if ('checked' == Configuration::get('AV_MULTILINGUE', null, null, $idShop)) {
                    $key = 'AV_CONSENT_ANSWER_NO' . $groupName;
                } else {
                    $key = 'AV_CONSENT_ANSWER_NO';
                }
                echo $key;

                if (Configuration::hasKey($key, null, null, $idShop)) {
                    $value = json_decode(Configuration::get($key, null, null, $idShop, false), true);
                    $values = array_values($value);
                    $values[] = (int) $idOrder;
                } else {
                    $values = [];
                    $values[] = (int) $idOrder;
                }
                Configuration::updateValue($key, json_encode($values), false, null, $idShop);
            }

            exit(json_encode($consent));
        }
    }
}
