/**
 *  Please read the terms of the CLUF license attached to this module(cf "licences" folder)
 *
 *  @author    Línea Gráfica E.C.E. S.L.
 *  @copyright Lineagrafica.es - Línea Gráfica E.C.E. S.L. all rights reserved.
 *  @license   https://www.lineagrafica.es/licenses/license_en.pdf
 *             https://www.lineagrafica.es/licenses/license_es.pdf
 *             https://www.lineagrafica.es/licenses/license_fr.pdf
 */

$(document).on('change','form.lgsitemaps #entity', function() {
    $.ajax({
        url : './index.php',
        method: 'get',
        dataType: 'json',
        cache: false,
        data: {
            'ajax' : 1,
            'controller' : 'AdminModules',
            'module_name' : 'lgsitemaps',
            'configure' : 'lgsitemaps',
            'action' : 'getImageTypes',
            'token' : lgsitemaps_token,
            'lgsitemaps_token' : lgsitemaps_token2,
            'entity' : $(this).val(),
            'rand': new Date().getTime()
        }
    }).success(function(response) {
        if (typeof response != "undefined") {
            if (typeof response.status != "undefined" && response.status == "OK") {
                $('#imagesize').html(response.html);
            } else {
                showErrorMessage(lgsitemaps_error_unknown_error);
            }
        } else {
            showErrorMessage(lgsitemaps_error_unknown_error);
        }
    }).error(function(response) {
        showErrorMessage(lgsitemaps_error_unknown_error);
    });
});