<?php
/**
 *  Please read the terms of the CLUF license attached to this module(cf "licences" folder)
 *
 * @author    Línea Gráfica E.C.E. S.L.
 * @copyright Lineagrafica.es - Línea Gráfica E.C.E. S.L. all rights reserved.
 * @license   https://www.lineagrafica.es/licenses/license_en.pdf
 *            https://www.lineagrafica.es/licenses/license_es.pdf
 *            https://www.lineagrafica.es/licenses/license_fr.pdf
 */

include_once(_PS_MODULE_DIR_.'lgsitemaps'.DIRECTORY_SEPARATOR.'classes'.DIRECTORY_SEPARATOR.'SitemapCron.php');

class LGSitemapsSitemapModuleFrontController extends ModuleFrontController
{
    public function __construct()
    {
        $this->content_only = true;
        $this->display_header = false;
        $this->display_footer = false;
        $this->display_header_javascript = false;
        $this->ajax = true;

        parent::__construct();
    }

    public function initContent()
    {
        ob_end_clean();
        ob_start();

        if (!Tools::getIsset('cron')) {
            $name = Tools::getValue('name');

            if (!Tools::getIsset('xsl')) {
                $path = _PS_MODULE_DIR_.'lgsitemaps/'.str_replace('.xml', '', $name).'.xml';
            } else {
                $path = _PS_MODULE_DIR_.'lgsitemaps/sitemap.xsl';
            }

            if ((method_exists('Tools', 'file_exists_no_cache') && Tools::file_exists_no_cache($path)) ||
                file_exists($path)
            ) {
                //header('Content-Type: application/xml; charset=utf-8');
                header('Content-Type: application/xml');
                header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
                header("Cache-Control: post-check=0, pre-check=0", false);
                header("Pragma: no-cache");
                $this->setResponseHeaders(200);
                $string = Tools::file_get_contents($path);
                echo $string;
            } else {
                header('Content-Type: text/html; charset=utf-8');
                header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
                header("Cache-Control: post-check=0, pre-check=0", false);
                header("Pragma: no-cache");
                $this->setResponseHeaders(404);
                echo $this->module->l('No sitemap found with this name');
            }
        } else {
            header('Content-Type: application/json');
            header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
            header("Cache-Control: post-check=0, pre-check=0", false);
            header("Pragma: no-cache");
            if (Tools::getIsset('generate')) {
                $this->setResponseHeaders(200);
                $sitemap = new SitemapCron(Tools::getValue('id_lg_sitemaps', 0));
                $sitemap->runInBackground(Tools::getValue('cron'));
            }
        }
        die();
    }

    /**
     * return de Ajax response
     *
     * @param $response
     * @param int $status_code
     */
    public function setResponseHeaders($status_code = 200)
    {
        if (!headers_sent()) {
            self::httpResponseCode($status_code);
        }
    }

    /**
     * set response code according to php version
     *
     * @param null $code
     * @return int|null
     */
    public static function httpResponseCode($code = null)
    {
        if (!function_exists('http_response_code')) {
            if ($code !== null) {
                switch ($code) {
                    case 100:
                        $text = 'Continue';
                        break;
                    case 101:
                        $text = 'Switching Protocols';
                        break;
                    case 200:
                        $text = 'OK';
                        break;
                    case 201:
                        $text = 'Created';
                        break;
                    case 202:
                        $text = 'Accepted';
                        break;
                    case 203:
                        $text = 'Non-Authoritative Information';
                        break;
                    case 204:
                        $text = 'No Content';
                        break;
                    case 205:
                        $text = 'Reset Content';
                        break;
                    case 206:
                        $text = 'Partial Content';
                        break;
                    case 300:
                        $text = 'Multiple Choices';
                        break;
                    case 301:
                        $text = 'Moved Permanently';
                        break;
                    case 302:
                        $text = 'Moved Temporarily';
                        break;
                    case 303:
                        $text = 'See Other';
                        break;
                    case 304:
                        $text = 'Not Modified';
                        break;
                    case 305:
                        $text = 'Use Proxy';
                        break;
                    case 400:
                        $text = 'Bad Request';
                        break;
                    case 401:
                        $text = 'Unauthorized';
                        break;
                    case 402:
                        $text = 'Payment Required';
                        break;
                    case 403:
                        $text = 'Forbidden';
                        break;
                    case 404:
                        $text = 'Not Found';
                        break;
                    case 405:
                        $text = 'Method Not Allowed';
                        break;
                    case 406:
                        $text = 'Not Acceptable';
                        break;
                    case 407:
                        $text = 'Proxy Authentication Required';
                        break;
                    case 408:
                        $text = 'Request Time-out';
                        break;
                    case 409:
                        $text = 'Conflict';
                        break;
                    case 410:
                        $text = 'Gone';
                        break;
                    case 411:
                        $text = 'Length Required';
                        break;
                    case 412:
                        $text = 'Precondition Failed';
                        break;
                    case 413:
                        $text = 'Request Entity Too Large';
                        break;
                    case 414:
                        $text = 'Request-URI Too Large';
                        break;
                    case 415:
                        $text = 'Unsupported Media Type';
                        break;
                    case 500:
                        $text = 'Internal Server Error';
                        break;
                    case 501:
                        $text = 'Not Implemented';
                        break;
                    case 502:
                        $text = 'Bad Gateway';
                        break;
                    case 503:
                        $text = 'Service Unavailable';
                        break;
                    case 504:
                        $text = 'Gateway Time-out';
                        break;
                    case 505:
                        $text = 'HTTP Version not supported';
                        break;
                    default:
                        $text = 'unknown';
                        break;
                }
                if ($text == 'unknown') {
                    exit('Unknown http status code "' . htmlentities($code) . '"');
                }
                $protocol = (isset($_SERVER['SERVER_PROTOCOL']) ? $_SERVER['SERVER_PROTOCOL'] : 'HTTP/1.0');
                header($protocol . ' ' . $code . ' ' . $text);
                $GLOBALS['http_response_code'] = $code;
            } else {
                $code = (isset($GLOBALS['http_response_code']) ? $GLOBALS['http_response_code'] : 200);
            }
            return $code;
        } else {
            http_response_code($code);
        }
    }
}
