<?php
/**
 *  Please read the terms of the CLUF license attached to this module(cf "licences" folder)
 *
 * @author    Línea Gráfica E.C.E. S.L.
 * @copyright Lineagrafica.es - Línea Gráfica E.C.E. S.L. all rights reserved.
 * @license   https://www.lineagrafica.es/licenses/license_en.pdf
 *            https://www.lineagrafica.es/licenses/license_es.pdf
 *            https://www.lineagrafica.es/licenses/license_fr.pdf
 */

include_once(_PS_MODULE_DIR_.'lgsitemaps'.DIRECTORY_SEPARATOR.'classes'.DIRECTORY_SEPARATOR.'SitemapCron.php');

class LGSitemapsCronModuleFrontController extends ModuleFrontController
{

    public $urls;
    public $sitemaps;

    public function __construct()
    {
        parent::__construct();
        $this->urls = array();
    }

    public function initContent()
    {
        parent::initContent();
        $crons = $this->getCronTasks();
        if (function_exists('curl_version')) {
            if (is_array($crons)) {
                foreach ($crons as $cron) {
                    $params = array();
                    $params['generate'] = 1;
                    $params['cron'] = 1;
                    $params['id_lg_sitemaps'] = $cron['id_sitemaps_cron'];
                    $url = $this->context->link->getModuleLink($this->module->name, 'sitemap', $params);
                    // echo $url;
                    $ch = curl_init($url);
                    echo $url;
                    if ($ch) {
                        if (!curl_setopt($ch, CURLOPT_HEADER, 0)) {
                            echo 'FAIL: curl_setopt(CURLOPT_HEADER)';
                        }

                        // Se pude devolver un valor convertible a booleano requiere un checkeo fuerte
                        if (curl_exec($ch) === false) {
                            echo 'FAIL: curl_exec()';
                        }
                        curl_close($ch);
                        echo 'SUCCESS:'.$cron['id_sitemaps_cron'];
                    } else {
                        echo 'FAIL: curl_init()';
                    }
                }
            } else {
                echo $this->module->l('No cron tasks found.');
            }
        } else {
            echo $this->module->l('Not curl extension found, cannot execute Cron Task');
        }
        die();
    }

    public function getCronTasks()
    {
        $query = new DBQuery();
        $query->from('lg_sitemaps_cron');
        return DB::getInstance()->executeS($query);
    }
}
