{*
* Page Cache Ultimate, Page Cache standard and Speed pack are powered by Jpresta (jpresta . com)
*
*    @author    Jpresta
*    @copyright Jpresta
*    @license   You are just allowed to modify this copy for your own use. You must not redistribute it. License
*               is permitted for one Prestashop instance only but you can install it on your test instances.
*}
<table id="pagecache_stats">
    <thead>
    <tr>
        <th colspan="2">
            <img
                    style="float: left; display: inline; width: 24px; height: 24px; margin-right: 5px" src="data:image/png;base64,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"
                    alt="" width="24" height="24"/>
            Page Cache Ultimate
            <div class="pcactions">
                <a href="{$url_on_off|escape:'html':'UTF-8'}" id="pc_btn_onoff" class="pagecache" title="{if $dbgpagecache eq '1'}{l s='Click to disable cache' mod='jprestaspeedpack'}{else}{l s='Click to enable cache' mod='jprestaspeedpack'}{/if}"><img src="{if $dbgpagecache eq '1'}data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYBAMAAAASWSDLAAAAGFBMVEUAAAAAAAAAAAAACwEALAYALQYAWgwAtRoYBxr9AAAAAnRSTlMA70YmMtEAAAAnSURBVBiVY2CgFIS4gIChIAgwKIE5SmDAoFYOAgPJQXGOC7JDKQUAiEIpgxadJPcAAAAASUVORK5CYII={else}data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAAVUlEQVRIx2NgGAXDHjAyMDC8J0WDGQODACnqWRhI1EAsOIXkg/+kaLxNpLpJDAwMkxkYGJhoHQejFoxaMGoBGTnZjMSigoWBgeEDiY4SoKZDRsEwAAAN4whhUFRB5gAAAABJRU5ErkJggg=={/if}" alt="" width="32" height="32/"></a>
                <a href="{$url_reload|escape:'html':'UTF-8'}" id="pc_btn_reload" class="pagecache" title="{l s='Reload this page, use browser cache if any' mod='jprestaspeedpack'}"><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAABmJLR0QA/wD/AP+gvaeTAAABfElEQVRIic2VvyuFURjHP9+nG0UWFhaJzY9SJhSx+gNktMtuuIvhTko3sSojmSwWiTD4AyzKcg1IXcpAl/c1eNXpdZzOvShPPcN7znM+32/nPc858A9jHJj8M7qkJ0mJmZWB5r8QSJ28AIZ+yuwGFiXtSDrNCaSSHoHZRsCdZrYpqeaBfkkzK9UDH5ZUiQE7WYmF90i6rRN+A0xF0SWdfAM5N7OyZ/wA6Ip1P+MBXANjjoHP8VegCFgsHEm7OfgzMJiruchE6242ZU3knowNT10hy6hwCzuAVncySZJ9z5rXWHheoM0zX41gyMxKaZqO8LELl0mSLABJvrAl/4OB+QiBOc+6Tr8V6SpXfAooaF868pw6f5jZqsfNUoBf9FwZ6yFDvZJePIu2gAGnrs/Mtj09UwP6QwKY2XLgSqhKeghceCtB+KeGp+Ficg9oihEAKJjZWiw82/eGXrcJSceS3jzgN0mHwHQIEDyCTnQBo0B79n0PnAF3jbj+1XgHKfq/BN1uAYoAAAAASUVORK5CYII=" alt="" width="32" height="32/"></a>
                <a href="{$url_del|escape:'html':'UTF-8'}" id="pc_btn_refresh" class="pagecache" title="{l s='Force this page to be generated (refresh cache)' mod='jprestaspeedpack'}"><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAABmJLR0QA/wD/AP+gvaeTAAABJklEQVRIie2VvUoDQRSFvxN/iqhBU0m6WBmQgBAfwjcQ38DUqeLz+ASCvZVgld7CMlamERVNuBa7K9dhd3YTYrcHhpmz9845s3fgDvwzVBI/As6B3YL4G3AHPK9i3pY0k2Ql4xXYLxLZjBgcu41PkiY+aGY94AQ4AHrAw7IGjXT+MrO+mX0G8aakGbANbBSJhAZN4DBddzIDtw7xnRp0SO4LYAp85CW3JL1UqHnZmAKtsAwABiyKfnUJLFKtXGwBo+w0wBi4dPwKGDp+AVw7Pko1ovACA5LSZbwLdB3fAwaOD0OxRvhh3agNaoPaIN6uIen17YArEq9k8NvwJN0A747f+kRJ98BO3t4Y+pLmK7TpOckL9wdFj/4pcFblNA6PwKQ0a934AcT/YhgYnBUrAAAAAElFTkSuQmCC" alt="" width="32" height="32/"></a>
                <a href="#" id="pc_btn_moreinfos" class="pagecache" title="{l s='Display more technical informations' mod='jprestaspeedpack'}" onclick="$('.pcadv').show();$('#pagecache_stats').css('width', 'inherit');return false;"><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAEcklEQVRIiY3WS2gcdRwH8FYpWPFxWDeb7Cb7mH3vzD5md3ZnZ9/v7DOeiloRCuJFBPGg3qrgRb0kh4pBPAlVKqIe9NwePChSEQ+tCEKRFjSxaayBxrj7//n9z74mSddk4M8e8uf/4fckJ04c4yukkqfq5ZK9VipLjWq11azVy+3l5Ui9UnwIvw8f541DXzmbOaUpyiOlbOblcj73QbVYuAvkj0a1stes1ajVqN9uN5e/77VaH3dbLW2l3TYf+/FcMvF4LqWczafVr4sZjcq57KCSz1GtVGT1cpktV6vUrNdYu9GgTrNJ3Xb7Xq/TWX+y11s58vFMPGbS4vJqRolfz6WSVEirrJTRGBCq5PPMiLTqddZpNAaIgCN7K93uzzjPz3w8GQ2bcFbVWPSGlpApm1RYXk1xhEaRcIRHMgBCI4RQB+JIr93uA/gL59yhx1Nh6XRCDL2ohKVfU9EwASEtEecIAWEj5LtyLncJyOdA/kRNZiHXcBr7gFjAZ4uHAt8AISUskgFhWSUxQLp28lr6aX4XgLlSyL8NpG9I1wRBunZ5TVY6nbkJEPV51oAQEHYYkVlGSdwFoo3vI5LzQMaFn0TSmSJ3EI2sXw57BCvOZSAMCANCQFhyiDBV1hGkK5EfA2jfC4bCkzESIExHWq1P9cshlyMnCs5+2OsmIMQjkYcIj4QlI3okDEhqDBS09LtAjIXvHyw8oCv65aDT3g257Lui20WIhEWARAO+y3LQvx4PBd9XJHEd3bUGRJgAafUMkI+AXES6PqkWCl8C2RkjoznZ0C8H7IuvBByLFHLaGSJhYbewG/G6z/C/CRbbA9NGCJ00NgaA04aaWIF8OGrh4TDWanf0P/oWra/7l2wEaABkAGRLcrvSMwdmxoeVcgGIPoyNCo+kMgS8tvlncfb8S1YGhJAuCrrsb0oeVyLsFZyoTQTpKhkfU+WIDzUxYeL96K5QIaPZitnMdURCY4TvLv2yx2pRce4BISA8Eg6QKDi2JY+wiZpsRf3eX2JBv8Tva6L9JLrrfFqO3gSyge7aBLLJhxE1YRzhLVwtFq/qgHveLOL85FmwDIwIIuHp4oUn1IQAKXoq1OSDmPiLqWiE0nJMnxPDxDOOlNBdgL6ahCxYnnhPsJgJCNuPOIaF9wi3caTx/bgYXFUiEuYkwoZI/ODu2kULV4xACufqCKH7RHJLFFyh8X3MyRoQzIjEppEMdxfS9S/WyiVEYp8Cc6ZHXXOmdwSLacN9f4TX5SXUREWqpGjA+9tk4oeRcITpuyupbOXU1DOH2gyABeczINuoyX7EMS68cxup+ptPvDxdK2RAKJOIvzqzl/G4DcgX+P19FAnzGRA9XXzivW7Gd5esL8ggJaRQH8gAyGtHDgyABaTsDdTkh3EkPtsC6XPiWGJ64YcIjSLZAfItVsq5Ix83FP0xPO7i3YXfK5gT8i0u/KNPvGOJdxdh2m+gfX8E8hwGUTn24wc/z7zZ7LVZCgCewlp5C0V/ASvlLOrhj3rd//tvy3/bBzyI9nxTMQAAAABJRU5ErkJggg==" alt="" width="32" height="32/"></a>
                <a href="{$url_close|escape:'html':'UTF-8'}" id="pc_btn_close" class="pagecache" title="{l s='Close this infos box' mod='jprestaspeedpack'}"><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAADiElEQVRIiYWWT6hVVRTGf9+59/oHvNrLJyUZWFkNIhokEfkgfZVBg8JspBHRKAwJdFSDBjYTCicFDRw4EYwciDgJNJyUg4zepOeDohcRvGnkQND9fQ3Ovufde/23OIu9z1lnr3/722tt7Z3fAwhJIBB1lBBCTbO1aZo31TSvAtuBWeA6sJzk59jnXMpCIEmA1Kcd9dqe3ZMGOsXa1uv1jwEHkQYAYpUyPk2uupRPbF8ESNIZaOyQGMetwAHpLUkLtt+PPUgpxJbHOCMuRbZ3In2vRl+HDEZ6EtNPTCKk1kX1mo9JvrQjAWkl9yLVMCB8CJoNPpj4ZhL6rcepaeq9nvh41X0/xXcyFMg7wPUkHySht/3RbSPpDOIiMExCEqUlplh1vLvMeS7JQpKlxjaxSXLY9haXgovl4rgYF3/j4rddvFLfcx+Z7KI4x2Or30KL9bY/kkTGUhM4CRxSC5pF4BKwtYpPAEeBBK4BvwjWdWuTHcAr/dhEeknS7HTSA793CZaWgPlq5AxwpCoC+Ae4MWZAFcb7+7aR2BkkaQwxCYFjtEbOIiFYAp5HWqlySIbABeCByeUBeLFvF4SebhNz21EaAKeBA8DZ6tzK2D8bqvK5UZxTSXiijYBp5d2HAIOQ04QXIAsTYnFSaNfY/9O0oW8b4NbdQN9Gmq8q7CY9kD6TmjnE1gqEaTX/9lMM8Ee4jVJP54nERzL6Uo20tUtLkucl/QA8rNGJXaXlxi7Y5YpdUhm7UFxwKadKuXW0lIJLwfZQ0kVgf/etlCWXstcuN0Zrx/hK3wkkP5KssIrxEUKupaJFMES6YHsXyRzJAdstusRfUjMO01q3OdN76MEZSJxkg5Pd3ZFvT/fLSX4jWQk5T5ir5aAH7Euy2Mo4T/JUoCsXtHv2qZ598nHadw/j/Ao8NhZDN1tNrDTa+jvLWu8lzSNd7rd1OyT5L8l7iS8RBqMVEykbA9AEGsanbVf8AukyEr3ZmU0dOpL8HWcxyb7EvanqeS+ulRWSfCfpUMAQerObNrYB1zYXspj4pyR7kmwai/BuhlJb5E3gc0mHIR6F1tu8cUji2pEyyu6fwKnYaxM/k2TNfbw/J+ld0Lddwmrj17Ytm1m/dg1J2tqQyVtBkiHkjSS7gB2sQnFZ0lXggtQs18tIV45Um6IAHtk8w7o1A4Q6xRMoqmGl28bRZrb7PVnixq8/4n8RDDW2Vjr3xQAAAABJRU5ErkJggg==" alt="" width="32" height="32/"></a>
            </div>
        </th>
    </tr>
    </thead>
    <tbody>
    <tr>
        <td>{l s='Page generation' mod='jprestaspeedpack'}</td>
        <td id="pc_speed">
            <span class="pctype0 pctype1 pctype3" style="display: none">{$speed|escape:'html':'UTF-8'}</span>
            <span class="pctype2" style="display: none">0 ms</span>
        </td>
    </tr>
    <tr>
        <td>{l s='Cache type' mod='jprestaspeedpack'}</td>
        <td id="pc_type">
            <b class="pctype0" style="display: none">{l s='no cache available :-(' mod='jprestaspeedpack'}</b>
            <b class="pctype1" style="display: none">{l s='server cache :-)' mod='jprestaspeedpack'}</b>
            <b class="pctype2" style="display: none">{l s='browser cache :-D (press F5 to refresh)' mod='jprestaspeedpack'}</b>
            <b class="pctype3" style="display: none">{l s='cache disabled' mod='jprestaspeedpack'}</b>
        </td>
    </tr>
    <tr>
        <td>{l s='Can be cached' mod='jprestaspeedpack'}</td>
        <td id="pc_cacheable">{$cacheable|escape:'html':'UTF-8'} {if $cacheable === 'false'} ({$cacheable_reason|escape:'html':'UTF-8'}){/if}</td>
    </tr>
    <tr>
        <td>{l s='Server cache timeout' mod='jprestaspeedpack'}</td>
        <td id="pc_timeout_server">{$timeout_server|escape:'html':'UTF-8'}</td>
    </tr>
    <tr>
        <td>{l s='Browser cache duration' mod='jprestaspeedpack'}</td>
        <td id="pc_timeout_browser">{$timeout_browser|escape:'html':'UTF-8'}</td>
    </tr>
    <tr>
        <td>{l s='Controller' mod='jprestaspeedpack'}</td>
        <td id="pc_controller">{$controller|escape:'html':'UTF-8'}</td>
    </tr>
    <tr>
        <td>{l s='Currency' mod='jprestaspeedpack'}</td>
        <td id="pc_cur">{$currency|escape:'html':'UTF-8'}</td>
    </tr>
    <tr>
        <td>{l s='Country/State/zipcode' mod='jprestaspeedpack'}</td>
        <td id="pc_loc_tax">{$loc_tax|escape:'html':'UTF-8'}</td>
    </tr>
    <tr>
        <td>{l s='Country' mod='jprestaspeedpack'}</td>
        <td id="pc_country">{$country|escape:'html':'UTF-8'}</td>
    </tr>
    <tr class="pcadv">
        <td>{l s='Cache key' mod='jprestaspeedpack'}</td>
        <td id="pc_cache_key"><pre style="white-space: pre-wrap">{$cache_key|escape:'html':'UTF-8'}</pre></td>
    </tr>
    <tr>
        <td>{l s='Groups' mod='jprestaspeedpack'}</td>
        <td id="pc_groups">{$groups|escape:'html':'UTF-8'}</td>
    </tr>
    <tr class="pcadv">
        <td>{l s='From cache' mod='jprestaspeedpack'}</td>
        <td id="pc_from_cache">{$from_cache|escape:'html':'UTF-8'}</td>
    </tr>
    <tr>
        <td>{l s='Performances' mod='jprestaspeedpack'}</td>
        <td id="pc_perfs">{l s='Server cache used' mod='jprestaspeedpack'} <b style="color: green">{$hit|escape:'html':'UTF-8'}</b> {l s='times and built' mod='jprestaspeedpack'} <b style="color: red">{$missed|escape:'html':'UTF-8'}</b> {l s='times' mod='jprestaspeedpack'} =&gt; {$perfs|escape:'html':'UTF-8'}</td>
    </tr>
    </tbody>
</table>
<script type="text/javascript">
    function jprestaSetCookie(cname, cvalue, ttl_minutes) {
        let d = new Date();
        d.setTime(d.getTime() + (ttl_minutes*60*1000));
        let expires = "expires="+ d.toUTCString();
        document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
    }
    function jprestaGetCookie(cname) {
        let name = cname + "=";
        let decodedCookie = decodeURIComponent(document.cookie);
        let ca = decodedCookie.split(';');
        for(let i = 0; i <ca.length; i++) {
            let c = ca[i];
            while (c.charAt(0) == ' ') {
                c = c.substring(1);
            }
            if (c.indexOf(name) == 0) {
                return c.substring(name.length, c.length);
            }
        }
        return "";
    }
    document.addEventListener("DOMContentLoaded", function(event) {
        try {
            if (false || isNaN(parseInt(jprestaGetCookie("pc_type_{$pagehash|escape:'html':'UTF-8'}")))) {
                pctype = 0;
            } else if (typeof document.cookie == 'undefined') {
                pctype = 1;
            } else {
                pctype = jprestaGetCookie("pc_type_{$pagehash|escape:'html':'UTF-8'}");
            }
            if (typeof pctype == 'undefined' || pctype == null) {
                pctype = 2;
            }
            $('.pctype' + pctype).show();
            if (pctype != 2) jprestaSetCookie("pc_type_{$pagehash|escape:'html':'UTF-8'}", 2, 60);
            // Fix for ultimateimagetool
            if (typeof $ !== 'undefined') {
                $('#pagecache_stats img.lazy').each(function() { $(this).attr('src', $(this).data('original')) });
            }
        } catch (err) {
            console.warn("Cannot treat PageCache infos box: " + err.message, err);
        }
    });
</script>
