<?php
/**
 * Page Cache Ultimate, Page Cache standard and Speed pack are powered by Jpresta (jpresta . com)
 *
 *    @author    Jpresta
 *    @copyright Jpresta
 *    @license   You are just allowed to modify this copy for your own use. You must not redistribute it. License
 *               is permitted for one Prestashop instance only but you can install it on your test instances.
 */

include_once(dirname(__FILE__) . '/../../jprestaspeedpack.php');

class jprestaspeedpackDboptimizeModuleFrontController extends ModuleFrontController
{
    public function initContent()
    {
        $this->setTemplate('module:jprestaspeedpack/views/templates/front/clearcache.tpl');

        if (Module::isEnabled("jprestaspeedpack")) {
            $token = Tools::getValue('token', '');
            $goodToken = JprestaUtils::getSecurityToken();
            if (!$goodToken || strcmp($goodToken, $token) === 0) {
                $module = Module::getInstanceByName("jprestaspeedpack");
                $result = $module->jpresta_submodules['JprestaDbOptimizer']->clean();
            } else {
                header("HTTP/1.0 404 Not Found");
                $result = 'Not OK: bad token ' . $token;
            }
        } else {
            $result = 'Not OK: module not active';
        }
        $this->context->smarty->assign(array(
            'result' => $result
        ));
    }

    public function getLayout()
    {
        return _PS_MODULE_DIR_ . 'jprestaspeedpack/views/templates/front/layout.tpl';
    }
}
