<?php
/**
 * Page Cache Ultimate, Page Cache standard and Speed pack are powered by Jpresta (jpresta . com)
 *
 *    @author    Jpresta
 *    @copyright Jpresta
 *    @license   You are just allowed to modify this copy for your own use. You must not redistribute it. License
 *               is permitted for one Prestashop instance only but you can install it on your test instances.
 */

include_once(dirname(__FILE__) . '/../../jprestaspeedpack.php');

class jprestaspeedpackClearcacheModuleFrontController extends ModuleFrontController
{
    public $php_self = null;

    public function init()
    {
        parent::init();
    }

    public function initContent()
    {
        parent::initContent();

        if (Tools::version_compare(_PS_VERSION_,'1.7','<')) {
            $this->setTemplate('clearcache.tpl');
        }
        else {
            $this->setTemplate('module:jprestaspeedpack/views/templates/front/clearcache.tpl');
        }

        $result = 'Not OK';
        if (Module::isEnabled("jprestaspeedpack")) {
            $token = Tools::getValue('token', '');
            $goodToken = JprestaUtils::getSecurityToken();
            if (!$goodToken || strcmp($goodToken, $token) === 0) {
                $is_specific = false;
                foreach (Jprestaspeedpack::getManagedControllersNames() as $controller) {
                    if (Tools::getIsset($controller)) {
                        // It's not a global reset
                        $is_specific = true;

                        if (strcmp($controller, 'index') === 0
                            || strcmp($controller, 'newproducts') === 0
                            || strcmp($controller, 'bestsales') === 0
                            || strcmp($controller, 'pricesdrop') === 0
                            || strcmp($controller, 'sitemap') === 0
                            || strcmp($controller, 'contact') === 0
                            || strcmp($controller, 'sitemap') === 0
                        ) {
                            // No ids for this controller
                            //echo "Deleting $controller <br/>";
                            PageCacheDAO::clearCacheOfObject($controller, null, false, 'from CRON');
                        } else {
                            $ids_str = Tools::getValue($controller);
                            $ids = self::parseIds($ids_str);
                            if (empty($ids)) {
                                PageCacheDAO::clearCacheOfObject($controller, null, true, 'from CRON');
                            }
                            else {
                                foreach ($ids as $id) {
                                    // Delete object one after the other
                                    //echo "Deleting $controller # $id <br/>";
                                    PageCacheDAO::clearCacheOfObject($controller, $id, true, 'from CRON');
                                }
                            }
                        }
                    }
                }
                $result = 'OK';
                if (!$is_specific) {
                    if (Tools::getIsset('nbHourExpired')) {
                        header("HTTP/1.0 404 Not Found");
                        $result = 'Parameter nbHourExpired is not supported anymore, the cache is now reduced continuously, this CRON is not necessary anymore.';
                    }
                    else {
                        // Clear the whole cache
                        $module = Module::getInstanceByName("jprestaspeedpack");
                        $module->clearCache();
                    }
                }
            } else {
                header("HTTP/1.0 404 Not Found");
                $result = 'Not OK: bad token ' . $token;
            }
        } else {
            $result = 'Not OK: module not active';
        }
        $this->context->smarty->assign(array(
            'result' => $result
        ));
    }

    public function getLayout()
    {
        return _PS_MODULE_DIR_ . 'jprestaspeedpack/views/templates/front/layout.tpl';
    }

    /**
     * @param string $ids Comma separated list of IDs
     * @return multitype:number Array of ID
     */
    private function parseIds($ids)
    {
        $ids_array = array();
        if (!empty($ids)) {
            $ids_str = explode(',', $ids);
            foreach ($ids_str as $id_str) {
                $id = (int) $id_str;
                if ($id > 0) {
                    $ids_array[] = $id;
                }
            }
        }
        return $ids_array;
    }
}
